package com.elitesland.tw.tw5.server.prd.humanresources.personnel.service;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.humanresources.query.PersonProjectExperienceQuery;
import com.elitesland.tw.tw5.api.prd.humanresources.service.PersonProjectExperienceService;
import com.elitesland.tw.tw5.api.prd.humanresources.vo.PersonProjectExperienceVO;
import com.elitesland.tw.tw5.server.prd.humanresources.personnel.convert.PersonProjectExperienceConvert;
import com.elitesland.tw.tw5.server.prd.humanresources.personnel.dao.PersonProjectExperienceDAO;
import com.elitesland.tw.tw5.server.prd.humanresources.personnel.entity.PersonProjectExperienceDO;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;

import java.util.List;

@Service
@RequiredArgsConstructor
@Slf4j
public class PersonProjectExperienceServiceImpl implements PersonProjectExperienceService {

    private final PersonProjectExperienceDAO personProjectExperienceDAO;

    @Override
    public void saveAll(List<PersonProjectExperienceVO> projectExperienceVOList, Long personId) {
        if (projectExperienceVOList != null) {
            if (projectExperienceVOList.size() == 0) {
                personProjectExperienceDAO.deleteByPersonId(personId);
            } else {
                for (PersonProjectExperienceVO personProjectExperienceVO : projectExperienceVOList) {
                    if (personProjectExperienceVO.getPersonId() == null) {
                        personProjectExperienceVO.setPersonId(personId);
                    }
                }
                personProjectExperienceDAO.saveAll(PersonProjectExperienceConvert.INSTANCE.toDos(projectExperienceVOList));
            }
        }
    }

    @Override
    public List<PersonProjectExperienceVO> findAllByPersonId(Long personId) {
        List<PersonProjectExperienceDO> personEduExperienceDOList = personProjectExperienceDAO.findAllByPersonId(personId);
        return PersonProjectExperienceConvert.INSTANCE.toVos(personEduExperienceDOList);
    }

    @Override
    public void deleteAllByPersonId(Long personId) {

        personProjectExperienceDAO.deleteByPersonId(personId);
    }

    @Override
    public PagingVO<PersonProjectExperienceVO> queryPaging(PersonProjectExperienceQuery query) {

        return personProjectExperienceDAO.queryPaging(query);
    }

}
