package com.elitesland.tw.tw5.server.prd.humanresources.personnel.service;

import com.elitesland.tw.tw5.api.prd.humanresources.payload.PersonWorkExperiencePayload;
import com.elitesland.tw.tw5.api.prd.humanresources.service.PersonWorkExperienceService;
import com.elitesland.tw.tw5.api.prd.humanresources.vo.PersonWorkExperienceVO;
import com.elitesland.tw.tw5.server.prd.humanresources.personnel.convert.PersonWorkExperienceConvert;
import com.elitesland.tw.tw5.server.prd.humanresources.personnel.dao.PersonWorkExperienceDAO;
import com.elitesland.tw.tw5.server.prd.humanresources.personnel.entity.PersonWorkExperienceDO;
import com.elitesland.tw.tw5.server.prd.humanresources.personnel.repo.PersonWorkExperienceRepo;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;

import java.util.List;

@Service
@RequiredArgsConstructor
@Slf4j
public class PersonWorkExperienceServiceImpl implements PersonWorkExperienceService {

    private final PersonWorkExperienceRepo personWorkExperienceRepo;

    private final PersonWorkExperienceDAO personWorkExperienceDAO;

    @Override
    public void save(PersonWorkExperiencePayload payload) {
        PersonWorkExperienceDO workExperienceDO = PersonWorkExperienceConvert.INSTANCE.toDo(payload);
        personWorkExperienceRepo.save(workExperienceDO);
    }

    @Override
    public List<PersonWorkExperienceVO> findAllByPersonId(Long personId) {
        List<PersonWorkExperienceDO> personWorkExperienceDOList = personWorkExperienceRepo.findAllByPersonId(personId);
        return PersonWorkExperienceConvert.INSTANCE.toVos(personWorkExperienceDOList);
    }

    @Override
    public void saveAll(List<PersonWorkExperienceVO> workExperienceVOList, Long personId) {
        if (workExperienceVOList != null) {
            if (workExperienceVOList.size() == 0) {
                personWorkExperienceDAO.deleteAllByPersonId(personId);
            } else {
                for (PersonWorkExperienceVO workExperienceVO : workExperienceVOList) {
                    if (workExperienceVO.getPersonId() == null) {
                        workExperienceVO.setPersonId(personId);
                    }
                }
                personWorkExperienceDAO.saveAll(PersonWorkExperienceConvert.INSTANCE.toDos(workExperienceVOList));
            }
        }
    }

    @Override
    public void deleteAllByPersonId(Long personId) {
        personWorkExperienceDAO.deleteAllByPersonId(personId);
    }
}
