package com.elitesland.tw.tw5.server.prd.humanresources.recommended.controller;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.humanresources.payload.PrdRecruitPositionPayload;
import com.elitesland.tw.tw5.api.prd.humanresources.query.PrdRecruitPositionQuery;
import com.elitesland.tw.tw5.api.prd.humanresources.service.PrdRecruitPositionService;
import com.elitesland.tw.tw5.api.prd.humanresources.vo.PrdRecruitPositionVO;
import com.elitesland.tw.tw5.server.common.TwOutputUtil;
import com.elitesland.tw.tw5.server.udc.UdcNameClass;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.web.bind.annotation.*;

import java.util.Arrays;
import java.util.List;

/**
 * 内部招聘管理
 *
 * @author zhangxiao
 * @folder 内部招聘管理
 * @date 2023-12-13
 */
@Api(tags = "内部招聘管理")
@RestController
@RequiredArgsConstructor
@RequestMapping("/api/crm/prdRecruitPosition")
@Slf4j
public class PrdRecruitPositionController {

    private final PrdRecruitPositionService prdRecruitPositionService;

    /**
     * 内部招聘管理-新增
     *
     * @param payload 有效载荷
     * @return {@link TwOutputUtil}
     * @folder 内部招聘管理
     */
    @PostMapping
    @ApiOperation("内部招聘管理-新增")
    public TwOutputUtil<PrdRecruitPositionVO> insert(@RequestBody PrdRecruitPositionPayload payload) {
        return TwOutputUtil.ok(prdRecruitPositionService.insert(payload));
    }

    /**
     * 内部招聘管理-更新
     *
     * @param payload 有效载荷
     * @return {@link TwOutputUtil}
     * @folder 内部招聘管理
     */
    @PutMapping
    @ApiOperation("内部招聘管理-更新")
    public TwOutputUtil<PrdRecruitPositionVO> update(@RequestBody PrdRecruitPositionPayload payload) {
        return TwOutputUtil.ok(prdRecruitPositionService.update(payload));
    }

    /**
     * 内部招聘管理-更新,支持置空,置空的字段需需要借助 protected List<String> nullFields;
     *
     * @param payload 有效载荷
     * @return {@link TwOutputUtil}
     * @folder 内部招聘管理
     */
    @PutMapping("update")
    @ApiOperation("内部招聘管理-更新,支持置空 置空的字段需需要借助 protected List<String> nullFields;")
    public TwOutputUtil<Long> updateByKeyDynamic(@RequestBody PrdRecruitPositionPayload payload) {
        return TwOutputUtil.ok(prdRecruitPositionService.updateByKeyDynamic(payload));
    }

    /**
     * 内部招聘管理-主键查询
     *
     * @param key 关键
     * @return {@link TwOutputUtil}
     * @folder 内部招聘管理
     */
    @GetMapping("/{key}")
    // @UdcNameClass
    @ApiOperation("内部招聘管理-主键查询")
    public TwOutputUtil<PrdRecruitPositionVO> queryOneByKey(@PathVariable Long key) {
        return TwOutputUtil.ok(prdRecruitPositionService.queryByKey(key));
    }

    /**
     * 内部招聘管理-分页
     *
     * @param query 查询
     * @return {@link TwOutputUtil}
     * @folder 内部招聘管理
     */
    @GetMapping("/paging")
    @UdcNameClass
    @ApiOperation("内部招聘管理-分页")
    public TwOutputUtil<PagingVO<PrdRecruitPositionVO>> paging(PrdRecruitPositionQuery query) {
        return TwOutputUtil.ok(prdRecruitPositionService.queryPaging(query));
    }

    /**
     * 内部招聘管理-查询列表
     *
     * @param query 查询
     * @return {@link TwOutputUtil}
     * @folder 内部招聘管理
     */
    @GetMapping("/list")
    // @UdcNameClass
    @ApiOperation("内部招聘管理-查询列表")
    public TwOutputUtil<List<PrdRecruitPositionVO>> queryList(PrdRecruitPositionQuery query) {
        return TwOutputUtil.ok(prdRecruitPositionService.queryListDynamic(query));
    }

    /**
     * 内部招聘管理-删除
     *
     * @param keys 主键id
     * @return result
     * @folder 内部招聘管理
     */
    @DeleteMapping("/deleteSoft")
    @ApiOperation("内部招聘管理-删除")
    public TwOutputUtil deleteSoft(Long[] keys) {
        prdRecruitPositionService.deleteSoft(Arrays.asList(keys));
        return TwOutputUtil.ok();
    }

}

