package com.elitesland.tw.tw5.server.prd.humanresources.resource.dao;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.humanresources.payload.ExternalResApplyPayload;
import com.elitesland.tw.tw5.api.prd.humanresources.query.ExternalResApplyQuery;
import com.elitesland.tw.tw5.api.prd.humanresources.vo.ExternalResApplyVO;
import com.elitesland.tw.tw5.api.prd.humanresources.vo.ExternalResApplyVO;
import com.elitesland.tw.tw5.server.common.util.SqlUtil;
import com.elitesland.tw.tw5.server.prd.humanresources.resource.entity.ExternalResApplyDO;
import com.elitesland.tw.tw5.server.prd.humanresources.resource.entity.QExternalResApplyDO;
import com.elitesland.tw.tw5.server.prd.humanresources.resource.repo.ExternalResApplyRepo;
import com.querydsl.core.QueryResults;
import com.querydsl.core.types.Projections;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import com.querydsl.jpa.impl.JPAUpdateClause;
import lombok.RequiredArgsConstructor;
import org.springframework.stereotype.Repository;
import org.springframework.util.ObjectUtils;

import java.util.List;
import java.util.Optional;

@Repository
@RequiredArgsConstructor
public class ExternalResApplyDAO {

    private final ExternalResApplyRepo externalResApplyRepo;

    private final JPAQueryFactory jpaQueryFactory;

    private final QExternalResApplyDO qExternalResApplyDO = QExternalResApplyDO.externalResApplyDO;


    private JPAQuery<ExternalResApplyVO> getJpaQueryWhere(ExternalResApplyQuery query) {
        JPAQuery<ExternalResApplyVO> jpaQuery = getJpaQuerySelect();
        jpaQuery.where(qExternalResApplyDO.deleteFlag.eq(0));

        if (!ObjectUtils.isEmpty(query.getProcInstStatus())) {
            jpaQuery.where(qExternalResApplyDO.procInstStatus.eq(query.getProcInstStatus()));
        }
        if (!ObjectUtils.isEmpty(query.getPersonName())) {
            jpaQuery.where(qExternalResApplyDO.personName.eq(query.getPersonName()));
        }
        if (!ObjectUtils.isEmpty(query.getPersonId())) {
            jpaQuery.where(qExternalResApplyDO.personId.eq(query.getPersonId()));
        }
        if (!ObjectUtils.isEmpty(query.getResType1())) {
            jpaQuery.where(qExternalResApplyDO.resType1.eq(query.getResType1()));
        }

        if (!ObjectUtils.isEmpty(query.getResType2())) {
            jpaQuery.where(qExternalResApplyDO.resType2.eq(query.getResType2()));
        }
        if (!ObjectUtils.isEmpty(query.getCooperationMode())) {
            jpaQuery.where(qExternalResApplyDO.cooperationMode.eq(query.getCooperationMode()));
        }
        if (!ObjectUtils.isEmpty(query.getSettleMethod())) {
            jpaQuery.where(qExternalResApplyDO.settleMethod.eq(query.getSettleMethod()));
        }
        if (!ObjectUtils.isEmpty(query.getPreeqvaAmt())) {
            jpaQuery.where(qExternalResApplyDO.preeqvaAmt.eq(query.getPreeqvaAmt()));
        }
        if (!ObjectUtils.isEmpty(query.getExpectedStartDate())) {
            jpaQuery.where(qExternalResApplyDO.expectedStartDate.between(query.getExpectedStartDate().get(0), query.getExpectedStartDate().get(1)));
        }
        if (!ObjectUtils.isEmpty(query.getExpectedEndDate())) {
            jpaQuery.where(qExternalResApplyDO.expectedEndDate.between(query.getExpectedEndDate().get(0), query.getExpectedEndDate().get(1)));
        }
        if (!ObjectUtils.isEmpty(query.getJobs())) {
            jpaQuery.where(qExternalResApplyDO.jobs.eq(query.getJobs()));
        }
        // 常用基础查询条件拼装
        SqlUtil.handleCommonJpaQuery(jpaQuery, qExternalResApplyDO._super, query);
        // 动态排序
        jpaQuery.orderBy(SqlUtil.getSortedColumn(qExternalResApplyDO, query.getOrders()));
        return jpaQuery;
    }

    private JPAQuery<ExternalResApplyVO> getJpaQuerySelect() {
        return jpaQueryFactory.select(Projections.bean(ExternalResApplyVO.class,
                        qExternalResApplyDO.id,
                        qExternalResApplyDO.createTime,
                        qExternalResApplyDO.procInstId,
                        qExternalResApplyDO.procInstStatus,
                        qExternalResApplyDO.personName,
                        qExternalResApplyDO.resType1,
                        qExternalResApplyDO.resType2,
                        qExternalResApplyDO.cooperationMode,
                        qExternalResApplyDO.settleMethod,
                        qExternalResApplyDO.preeqvaAmt,
                        qExternalResApplyDO.jobClass1,
                        qExternalResApplyDO.jobClass2,
                        qExternalResApplyDO.expectedStartDate,
                        qExternalResApplyDO.expectedEndDate,
                        qExternalResApplyDO.orgId,
                        qExternalResApplyDO.parentId,
                        qExternalResApplyDO.cooperationMode,
                        qExternalResApplyDO.createUserId,
                        qExternalResApplyDO.personId
                )).from(qExternalResApplyDO);
    }




    public ExternalResApplyDO save(ExternalResApplyDO applyDO) {
        return externalResApplyRepo.save(applyDO);
    }

    public void updateProcData(ExternalResApplyPayload payload) {
        JPAUpdateClause update = jpaQueryFactory.update(qExternalResApplyDO)
                .where(qExternalResApplyDO.id.eq(payload.getId()));

        if (payload.getProcInstId() != null) {
            update.set(qExternalResApplyDO.procInstId, payload.getProcInstId());
        }
        if (payload.getProcInstStatus() != null) {
            update.set(qExternalResApplyDO.procInstStatus, payload.getProcInstStatus());
        }
        if (payload.getApprovedTime() != null) {
            update.set(qExternalResApplyDO.approvedTime, payload.getApprovedTime());
        }
        List<String> nullFields = payload.getNullFields();
        if (nullFields != null && nullFields.size() > 0) {
            if (nullFields.contains("procInstStatus")) {
                update.setNull(qExternalResApplyDO.procInstStatus);
            }
            if (nullFields.contains("procInstId")) {
                update.setNull(qExternalResApplyDO.procInstId);
            }
        }

        // 执行修改
        update.execute();
    }

    public ExternalResApplyDO findByProcId(String procId) {
        return externalResApplyRepo.findByProcInstId(procId);
    }

    public ExternalResApplyDO findById(Long id) {
        Optional<ExternalResApplyDO> applyDO = externalResApplyRepo.findById(id);
        return applyDO.orElse(null);
    }

    public ExternalResApplyDO findByPersonId(Long personId) {
        return externalResApplyRepo.findByPersonId(personId);
    }


    public PagingVO<ExternalResApplyVO> queryPaging(ExternalResApplyQuery query) {
        JPAQuery<ExternalResApplyVO> jpaQuery = getJpaQueryWhere(query);
        QueryResults<ExternalResApplyVO> result = jpaQuery.offset(query.getPageRequest().getOffset()).limit(query.getPageRequest().getPageSize()).fetchResults();
        return PagingVO.<ExternalResApplyVO>builder().records(result.getResults()).total(result.getTotal()).build();
    }
}
