package com.elitesland.tw.tw5.server.prd.humanresources.resource.dao;

import com.elitesland.tw.tw5.server.prd.humanresources.resource.entity.QResPortrayalEvalConfigDO;
import com.elitesland.tw.tw5.server.prd.humanresources.resource.entity.ResPortrayalEvalConfigDO;
import com.elitesland.tw.tw5.server.prd.humanresources.resource.repo.ResPortrayalEvalConfigRepo;
import com.querydsl.jpa.impl.JPAQueryFactory;
import lombok.RequiredArgsConstructor;
import org.springframework.stereotype.Repository;

import java.util.List;

@Repository
@RequiredArgsConstructor
public class ResPortrayalEvalConfigDAO {

    private final ResPortrayalEvalConfigRepo resPortrayalEvalConfigRepo;

    private final QResPortrayalEvalConfigDO qResPortrayalEvalConfigDO = QResPortrayalEvalConfigDO.resPortrayalEvalConfigDO;

    private final JPAQueryFactory jpaQueryFactory;

    public void saveAll(List<ResPortrayalEvalConfigDO> resPortrayalEvalConfigDOList) {
        resPortrayalEvalConfigRepo.saveAll(resPortrayalEvalConfigDOList);
    }

    public void updateDefaultConfig(String evalPointIds) {
        jpaQueryFactory.update(qResPortrayalEvalConfigDO)
                .set(qResPortrayalEvalConfigDO.evalPointIds, evalPointIds)
                .where(qResPortrayalEvalConfigDO.defaultFlag.eq(true))
                .execute();
    }

    public void saveConfig(ResPortrayalEvalConfigDO configDO) {
        resPortrayalEvalConfigRepo.save(configDO);
    }

    public String getDefaultEvalPointIds() {
        return jpaQueryFactory.select(qResPortrayalEvalConfigDO.evalPointIds)
                .from(qResPortrayalEvalConfigDO)
                .where(qResPortrayalEvalConfigDO.defaultFlag.eq(true))
                .where(qResPortrayalEvalConfigDO.deleteFlag.eq(0))
                .fetchOne();
    }

    public String getResEvalPointIds(Long userId) {
        return jpaQueryFactory.select(qResPortrayalEvalConfigDO.evalPointIds)
                .from(qResPortrayalEvalConfigDO)
                .where(qResPortrayalEvalConfigDO.deleteFlag.eq(0))
                .where(qResPortrayalEvalConfigDO.userId.eq(userId))
                .fetchOne();
    }

    public void updateResConfig(ResPortrayalEvalConfigDO resConfigDO) {
        jpaQueryFactory.update(qResPortrayalEvalConfigDO)
                .set(qResPortrayalEvalConfigDO.evalPointIds, resConfigDO.getEvalPointIds())
                .where(qResPortrayalEvalConfigDO.deleteFlag.eq(0))
                .where(qResPortrayalEvalConfigDO.userId.eq(resConfigDO.getUserId()))
                .execute();
    }


}
