package com.elitesland.tw.tw5.server.prd.inv.controller;

import com.elitesland.tw.tw5.api.prd.inv.payload.InvItemCatPayload;
import com.elitesland.tw.tw5.api.prd.inv.query.InvItemCatQuery;
import com.elitesland.tw.tw5.api.prd.inv.vo.InvItemCatVO;
import com.elitesland.tw.tw5.api.prd.inv.service.InvItemCatService;
import com.elitesland.tw.tw5.server.common.TwOutputUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;

import com.elitesland.tw.tw5.server.udc.UdcNameClass;
import com.elitescloud.cloudt.common.base.PagingVO;

import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import java.io.IOException;
import javax.servlet.http.HttpServletResponse;
import org.springframework.web.bind.annotation.*;

import java.util.Arrays;
import java.util.List;

/**
 * 发票商品分类对象
 *
 * @author zoey
 * @date 2023-07-31
 */
@Api(tags = "发票商品分类对象")
@RestController
@RequiredArgsConstructor
@RequestMapping("/api/inv/invItemCat")
@Slf4j
public class InvItemCatController {

private final InvItemCatService invItemCatService;

    /**
     * 发票商品分类对象-新增
     *
     * @param payload 有效载荷
     * @return {@link TwOutputUtil}
     */
    @PostMapping
    @ApiOperation("发票商品分类对象-新增")
    public TwOutputUtil<InvItemCatVO> insert(@RequestBody InvItemCatPayload payload){
         return TwOutputUtil.ok(invItemCatService.insert(payload));
    }

    /**
     * 发票商品分类对象-更新
     *
     * @param payload 有效载荷
     * @return {@link TwOutputUtil}
     */
    @PutMapping
    @ApiOperation("发票商品分类对象-更新")
    public TwOutputUtil<InvItemCatVO> update(@RequestBody InvItemCatPayload payload){
        return TwOutputUtil.ok(invItemCatService.update(payload));
    }

    /**
     * 发票商品分类对象-更新,支持置空,置空的字段需需要借助 protected List<String> nullFields;
     *
     * @param payload 有效载荷
     * @return {@link TwOutputUtil}
     */
    @PutMapping("update")
    @ApiOperation("发票商品分类对象-更新,支持置空 置空的字段需需要借助 protected List<String> nullFields;")
    public TwOutputUtil<Long> updateByKeyDynamic(@RequestBody InvItemCatPayload payload){
        return TwOutputUtil.ok(invItemCatService.updateByKeyDynamic(payload));
    }

    /**
     * 发票商品分类对象-主键查询
     *
     * @param key 关键
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/{key}")
    // @UdcNameClass
    @ApiOperation("发票商品分类对象-主键查询")
    public TwOutputUtil<InvItemCatVO> queryOneByKey(@PathVariable Long key) {
        return TwOutputUtil.ok(invItemCatService.queryByKey(key));
    }

    /**
     * 发票商品分类对象-分页
     *
     * @param query 查询
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/paging")
    // @UdcNameClass
    @ApiOperation("发票商品分类对象-分页")
    public TwOutputUtil<PagingVO<InvItemCatVO>> paging(InvItemCatQuery query) {
        return TwOutputUtil.ok(invItemCatService.queryPaging(query));
    }

    /**
     * 发票商品分类对象-查询列表
     *
     * @param query 查询
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/list")
    // @UdcNameClass
    @ApiOperation("发票商品分类对象-查询列表")
    public TwOutputUtil<List<InvItemCatVO>> queryList(InvItemCatQuery query) {
        return TwOutputUtil.ok(invItemCatService.queryListDynamic(query));
    }

    /**
     * 发票商品分类对象-删除
     *
     * @param keys 主键id
     * @return result
     */
    @DeleteMapping("/deleteSoft")
    @ApiOperation("发票商品分类对象-删除")
    public TwOutputUtil deleteSoft(Long[] keys) {
         invItemCatService.deleteSoft(Arrays.asList(keys));
        return TwOutputUtil.ok();
    }

}

