package com.elitesland.tw.tw5.server.prd.my.controller;

import com.alibaba.excel.EasyExcel;
import com.alibaba.excel.write.builder.ExcelWriterSheetBuilder;
import com.alibaba.excel.write.style.column.LongestMatchColumnWidthStyleStrategy;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.my.payload.UserVacationApplyPayload;
import com.elitesland.tw.tw5.api.prd.my.query.UserVacationApplyQuery;
import com.elitesland.tw.tw5.api.prd.my.service.UserVacationApplyService;
import com.elitesland.tw.tw5.api.prd.my.vo.UserVacationApplyDetailVO;
import com.elitesland.tw.tw5.api.prd.my.vo.UserVacationApplyExcelVO;
import com.elitesland.tw.tw5.api.prd.my.vo.UserVacationApplyVO;
import com.elitesland.tw.tw5.server.common.TwOutputUtil;
import com.elitesland.tw.tw5.server.common.excel.ExcelUtil;
import com.elitesland.tw.tw5.server.prd.my.convert.UserVacationApplyConvert;
import com.elitesland.tw.tw5.server.udc.UdcNameClass;
import com.elitesland.tw.tw5.server.udc.UdcUtil;
import io.swagger.annotations.ApiModelProperty;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.net.URLEncoder;
import java.util.List;

/**
 * 用户请假申请
 *
 * @author sunxw
 * @description 用户假期申请
 * @Date 2023/5/8
 */
@RestController
@RequiredArgsConstructor
@RequestMapping("/api/my/applyVacation")
@Slf4j
public class UserVacationApplyController {

    private final UserVacationApplyService userVacationApplyService;
    private final UdcUtil udcUtil;

    /**
     * 分页
     *
     * @param query
     * @return
     */
    @GetMapping("/paging")
    @UdcNameClass
    public TwOutputUtil paging(UserVacationApplyQuery query) {
        final PagingVO<UserVacationApplyVO> paging = userVacationApplyService.paging(query);
        return TwOutputUtil.ok(paging);
    }

    /**
     * 列表查询
     *
     * @param query
     * @return
     */
    @GetMapping("/queryList")
    @UdcNameClass
    public TwOutputUtil queryList(UserVacationApplyQuery query) {
        List<UserVacationApplyVO> userVacationApplyVOS = userVacationApplyService.queryList(query);
        return TwOutputUtil.ok(userVacationApplyVOS);
    }

    /**
     * 导出
     *
     * @param query
     * @return
     */
    @GetMapping("/exportExcel")
    public void exportExcel(UserVacationApplyQuery query, HttpServletResponse response) throws IOException {
        List<UserVacationApplyVO> list = userVacationApplyService.list(query);
        if (!CollectionUtils.isEmpty(list)) {
            list = udcUtil.translateList(list);
            List<UserVacationApplyExcelVO> resultList = UserVacationApplyConvert.INSTANCE.voListVoExcelExport(list);
            //定义文件名称
            String sheetName = "请假申请";
            //对文件名进行固定格式编码
            String fileName = URLEncoder.encode(sheetName + System.currentTimeMillis() + ".xlsx", "UTF-8");
            //设置请求响应内容类型
            //作用:使客户端浏览器，区分不同种类的数据，并根据不同的MIME调用浏览器内不同的程序嵌入模块来处理相应的数据。
            response.setContentType("application/vnd.openxmlformats-officedocument.spreadsheetml.sheet");
            //设置请求响应内容编码方式
            response.setCharacterEncoding("utf-8");
            //文件下载，指定默认名
            response.addHeader("Content-Disposition", "attachment;filename=" + fileName);

            final ExcelWriterSheetBuilder sheet = EasyExcel.write(response.getOutputStream(), UserVacationApplyExcelVO.class)
                    .registerWriteHandler(new LongestMatchColumnWidthStyleStrategy())
                    .sheet(sheetName);
            // 列
            ExcelUtil.excelHelper(sheet, UserVacationApplyExcelVO.class, null);
            //写入
            sheet.doWrite(resultList);
        }
    }

    /**
     * 根据请假申请id获取明细
     *
     * @param applyId
     * @return
     */
    @GetMapping("/{applyId}")
    public TwOutputUtil getDetailByApplyKey(@PathVariable("applyId") Long applyId) {
        final List<UserVacationApplyDetailVO> list = userVacationApplyService.getDetailByApplyKey(applyId);
        return TwOutputUtil.ok(list);
    }

    /**
     * 请假申请提交
     *
     * @param payload
     * @return
     */
    @ApiModelProperty("请假申请提交")
    @PostMapping("/apply")
    public TwOutputUtil apply(@RequestBody UserVacationApplyPayload payload) {
        userVacationApplyService.userVacationApply(payload);
        return TwOutputUtil.ok();
    }

    /**
     * 请假申请流程信息-流程id
     *
     * @param prcoInstId
     * @return
     */
    @ApiModelProperty("请假申请流程信息-流程id")
    @GetMapping("/apply/query/{prcoInstId}")
    public TwOutputUtil<UserVacationApplyVO> query(@PathVariable String prcoInstId) {
        return TwOutputUtil.ok(userVacationApplyService.queryApply(prcoInstId));
    }

    /**
     * 请假申请流程信息
     *
     * @param businessKey
     * @return
     */
    @ApiModelProperty("请假申请流程信息")
    @GetMapping("/apply/queryByKey/{businessKey}")
    @UdcNameClass
    public TwOutputUtil<UserVacationApplyVO> queryByKey(@PathVariable String businessKey) {
        return TwOutputUtil.ok(userVacationApplyService.queryApplyByKey(businessKey));
    }


    /**
     * 请假申请新增
     *
     * @param payload
     * @return
     */
    @ApiModelProperty("请假申请新增")
    @PostMapping("/insert")
    public TwOutputUtil<UserVacationApplyVO> insert(@RequestBody UserVacationApplyPayload payload) {
        return TwOutputUtil.ok(userVacationApplyService.userVacationInsert(payload));
    }

    /**
     * 请假申请更新
     *
     * @param payload
     * @return
     */
    @ApiModelProperty("请假申请更新")
    @PostMapping("/update")
    public TwOutputUtil<UserVacationApplyVO> update(@RequestBody UserVacationApplyPayload payload) {
        return TwOutputUtil.ok(userVacationApplyService.userVacationUpdate(payload));
    }
}
