package com.elitesland.tw.tw5.server.prd.my.entity;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.bean.copier.CopyOptions;
import com.elitescloud.cloudt.common.annotation.Comment;
import com.elitescloud.boot.model.entity.BaseModel;
import lombok.Data;
import lombok.Getter;
import lombok.Setter;
import org.hibernate.annotations.Where;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import java.time.LocalDate;

/**
 * 工时-双周计划明细
 *
 * @author carl
 * @date 2022-12-19
 */
@Entity
@Table(name = "t_timesheet_biweekly_detail", indexes = {
})
@org.hibernate.annotations.Table(appliesTo = "t_timesheet_biweekly_detail", comment = "工时表-双周计划明细表")
@Data
@Getter
@Setter
@Where(clause = "delete_flag= 0")
public class TimesheetBiweeklyDetailDO extends BaseModel {

    /**
     * 双周计划id
     */
    @Comment("双周计划id")
    @Column()
    private Long tsbId;
    /**
     * 类型
     */
    @Comment("类型 10 本周预计工作 20 本周实际工作 30 预计下周工作")
    @Column()
    private String type;

    /**
     * 项目id
     */
    @Comment("项目id")
    @Column()
    private Long projId;
    /**
     * 项目名称
     */
    @Comment("项目名称")
    @Column()
    private String projectName;
    /**
     * 任务id
     */
    @Comment("任务id")
    @Column()
    private Long taskId;
    /**
     * 任务名称冗余
     */
    @Comment("任务名称冗余")
    @Column()
    private String taskName;
    /**
     * 活动id
     */
    @Comment("活动id")
    @Column()
    private Long actId;
    /**
     * 活动名称
     */
    @Comment("活动名称")
    @Column()
    private String actName;

    /**
     * 工作说明
     */
    @Comment("工作说明")
    @Column()
    private String workDesc;
    /**
     * 所属日期
     */
    @Comment("所属日期")
    @Column()
    private LocalDate tsbDate;

    /**
     * 所在年周
     */
    @Comment("所在年周")
    @Column()
    private Integer yearWeek;
    /**
     * 拓展1
     */
    @Comment("拓展1")
    @Column()
    private String ext1;
    /**
     * 拓展2
     */
    @Comment("拓展2")
    @Column()
    private String ext2;
    /**
     * 拓展3
     */
    @Comment("拓展3")
    @Column()
    private String ext3;


    public void copy(TimesheetBiweeklyDetailDO source) {
        BeanUtil.copyProperties(source, this, CopyOptions.create().setIgnoreNullValue(true));
    }
}
