package com.elitesland.tw.tw5.server.prd.my.repo;

import com.elitesland.tw.tw5.server.prd.my.entity.TaskDO;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.JpaSpecificationExecutor;
import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.jpa.repository.Query;

import java.math.BigDecimal;
import java.util.List;
import java.util.Map;

/**
* 工时用-任务表
*
* @author duwh
* @date 2022-12-09
*/
public interface TaskRepo extends JpaRepository<TaskDO, Long>, JpaSpecificationExecutor<TaskDO> {

    TaskDO getByTaskIdV4(Long taskIdV4);


    List<TaskDO> queryByTaskIdV4In(List<Long> tw4TaskIds);

    @Query("select id as taskId,taskIdV4 as taskIdV4 from TaskDO where deleteFlag=0")
    List<Map<String, Object>> getV4AndV5TaskIds();

    @Modifying
    @Query("update TaskDO set taskStatus=?2 where taskIdV4=?1")
    void updateTaskStatus(Long idV4,String taskStatus);

    /**
     * 更新 工时填报剩余可用当量
     *
     * @param idV4          id v4
     * @param effectiveEqva 有效eqva
     */
    @Modifying
    @Query("update TaskDO set effectiveEqva=?2 where taskIdV4=?1")
    void updateTaskEffectiveEqva(Long idV4, BigDecimal effectiveEqva);

    /**
     * 更新 工时填报剩余可用当量
     *
     * @param idV4          id v4
     * @param effectiveEqva 有效eqva
     */
    @Modifying
    @Query("update TaskDO set usedEqva=coalesce(usedEqva,0)+?2,effectiveEqva=?3 where taskIdV4=?1")
    void updateTaskEffectiveEqvaAndUsedEqva(Long idV4,BigDecimal usedEqva, BigDecimal effectiveEqva);

    /**
     * 计算任务包已填工时当量
     *
     * @param taskId   任务id
     * @param usedEqva 使用eqva
     */
    @Modifying
    @Query("update TaskDO set usedEqva=?2 where taskIdV4=?1")
    void updateUsedEqva(Long taskId, BigDecimal usedEqva);

    @Modifying
    @Query("update TaskDO set reasonId=?2,expenseBuId=?3 where taskIdV4=?1")
    void updateTaskMess(Long taskIdV4, Long reasonId, Long expenseBuId);

    @Query("update LogDO set deleteFlag=1 where id in ?1")
    @Modifying
    void deleteSoft(List<Long> keys);
}
