package com.elitesland.tw.tw5.server.prd.my.service;

import cn.hutool.core.collection.CollUtil;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.server.common.TwException;
import com.elitesland.tw.tw5.server.common.workFlow.ProcDefKey;
import com.elitesland.tw.tw5.server.prd.common.GlobalUtil;
import com.elitesland.tw.tw5.server.prd.common.WorkflowUtil;
import com.elitesland.tw.tw5.server.prd.common.functionEnum.RestStatusEnum;
import com.elitesland.tw.tw5.server.prd.common.functionEnum.WorkFlowStatusEnum;
import com.elitesland.tw.tw5.server.prd.my.entity.OvertimeApplicationDO;
import com.elitesland.tw.tw5.server.prd.my.entity.ProjectDO;
import com.elitesland.tw.tw5.server.prd.my.query.OvertimeApplicationQuery;
import com.elitesland.tw.tw5.server.prd.my.repo.ProjectRepo;
import com.elitesland.tw.tw5.server.prd.my.vo.ApproveLeaderDTO;
import com.elitesland.tw.tw5.server.prd.my.vo.OvertimeApplicationVO;
import com.elitesland.tw.tw5.server.prd.org.convert.OvertimeApplicationConvert;
import com.elitesland.tw.tw5.server.prd.org.repo.PrdOrgEmployeeRepo;
import com.elitesland.tw.tw5.server.prd.work.dao.OvertimeApplicationDAO;
import com.elitesland.tw.tw5.server.prd.work.repo.OvertimeApplicationRepo;
import com.elitesland.workflow.ProcessInfo;
import com.elitesland.workflow.payload.StartProcessPayload;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;

import java.time.LocalDate;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;

/**
 * @BelongsProject: tw-svr5
 * @BelongsPackage: com.elitesland.tw.tw5.server.prd.my.service
 * @Author: dragonHuang
 * @CreateTime: 2023-08-30  14:29
 * @Description: TODO
 * @Version: 1.0
 */
@Service
@RequiredArgsConstructor
@Slf4j
public class OvertimeApplicationServiceImpl {

    private final WorkflowUtil workflowUtil;
    private final OvertimeApplicationDAO overtimeApplicationDAO;
    private final OvertimeApplicationRepo overtimeApplicationRepo;
    private final ProjectRepo projectRepo;
    private final PrdOrgEmployeeRepo prdOrgEmployeeRepo;

    public Long submitOvertime(OvertimeApplicationVO overtimeApplicationVO) {

        final Long loginUserId = GlobalUtil.getLoginUserId();
        overtimeApplicationVO.setUserId(loginUserId);
        LocalDate overtimeWorkDate = overtimeApplicationVO.getOvertimeWorkDate();
        List<String> approveStatusList = new ArrayList<>();
        approveStatusList.add(WorkFlowStatusEnum.APPROVED.getCode());
        approveStatusList.add(WorkFlowStatusEnum.APPROVING_WORK.getCode());
        approveStatusList.add(WorkFlowStatusEnum.CREATE_WORK.getCode());
        if (overtimeApplicationRepo.existsByOvertimeWorkDateAndUserIdAndApproveStatusIn(overtimeWorkDate,loginUserId,approveStatusList)){
            throw TwException.error("500", "不能重复提交申请");
        }
        ApproveLeaderDTO approveLeader = overtimeApplicationDAO.getApproveLeader(overtimeApplicationVO);

        if(approveLeader == null){
            throw TwException.error("500", "该流程审批人为空，请重新填写!");
        }

        //流程启动成功后，回写加班申请表数据
        OvertimeApplicationDO overtimeApplicationDO = new OvertimeApplicationDO();
        overtimeApplicationDO.setOvertimeWorkDate(overtimeWorkDate);
        overtimeApplicationDO.setOvertimeWorkDesc(overtimeApplicationVO.getOvertimeWorkDesc());
        overtimeApplicationDO.setOvertimeWorkHour(overtimeApplicationVO.getOvertimeWorkHour());
        overtimeApplicationDO.setProjectId(overtimeApplicationVO.getProjectId());
        overtimeApplicationDO.setUserId(overtimeApplicationVO.getUserId());
        overtimeApplicationDO.setRestStatus(RestStatusEnum.CREATE.getCode());
        overtimeApplicationDO.setApproveStatus(WorkFlowStatusEnum.APPROVING_WORK.getCode());

        OvertimeApplicationDO save = overtimeApplicationRepo.save(overtimeApplicationDO);

        HashMap<String, Object> variables = new HashMap<>();
        // 项目经理或发包人审批
        Long userId;
        if (overtimeApplicationVO.getProjectId()==0){
            userId = approveLeader.getDisterUserId();
        }else {
            userId = approveLeader.getPmUserId();
        }
        variables.put("Activity_0hzxl2f", CollUtil.newArrayList(userId));
        // 直属上级审批
        variables.put("Activity_19biraq", CollUtil.newArrayList(approveLeader.getParentUserId()));
        // BU LEADER 审批
        variables.put("Activity_0ko02kn", CollUtil.newArrayList(approveLeader.getManageUserId()));

        log.info("加班申请审批人------------====" + approveLeader);

        //发起加班审批流程
        ProcessInfo processInfo = workflowUtil.startProcess(StartProcessPayload.of(
                ProcDefKey.OVERTIME_APPLICATION.name(),
                overtimeApplicationVO.getOvertimeWorkDate() + "工作计划申请流程",
                save.getId() + "",
                variables)
        );

        overtimeApplicationDO.setProcessInstanceId(processInfo.getProcInstId());
        overtimeApplicationDAO.updateById(overtimeApplicationDO);

        return save.getId();
    }

    public OvertimeApplicationVO findOvertimeApplicationById(Long id) {
        Optional<OvertimeApplicationDO> byId = overtimeApplicationRepo.findById(id);
        if(byId.isPresent()){
            OvertimeApplicationDO overtimeApplicationDO = byId.get();
            OvertimeApplicationVO overtimeApplicationVO = OvertimeApplicationConvert.INSTANCE.toDo(overtimeApplicationDO);
            Optional<ProjectDO> byProjIdV4 = projectRepo.findByProjIdV4(overtimeApplicationVO.getProjectId());
            overtimeApplicationVO.setProjectName(byProjIdV4.get().getProjName());
            String employeeName = prdOrgEmployeeRepo.queryEmployeeNameByUserId(overtimeApplicationVO.getUserId());
            overtimeApplicationVO.setUserName(employeeName);
            return overtimeApplicationVO;
        }
        return null;
    }

    public PagingVO<OvertimeApplicationVO> findOvertimeApplicationPage(OvertimeApplicationQuery query){
        return overtimeApplicationDAO.queryPaging(query);
    }

    public List<OvertimeApplicationVO> findAvailableOvertimeApplications() {
        List<OvertimeApplicationVO> list = overtimeApplicationDAO.findAvailableOvertimeApplications();
        return list;
    }


}
