package com.elitesland.tw.tw5.server.prd.my.service;

import cn.hutool.core.util.RandomUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.core.annotation.TenantTransaction;
import com.elitescloud.cloudt.core.annotation.common.TenantIsolateType;
import com.elitescloud.cloudt.security.entity.GeneralUserDetails;
import com.elitescloud.cloudt.system.provider.SysUserRpcService;
import com.elitescloud.cloudt.system.provider.dto.SysUserRpcDTO;
import com.elitescloud.cloudt.system.provider.param.SysUserRpcDtoParam;
import com.elitescloud.cloudt.system.vo.SysUserDTO;
import com.elitesland.tw.tw5.api.prd.cal.service.CalAccountService;
import com.elitesland.tw.tw5.api.prd.cal.vo.CalAccountVO;
import com.elitesland.tw.tw5.api.prd.crm.query.CrmCustomerOperationChanceQuery;
import com.elitesland.tw.tw5.api.prd.crm.query.CrmOperationPlanDetailQuery;
import com.elitesland.tw.tw5.api.prd.crm.service.CrmActActivityService;
import com.elitesland.tw.tw5.api.prd.crm.service.CrmLeadsService;
import com.elitesland.tw.tw5.api.prd.crm.service.CrmOperationPlanDetailService;
import com.elitesland.tw.tw5.api.prd.crm.vo.CrmCustomerOperationChanceVO;
import com.elitesland.tw.tw5.api.prd.humanresources.service.PrdPerformanceExamResultService;
import com.elitesland.tw.tw5.api.prd.my.payload.PwdForgotPayload;
import com.elitesland.tw.tw5.api.prd.my.query.PrdOrgEmployeeConfigQuery;
import com.elitesland.tw.tw5.api.prd.my.service.PrdOrgEmployeeConfigService;
import com.elitesland.tw.tw5.api.prd.my.service.PrdUserService;
import com.elitesland.tw.tw5.api.prd.my.vo.PrdOrgEmployeeConfigVO;
import com.elitesland.tw.tw5.api.prd.my.vo.PrdUserDataVO;
import com.elitesland.tw.tw5.api.prd.my.vo.PrdUserRemindVO;
import com.elitesland.tw.tw5.api.prd.my.vo.TwRecentWorkVO;
import com.elitesland.tw.tw5.api.prd.org.service.PrdOrgEmployeeEqvaRatioService;
import com.elitesland.tw.tw5.api.prd.org.service.PrdOrgEmployeeService;
import com.elitesland.tw.tw5.api.prd.org.vo.PrdOrgDataRefVO;
import com.elitesland.tw.tw5.api.prd.org.vo.PrdOrgEmployeeRefVO;
import com.elitesland.tw.tw5.api.prd.partner.common.service.BusinessPartnerService;
import com.elitesland.tw.tw5.api.prd.pms.service.PmsConContractService;
import com.elitesland.tw.tw5.api.prd.pms.service.PmsProjectService;
import com.elitesland.tw.tw5.api.prd.pms.service.PmsResourcePlanService;
import com.elitesland.tw.tw5.api.prd.salecon.query.ConReceivablePlanQuery;
import com.elitesland.tw.tw5.api.prd.salecon.service.ConReceivablePlanService;
import com.elitesland.tw.tw5.api.prd.salecon.service.SaleConExecConditionService;
import com.elitesland.tw.tw5.api.prd.system.service.PrdSystemProblemFeedbackService;
import com.elitesland.tw.tw5.api.prd.system.service.PrdSystemShortcutService;
import com.elitesland.tw.tw5.api.prd.system.vo.PrdSystemMenuVO;
import com.elitesland.tw.tw5.api.prd.system.vo.PrdSystemSelectionVO;
import com.elitesland.tw.tw5.api.prd.system.vo.PrdSystemShortcutJsonVO;
import com.elitesland.tw.tw5.api.prd.system.vo.PrdSystemShortcutVO;
import com.elitesland.tw.tw5.api.prd.task.service.TaskInfoService;
import com.elitesland.tw.tw5.api.prd.visit.query.VisitTaskQuery;
import com.elitesland.tw.tw5.server.common.TwException;
import com.elitesland.tw.tw5.server.common.util.*;
import com.elitesland.tw.tw5.server.prd.common.CacheUtil;
import com.elitesland.tw.tw5.server.prd.common.FileUtil;
import com.elitesland.tw.tw5.server.prd.common.GlobalUtil;
import com.elitesland.tw.tw5.server.prd.common.functionEnum.CalAccTypeEnum;
import com.elitesland.tw.tw5.server.prd.common.functionEnum.FunctionSelectionEnum;
import com.elitesland.tw.tw5.server.prd.common.functionEnum.RemindTypeEnum;
import com.elitesland.tw.tw5.server.prd.common.functionEnum.RoleEnum;
import com.elitesland.tw.tw5.server.prd.crm.dao.CrmCustomerOperationChanceDAO;
import com.elitesland.tw.tw5.server.prd.crm.visit.constants.VisitTaskEvalStatusEnum;
import com.elitesland.tw.tw5.server.prd.crm.visit.constants.VisitTaskStatusEnum;
import com.elitesland.tw.tw5.server.prd.crm.visit.dao.VisitTaskDAO;
import com.elitesland.tw.tw5.server.prd.my.constant.PrdOrgEmployeeConfigTypeEnum;
import com.elitesland.tw.tw5.server.prd.my.dao.PrdUserDAO;
import com.elitesland.tw.tw5.server.prd.my.entity.PrdUserRemindDO;
import com.elitesland.tw.tw5.server.prd.qixin.config.QiXinProperties;
import com.elitesland.tw.tw5.server.prd.system.constant.PrdSystemShortcutIconTypeEnum;
import com.elitesland.tw.tw5.server.prd.system.dao.PrdSystemRoleDAO;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.codec.binary.Base64;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.*;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import java.io.IOException;
import java.math.BigDecimal;
import java.net.URLEncoder;
import java.time.LocalDate;
import java.time.temporal.TemporalAdjusters;
import java.util.*;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

/**
 * 菜单管理service
 *
 * @author wangding
 */
@Service
@RequiredArgsConstructor
@Slf4j
// 配置文件动态刷新
@RefreshScope
public class PrdUserServiceImpl implements PrdUserService {
    private final PrdUserDAO dao;
    private final CrmCustomerOperationChanceDAO customerOperationChanceDAO;
    private final CacheUtil cacheUtil;
    private final FileUtil fileUtil;
    private final PrdSystemProblemFeedbackService prdSystemProblemFeedbackService;
    private final CrmActActivityService activityservice;
    @Autowired
    private CrmLeadsService crmLeadsService;
    private final CrmOperationPlanDetailService crmOperationPlanDetailService;
    private final PrdSystemRoleDAO systemRoleDAO;
    private final VisitTaskDAO visitTaskDAO;
    private final PrdOrgEmployeeService prdOrgEmployeeService;

    private final PmsConContractService conContractService;

    private final PmsResourcePlanService pmsResourcePlanService;
    private final PmsProjectService pmsProjectService;

    private final PrdOrgEmployeeEqvaRatioService eqvaRatioService;

    private final TaskInfoService taskInfoService;

    private final ConReceivablePlanService receivablePlanService;
    private final SaleConExecConditionService saleConExecConditionService;

    @Autowired
    private SysUserRpcService sysUserService;
    /**
     * 验证码长度
     */
    private static final Integer CODE_LEN = 6;
    private static final int MIN_STRENGTH = 5;
    private final JavaMailUtil mailHelper;
    @Autowired
    private StringRedisTemplate redisTemplate;

    @Value("${bangwo8.url:xxx}")
    private String bangwo8Url;
    @Value("${bangwo8.key:xxx}")
    private String bangwo8Key;
    @Value("${bangwo8.aid:xxx}")
    private String aid;
    @Value("${bangwo8.api.login:xxx}")
    private String loginUrl;
    @Value("${bangwo8.authaccount:xxx}")
    private String authaccount;
    @Value("${bangwo8.private_key:xxx}")
    // TODO 后续优化 com.elitesland.tw.tw5.server.prd.bangwo.config.BangWoProperties
    private String privateKey;
    @Value("${bangwo8.api.ticket:xxx}")
    // TODO 后续优化 com.elitesland.tw.tw5.server.prd.bangwo.config.BangWoProperties
    private String ticketUrl;
    @Value("${report.publicKey:xxx}")
    private String reportPublicKey;

    @Value("${tw5.workflow.enabled:false}")
    private Boolean workflow_enabled;
    private final QiXinProperties qiXinProperties;

    private final BusinessPartnerService businessPartnerService;

    private final CalAccountService calAccountService;

    private final PrdPerformanceExamResultService prdPerformanceExamResultService;
    private final PrdOrgEmployeeConfigService prdOrgEmployeeConfigService;
    private final PrdSystemShortcutService prdSystemShortcutService;
    private final String SHORTCUT_PREFIX = "/cloudt/system/com/file/v1/";
    private final String SHORTCUT_SUFFIX = "/show";

    @Transactional
    @Override

    public PrdUserDataVO queryUserDetail() {
        Long userId = GlobalUtil.getLoginUserId();
        PrdUserDataVO vo = dao.queryUserDetail(userId);
        vo.setHeadDatas(fileUtil.getFileDatas(vo.getHeadCodes()));
        vo.setOrgRoles(dao.queryRolesById(userId + ""));
        vo.setParentName(cacheUtil.getUserName(vo.getParentId()));

        List<PrdSystemShortcutVO> shortcutVOs = dao.queryShortcutList();
//        if (StringUtils.hasText(vo.getShortcutIds())) {
//            shortcutVOs.forEach(shortcutVO -> {
//                        if (vo.getShortcutIds().contains(shortcutVO.getId() + "")) {
//                            shortcutVO.setIsMy(0);
//                        }
//                    }
//            );
//        }

        // 系统图标处理
        // 业务伙伴图标权限 true 有 false 没有
        Boolean rolePermission = cacheUtil.hasSystemRolePermission(Arrays.asList(RoleEnum.SYS.getCode(), RoleEnum.OPS.getCode(), RoleEnum.FINANCE_MEMBER.getCode(),
                RoleEnum.BUSINESS_PARTNER_MANAGER.getCode(), RoleEnum.PLAT_ALL_PIC.getCode(), RoleEnum.PLAT_BUSINESS_PIC.getCode()));

        // 查询个人配置的图标
        PrdOrgEmployeeConfigQuery query = new PrdOrgEmployeeConfigQuery();
        query.setUserId(userId);
        query.setConfigType(PrdOrgEmployeeConfigTypeEnum.icon.getCode());
        List<PrdOrgEmployeeConfigVO> prdOrgEmployeeConfigVOS = prdOrgEmployeeConfigService.queryListDynamic(query);
        // 如果个人有配置图标
        if (!CollectionUtils.isEmpty(prdOrgEmployeeConfigVOS)) {
            PrdOrgEmployeeConfigVO prdOrgEmployeeConfigVO = prdOrgEmployeeConfigVOS.get(0);
            vo.setShortcutJson(prdOrgEmployeeConfigVO.getContentJson());
            vo.setUserConfigIconId(prdOrgEmployeeConfigVO.getId());
        } else {
            // 当没有用户配置的时候
            if (!CollectionUtils.isEmpty(shortcutVOs)) {

                List<PrdSystemShortcutJsonVO> prdSystemShortcutJsonVOS = new ArrayList<>();
                shortcutVOs.stream().forEach(shortcutVO -> {
                    if (!rolePermission && shortcutVO.getType().equals(PrdSystemShortcutIconTypeEnum.BUSINESS_PARTNER.getCode())) {
                        return;
                    }
                    PrdSystemShortcutJsonVO prdSystemShortcutJsonVO = new PrdSystemShortcutJsonVO();
                    prdSystemShortcutJsonVO.setType(shortcutVO.getType());
                    prdSystemShortcutJsonVO.setFixFlag(shortcutVO.getFixFlag());
                    prdSystemShortcutJsonVO.setIcon(SHORTCUT_PREFIX + shortcutVO.getShortcutIcon() + SHORTCUT_SUFFIX);
                    prdSystemShortcutJsonVO.setTitle(shortcutVO.getShortcutName());
                    prdSystemShortcutJsonVO.setBadge("");
                    prdSystemShortcutJsonVO.setShowBadgeFlag(false);
                    prdSystemShortcutJsonVO.setExt1("");
                    prdSystemShortcutJsonVO.setExt2("");
                    prdSystemShortcutJsonVO.setExt3("");
                    prdSystemShortcutJsonVOS.add(prdSystemShortcutJsonVO);
                });
                vo.setShortcutJson(JSON.toJSONString(prdSystemShortcutJsonVOS));

            } else {
                throw TwException.error("", "请先设置系统图标");
            }
        }

        String ticket = UUID.randomUUID().toString();
        vo.setTicket(new String(Base64.encodeBase64(ticket.getBytes())));
        //  vo.setShortcutVOs(shortcutVOs);
        List<String> userSystemRoleCodes = cacheUtil.getSystemRoleCodes(userId);
        vo.setRoleCodes(new HashSet<>(userSystemRoleCodes));
        vo.setQxBEnabled(qiXinProperties.getEnabled());
        transferSystemSelection(vo);
        dao.updateTicket(vo.getId(), ticket);
        CalAccountVO calAccountVO = calAccountService.queryByAuTypeAndAuId(CalAccTypeEnum.RES.getCode(), userId);
        vo.setTotalAmt(calAccountVO.getTotalAmt());
        vo.setTotalQty(calAccountVO.getTotalQty());
        vo.setAvalQty(calAccountVO.getAvalQty());
        LocalDate today = LocalDate.now();
        // 获取今年的第一天和最后一天
        LocalDate firstDay = today.with(TemporalAdjusters.firstDayOfYear());
        LocalDate lastDay = today.with(TemporalAdjusters.lastDayOfYear());
//        // 获取额定当量
//        BigDecimal edEqva = prdPerformanceExamResultService.getEdEqva(firstDay, lastDay, userId);
//        vo.setRatedQty(edEqva);
        // 获取当量系数
        BigDecimal eqvaRatio = eqvaRatioService.getEqvaRatio(userId, today);
        vo.setEqvaRatio(eqvaRatio);
        return vo;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public PrdUserDataVO getUserInfoBase() {
        Long userId = GlobalUtil.getLoginUserId();
        PrdUserDataVO vo = dao.queryUserDetail(userId);
        vo.setUserId(userId);
        // 组织角色
        vo.setOrgRoles(dao.queryRolesById(userId + ""));
        // 系统角色
        vo.setSystemRoles(cacheUtil.getSystemRoleCodes(userId));
        // 翻译
        transferSystemSelection(vo);
        vo.setWorkflowEnabled(workflow_enabled);
        vo.setQxBEnabled(qiXinProperties.getEnabled());
        return vo;
    }

    @Transactional
    @Override
    public Long updateShortcut(String shortcutIds) {
        Long userId = GlobalUtil.getLoginUserId();
        return dao.updateShortcut(userId, shortcutIds);
    }

    @Override
    public void updatePassword(String oldPassword, String newPassword) {
        if (StringUtils.hasText(oldPassword) && StringUtils.hasText(newPassword)) {
            Long userId = GlobalUtil.getLoginUserId();
//            SysPasswordUpdate passwordUpdate = new SysPasswordUpdate();
//            passwordUpdate.setUserId(userId);
//            passwordUpdate.setCurrentPassword(new String(Base64.encodeBase64(oldPassword.getBytes())));
//            passwordUpdate.setNewPassword(new String(Base64.encodeBase64(newPassword.getBytes())));
            sysUserService.changePasswordNoSec(GlobalUtil.getLoginUserId(), newPassword);
        } else {
            throw TwException.error("", "无效的密码");
        }

    }

    @Override
    public List<TwRecentWorkVO> findMyWork() {
        Long userId = GlobalUtil.getLoginUserId();
        List<TwRecentWorkVO> recentWorkVOList = new ArrayList<>();
        //TODO 具体的配置
        //销售合同项目待创建  要求靠前一些
        contractNotice(recentWorkVOList, userId);
        //经营机会点待跟踪
        customerOperationChance(recentWorkVOList, userId);
        //活动待发布
        activityRelease(recentWorkVOList, userId);
        //问题反馈
        problemFeedback(recentWorkVOList, userId);
        //待领取线索
        leadsToReceive(recentWorkVOList, userId);
        //待分配线索
        leadsToDistribute(recentWorkVOList, userId);
        //经营计划待执行  执行者为当量登录人 未读的经营计划任务
        operationPlanDetail(recentWorkVOList, userId);
        // 待办拜访任务
        visitTask(recentWorkVOList, userId);
        // 待办拜访评价
        visitTaskEval(recentWorkVOList, userId);
        //待确认潜在客户
        confilmedCustomer(recentWorkVOList);
        // 资源规划待更新
        resourcePlanNotice(recentWorkVOList, userId);
        //项目汇报待提交
        projectBriefWork(recentWorkVOList, userId);
        //查询项目预计当量&费用待更新代办
//        queryProjectUpdateWork(recentWorkVOList, userId);
        //项目预算需变更代办
        queryProjectUpdateBudgetWorkCount(recentWorkVOList, userId);
        // 任务待验收
        taskAcceptance(recentWorkVOList, userId);
        // 判断当前登录人是不是平台项目会计
        List<Long> userIdsByRole = systemRoleDAO.queryUserIdByRoleCodes(Arrays.asList(RoleEnum.PLAT_PRJ_ACCOUNTANT.getCode()));
        if (userIdsByRole != null && !userIdsByRole.isEmpty() && userIdsByRole.contains(userId)) {
            // 结算单回收
            recycleSettle(recentWorkVOList);
        }
        //合同预算资源规划
        contractBudgetPersonPlan(recentWorkVOList, userId);
        return recentWorkVOList;
    }


    @Override
    public List<PrdUserRemindVO> findMyRemind() {
        Long userId = GlobalUtil.getLoginUserId();
        LocalDate newDate = LocalDate.now();

        List<PrdUserRemindVO> resRemindVOS = new ArrayList<>();
        List<PrdUserRemindVO> remindVOS = dao.queryReminds(userId);
        for (PrdUserRemindVO remindVO : remindVOS) {
            if (remindVO.getNoRemindDate() == null || !remindVO.getNoRemindDate().equals(newDate)) {
                String remindType = remindVO.getRemindType();
                //待领取线索
                if (remindType.equals(RemindTypeEnum.RECEIVED_LEAD.getCode())) {
                    long num = crmLeadsService.countNotReceivedLeadsByUserId(userId);
                    if (num > 0) {
                        Map<String, Object> map = new HashMap<>();
                        map.put("num", num);
                        String remindContent = SpelUtil.parseStringExpression(remindVO.getRemindContent(), map);
                        remindVO.setRemindContent(remindContent);
                        resRemindVOS.add(remindVO);
                    }
                }
                //待发布活动
                if (remindType.equals(RemindTypeEnum.ACTIVITY_UNRELEASE.getCode())) {
                    Map<String, Object> objectMap = activityservice.findActivityUnReleaseByUserId(userId);
                    Long num = (Long) objectMap.get("num");
                    if (num > 0) {
                        Map<String, Object> map = new HashMap<>();
                        map.put("num", num);
                        String remindContent = SpelUtil.parseStringExpression(remindVO.getRemindContent(), map);
                        remindVO.setRemindContent(remindContent);
                        remindVO.setSurplusTime(objectMap.get("time") + "");
                        resRemindVOS.add(remindVO);

                    }

                }

            }
        }
        return resRemindVOS;
    }

    @Transactional
    @Override
    public Boolean updateMyRemind(String remindType) {
        Long userId = GlobalUtil.getLoginUserId();
        LocalDate newDate = LocalDate.now();
        PrdUserRemindDO userRemindDO = dao.queryUserRemind(userId, remindType);
        if (userRemindDO == null) {
            userRemindDO = new PrdUserRemindDO();
            userRemindDO.setRemindType(remindType);
            userRemindDO.setUserId(userId);
        }
        userRemindDO.setNoRemindDate(newDate);
        dao.saveUserRemind(userRemindDO);
        return true;
    }

    @Override
    public void queryUserByTicket(HttpServletRequest request, HttpServletResponse response) {
        String ticket = request.getParameter("ticket");
        //对获取的加密的token进行解密：使用 Base64
        if (ticket != null && !ticket.isEmpty()) {
            ticket = new String(Base64.decodeBase64(ticket.getBytes()));
        }
        Map<String, Object> paramMap = new HashMap<>();
        JSONObject jsonObject = null;
        HttpSession session = request.getSession();
//        通过ticket查询用户信息
        PrdUserDataVO info = dao.queryUserByTicket(ticket);
        try {
            if (info == null) {
                paramMap.put("el-result-cod", "NG_UNSUPPORTED");
                paramMap.put("statusCode", "401");
                jsonObject = new JSONObject(paramMap);
                response.setStatus(401);
                session.setAttribute("paramMap", paramMap);
            }
            paramMap.put("app_login_type", "SSO");
            paramMap.put("app_login_id", info.getId());
            paramMap.put("app_login_email", info.getEmail());
            paramMap.put("app_login_ticket", ticket);
            paramMap.put("el-result-cod", "OK");
            paramMap.put("statusCode", "200");
            jsonObject = new JSONObject(paramMap);
            response.setStatus(200);
            session.setAttribute("paramMap", paramMap);
            response.getWriter().print(jsonObject);
        } catch (NullPointerException e) {
            try {
                response.getWriter().print(jsonObject);
            } catch (IOException ex) {
                ex.printStackTrace();
            }
        } catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public String getBangwo8Sign() {
        //签名， md5(aid+loginname+time+双方约定的密钥)
        String loginName = "";
        try {
            //获取当前登录用户
            SysUserDTO loginUser = GlobalUtil.getLoginUser();
            String[] split = loginUser.getEmail().split("\\.");
            loginName = split[0] + split[1].split("@")[0];
//            loginName ="zhuyuexiang";
        } catch (Exception e) {
            TwException.error("", "未获取到登录用户信息！");
        }
        //10位的当前时间
        long currentTime = (System.currentTimeMillis() / 1000) - 300;
        //32位，小写
        String message = aid + loginName + currentTime + bangwo8Key;
        String sign = DigestUtils.md5DigestAsHex(message.getBytes());
        String url = String.join("", bangwo8Url, loginUrl, "?aid=", aid, "&loginname=", loginName, "&type=0&time=", String.valueOf(currentTime), "&sign=", sign);
        return url;
    }

    @Override
    public String getBangwo8LoginFreeSign() {
//        String nonce = String.valueOf((int) ((Math.random() * 9 + 1) * 100000));
        String nonce = "123456";
        String timestamp = String.valueOf(System.currentTimeMillis());
        Map<String, String> map = new TreeMap<String, String>();
//        map.put("mobile", "15564532345");
        map.put("authaccount", authaccount);
        map.put("private_key", privateKey);
        map.put("timestamp", timestamp);
        map.put("nonce", nonce);
        String sign = Bangwo8Signature.makeSignature(map);
        return String.join("", bangwo8Url, ticketUrl, "&nonce=", nonce, "&timestamp=", timestamp, "&signature=", sign, "&authaccount=", authaccount);
    }

    @Override
    public String getFrSsoToken() {
        SysUserDTO loginUser = GlobalUtil.getLoginUser();
        if (ObjectUtils.isEmpty(loginUser)) {
            throw TwException.error("", "登录失败,获取用户信息失败！");
        }
        //加密后的ssoToken,可以在前台界面进行解密测试
        String encrypt = RsaEncrypt.encrypt(loginUser.getEmail(), reportPublicKey);
        System.out.println("encrypted username: " + encrypt);

        //encode后的token,可以直接放于url上进行单点
        String encode = "";
        try {
            encode = URLEncoder.encode(encrypt, "UTF-8");
        } catch (Exception e) {
            throw TwException.error("", e.toString());
        }
        log.debug("加密后的值为：：" + encode);
        return encode;
    }


    @Override
    public void captcha2Email(String email, String type) {
        String captchaCode;
        long currentTime = System.currentTimeMillis();
        String captchaAndTimestamp = redisTemplate.opsForValue().get(type + email);
        if (StringUtils.hasText(captchaAndTimestamp)) {
            String[] split = captchaAndTimestamp.split("=");
            captchaCode = split[0];
            long timestamp = Long.parseLong(split[1]);
            //超过5分钟，失效并重置原有验证码
            if (currentTime - timestamp > 5 * 60 * 1000) {
                captchaCode = RandomUtil.randomStringUpper(CODE_LEN);
                redisTemplate.opsForValue().set(type + email, captchaCode + "=" + currentTime, 5, TimeUnit.MINUTES);
            }
        } else {
            captchaCode = RandomUtil.randomStringUpper(CODE_LEN);
            redisTemplate.opsForValue().set(type + email, captchaCode + "=" + currentTime, 5, TimeUnit.MINUTES);
        }
        StringBuilder msgContent = new StringBuilder("<html><body>");
        msgContent.append("尊敬的用户，<br>");
        msgContent.append("您好！我们注意到您最近在找回密码方面遇到了一些问题。为了确保您的账户安全，我们特别为您提供了以下验证码以供验证身份。请在找回密码页面输入以下验证码：<br>");
        msgContent.append("验证码：<a style=\"color: red;font-size: 20px;\"> [").append(captchaCode).append("]</a><br>");
        msgContent.append("此验证码将在接收邮件后的").append("<a style=\"font-size: 20px;\">").append(" 5分钟 ").append("</a>内有效，请您尽快使用。<br>");
        msgContent.append("为了保护您的账户安全，请注意以下几点：<br>");
        msgContent.append("<p style=\"text-indent: 20px;\">不要泄露验证码： 请勿将此验证码透露给任何人，包括我们的客服人员。我们绝不会通过电子邮件或电话索取此验证码。</p>");
        msgContent.append("<p style=\"text-indent: 20px;\">防范钓鱼网站： 请始终通过我们官方网站进行密码重置操作，避免受到钓鱼网站的欺骗。</p>");
        msgContent.append("如果您没有尝试找回密码，请忽略此邮件。如果您有任何疑问或需要帮助，请随时联系我们的客服团队。<br>");
        msgContent.append("再次感谢您对我们的信任和支持！<br>");
        msgContent.append("泰列沃克事业部祝您一切顺利！</body></html>");
        JavaMailPayload mailPayload = new JavaMailPayload();
        // 邮箱
        mailPayload.setReceiveEmail(email);
        // 主题
        mailPayload.setSubject("密码重置验证码及安全提醒");
        // 邮件正文
        mailPayload.setText(msgContent.toString());
        mailHelper.sendEmailByAdmin(mailPayload);
    }

    @Override
    public void forgotPwd(PwdForgotPayload payload, String type) {
        this.checkForgotPwdParams(payload);
        this.checkPasswordStrength(payload.getNewPwd());
        String captchaAndTimestamp = redisTemplate.opsForValue().get(type + payload.getEmail());
        //验证码核验成功进行密码重置
        if (StringUtils.hasText(captchaAndTimestamp) && captchaAndTimestamp.split("=")[0].equals(payload.getCaptchaCode())) {
            SysUserRpcDtoParam param = new SysUserRpcDtoParam();
            param.setEmails(List.of(payload.getEmail()));
            List<SysUserRpcDTO> search = sysUserService.findUserRpcDtoByParam(param);
            if (CollectionUtils.isEmpty(search)) {
                throw new BusinessException("根据当前邮箱未找到系统用户信息");
            }
            SysUserRpcDTO sysUserDTO = search.get(0);
            sysUserService.changePasswordNoSec(sysUserDTO.getId(), payload.getNewPwd());
        } else {
            throw new BusinessException("验证码校验错误，修改密码失败");
        }
    }

    private void checkForgotPwdParams(PwdForgotPayload payload) {
        Assert.notNull(payload.getNewPwd(), "新密码不能为空");
        Assert.notNull(payload.getConfirmPwd(), "确认密码不能为空");
        Assert.notNull(payload.getCaptchaCode(), "验证码不能为空");
        Assert.notNull(payload.getEmail(), "邮箱不能为空");
        if (!payload.getNewPwd().equals(payload.getConfirmPwd())) {
            throw new BusinessException("两次输入的密码不一致！");
        }
    }

    private void checkPasswordStrength(String password) {
        // 数字
        final Pattern digits = Pattern.compile("(?=.*[0-9]).*");
        // 小写字母
        final Pattern lcases = Pattern.compile("(?=.*[a-z]).*");
        // 大写字母
        final Pattern ucases = Pattern.compile("(?=.*[A-Z]).*");
        // 特殊字符
        final Pattern scases = Pattern.compile("(?=.*[~!@#$%^&*()_-]).*");
        // 最小的长度
        final int MIN_LEN = 8;
        // 较好的长度
        final int GOOD_LEN = 10;

        int strength = 0;
        if (password.length() >= MIN_LEN) {
            if (password.length() >= GOOD_LEN) {
                strength += 2;
            } else {
                strength += 1;
            }
            if (digits.matcher(password).matches()) {
                strength += 2;
            }
            if (lcases.matcher(password).matches()) {
                strength += 2;
            }
            if (ucases.matcher(password).matches()) {
                strength += 2;
            }
            if (scases.matcher(password).matches()) {
                strength += 2;
            }
        }
        if (MIN_STRENGTH > strength) {
            throw new BusinessException("密码强度不足");
        }
    }

    @Override
    public List<PrdOrgDataRefVO> queryOrgList() {
        Long userId = GlobalUtil.getLoginUserId();
        return dao.queryOrgListByKey(userId);
    }

    @Override
    public List<PrdOrgEmployeeRefVO> queryLowListByKey(Long orgId) {
        Long userId = GlobalUtil.getLoginUserId();
        return dao.queryLowListByKey(orgId, userId);
    }

    @TenantTransaction(isolateType = TenantIsolateType.DEFAULT)
    @Override
    public List<PrdSystemMenuVO> queryMenus() {
        List<PrdSystemMenuVO> menuVOS = dao.queryUsableList();

        GeneralUserDetails loginGeneralUser = GlobalUtil.getLoginGeneralUser();

        //List<Long> saleAdminUserIdsByRole = systemRoleDAO.queryUserIdByRoleCodes(Arrays.asList(RoleEnum.SYS.getCode()));
        // Boolean sysRole = cacheUtil.hasSystemRolePermission(Arrays.asList(RoleEnum.SYS.getCode()));
        if (loginGeneralUser.isSystemAdmin()) {
            return menuVOS;
        }
        if (loginGeneralUser.isTenantAdmin()) {
            return menuVOS.stream().filter(menuVO_ -> !menuVO_.getPortalRoute().contains("/tenancy")).collect(Collectors.toList());
        }
        List<Long> userMenuIds = dao.queryUserMenuIds(loginGeneralUser.getUserId());
//        if (userId.longValue() == 356948235909079040L) {
//            return menuVOS;
//        }
        return menuVOS.stream().filter(menuVO -> userMenuIds.indexOf(menuVO.getId()) >= 0).collect(Collectors.toList());
    }

    private void customerOperationChance(List<TwRecentWorkVO> recentWorkVOList, long userId) {
        CrmCustomerOperationChanceQuery query = new CrmCustomerOperationChanceQuery();
        query.setTrackerUserId(userId);

        query.setIsRead(0);
        query.setNoPermissionFlag(true);
        PagingVO<CrmCustomerOperationChanceVO> paging = customerOperationChanceDAO.paging(query);
        final Long total = paging.getTotal();
        if (total.compareTo(0L) != 0) {
            recentWorkVOList.add(TwRecentWorkVO.of("经营机会点待跟踪", total, TwRecentWorkVO.RecentWorkType.OPERATION_CHANCE_DETAIL.getCode()));
        }
    }

    //活动待发布
    private void activityRelease(List<TwRecentWorkVO> recentWorkVOList, long userId) {
        Map<String, Object> objectMap = activityservice.findActivityUnReleaseByUserId(userId);
        final long num = (Long) objectMap.get("num");
        if (num > 0) {
            recentWorkVOList.add(TwRecentWorkVO.of("活动待发布", num, TwRecentWorkVO.RecentWorkType.ACTIVITY_RELEASE.getCode()));
        }
    }

    //问题反馈
    private void problemFeedback(List<TwRecentWorkVO> recentWorkVOList, long userId) {
        final long num = prdSystemProblemFeedbackService.findWorkProblemFeedbackByUserId(userId);
        if (num > 0) {
            recentWorkVOList.add(TwRecentWorkVO.of("问题反馈", num, TwRecentWorkVO.RecentWorkType.FEED_BACK.getCode()));
        }
    }

    //待接收线索
    private void leadsToReceive(List<TwRecentWorkVO> recentWorkVOList, long userId) {
        final long num = crmLeadsService.countNotReceivedLeadsByUserId(userId);
        if (num > 0) {
            recentWorkVOList.add(TwRecentWorkVO.of("待领取线索", num, TwRecentWorkVO.RecentWorkType.LEADS_TO_RECEIVE.getCode()));
        }
    }

    //待分配线索
    private void leadsToDistribute(List<TwRecentWorkVO> recentWorkVOList, long userId) {
        final long num = crmLeadsService.countNotDistributedLeadsByUserId(userId);
        if (num > 0) {
            recentWorkVOList.add(TwRecentWorkVO.of("线索待分配", num, TwRecentWorkVO.RecentWorkType.LEADS_TO_DISTRIBUTE.getCode(), "/leadsManager/offshore"));
        }
    }

    /**
     * 经营计划待执行  执行者为当量登录人 未读的经营计划任务
     *
     * @param recentWorkVOList 待办集合
     * @param userId           用户id
     */
    private void operationPlanDetail(List<TwRecentWorkVO> recentWorkVOList, Long userId) {
        CrmOperationPlanDetailQuery planDetailQuery = new CrmOperationPlanDetailQuery();
        // 执行者
        planDetailQuery.setPerformerId(userId);
        // 未读
        planDetailQuery.setReadFlag(0);
        final long count = crmOperationPlanDetailService.count(planDetailQuery);
        if (count > 0) {
            recentWorkVOList.add(TwRecentWorkVO.of("经营计划待执行", count, TwRecentWorkVO.RecentWorkType.OPERATION_PLAN_DETAIL.getCode(), "/leadsManager/offshore"));
        }
    }

    /**
     * 待办拜访任务
     *
     * @param recentWorkVOList 待办集合
     * @param userId           用户id
     */
    private void visitTask(List<TwRecentWorkVO> recentWorkVOList, Long userId) {
        VisitTaskQuery taskQuery = new VisitTaskQuery();
        taskQuery.setVisitMemberId(userId);
        List<String> statusList = new ArrayList<>();
        statusList.add(VisitTaskStatusEnum.NEW.getCode());
        statusList.add(VisitTaskStatusEnum.READY.getCode());
        taskQuery.setStatusList(statusList);
//        taskQuery.setRemindTime(LocalDateTime.now());
        final long count = visitTaskDAO.done(taskQuery);
        if (count > 0) {
            recentWorkVOList.add(TwRecentWorkVO.of(TwRecentWorkVO.RecentWorkType.VISIT_TASK.getDesc(), count, TwRecentWorkVO.RecentWorkType.VISIT_TASK.getCode(), "/visit/task"));
        }
    }

    /**
     * 待办拜访评价
     *
     * @param recentWorkVOList 待办集合
     * @param userId           用户id
     */
    private void visitTaskEval(List<TwRecentWorkVO> recentWorkVOList, Long userId) {
        VisitTaskQuery taskQuery = new VisitTaskQuery();
        //只有拜访评价人员才能看到代办
        if (cacheUtil.hasSystemRolePermission(Arrays.asList(RoleEnum.EVAL_TASK_PIC.getCode()))) {
            taskQuery.setStatus(VisitTaskStatusEnum.OK.getCode());
            taskQuery.setEvalStatus(VisitTaskEvalStatusEnum.NEW.getCode());
            final long count = visitTaskDAO.count(taskQuery);
            if (count > 0) {
                recentWorkVOList.add(TwRecentWorkVO.of(TwRecentWorkVO.RecentWorkType.VISIT_TASK_EVAL.getDesc(), count, TwRecentWorkVO.RecentWorkType.VISIT_TASK_EVAL.getCode(), "/visit/task?eval=true"));
            }
        }
    }

    /**
     * 待确认潜在客户
     */
    private void confilmedCustomer(List<TwRecentWorkVO> recentWorkVOList) {
        // 有潜在客户负责人角色才显示这个代办
        if (cacheUtil.hasSystemRolePermission(Arrays.asList(RoleEnum.POTENTIAL_CUST_CONFIRM.getCode()))) {
            final long count = businessPartnerService.countConfirmedCustomer();
            if (count > 0) {
                recentWorkVOList.add(TwRecentWorkVO.of("待确认潜在客户", count, TwRecentWorkVO.RecentWorkType.COMFIRMED_CUSTOMER.getCode()));
            }
        }
    }


    /**
     * 销售合同项目待创建
     *
     * @param recentWorkVOList
     */
    private void contractNotice(List<TwRecentWorkVO> recentWorkVOList, Long userId) {
        List<String> custPropList = new ArrayList<>();
        PrdSystemSelectionVO systemSelection = cacheUtil.getSystemSelection("crm:company_nature");
        List<PrdSystemSelectionVO> children = systemSelection.getChildren();
        if(cacheUtil.hasSystemRolePermission(Arrays.asList(RoleEnum.A_CUST_NATURE.getCode()))){
            children.forEach(item->{
                if(item.getExtString1().equals(RoleEnum.A_CUST_NATURE.getCode())){
                    custPropList.add(item.getSelectionValue());
                }
            });
        }
        if(cacheUtil.hasSystemRolePermission(Arrays.asList(RoleEnum.B_CUST_NATURE.getCode()))){
            children.forEach(item->{
                if(item.getExtString1().equals(RoleEnum.B_CUST_NATURE.getCode())){
                    custPropList.add(item.getSelectionValue());
                }
            });
        }
        if(!CollectionUtils.isEmpty(custPropList)){
            final long num = conContractService.findCountByCustProp(custPropList);
            if (num > 0) {
                recentWorkVOList.add(TwRecentWorkVO.of(TwRecentWorkVO.RecentWorkType.PROJECT_TO_CREATE.getDesc(), num, TwRecentWorkVO.RecentWorkType.PROJECT_TO_CREATE.getCode()));
            }
        }
    }

    /**
     * 资源规划待更新
     *
     * @param recentWorkVOList
     */
    private void resourcePlanNotice(List<TwRecentWorkVO> recentWorkVOList, Long userId) {
        //没有
//        final long num = pmsResourcePlanService.findRemindCount(userId);
//        if (num > 0) {
//            recentWorkVOList.add(TwRecentWorkVO.of(TwRecentWorkVO.RecentWorkType.RESOURCE_PLAN_TO_UPDATE.getDesc(), num, TwRecentWorkVO.RecentWorkType.RESOURCE_PLAN_TO_UPDATE.getCode()));
//        }
    }

    /**
     * 任务验收
     *
     * @param recentWorkVOList
     * @param userId
     */
    private void taskAcceptance(List<TwRecentWorkVO> recentWorkVOList, Long userId) {
        final long num = taskInfoService.findAcceptCount(userId);
        if (num > 0) {
            recentWorkVOList.add(TwRecentWorkVO.of(TwRecentWorkVO.RecentWorkType.TASK_ACCEPTANCE.getDesc(), num, TwRecentWorkVO.RecentWorkType.TASK_ACCEPTANCE.getCode()));
        }
    }

    /**
     * 结算单回收
     *
     * @param recentWorkVOList
     */
    private void recycleSettle(List<TwRecentWorkVO> recentWorkVOList) {
        ConReceivablePlanQuery conReceivablePlanQuery = new ConReceivablePlanQuery();
        // 待回收
        conReceivablePlanQuery.setRecycleSettleFlag(0);
        final long num = receivablePlanService.countListDynamic(conReceivablePlanQuery);
        if (num > 0) {
            recentWorkVOList.add(TwRecentWorkVO.of(TwRecentWorkVO.RecentWorkType.RECYCLE_SETTLE.getDesc(), num, TwRecentWorkVO.RecentWorkType.RECYCLE_SETTLE.getCode(), ""));
        }
    }


    /**
     * 任务验收
     *
     * @param recentWorkVOList
     * @param userId
     */
    private void contractBudgetPersonPlan(List<TwRecentWorkVO> recentWorkVOList, Long userId) {

        final long num = saleConExecConditionService.queryWorkAgentFlagCount(userId);
        if (num > 0) {
            recentWorkVOList.add(TwRecentWorkVO.of(TwRecentWorkVO.RecentWorkType.CONTRACT_BUDGET_PERSON_PLAN.getDesc(), num, TwRecentWorkVO.RecentWorkType.CONTRACT_BUDGET_PERSON_PLAN.getCode()));
        }
    }

    //全局翻译
    void transferSystemSelection(PrdUserDataVO vo) {
        vo.setJobsName(cacheUtil.transferSystemSelection(FunctionSelectionEnum.EmployeeJobs.getCode(), vo.getJobs()));
    }


    /**
     * 项目汇报待提交
     *
     * @param recentWorkVOList
     */
    private void projectBriefWork(List<TwRecentWorkVO> recentWorkVOList, Long userId) {
//        List<PmsProjectVO> pmsProjectVOS = pmsProjectService.queryProjectBriefWork(userId);
//        if (!ObjectUtils.isEmpty(pmsProjectVOS)) {
//            recentWorkVOList.add(TwRecentWorkVO.of(TwRecentWorkVO.RecentWorkType.PROJECT_TO_BRIEF.getDesc(), (long) pmsProjectVOS.size(), TwRecentWorkVO.RecentWorkType.PROJECT_TO_BRIEF.getCode()));
//        }
    }

//    /**
//     * 查询项目预计当量&费用待更新代办
//     *
//     * @param recentWorkVOList
//     */
//    private void queryProjectUpdateWork(List<TwRecentWorkVO> recentWorkVOList, Long userId) {
//        final long num = pmsProjectService.queryProjectUpdateWorkCount(userId);
//        if (num > 0) {
//            recentWorkVOList.add(TwRecentWorkVO.of(TwRecentWorkVO.RecentWorkType.PROJECT_UPDATE.getDesc(), num, TwRecentWorkVO.RecentWorkType.PROJECT_UPDATE.getCode()));
//        }
//    }

    /**
     * 项目预算需变更代办
     *
     * @param recentWorkVOList
     */
    private void queryProjectUpdateBudgetWorkCount(List<TwRecentWorkVO> recentWorkVOList, Long userId) {
//        final long num = pmsProjectService.queryProjectUpdateBudgetWorkCount(userId);
//        if (num > 0) {
//            recentWorkVOList.add(TwRecentWorkVO.of(TwRecentWorkVO.RecentWorkType.PROJECT_BUDGET_UPDATE.getDesc(), num, TwRecentWorkVO.RecentWorkType.PROJECT_BUDGET_UPDATE.getCode()));
//        }
    }
}
