package com.elitesland.tw.tw5.server.prd.org.controller;

import com.alibaba.fastjson.JSONObject;
import com.elitescloud.boot.auth.model.OAuthToken;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.humanresources.payload.PersonResPayload;
import com.elitesland.tw.tw5.api.prd.humanresources.service.PersonResService;
import com.elitesland.tw.tw5.api.prd.org.payload.PrdOrgEmployeePayload;
import com.elitesland.tw.tw5.api.prd.org.payload.PrdOrgEmployeeRefPayload;
import com.elitesland.tw.tw5.api.prd.org.payload.PrdOrgTenantEmployeePayload;
import com.elitesland.tw.tw5.api.prd.org.query.PrdOrgEmployeeQuery;
import com.elitesland.tw.tw5.api.prd.org.service.PrdOrgEmployeeService;
import com.elitesland.tw.tw5.api.prd.org.vo.PrdOrgEmployeeVO;
import com.elitesland.tw.tw5.server.common.TwOutputUtil;
import com.elitesland.tw.tw5.server.udc.UdcNameClass;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.multipart.MultipartFile;

import javax.servlet.http.HttpServletResponse;
import java.util.Arrays;
import java.util.List;

/**
 * 员工管理
 *
 * @author wangding
 */
@Api("员工管理")
@RestController
@RequiredArgsConstructor
//@RequestMapping(API_ORG)
@RequestMapping("/api/org")
@Slf4j
public class PrdOrgEmployeeController {

    private final PrdOrgEmployeeService service;

    private final PersonResService resService;

    /**
     * 通过租户新增
     *
     * @param entity po类
     * @return result
     */
    @PostMapping("/employee/saveTenantUser")
    public TwOutputUtil saveTenantUser(PrdOrgTenantEmployeePayload entity) {
        return TwOutputUtil.ok(service.saveTenantUser(entity));

    }

    /**
     * 新建
     *
     * @param entity po类
     * @return result
     */
    @ApiOperation("新增")
    @PostMapping("/employee/insert")
    //@GlobalTransactional
    public TwOutputUtil insert(@RequestBody PrdOrgEmployeePayload entity) {
        return TwOutputUtil.ok(service.insert(entity));

    }

    /**
     * 全部修改
     *
     * @param entity po类
     * @return result
     */
    @ApiOperation("修改")
    @PutMapping("/employee/update")
    //@GlobalTransactional
    public TwOutputUtil update(@RequestBody PrdOrgEmployeePayload entity) {
        service.update(entity);
        return TwOutputUtil.ok();

    }

    /**
     * 修改员工组织关系
     *
     * @param payloadStrs po类
     * @return result
     */
    @ApiOperation("修改员工组织关系")
    @PutMapping("/employee/updateEmployeeRef")
    public TwOutputUtil updateEmployeeRef(String payloadStrs) {
        service.updateEmployeeRef(JSONObject.parseArray(payloadStrs, PrdOrgEmployeeRefPayload.class));
        return TwOutputUtil.ok();

    }

    /**
     * 列表查询
     *
     * @param query 条件
     * @return result
     */
    @ApiOperation("列表查询")
    @UdcNameClass
    @GetMapping("/employee/list")
    public TwOutputUtil queryList(PrdOrgEmployeeQuery query) {
        List<PrdOrgEmployeeVO> list = service.queryList(query);
        return TwOutputUtil.ok(list);
    }

    /**
     * 分页条件查询
     *
     * @param query 条件
     * @return result
     */
    @ApiOperation("分页条件查询")
    @GetMapping("/employee/pading")
    public TwOutputUtil queryPading(PrdOrgEmployeeQuery query) {
        PagingVO<PrdOrgEmployeeVO> paging = service.paging(query);
        return TwOutputUtil.ok(paging);
    }

    /**
     * 根据主键查询
     *
     * @param key 主键
     * @return result
     */
    @ApiOperation("主键查询")
    @UdcNameClass
    @GetMapping("/employee/{key}")
    public TwOutputUtil findByKey(@PathVariable Long key) {
        PrdOrgEmployeeVO vo = service.queryByKey(key);
        return TwOutputUtil.ok(vo);
    }

    /**
     * 根据用户id查询
     *
     * @param userId 主键
     * @return result
     */
    @ApiOperation("用户id查询")
    @GetMapping("/employee/byUserId/{userId}")
    public TwOutputUtil findByUserId(@PathVariable Long userId) {
        PrdOrgEmployeeVO vo = service.queryByUserId(userId);
        return TwOutputUtil.ok(vo);
    }

    /**
     * 根据主键查询所有上级id
     *
     * @param key 主键
     * @return result
     */
    @ApiOperation("根据主键查询所有上级id")
    @GetMapping("/employee/queryParentIds/{key}")
    public TwOutputUtil queryParentIds(@PathVariable Long key) {
        return TwOutputUtil.ok(service.queryParentIdsByUserId(key));
    }


    /**
     * 逻辑删除
     *
     * @param keys 主键
     * @return result
     */
    @ApiOperation("逻辑删除")
    @DeleteMapping("/employee/delete")
    //@GlobalTransactional
    public TwOutputUtil delete(Long[] keys) {
        service.deleteSoft(Arrays.asList(keys));
        return TwOutputUtil.ok();
    }


    /**
     * 移除员工组织
     *
     * @param userId 员工id
     * @param orgIds 组织ids
     * @return result
     */
    @ApiOperation("移除员工组织")
    @PutMapping("/employee/deleteOrg")
    public TwOutputUtil deleteOrg(Long userId, Long[] orgIds) {
        service.deleteOrgRefSoft(userId, Arrays.asList(orgIds));
        return TwOutputUtil.ok();
    }


    /**
     * 重置密码
     *
     * @param userId 被操作员工主键
     * @return result
     */
    @ApiOperation("重置密码")
    @GetMapping("/employee/resetEmployeePawword/{userId}")
    public TwOutputUtil resetEmployeePawword(@PathVariable Long userId) {
        service.resetEmployeePawword(userId);
        return TwOutputUtil.ok();
    }

    /**
     * 获取用户uuid
     *
     * @return result
     */
    @GetMapping("/employee/getUserUUid")
    public TwOutputUtil getUserUUid() {
        return TwOutputUtil.ok(service.getUserUUid());
    }


    /**
     * 绑定企业微信id
     *
     * @param uuid
     * @return result
     */
    @GetMapping("/employee/bindWecomId")
    public TwOutputUtil bindWecomId(String uuid) {
        return TwOutputUtil.ok(service.bindWecomId(uuid));
    }


    /**
     * 更新企业微信id
     *
     * @param userId
     * @return result
     */
    @GetMapping("/employee/updateWecomId")
    public TwOutputUtil updateWecomId(Long[] userId) {
        List<Long> userIdsData = null;
        if (userId != null && userId.length > 0) {
            userIdsData = Arrays.asList(userId);
        }
        service.updateWecomId(userIdsData);
        return TwOutputUtil.ok();
    }

    /**
     * 解绑企业微信id
     *
     * @param userId
     * @return result
     */
    @GetMapping("/employee/unbindWecomId")
    public TwOutputUtil unbindWecomId(Long[] userId) {
        List<Long> userIdsData = null;
        if (userId != null && userId.length > 0) {
            userIdsData = Arrays.asList(userId);
        }
        service.unbindWecomId(userIdsData);
        return TwOutputUtil.ok();
    }

    /**
     * 消费登录授权码,获取企业微信的用户信息
     *
     * @return result
     */
    @GetMapping("/employee/wxLogin/{code}")
    public ApiResult<OAuthToken> wxLogin(@PathVariable String code) {
        ApiResult<OAuthToken> result = service.wxLogin(code);
        return result;
    }

//    /**
//     * 全局更新企业微信id
//     *
//     * @return result
//     */
//    @GetMapping("/employee/updateAllWecomId")
//    public TwOutputUtil updateAllWecomId() {
//        service.updateAllWecomId();
//        return TwOutputUtil.ok();
//    }

    /**
     * 批量导出excel
     *
     * @return result
     */
    @ApiOperation("批量导出excel")
    @GetMapping("/employee/batchExport")
    public void batchExport(HttpServletResponse response, PrdOrgEmployeeQuery query) {
        service.downloadPlus(response, query);
    }

    /**
     * 批量导入excel
     *
     * @return result
     */
    @ApiOperation("批量导入excel")
    @PostMapping(value = "/employee/batchImport", consumes = MediaType.MULTIPART_FORM_DATA_VALUE)
    //@GlobalTransactional
    public TwOutputUtil batchImport(MultipartFile file) {
        service.importEmployees(file);
        return TwOutputUtil.ok();
    }
//    /**
//     * 测试批量导出excel
//     *
//     * @return result
//     */
//    @ApiOperation("测试")
//    @GetMapping("/employee/batchExportTest")
//
//    public void batchExportTest(HttpServletResponse response) {
//        PrdOrgEmployeeQuery query = new PrdOrgEmployeeQuery();
//        PagingVO<PrdOrgEmployeeVO> evo = service.paging(query);
//        List<PrdOrgEmployeeVO> list = evo.getRecords();
//        service.downloadPlus(response, list);
//    }

    /**
     * 查询用户角色
     *
     * @param userId
     * @return
     */
    @ApiOperation("根据id查询用户角色")
    @GetMapping("/employee/queryUserRole")
    public TwOutputUtil queryUserRole(Long userId) {
        List<String> roleCodes = service.queryUserRole(userId);
        return TwOutputUtil.ok(roleCodes);
    }

//    /**
//     * 加入黑名单
//     *
//     * @param id
//     * @return
//     */
//    @ApiOperation("加入黑名单")
//    @PostMapping("/employee/inBlack")
//    public TwOutputUtil updateBlack(Long id) {
//        service.updateBlackList(id);
//        return TwOutputUtil.ok();
//    }

    /**
     * 资源新增
     *
     * @param entity
     * @return
     */
    @ApiOperation("资源新增")
    @PostMapping("/res/insert")
    public TwOutputUtil insertRes(@RequestBody PrdOrgEmployeePayload entity) {
        service.insertNew(entity);
        return TwOutputUtil.ok();
    }

    /**
     * 全部修改
     *
     * @param entity po类
     * @return result
     */
    @ApiOperation("资源修改")
    @PostMapping("/res/update")
    // @GlobalTransactional
    public TwOutputUtil update(@RequestBody PersonResPayload entity) {
        service.updateNew(entity);
        return TwOutputUtil.ok();

    }

    /**
     * 全部修改
     *
     * @param entity po类
     * @return result
     */
    @ApiOperation("个人信息变更-提交")
    @PostMapping("/res/personInfoChange/submit")
//    @GlobalTransactional
    public TwOutputUtil submitPersonInfoChange(@RequestBody PersonResPayload entity) {
        resService.personInfoChangeSubmit(entity);
        return TwOutputUtil.ok();
    }

    /**
     * 个人信息变更-编辑
     *
     * @param entity po类
     * @return result
     */
    @ApiOperation("个人信息变更-编辑")
    @PostMapping("/res/personInfoChange/update")
    public TwOutputUtil personalUpdate(@RequestBody PersonResPayload entity) {
        resService.updateChange(entity);
        return TwOutputUtil.ok();
    }

    /**
     * 信息变更对比
     *
     * @param procId po类
     * @return result
     */
    @ApiOperation("个人信息变更对比")
    @GetMapping("/res/update/personal/query")
    public TwOutputUtil personalChangeInfo(Long employeeId, String procId) {
        return TwOutputUtil.ok(resService.personalChangeInfo(employeeId, procId));
    }

    /**
     * 入职信息完善检查
     *
     * @param personId
     * @return result
     */
    @ApiOperation("入职信息完善检查")
    @GetMapping("/res/entry/check/{personId}")
    public TwOutputUtil entryInfoCheck(@PathVariable Long personId) {
        return TwOutputUtil.ok(service.entryInfoCheck(personId));
    }

    /**
     * 分页查询 用户与角色一一对应
     *
     * @param query
     * @return
     */
    @ApiOperation("分页条件查询用户跟角色一一对应")
    @GetMapping("/employee/pagingRole")
    public TwOutputUtil queryPagingRoleO(PrdOrgEmployeeQuery query) {
        return TwOutputUtil.ok(service.pagingRole(query));
    }

    /**
     * 通过维度id查询维度下用户所有直属上级数据
     *
     * @param dimensionId 维度id，如果为空则是查所有维度下用户上级数据
     * @param userId      用户id ，如果为空则查当前登录人上级数据
     * @return
     */
    @ApiOperation("通过维度id查询维度下用户所有直属上级数据")
    @GetMapping("/employee/queryParentUsers")
    public TwOutputUtil queryParentUsers(Long dimensionId, Long userId) {
        return TwOutputUtil.ok(service.queryParentUsers(dimensionId, userId));
    }

    /**
     * 通过值id查询组织下用户所有直属下级数据
     *
     * @param orgId  组织id，如果为空则是查所有组织下用户直属下级数据
     * @param userId 用户id ，如果为空则查当前登录人直属下级数据
     * @return
     */
    @ApiOperation("通过值id查询维度下用户所有直属下级数据")
    @GetMapping("/employee/queryLowListByKey")
    public TwOutputUtil queryLowListByKey(Long orgId, Long userId) {
        return TwOutputUtil.ok(service.queryLowListByKey(orgId, userId));
    }

    /**
     * 通过值id查询组织下用户所有所有下级（下级的下级。。。）数据
     *
     * @param orgId  组织id，如果为空则是查所有组织下用户直属下级数据
     * @param userId 用户id ，如果为空则查当前登录人直属下级数据
     * @return
     */
    @ApiOperation("通过值id查询维度下用户所有所有下级（下级的下级。。。）数据")
    @GetMapping("/employee/queryLowChildListByKey")
    public TwOutputUtil queryLowChildListByKey(Long orgId, Long userId) {
        return TwOutputUtil.ok(service.queryLowChildListByKey(orgId, userId));
    }

    /**
     * 通过值id查询维度下用户所有所有上级（上级的上级。。。）数据
     *
     * @param dimensionId 维度id，果为空则是查所有维度下用户上级上级数据
     * @param userId      用户id ，如果为空则查当前登录人直属下级数据
     * @return
     */
    @ApiOperation("通过值id查询维度下用户所有所有上级（上级的上级。。。）数据")
    @GetMapping("/employee/queryAllParentUsers")
    public TwOutputUtil queryAllParentUsers(Long dimensionId, Long userId) {
        return TwOutputUtil.ok(service.queryAllParentUsers(dimensionId, userId));
    }
}
