package com.elitesland.tw.tw5.server.prd.partner.business.dao;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.partner.business.payload.BusinessOperationPartnerPayload;
import com.elitesland.tw.tw5.api.prd.partner.business.query.BusinessOperationPartnerQuery;
import com.elitesland.tw.tw5.api.prd.partner.business.vo.BusinessOperationPartnerVO;
import com.elitesland.tw.tw5.server.common.util.SqlUtil;
import com.elitesland.tw.tw5.server.prd.partner.business.entity.BusinessOperationPartnerDO;
import com.elitesland.tw.tw5.server.prd.partner.business.entity.QBusinessOperationPartnerDO;
import com.elitesland.tw.tw5.server.prd.partner.business.repo.BusinessOperationPartnerRepo;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import com.querydsl.jpa.impl.JPAUpdateClause;
import lombok.RequiredArgsConstructor;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.ObjectUtils;

import java.util.ArrayList;
import java.util.List;

/**
 * 业务合作伙伴-工商股东
 *
 * @author wangly
 * @date 2023-05-18
 */
@Repository
@RequiredArgsConstructor
public class BusinessOperationPartnerDAO {

    private final JPAQueryFactory jpaQueryFactory;
    private final BusinessOperationPartnerRepo repo;
    private final QBusinessOperationPartnerDO qdo = QBusinessOperationPartnerDO.businessOperationPartnerDO;

    /**
     * 拼装查询字段
     *
     * @return jpaQuery对象
     */
    private JPAQuery<BusinessOperationPartnerVO> getJpaQuerySelect() {
        return jpaQueryFactory.select(Projections.bean(BusinessOperationPartnerVO.class,
                qdo.id,
                //qdo.remark,
                //qdo.createUserId,
                //qdo.creator,
                //qdo.createTime,
                //qdo.modifyUserId,
                //qdo.updater,
                //qdo.modifyTime,
                // 地址簿id
                qdo.bookId,
                // 总实缴
                qdo.totalRealCapi,
                // 出资时间
                qdo.date,
                // 历史股东
                qdo.isHstory,
                // 股东类型
                qdo.stockType,
                // 股东姓名
                qdo.name,
                // 人员id（股东为自然人显示pid）
                qdo.pid,
                // 认缴出资列表
                qdo.shouldcapiitems,
                // 总认缴
                qdo.totalShouldCapi,
                // 股比
                qdo.stockPercent,
                // 企业id（股东为企业显示eid）
                qdo.eid,
                // 类型
                qdo.identifyType,
                // 认缴出资额
                qdo.capi,
                // 股东ID
                qdo.identifyNo,
                // 实缴出资列表s
                qdo.realCapiItems,
                // 出资方式
                qdo.type,
                // 业务伙伴主键 business_partner.id
                qdo.partnerId,
                // 业务伙伴名称
                qdo.partnerName
        )).from(qdo);
    }

    /**
     * 拼装查询条件
     *
     * @param query 查询参数
     * @return jpaQuery对象
     */
    private JPAQuery<BusinessOperationPartnerVO> getJpaQueryWhere(BusinessOperationPartnerQuery query) {
        JPAQuery<BusinessOperationPartnerVO> jpaQuery = getJpaQuerySelect();
            // 条件封装
            jpaQuery.where(where(query));
            // 常用基础查询条件拼装
            SqlUtil.handleCommonJpaQuery(jpaQuery, qdo._super, query);
            // 动态排序
            jpaQuery.orderBy(SqlUtil.getSortedColumn(qdo, query.getOrders()));
            return jpaQuery;
    }

    /**
     * 统计
     *
     * @param query 查询参数
     * @return jpaQuery对象
     */
    public long count(BusinessOperationPartnerQuery query) {
        JPAQuery<Long> jpaQuery = jpaQueryFactory
        .select(qdo.count())
        .from(qdo);
        jpaQuery.where(where(query));
        // 常用基础查询条件拼装
        SqlUtil.handleCommonJpaQuery(jpaQuery, qdo._super, query);
        long total = jpaQuery.fetchOne();
        return total;
    }

    /**
     * 查询条件封装
     *
     * @param query 条件
     * @return {@link Predicate}
     */
    private Predicate where(BusinessOperationPartnerQuery query){
        List<Predicate> list = new ArrayList<>();
        /** 记录唯一ID 精确 */
        if (!ObjectUtils.isEmpty(query.getId())) {
            list.add(qdo.id.eq(query.getId()));
        }
        /** 地址簿id 精确 */
        if (!ObjectUtils.isEmpty(query.getBookId())) {
            list.add(qdo.bookId.eq(query.getBookId()));
        }
        /** 总实缴 精确 */
        if (!ObjectUtils.isEmpty(query.getTotalRealCapi())) {
            list.add(qdo.totalRealCapi.eq(query.getTotalRealCapi()));
        }
        /** 出资时间 精确 */
        if (!ObjectUtils.isEmpty(query.getDate())) {
            list.add(qdo.date.eq(query.getDate()));
        }
        /** 历史股东 精确 */
        if (!ObjectUtils.isEmpty(query.getIsHstory())) {
            list.add(qdo.isHstory.eq(query.getIsHstory()));
        }
        /** 股东类型 精确 */
        if (!ObjectUtils.isEmpty(query.getStockType())) {
            list.add(qdo.stockType.eq(query.getStockType()));
        }
        /** 股东姓名 精确 */
        if (!ObjectUtils.isEmpty(query.getName())) {
            list.add(qdo.name.eq(query.getName()));
        }
        /** 人员id（股东为自然人显示pid） 精确 */
        if (!ObjectUtils.isEmpty(query.getPid())) {
            list.add(qdo.pid.eq(query.getPid()));
        }
        /** 认缴出资列表 精确 */
        if (!ObjectUtils.isEmpty(query.getShouldcapiitems())) {
            list.add(qdo.shouldcapiitems.eq(query.getShouldcapiitems()));
        }
        /** 总认缴 精确 */
        if (!ObjectUtils.isEmpty(query.getTotalShouldCapi())) {
            list.add(qdo.totalShouldCapi.eq(query.getTotalShouldCapi()));
        }
        /** 股比 精确 */
        if (!ObjectUtils.isEmpty(query.getStockPercent())) {
            list.add(qdo.stockPercent.eq(query.getStockPercent()));
        }
        /** 企业id（股东为企业显示eid） 精确 */
        if (!ObjectUtils.isEmpty(query.getEid())) {
            list.add(qdo.eid.eq(query.getEid()));
        }
        /** 类型 精确 */
        if (!ObjectUtils.isEmpty(query.getIdentifyType())) {
            list.add(qdo.identifyType.eq(query.getIdentifyType()));
        }
        /** 认缴出资额 精确 */
        if (!ObjectUtils.isEmpty(query.getCapi())) {
            list.add(qdo.capi.eq(query.getCapi()));
        }
        /** 股东ID 精确 */
        if (!ObjectUtils.isEmpty(query.getIdentifyNo())) {
            list.add(qdo.identifyNo.eq(query.getIdentifyNo()));
        }
        /** 实缴出资列表 精确 */
        if (!ObjectUtils.isEmpty(query.getRealCapiItems())) {
            list.add(qdo.realCapiItems.eq(query.getRealCapiItems()));
        }
        /** 出资方式 精确 */
        if (!ObjectUtils.isEmpty(query.getType())) {
            list.add(qdo.type.eq(query.getType()));
        }
        /** 业务伙伴主键 business_partner.id 精确 */
        if (!ObjectUtils.isEmpty(query.getPartnerId())) {
            list.add(qdo.partnerId.eq(query.getPartnerId()));
        }
        /** 业务伙伴名称 精确 */
        if (!ObjectUtils.isEmpty(query.getPartnerName())) {
            list.add(qdo.partnerName.eq(query.getPartnerName()));
        }
        return ExpressionUtils.allOf(list);
    }

    /**
     * 根据主键查询
     *
     * @param id 主键
     * @return 结果
     */
    public BusinessOperationPartnerVO queryByKey(Long id) {
        JPAQuery<BusinessOperationPartnerVO> jpaQuery = getJpaQuerySelect();
            jpaQuery.where(qdo.id.eq(id));
            jpaQuery.where(qdo.deleteFlag.eq(0));
        return jpaQuery.fetchFirst();
    }

    /**
     * 动态查询集合
     *
     * @param query 查询参数
     * @return 结果集合
     */
    public List<BusinessOperationPartnerVO> queryListDynamic(BusinessOperationPartnerQuery query) {
        JPAQuery<BusinessOperationPartnerVO> jpaQuery = getJpaQueryWhere(query);
        return jpaQuery.fetch();
    }

    /**
     * 分页查询
     *
     * @param query 查询参数
     * @return 分页结果
     */
    public PagingVO<BusinessOperationPartnerVO> queryPaging(BusinessOperationPartnerQuery query) {
        long total = count(query);
        if (total == 0) {
             return PagingVO.empty();
        }
        JPAQuery<BusinessOperationPartnerVO> jpaQuery = getJpaQueryWhere(query);
        List<BusinessOperationPartnerVO> result = jpaQuery
                .offset(query.getPageRequest().getOffset())
                .limit(query.getPageRequest().getPageSize())
                .fetch();
        return PagingVO.<BusinessOperationPartnerVO>builder().records(result).total(total).build();
    }

    /**
     * 调用jpa的保存
     *
     * @param ado do对象
     * @return 保存后的对象
     */
    public BusinessOperationPartnerDO save(BusinessOperationPartnerDO ado) {
        return repo.save(ado);
    }

    /**
     * 调用jpa的保存所有
     *
     * @param dos 多个do对象
     * @return 保存后的对象集合
     */
    public List<BusinessOperationPartnerDO> saveAll(List<BusinessOperationPartnerDO> dos) {
        return repo.saveAll(dos);
    }

    /**
     * 按主键动态修改（只修非null字段，如果需要将某些字段修改为null，请添加nullFields）
     *
     * @param payload 要修改的对象
     * @return 修改的行数
     */
    @Transactional
    public long updateByKeyDynamic(BusinessOperationPartnerPayload payload) {
        JPAUpdateClause update = jpaQueryFactory.update(qdo)
        .where(qdo.id.eq(payload.getId()));
        // 记录唯一ID
        if (payload.getId() != null) {
            update.set(qdo.id, payload.getId());
        }
        // 地址簿id
        if (payload.getBookId() != null) {
            update.set(qdo.bookId, payload.getBookId());
        }
        // 总实缴
        if (payload.getTotalRealCapi() != null) {
            update.set(qdo.totalRealCapi, payload.getTotalRealCapi());
        }
        // 出资时间
        if (payload.getDate() != null) {
            update.set(qdo.date, payload.getDate());
        }
        // 历史股东
        if (payload.getIsHstory() != null) {
            update.set(qdo.isHstory, payload.getIsHstory());
        }
        // 股东类型
        if (payload.getStockType() != null) {
            update.set(qdo.stockType, payload.getStockType());
        }
        // 股东姓名
        if (payload.getName() != null) {
            update.set(qdo.name, payload.getName());
        }
        // 人员id（股东为自然人显示pid）
        if (payload.getPid() != null) {
            update.set(qdo.pid, payload.getPid());
        }
        // 认缴出资列表
        if (payload.getShouldcapiitems() != null) {
            update.set(qdo.shouldcapiitems, payload.getShouldcapiitems());
        }
        // 总认缴
        if (payload.getTotalShouldCapi() != null) {
            update.set(qdo.totalShouldCapi, payload.getTotalShouldCapi());
        }
        // 股比
        if (payload.getStockPercent() != null) {
            update.set(qdo.stockPercent, payload.getStockPercent());
        }
        // 企业id（股东为企业显示eid）
        if (payload.getEid() != null) {
            update.set(qdo.eid, payload.getEid());
        }
        // 类型
        if (payload.getIdentifyType() != null) {
            update.set(qdo.identifyType, payload.getIdentifyType());
        }
        // 认缴出资额
        if (payload.getCapi() != null) {
            update.set(qdo.capi, payload.getCapi());
        }
        // 股东ID
        if (payload.getIdentifyNo() != null) {
            update.set(qdo.identifyNo, payload.getIdentifyNo());
        }
        // 实缴出资列表
        if (payload.getRealCapiItems() != null) {
            update.set(qdo.realCapiItems, payload.getRealCapiItems());
        }
        // 出资方式
        if (payload.getType() != null) {
            update.set(qdo.type, payload.getType());
        }
        // 业务伙伴主键 business_partner.id
        if (payload.getPartnerId() != null) {
            update.set(qdo.partnerId, payload.getPartnerId());
        }
        // 业务伙伴名称
        if (payload.getPartnerName() != null) {
            update.set(qdo.partnerName, payload.getPartnerName());
        }
        // 处理要设置成空的字段
        List<String> nullFields = payload.getNullFields();
        if (nullFields != null && nullFields.size() > 0) {
            // 记录唯一ID
            if (nullFields.contains("id")) {
                update.setNull(qdo.id);
            }
            // 地址簿id
            if (nullFields.contains("bookId")) {
                update.setNull(qdo.bookId);
            }
            // 总实缴
            if (nullFields.contains("totalRealCapi")) {
                update.setNull(qdo.totalRealCapi);
            }
            // 出资时间
            if (nullFields.contains("date")) {
                update.setNull(qdo.date);
            }
            // 历史股东
            if (nullFields.contains("isHstory")) {
                update.setNull(qdo.isHstory);
            }
            // 股东类型
            if (nullFields.contains("stockType")) {
                update.setNull(qdo.stockType);
            }
            // 股东姓名
            if (nullFields.contains("name")) {
                update.setNull(qdo.name);
            }
            // 人员id（股东为自然人显示pid）
            if (nullFields.contains("pid")) {
                update.setNull(qdo.pid);
            }
            // 认缴出资列表
            if (nullFields.contains("shouldcapiitems")) {
                update.setNull(qdo.shouldcapiitems);
            }
            // 总认缴
            if (nullFields.contains("totalShouldCapi")) {
                update.setNull(qdo.totalShouldCapi);
            }
            // 股比
            if (nullFields.contains("stockPercent")) {
                update.setNull(qdo.stockPercent);
            }
            // 企业id（股东为企业显示eid）
            if (nullFields.contains("eid")) {
                update.setNull(qdo.eid);
            }
            // 类型
            if (nullFields.contains("identifyType")) {
                update.setNull(qdo.identifyType);
            }
            // 认缴出资额
            if (nullFields.contains("capi")) {
                update.setNull(qdo.capi);
            }
            // 股东ID
            if (nullFields.contains("identifyNo")) {
                update.setNull(qdo.identifyNo);
            }
            // 实缴出资列表
            if (nullFields.contains("realCapiItems")) {
                update.setNull(qdo.realCapiItems);
            }
            // 出资方式
            if (nullFields.contains("type")) {
                update.setNull(qdo.type);
            }
            // 业务伙伴主键 business_partner.id
            if (nullFields.contains("partnerId")) {
                update.setNull(qdo.partnerId);
            }
            // 业务伙伴名称
            if (nullFields.contains("partnerName")) {
                update.setNull(qdo.partnerName);
            }
        }
        //拼装更新
        SqlUtil.updateCommonJpaQuery(update, qdo._super);
        // 执行修改
        return update.execute();
    }

    /**
     * 逻辑删除
     *
     * @param keys 主集合
     * @return 删除的行数
     */
    public long deleteSoft(List<Long> keys) {
        JPAUpdateClause update = jpaQueryFactory.update(qdo)
            .set(qdo.deleteFlag, 1)
            .where(qdo.id.in(keys));
        //拼装更新
        SqlUtil.updateCommonJpaQuery(update, qdo._super);
        return update.execute();
    }
    /**
     * 根据partnerId删除
     *
     * @param partnerId 业务伙伴id
     * @return 删除的行数
     */
    public void deleteByPartnerId(Long partnerId){
        JPAUpdateClause update = jpaQueryFactory.update(qdo)
                .set(qdo.deleteFlag, 1)
                .where(qdo.partnerId.eq(partnerId));
        //拼装更新
        SqlUtil.updateCommonJpaQuery(update, qdo._super);
        update.execute();
    }
}

