package com.elitesland.tw.tw5.server.prd.partner.identity.entity;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.bean.copier.CopyOptions;
import com.elitescloud.boot.model.entity.BaseModel;
import com.elitescloud.cloudt.common.annotation.Comment;
import com.elitesland.tw.tw5.api.common.annotation.FieldCreateLog;
import com.elitesland.tw.tw5.api.common.annotation.FieldUpdateLog;
import com.elitesland.workflow.enums.ProcInstStatus;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;
import org.hibernate.annotations.Where;

import javax.persistence.*;
import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;

/**
 * 业务伙伴-客户信息
 *
 * @author wangly
 * @date 2023-05-16
 */
@Entity
@Table(name = "com_business_customer_info", indexes = {
        @Index(name = "index_partner_id", columnList = "partner_id"),
        @Index(name="index_book_id",columnList = "book_id")
})
@org.hibernate.annotations.Table(appliesTo = "com_business_customer_info", comment = "业务伙伴-客户信息")
@Getter
@Setter
@Where(clause = "delete_flag= 0")
public class BusinessCustomerInfoDO extends BaseModel implements Serializable {
    /**
     * 业务伙伴id business_partner.id
     */
    @Comment("业务伙伴id")
    @Column(name = "partner_id")
    private Long partnerId;

    /**
     * 地址薄id
     */
    @Comment("地址薄id")
    @Column(name = "book_id")
    private Long bookId;

    /**
     * 客户编号
     */
    @Comment("客户编号")
    @Column()
    private String customerNo;

    /**
     * 客户状态 udc[CRM:BUSINESS_PARTNER:STATUS]
     */
    @Comment("客户状态 udc[CRM:BUSINESS_PARTNER:STATUS]")
    @Column()
    @FieldUpdateLog(fieldName = "客户状态", selectionKey = "CRM:BUSINESS_PARTNER:STATUS")
    @FieldCreateLog(fieldName = "客户状态", selectionKey = "CRM:BUSINESS_PARTNER:STATUS")
    private String customerStatus;
    /**
     * 客户级别 udc[crm:customer_grade]
     */
    @Comment("客户级别 udc[crm:customer_grade]")
    @Column()
    @FieldUpdateLog(fieldName = "客户级别", selectionKey = "crm:customer_grade")
    @FieldCreateLog(fieldName = "客户级别", selectionKey = "crm:customer_grade")
    private String customerGradle;
    /**
     * 客户来源 udc[crm:customer_source]
     */
    @Comment("客户来源 udc[crm:customer_source]")
    @Column()
    @FieldUpdateLog(fieldName = "客户来源", selectionKey = "crm:customer_source")
    @FieldCreateLog(fieldName = "客户来源", selectionKey = "crm:customer_source")
    private String customerSource;
    /**
     * 客户区域 udc[crm:customer_region]
     */
    @Comment("客户区域 udc[crm:customer_region]")
    @Column()
    @FieldUpdateLog(fieldName = "客户区域", selectionKey = "crm:customer_region")
    @FieldCreateLog(fieldName = "客户区域", selectionKey = "crm:customer_region")
    private String customerRegion;
    /**
     * 客户经营状态
     */
    @Comment("客户经营状态")
    @Column()
    @FieldUpdateLog(fieldName = "客户经营状态", selectionKey = "CRM:BUSINESS_PARTNER:SWITCH")
    @FieldCreateLog(fieldName = "客户经营状态", selectionKey = "CRM:BUSINESS_PARTNER:SWITCH")
    private Boolean isOperate;

    /**
     * 客户来源 udc[crm:customer_source]
     */
    @Comment("客户阶段 udc[crm:customer_stage]")
    @Column()
    @FieldUpdateLog(fieldName = "客户阶段", selectionKey = "crm:customer_stage")
    @FieldCreateLog(fieldName = "客户阶段", selectionKey = "crm:customer_stage")
    private String customerStage;

    /**
     * 流程实例ID
     */
    @Comment("流程实例ID")
    @Column()
    private String procInstId;
    /**
     * 流程审批状态
     */
    @Comment("流程审批状态")
    @Column()
    @Enumerated(EnumType.STRING)
    private ProcInstStatus procInstStatus;
    /**
     * 提交时间
     */
    @Comment("提交时间")
    @Column()
    private LocalDateTime submitTime;
    /**
     * 审批时间
     */
    @Comment("审批时间")
    @Column()
    private LocalDateTime approvedTime;


    /**
     * 策略id business_strategy.id
     */
    @Comment("策略id business_strategy.id")
    @Column()
    private Long strategyId;

    /**
     * 分数
     */
    @Comment("分数")
    @Column()
    private BigDecimal score;

    /**
     * 指标详情
     */
    @Comment("指标详情")
    @Column(name = "indexInfo",
            columnDefinition = "TEXT comment '规格属性Json' ")
    private String indexInfo;

    /**
     * 扩展字段1
     */
    @Comment("扩展字段1")
    @Column()
    private String ext1;
    /**
     * 扩展字段2
     */
    @Comment("扩展字段2")
    @Column()
    private String ext2;
    /**
     * 扩展字段3
     */
    @Comment("扩展字段3")
    @Column()
    private String ext3;
    /**
     * 扩展字段4
     */
    @Comment("扩展字段4")
    @Column()
    private String ext4;
    /**
     * 扩展字段5
     */
    @Comment("扩展字段5")
    @Column()
    private String ext5;

    /**
     * 待确认潜在客户
     */
    @Comment("待确认潜在客户")
    @Column()
    private Boolean confirmFlag;

    @Comment("同步时间")
    @Column()
    private LocalDateTime syncTime;

    /**
     * 是否同步过JDE
     */
    @Comment("是否同步过JDE")
    @Column()
    private Boolean syncJdeFlag;


    /**
     * 是否是新客户
     */
    @Comment("是否是新客户")
    @Column()
    private Boolean newCustFlag;
    public void copy(BusinessCustomerInfoDO source) {
        BeanUtil.copyProperties(source, this, CopyOptions.create().setIgnoreNullValue(true));
    }
}
