package com.elitesland.tw.tw5.server.prd.partner.strategy.service;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.boot.core.base.BaseServiceImpl;
import com.elitesland.tw.tw5.api.prd.partner.strategy.payload.BusinessModelIndexSettingPayload;
import com.elitesland.tw.tw5.api.prd.partner.strategy.query.BusinessModelIndexSettingQuery;
import com.elitesland.tw.tw5.api.prd.partner.strategy.service.BusinessModelIndexSettingService;
import com.elitesland.tw.tw5.api.prd.partner.strategy.vo.BusinessModelIndexSettingVO;
import com.elitesland.tw.tw5.server.prd.partner.constants.BusinessStrategyIndexEnum;
import com.elitesland.tw.tw5.server.prd.partner.strategy.convert.BusinessModelIndexSettingConvert;
import com.elitesland.tw.tw5.server.prd.partner.strategy.dao.BusinessModelIndexSettingDAO;
import com.elitesland.tw.tw5.server.prd.partner.strategy.entity.BusinessModelIndexSettingDO;
import com.elitesland.tw.tw5.server.prd.partner.strategy.repo.BusinessModelIndexSettingRepo;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

import java.util.List;
import java.util.Optional;

/**
 * 分级策略模型指标配置
 *
 * @author wangly
 * @date 2023-06-19
 */
@Service
@RequiredArgsConstructor
@Slf4j
public class BusinessModelIndexSettingServiceImpl extends BaseServiceImpl implements BusinessModelIndexSettingService {

    private final BusinessModelIndexSettingRepo businessModelIndexSettingRepo;
    private final BusinessModelIndexSettingDAO businessModelIndexSettingDAO;

    @Override
    public PagingVO<BusinessModelIndexSettingVO> queryPaging(BusinessModelIndexSettingQuery query){
        return businessModelIndexSettingDAO.queryPaging(query);
    }

    @Override
    public List<BusinessModelIndexSettingVO> queryListDynamic(BusinessModelIndexSettingQuery query){
        List<BusinessModelIndexSettingVO> businessModelIndexSettingVOS = businessModelIndexSettingDAO.queryListDynamic(query);
        businessModelIndexSettingVOS.forEach(vo->{
            vo.setSourceFiledDesc(BusinessStrategyIndexEnum.valueOf(vo.getSourceFiled()).getDesc());
        });
        return businessModelIndexSettingVOS;
    }

    @Override
    public BusinessModelIndexSettingVO queryByKey(Long key) {
        BusinessModelIndexSettingDO entity = businessModelIndexSettingRepo.findById(key).orElseGet(BusinessModelIndexSettingDO::new);
        Assert.notNull(entity.getId(), "不存在");
        BusinessModelIndexSettingVO vo = BusinessModelIndexSettingConvert.INSTANCE.toVo(entity);
        return vo;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public BusinessModelIndexSettingVO insert(BusinessModelIndexSettingPayload payload) {
        BusinessModelIndexSettingDO entityDo = BusinessModelIndexSettingConvert.INSTANCE.toDo(payload);
        return BusinessModelIndexSettingConvert.INSTANCE.toVo(businessModelIndexSettingRepo.save(entityDo));
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public BusinessModelIndexSettingVO update(BusinessModelIndexSettingPayload payload) {
        BusinessModelIndexSettingDO entity = businessModelIndexSettingRepo.findById(payload.getId()).orElseGet(BusinessModelIndexSettingDO::new);
        Assert.notNull(entity.getId(), "不存在");
        BusinessModelIndexSettingDO entityDo = BusinessModelIndexSettingConvert.INSTANCE.toDo(payload);
        entity.copy(entityDo);
        return BusinessModelIndexSettingConvert.INSTANCE.toVo(businessModelIndexSettingRepo.save(entity));
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public long updateByKeyDynamic(BusinessModelIndexSettingPayload payload) {
        BusinessModelIndexSettingDO entity = businessModelIndexSettingRepo.findById(payload.getId()).orElseGet(BusinessModelIndexSettingDO::new);
        Assert.notNull(entity.getId(), "不存在");
        long result = businessModelIndexSettingDAO.updateByKeyDynamic(payload);
        return result;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void deleteSoft(List<Long> keys) {
        if (!keys.isEmpty()) {
            businessModelIndexSettingDAO.deleteSoft(keys);
        }
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void deleteSoftByModelIndexId(Long modelIndexId) {
        businessModelIndexSettingDAO.deleteSoftByModelIndexId(modelIndexId);
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void deleteSoftByModelId(Long modelId) {
        businessModelIndexSettingDAO.deleteSoftByModelId(modelId);
    }
}
