package com.elitesland.tw.tw5.server.prd.pms.controller;

import com.elitescloud.boot.common.param.BaseViewModel;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.pms.query.PmsResourcePlanRoleQuery;
import com.elitesland.tw.tw5.api.prd.pms.service.PmsConContractService;
import com.elitesland.tw.tw5.api.prd.pms.service.PmsResourcePlanService;
import com.elitesland.tw.tw5.api.prd.salecon.query.SaleConContractQuery;
import com.elitesland.tw.tw5.server.common.TwOutputUtil;
import com.elitesland.tw.tw5.server.udc.UdcNameClass;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.ArrayList;


/**
 * PMS  待办
 *
 * @author xxb
 * @date 2023-08-11
 */
@Api(tags = "PMS  待办")
@RestController
@RequiredArgsConstructor
@RequestMapping("/api/pms/todo")
@Slf4j
public class PmsToDoController {

    private final PmsConContractService conContractService;

    private final PmsResourcePlanService pmsResourcePlanService;

    /**
     * 销售合同项目待创建
     *
     * @param query 查询
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/contractNotice")
    @UdcNameClass
    @ApiOperation("销售合同项目待创建")
    public TwOutputUtil contractNotice(SaleConContractQuery query) {
        return TwOutputUtil.ok(conContractService.findCountByCustProp(query));
    }


    /**
     * 资源规划待更新
     *
     * @return
     */
    @GetMapping("/resourcePlanNotice")
    @ApiOperation("资源规划待更新")
    public TwOutputUtil resourcePlanNotice(PmsResourcePlanRoleQuery query) {
//        return TwOutputUtil.ok(pmsResourcePlanService.resourcePlanNotice(query));
        //资源规划结构调整，暂时舍弃这个，没办法梳理需求，如果后续需要，重新梳理下老的资源逻辑赋值
        PagingVO<BaseViewModel> build = PagingVO.<BaseViewModel>builder().records(new ArrayList<>()).total(0).build();
        return TwOutputUtil.ok(build);
    }

}
