package com.elitesland.tw.tw5.server.prd.pms.dao;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.salecon.query.SaleConContractQuery;
import com.elitesland.tw.tw5.api.prd.salecon.vo.SaleConContractVO;
import com.elitesland.tw.tw5.server.common.util.SqlUtil;
import com.elitesland.tw.tw5.server.prd.common.functionEnum.SaleConEnum;
import com.elitesland.tw.tw5.server.prd.crm.entity.QCrmOpportunityDO;
import com.elitesland.tw.tw5.server.prd.partner.common.entity.QBusinessPartnerDO;
import com.elitesland.tw.tw5.server.prd.pms.entity.QPmsProjectDO;
import com.elitesland.tw.tw5.server.prd.salecon.entity.QSaleConContractDO;
import com.elitesland.tw.tw5.server.prd.salecon.entity.QSaleConExecConditionDO;
import com.elitesland.workflow.enums.ProcInstStatus;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.core.types.dsl.BooleanExpression;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import lombok.RequiredArgsConstructor;
import org.springframework.stereotype.Repository;
import org.springframework.util.ObjectUtils;

import java.util.ArrayList;
import java.util.List;

/**
 * 销售合同关联项目dao
 *
 * @author carl
 * @date 2023-10-25
 */
@Repository
@RequiredArgsConstructor
public class PmsConContractDAO {

    private final JPAQueryFactory jpaQueryFactory;
    private final QPmsProjectDO qdoProject = QPmsProjectDO.pmsProjectDO;
    private final QSaleConContractDO qdoSaleCon0 = new QSaleConContractDO("saleConContractDO0");
    private final QSaleConContractDO qdoSaleCon1 = new QSaleConContractDO("saleConContractDO1");
    private final QSaleConExecConditionDO qSaleConExecConditionDO = QSaleConExecConditionDO.saleConExecConditionDO;
    private final QBusinessPartnerDO qBusinessPartnerDO = QBusinessPartnerDO.businessPartnerDO;
    private final QCrmOpportunityDO qCrmOpportunityDO = QCrmOpportunityDO.crmOpportunityDO;
    /**
     * 拼装查询字段
     *
     * @return jpaQuery对象
     */
    private JPAQuery<SaleConContractVO> getJpaQuerySelect0() {
        return jpaQueryFactory.select(Projections.bean(SaleConContractVO.class,
                qdoSaleCon0.id,
                // 合同编号
                qdoSaleCon0.code,
                // 合同名称
                qdoSaleCon0.name,
                //客户名称
                qBusinessPartnerDO.partnerName,
                // 签单BU_ID
                qdoSaleCon0.signBuId,
                // 销售负责人ID
                qdoSaleCon0.saleManUserId,
                // 交付BU_ID
                qdoSaleCon0.deliBuId,
                // 交付用户id
                qdoSaleCon0.deliUserId,
                // 合同开始日期
                qdoSaleCon0.startDate,
                // 合同结束日期
                qdoSaleCon0.endDate,

                // 合同状态
                qdoSaleCon0.status,
                // 客户项目
                qdoSaleCon0.custProj,
                // 销售内容
                qdoSaleCon0.saleContent,
                // 产品大类
                qdoSaleCon0.productClass,
                // 产品小类
                qdoSaleCon0.productSubClass,
                // 交付地点
                qdoSaleCon0.deliveryAddress,
                // 财务期间ID
                qdoSaleCon0.finPeriodId,

                // 合同总金额
                qdoSaleCon0.amt,
                // 其它费用
                qdoSaleCon0.extraAmt,
                // 有效合同金额
                qdoSaleCon0.effectiveAmt,
                // 毛利
                qdoSaleCon0.grossProfit,
                // 销售区域BU_ID
                qdoSaleCon0.regionBuId,
                // 销售区域负责人
                qdoSaleCon0.regionUserId,


                // 副签单BU_ID
                qdoSaleCon0.coSignBuId,
                // 副签单用户id
                qdoSaleCon0.coSignUserId,

                // 副交付BU_ID
                qdoSaleCon0.codeliBuId,
                // 副交付用户id
                qdoSaleCon0.codeliUserId,
                // 平台合同类型
                qdoSaleCon0.platType,
                // 主合同类型
                qdoSaleCon0.mainType,
                // PMO用户ID
                qdoSaleCon0.pmoUserId,
                // 来源类型
                qdoSaleCon0.sourceType,
                // 外部来源
                qdoSaleCon0.externalIden,
                // 外部来源人
                qdoSaleCon0.externalName,
                // 外部来源电话
                qdoSaleCon0.externalPhone,
                // 内部来源BU_ID
                qdoSaleCon0.internalBuId,
                // 利益承诺
                qdoSaleCon0.profitDesc,
                // 税率
                qdoSaleCon0.taxRate,
                // 内部来源用户ID
                qdoSaleCon0.internalUserId,

                // 纸质合同状态描述
                qdoSaleCon0.paperDesc,
                // 纸质合同状态
                qdoSaleCon0.paperStatus,
                // 合同激活时间
                qdoSaleCon0.acitveDate,
                // 产品
                qdoSaleCon0.product,
                // 简要说明
                qdoSaleCon0.briefDesc,
                // 工作类型
                qdoSaleCon0.workType,
                // 促销类型
                qdoSaleCon0.promotionType,
                // 范围性质
                qdoSaleCon0.rangeProp,
                // 半开口说明
                qdoSaleCon0.halfOpenDesc,
                // 供应主体类别
                qdoSaleCon0.supplierType,
                // 提成类别
                qdoSaleCon0.commissionType,
                // 交易方式
                qdoSaleCon0.transactionMethod,
                // 交易性质
                qdoSaleCon0.transactionNature,
                // 需求类别
                qdoSaleCon0.demandType,
                // 销售分类
                qdoSaleCon0.saleClass,
                // 客户承担差旅费
                qdoSaleCon0.custBarExpense,
                // 报销政策说明
                qdoSaleCon0.reimbursementDesc,
                // 额定当量
                qdoSaleCon0.ratedEqva,
                // 额定费用
                qdoSaleCon0.ratedExpense,
                // 合同打印方
                qdoSaleCon0.contractPrinter,
                // 打印份数
                qdoSaleCon0.printCount,
                // 盖章类型
                qdoSaleCon0.sealType,
                qdoSaleCon0.filingFlag,
                qdoSaleCon0.ratedCost,
                qdoSaleCon0.preSaleBuId,
                qdoSaleCon0.preSaleUserId,
                qdoSaleCon0.signDate,
                //项目经理
                qdoSaleCon0.pmResId,
                qdoSaleCon1.name.as("parentName"),
                // 项目重要度
                qCrmOpportunityDO.projectImportance

        )).from(qdoSaleCon0).leftJoin(qdoSaleCon1).on(qdoSaleCon0.parentId.isNotNull().and(qdoSaleCon0.parentId.eq(qdoSaleCon1.id)))
                .leftJoin(qBusinessPartnerDO).on(qdoSaleCon0.custId.eq(qBusinessPartnerDO.bookId))
                .leftJoin(qCrmOpportunityDO).on(qdoSaleCon0.oppoId.eq(qCrmOpportunityDO.id).and(qCrmOpportunityDO.deleteFlag.eq(0)))
                .where(qdoSaleCon0.id.notIn(queryContractIdsWhere()));
    }

    /**
     * 获取一创建过项目的合同id过滤条件
     *
     * @return
     */
    JPAQuery<Long> queryContractIdsWhere() {
        JPAQuery<Long> where = jpaQueryFactory.select(qdoProject.contractId).from(qdoProject).where(qdoProject.contractId.isNotNull());
        return where;
    }

    /**
     * 查询条件封装
     *
     * @param query 条件
     * @return {@link Predicate}
     */

    /**
     * SELECT count(1) FROM sale_con_contract WHERE ID not in
     * (SELECT CONTRACT_ID FROM pms_project WHERE CONTRACT_ID is not null)  " +
     * "and DELI_USER_ID= ?1 AND DELETE_FLAG= 0 " +
     * "AND ( ( STATUS = 'ACTIVE' AND MAIN_TYPE = 'SUB' ) OR ( STATUS = 'ACTIVE_WAITING' AND PLAT_TYPE = 'NO_CONTRACT_VIRTUAL_CONTRACT'  AND MAIN_TYPE = 'SUB' ) )"
     *
     * @param query
     * @return
     */
    private Predicate where(SaleConContractQuery query) {
        List<Predicate> list = new ArrayList<>();
        /** 交付负责人 */
        if (!ObjectUtils.isEmpty(query.getDeliUserId())) {
            list.add(qdoSaleCon0.deliUserId.eq(query.getDeliUserId()));
        }
        if (!ObjectUtils.isEmpty(query.getCustPropList())) {
            list.add(qBusinessPartnerDO.partnerNature.in(query.getCustPropList()));
        }
        //不等虚拟合同
        list.add(qdoSaleCon0.platType.ne(SaleConEnum.FICTITIOUS.getCode()));
//
        BooleanExpression jpaQueryOr = qdoSaleCon0.status.eq("ACTIVE").and(qdoSaleCon0.mainType.eq("SUB"));
        jpaQueryOr = jpaQueryOr.or(qdoSaleCon0.status.eq("ACTIVE_WAITING").and(qdoSaleCon0.platType.eq(SaleConEnum.NO_CONTRACT_VIRTUAL_CONTRACT.getCode())).and(qdoSaleCon0.mainType.eq("SUB")));
        list.add(jpaQueryOr);
        return ExpressionUtils.allOf(list);
    }

    /**
     * 统计
     *
     * @param query 查询参数
     * @return jpaQuery对象
     */
    public long count(SaleConContractQuery query) {
        JPAQuery<Long> jpaQuery = jpaQueryFactory
                .select(qdoSaleCon0.count())
                .from(qdoSaleCon0).leftJoin(qBusinessPartnerDO).on(qdoSaleCon0.custId.eq(qBusinessPartnerDO.bookId))
                .where(qdoSaleCon0.id.notIn(queryContractIdsWhere()));
        jpaQuery.where(where(query));

        long total = jpaQuery.fetchOne();
        return total;
    }

    /**
     * 分页查询
     *
     * @param query 查询参数
     * @return 分页结果
     */
    public PagingVO<SaleConContractVO> queryPaging(SaleConContractQuery query) {
        long total = count(query);
        if (total == 0) {
            return PagingVO.empty();
        }
        JPAQuery<SaleConContractVO> jpaQuery = getJpaQueryWhere(query);
        List<SaleConContractVO> result = jpaQuery
                .offset(query.getPageRequest().getOffset())
                .limit(query.getPageRequest().getPageSize())
                .fetch();
        return PagingVO.<SaleConContractVO>builder().records(result).total(total).build();
    }

    /**
     * 拼装查询条件
     *
     * @param query 查询参数
     * @return jpaQuery对象
     */
    private JPAQuery<SaleConContractVO> getJpaQueryWhere(SaleConContractQuery query) {
        JPAQuery<SaleConContractVO> jpaQuery = getJpaQuerySelect0();
        // 条件封装
        jpaQuery.where(where(query));

        // 动态排序
        jpaQuery.orderBy(SqlUtil.getSortedColumn(qdoSaleCon0, query.getOrders()));
        return jpaQuery;
    }

}
