package com.elitesland.tw.tw5.server.prd.pms.dao;


import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.pms.payload.PmsProjectPayload;
import com.elitesland.tw.tw5.api.prd.pms.query.PmsProjectQuery;
import com.elitesland.tw.tw5.api.prd.pms.vo.PmsProjectVO;
import com.elitesland.tw.tw5.api.prd.salecon.vo.SaleConContractVO;
import com.elitesland.tw.tw5.server.common.util.SqlUtil;
import com.elitesland.tw.tw5.server.prd.budget.entity.QBudgetDO;
import com.elitesland.tw.tw5.server.prd.common.functionEnum.SaleConEnum;
import com.elitesland.tw.tw5.server.prd.pms.common.functionEnum.PmsReasonTypeEnum;
import com.elitesland.tw.tw5.server.prd.pms.entity.PmsProjectDO;
import com.elitesland.tw.tw5.server.prd.pms.entity.QPmsProjectDO;
import com.elitesland.tw.tw5.server.prd.pms.entity.QPmsProjectMembersDO;
import com.elitesland.tw.tw5.server.prd.pms.repo.PmsProjectRepo;
import com.elitesland.tw.tw5.server.prd.salecon.entity.QSaleConContractDO;
import com.elitesland.tw.tw5.server.prd.salecon.entity.QSaleConExecConditionDO;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.core.types.dsl.BooleanExpression;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import com.querydsl.jpa.impl.JPAUpdateClause;
import lombok.RequiredArgsConstructor;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.ObjectUtils;

import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.ArrayList;
import java.util.List;

/**
 * 项目
 *
 * @author carl
 * @date 2023-08-07
 */
@Repository
@RequiredArgsConstructor
public class PmsProjectDAO {

    private final JPAQueryFactory jpaQueryFactory;
    private final PmsProjectRepo repo;
    private final QPmsProjectDO qdo = QPmsProjectDO.pmsProjectDO;
    private final QSaleConContractDO qdoSaleCon = QSaleConContractDO.saleConContractDO;
    private final QBudgetDO qdoBudget = QBudgetDO.budgetDO;
    private final QPmsProjectMembersDO qdoMembers = QPmsProjectMembersDO.pmsProjectMembersDO;
    private final QSaleConExecConditionDO qdoExecCondition = QSaleConExecConditionDO.saleConExecConditionDO;

    /**
     * 拼装查询字段
     *
     * @return jpaQuery对象
     */
    private JPAQuery<SaleConContractVO> getJpaQuerySelect0() {
        return jpaQueryFactory.select(Projections.bean(SaleConContractVO.class,
                qdoSaleCon.id,
                // 合同编号
                qdoSaleCon.code,
                // 合同名称
                qdoSaleCon.name,
                // 合同状态
                qdoSaleCon.status,
                // 客户项目
                qdoSaleCon.custProj,
                // 销售内容
                qdoSaleCon.saleContent,
                // 产品大类
                qdoSaleCon.productClass,
                // 产品小类
                qdoSaleCon.productSubClass,
                // 交付地点
                qdoSaleCon.deliveryAddress,
                // 财务期间ID
                qdoSaleCon.finPeriodId,

                // 合同总金额
                qdoSaleCon.amt,
                // 其它费用
                qdoSaleCon.extraAmt,
                // 有效合同金额
                qdoSaleCon.effectiveAmt,
                // 毛利
                qdoSaleCon.grossProfit,
                // 销售区域BU_ID
                qdoSaleCon.regionBuId,
                // 销售区域负责人
                qdoSaleCon.regionUserId,
                // 签单BU_ID
                qdoSaleCon.signBuId,
                // 销售负责人ID
                qdoSaleCon.saleManUserId,

                // 副签单BU_ID
                qdoSaleCon.coSignBuId,
                // 副签单用户id
                qdoSaleCon.coSignUserId,
                // 交付BU_ID
                qdoSaleCon.deliBuId,
                // 交付用户id
                qdoSaleCon.deliUserId,
                // 副交付BU_ID
                qdoSaleCon.codeliBuId,
                // 副交付用户id
                qdoSaleCon.codeliUserId,
                // 平台合同类型
                qdoSaleCon.platType,
                // 主合同类型
                qdoSaleCon.mainType,
                // PMO用户ID
                qdoSaleCon.pmoUserId,
                // 来源类型
                qdoSaleCon.sourceType,
                // 外部来源
                qdoSaleCon.externalIden,
                // 外部来源人
                qdoSaleCon.externalName,
                // 外部来源电话
                qdoSaleCon.externalPhone,
                // 内部来源BU_ID
                qdoSaleCon.internalBuId,
                // 利益承诺
                qdoSaleCon.profitDesc,
                // 税率
                qdoSaleCon.taxRate,
                // 内部来源用户ID
                qdoSaleCon.internalUserId,
                // 合同开始日期
                qdoSaleCon.startDate,
                // 合同结束日期
                qdoSaleCon.endDate,
                // 纸质合同状态描述
                qdoSaleCon.paperDesc,
                // 纸质合同状态
                qdoSaleCon.paperStatus,
                // 合同激活时间
                qdoSaleCon.acitveDate,
                // 产品
                qdoSaleCon.product,
                // 简要说明
                qdoSaleCon.briefDesc,
                // 工作类型
                qdoSaleCon.workType,
                // 促销类型
                qdoSaleCon.promotionType,
                // 范围性质
                qdoSaleCon.rangeProp,
                // 半开口说明
                qdoSaleCon.halfOpenDesc,
                // 供应主体类别
                qdoSaleCon.supplierType,
                // 提成类别
                qdoSaleCon.commissionType,
                // 交易方式
                qdoSaleCon.transactionMethod,
                // 交易性质
                qdoSaleCon.transactionNature,
                // 需求类别
                qdoSaleCon.demandType,
                // 销售分类
                qdoSaleCon.saleClass,
                // 客户承担差旅费
                qdoSaleCon.custBarExpense,
                // 报销政策说明
                qdoSaleCon.reimbursementDesc,
                // 额定当量
                qdoSaleCon.ratedEqva,
                // 额定费用
                qdoSaleCon.ratedExpense,
                // 合同打印方
                qdoSaleCon.contractPrinter,
                // 打印份数
                qdoSaleCon.printCount,
                // 盖章类型
                qdoSaleCon.sealType,
                // 商机ID
                qdoSaleCon.oppoId,

                qdoSaleCon.folderId,
                qdoSaleCon.closeDate,
                qdoSaleCon.preSaleBuId,
                qdoSaleCon.preSaleUserId,
                qdoSaleCon.finGross,
                qdoSaleCon.sysGross,
                qdoSaleCon.finRatedEqva,
                qdoSaleCon.netRate,
                qdoSaleCon.ratedCost

        )).from(qdoSaleCon);
    }

    /**
     * 根据合同主键查询
     *
     * @param saleConId 主键
     * @return 结果
     */
    public SaleConContractVO querySaleConContractBySaleConId(Long saleConId) {
        JPAQuery<SaleConContractVO> jpaQuery = getJpaQuerySelect0();
        jpaQuery.where(qdoSaleCon.id.eq(saleConId));
        jpaQuery.where(qdoSaleCon.deleteFlag.eq(0));
        return jpaQuery.fetchFirst();
    }

    /**
     * 拼装查询字段
     *
     * @return jpaQuery对象
     */
    private JPAQuery<PmsProjectVO> getJpaQuerySelect() {
        return jpaQueryFactory.select(Projections.bean(PmsProjectVO.class,
                qdo.id,
                qdo.remark,
                qdo.createUserId,
                qdo.creator,
                qdo.createTime,

                // 项目重要度
                qdo.projectImportance,
                // 预算总人天
                qdo.totalDays,
                // 费用总成本
                qdo.totalCost,
                // 工时结算周期
                qdo.timesheetPeriod,
                // 项目名称
                qdo.projName,
                // 项目状态
                qdo.projStatus,
                // 合同id
                qdo.contractId,
                // 项目模板id
                qdo.projTempId,
                // 客户行业
                qdo.custIdst,
                // 客户区域
                qdo.custRegion,
                // 预计开始日期
                qdo.planStartDate,
                // 预计结束日期
                qdo.planEndDate,
                //实际开始
                qdo.startDate,
                //实际结束
                qdo.endDate,
                // 项目经理资源id
                qdo.pmResId,
                // 项目经理当量系数
                qdo.pmEqvaRatio,
                // pmo资源负责人id
                qdo.pmoResId,
                // pmo助理资源负责人id
                qdo.pmoDeputyResId,
                // 总当量
                qdo.totalEqva,
                // 派发当量（交付负责人-项目经理）
                qdo.distEqva,
                // 派发费用（交付负责人-项目经理）
                qdo.distCost,
                // 费用总预算
                qdo.totalReimbursement,
                // 当量预估单价
                qdo.eqvaPrice,
                // 允许外包
                qdo.epibolyPermitFlag,
                // 允许转包
                qdo.subcontractPermitFlag,
                // 非结算活动需要审批
                qdo.finishApproveFlag,
                // 最低保证金
                qdo.deposit,
                // 关联项目
                qdo.relatedProjId,
                // 绩效规则
                qdo.performanceDesc,
                // 关闭原因
                qdo.closeReason,

                // 差旅餐补限额
                qdo.maxTravelFee,
                // 项目编号
                qdo.projNo,
                // 完工百分比
                qdo.compPercent,
                // 允许一人多任务包
                qdo.muiltiTaskFlag,
                //最近汇报时间
                qdo.reportTime,
                // 项目进度状态
                qdo.projProcessStatus,
                // 自动汇报标识
                qdo.autoReportFlag,
                // 每期确认金额
                qdo.reportPeriodAmt,
                // 汇报开始期间
                qdo.reportStartDate,
                // 汇报期间数
                qdo.reportQty,
                // 包含客户承担费用标志
                qdo.containsCustomerFlag,
                // 项目难度
                qdo.projectDifficult,
                // 项目预算总开关标志 0:否 1:是
                qdo.budgetSwitchFlag,
                // 项目活动状态
                qdo.projActivityStatus,
                // 项目活动审批状态
                qdo.projActivityApprStatus,
                // 关联项目编号
                qdo.relatedProjNo,
                // 产品编号
                qdo.productNo,
                // 易道壳项目过程文档itemid
                qdo.processDocItemId,
                // 易道壳项目验收文档itemid
                qdo.acceptanceDocItemId,
                // 易道壳项目总结文档itemid
                qdo.summaryDocItemId,
                // 研发补贴金额
                qdo.subsidyAmt,
                // 折旧月数
                qdo.depreciationMonths,
                // 折旧开始时间
                qdo.depreciationStartDate,
                // sow节选
                qdo.sowFiles,
                // 预算附件
                qdo.budgetFiles,
                // 绩效附件
                qdo.performanceFiles,
                // 附件
                qdo.projectFiles,
                //资源规划日期
                qdo.planUpdateDate,
                // 扩展字段1
                qdo.ext1,
                // 项目收入确认备注
                qdo.ext2,
                //慧通同步标记
                qdo.hwhtSyncFlag,
                // 帮我吧项目名称
                qdo.bangwo8ProjName,
                // 交付BU_ID
                qdoSaleCon.deliBuId,
                //交付负责人id
                qdoSaleCon.deliUserId,
                // 销售负责人ID
                qdoSaleCon.saleManUserId,
                //参考合同号
                qdoSaleCon.referCode,
                // 工作类型
                qdoSaleCon.workType,
                // 签单BU_ID
                qdoSaleCon.signBuId,
                // 子合同名称
                qdoSaleCon.name.as("contractName"),
                // 子合同编号
                qdoSaleCon.code.as("contractNo"),
                // 平台合同类型
                qdoSaleCon.platType,
                // 项目总金额
                qdoSaleCon.amt.as("sumAmt"),
                // 交付地点
                qdoSaleCon.deliveryAddress,
                //签约公司ID
                // qdoSaleCon.ouId,
                qdoSaleCon.ouBookId,
                //客户承担差旅费
                qdoSaleCon.custBarExpense,
                //币种
                qdoSaleCon.currCode,
                //税率
                qdoSaleCon.taxRate,
                //有效合同金额
                qdoSaleCon.effectiveAmt,
                //客户id
                qdoSaleCon.custId,
                //财务核定额定当量
                qdoSaleCon.finRatedEqva,
                //额定费用
                qdoSaleCon.ratedCost,
                // 合同状态
                qdoSaleCon.status.as("contractStatus"),
                // 商机ID
                qdoSaleCon.oppoId,
                // 产品大类
                qdoSaleCon.productClass,
                // 签订日期
                qdoSaleCon.signDate.as("contractSignDate"),
                // 合同开始日期
                qdoSaleCon.startDate.as("contractStartDate"),
                // 合同结束日期
                qdoSaleCon.endDate.as("contractEndDate"),
                // 产品小类
                qdoSaleCon.productSubClass,
                qdoSaleCon.referCode,
                // 研发立项附件
                qdo.researchFiles,
                qdo.superResId,
                qdo.riskLevel,
                qdo.planOnlineDate,
                qdo.noContractFlag,
                qdo.subjectTempId,
                qdo.changeFlag,
                //成本级别
                qdo.costLevel
        )).from(qdo).leftJoin(qdoSaleCon).on(qdo.contractId.eq(qdoSaleCon.id));
    }

    /**
     * 拼装查询条件
     *
     * @param query 查询参数
     * @return jpaQuery对象
     */
    private JPAQuery<PmsProjectVO> getJpaQueryWhere(PmsProjectQuery query) {
        JPAQuery<PmsProjectVO> jpaQuery = getJpaQuerySelect();
        // 条件封装
        jpaQuery.where(where(query));
        // 常用基础查询条件拼装
        SqlUtil.handleCommonJpaQuery(jpaQuery, qdo._super, query);
        // 动态排序
        jpaQuery.orderBy(SqlUtil.getSortedColumn(qdo, query.getOrders()));
        return jpaQuery;
    }

    /**
     * 统计
     *
     * @param query 查询参数
     * @return jpaQuery对象
     */
    public long count(PmsProjectQuery query) {
        JPAQuery<Long> jpaQuery = jpaQueryFactory
                .select(qdo.count())
                .from(qdo).leftJoin(qdoSaleCon).on(qdo.contractId.eq(qdoSaleCon.id));
        jpaQuery.where(where(query));
        // 常用基础查询条件拼装
        SqlUtil.handleCommonJpaQuery(jpaQuery, qdo._super, query);
        long total = jpaQuery.fetchOne();
        return total;
    }


    /**
     * 查询条件封装
     *
     * @param query 条件
     * @return {@link Predicate}
     */
    private Predicate where(PmsProjectQuery query) {
        List<Predicate> list = new ArrayList<>();
        /** 记录唯一ID 精确 */
        if (!ObjectUtils.isEmpty(query.getId())) {
            list.add(qdo.id.eq(query.getId()));
        }
        /**
         * jde
         */
        if (!ObjectUtils.isEmpty(query.getJdeConfirmTimeStart())) {
            list.add(qdo.jdeConfirmTime.after(LocalDateTime.of(query.getJdeConfirmTimeStart(), LocalTime.MIN)));
        }
        if (!ObjectUtils.isEmpty(query.getJdeConfirmTimeEnd())) {
            list.add(qdo.jdeConfirmTime.before(LocalDateTime.of(query.getJdeConfirmTimeEnd(), LocalTime.MAX)));
        }
        if (!ObjectUtils.isEmpty(query.getJdeDocNo())) {
            list.add(qdo.jdeDocNo.like(SqlUtil.toSqlLikeString(query.getJdeDocNo())));
        }
        if (!ObjectUtils.isEmpty(query.getJdeDocState())) {
            list.add(qdo.jdeDocState.eq(query.getJdeDocState()));
        }
        if (!ObjectUtils.isEmpty(query.getNotInIds())) {
            list.add(qdo.id.notIn(query.getNotInIds()));
        }
        if (!ObjectUtils.isEmpty(query.getInIds())) {
            list.add(qdo.id.in(query.getInIds()));
        }
        /** 项目重要度 精确 */
        if (!ObjectUtils.isEmpty(query.getProjectImportance())) {
            list.add(qdo.projectImportance.eq(query.getProjectImportance()));
        }
        /** 预算总人天 精确 */
        if (!ObjectUtils.isEmpty(query.getTotalDays())) {
            list.add(qdo.totalDays.eq(query.getTotalDays()));
        }
        /** 费用总成本 精确 */
        if (!ObjectUtils.isEmpty(query.getTotalCost())) {
            list.add(qdo.totalCost.eq(query.getTotalCost()));
        }
        /** 工时结算周期 精确 */
        if (!ObjectUtils.isEmpty(query.getTimesheetPeriod())) {
            list.add(qdo.timesheetPeriod.eq(query.getTimesheetPeriod()));
        }
        /** 项目名称 模糊 */
        if (!ObjectUtils.isEmpty(query.getProjName())) {
            list.add(qdo.projName.like(SqlUtil.toSqlLikeString(query.getProjName())));
        }
        /** 督导  */
        if (!ObjectUtils.isEmpty(query.getSuperResId())) {
            list.add(qdo.superResId.eq(query.getSuperResId()));
        }
        /** 预计上线时间  */
        if (!ObjectUtils.isEmpty(query.getPlanOnlineDate())) {
            list.add(qdo.planOnlineDate.eq(query.getPlanOnlineDate()));
        }
        /** 风险等级  */
        if (!ObjectUtils.isEmpty(query.getRiskLevel())) {
            list.add(qdo.riskLevel.eq(query.getRiskLevel()));
        }

        /** 项目状态 精确 */
        if (!ObjectUtils.isEmpty(query.getProjStatus())) {
            if (ObjectUtils.isEmpty(query.getProjStatusType()) || "1".equals(query.getProjStatusType())) {
                list.add(qdo.projStatus.eq(query.getProjStatus()));
            } else {
                list.add(qdo.projStatus.ne(query.getProjStatus()));
            }
        }
        if (!ObjectUtils.isEmpty(query.getProjStatusList())) {
            if (ObjectUtils.isEmpty(query.getProjStatusType()) || "1".equals(query.getProjStatusType())) {
                list.add(qdo.projStatus.in(query.getProjStatusList()));
            } else {
                list.add(qdo.projStatus.notIn(query.getProjStatusList()));
            }
        }
        /** 合同id 精确 */
        if (!ObjectUtils.isEmpty(query.getContractId())) {
            list.add(qdo.contractId.eq(query.getContractId()));
        }
        /** 项目模板id 精确 */
        if (!ObjectUtils.isEmpty(query.getProjTempId())) {
            list.add(qdo.projTempId.eq(query.getProjTempId()));
        }
        /** 客户行业 精确 */
        if (!ObjectUtils.isEmpty(query.getCustIdst())) {
            list.add(qdo.custIdst.eq(query.getCustIdst()));
        }
        /** 客户区域 精确 */
        if (!ObjectUtils.isEmpty(query.getCustRegion())) {
            list.add(qdo.custRegion.eq(query.getCustRegion()));
        }
        /** 预计开始日期 精确 */
        if (!ObjectUtils.isEmpty(query.getPlanStartDate())) {
            list.add(qdo.planStartDate.eq(query.getPlanStartDate()));
        }
        /** 预计结束日期 精确 */
        if (!ObjectUtils.isEmpty(query.getPlanEndDate())) {
            list.add(qdo.planEndDate.eq(query.getPlanEndDate()));
        }
        /** 项目经理资源id 精确 */
        if (!ObjectUtils.isEmpty(query.getPmResId())) {
            list.add(qdo.pmResId.eq(query.getPmResId()));
        }
        /** 项目经理当量系数 精确 */
        if (!ObjectUtils.isEmpty(query.getPmEqvaRatio())) {
            list.add(qdo.pmEqvaRatio.eq(query.getPmEqvaRatio()));
        }
        /** pmo资源负责人id 精确 */
        if (!ObjectUtils.isEmpty(query.getPmoResId())) {
            list.add(qdo.pmoResId.eq(query.getPmoResId()));
        }
        /** pmo助理资源负责人id 精确 */
        if (!ObjectUtils.isEmpty(query.getPmoDeputyResId())) {
            list.add(qdo.pmoDeputyResId.eq(query.getPmoDeputyResId()));
        }
        /** 总当量 精确 */
        if (!ObjectUtils.isEmpty(query.getTotalEqva())) {
            list.add(qdo.totalEqva.eq(query.getTotalEqva()));
        }
        /** 派发当量（交付负责人-项目经理） 精确 */
        if (!ObjectUtils.isEmpty(query.getDistEqva())) {
            list.add(qdo.distEqva.eq(query.getDistEqva()));
        }
        /** 派发费用（交付负责人-项目经理） 精确 */
        if (!ObjectUtils.isEmpty(query.getDistCost())) {
            list.add(qdo.distCost.eq(query.getDistCost()));
        }
        /** 费用总预算 精确 */
        if (!ObjectUtils.isEmpty(query.getTotalReimbursement())) {
            list.add(qdo.totalReimbursement.eq(query.getTotalReimbursement()));
        }
        /** 当量预估单价 精确 */
        if (!ObjectUtils.isEmpty(query.getEqvaPrice())) {
            list.add(qdo.eqvaPrice.eq(query.getEqvaPrice()));
        }
        /** 允许外包 精确 */
        if (!ObjectUtils.isEmpty(query.getEpibolyPermitFlag())) {
            list.add(qdo.epibolyPermitFlag.eq(query.getEpibolyPermitFlag()));
        }
        /** 允许转包 精确 */
        if (!ObjectUtils.isEmpty(query.getSubcontractPermitFlag())) {
            list.add(qdo.subcontractPermitFlag.eq(query.getSubcontractPermitFlag()));
        }
        /** 非结算活动需要审批 精确 */
        if (!ObjectUtils.isEmpty(query.getFinishApproveFlag())) {
            list.add(qdo.finishApproveFlag.eq(query.getFinishApproveFlag()));
        }
        /** 最低保证金 精确 */
        if (!ObjectUtils.isEmpty(query.getDeposit())) {
            list.add(qdo.deposit.eq(query.getDeposit()));
        }
        /** 关联项目 精确 */
        if (!ObjectUtils.isEmpty(query.getRelatedProjId())) {
            list.add(qdo.relatedProjId.eq(query.getRelatedProjId()));
        }
        /** 绩效规则 精确 */
        if (!ObjectUtils.isEmpty(query.getPerformanceDesc())) {
            list.add(qdo.performanceDesc.eq(query.getPerformanceDesc()));
        }
        /** 关闭原因 精确 */
        if (!ObjectUtils.isEmpty(query.getCloseReason())) {
            list.add(qdo.closeReason.eq(query.getCloseReason()));
        }

        /** 差旅餐补限额 精确 */
        if (!ObjectUtils.isEmpty(query.getMaxTravelFee())) {
            list.add(qdo.maxTravelFee.eq(query.getMaxTravelFee()));
        }
        /** 项目编号 模糊 */
        if (!ObjectUtils.isEmpty(query.getProjNo())) {
            list.add(qdo.projNo.like(SqlUtil.toSqlLikeString(query.getProjNo())));
        }
        /** 项目编号 模糊 */
        if (!ObjectUtils.isEmpty(query.getProjNoList())) {
            list.add(qdo.projNo.in(query.getProjNoList()));
        }
        /** 完工百分比 精确 */
        if (!ObjectUtils.isEmpty(query.getCompPercent())) {
            list.add(qdo.compPercent.eq(query.getCompPercent()));
        }
        /** 允许一人多任务包 精确 */
        if (!ObjectUtils.isEmpty(query.getMuiltiTaskFlag())) {
            list.add(qdo.muiltiTaskFlag.eq(query.getMuiltiTaskFlag()));
        }
        /** 项目进度状态 精确 */
        if (!ObjectUtils.isEmpty(query.getProjProcessStatus())) {
            list.add(qdo.projProcessStatus.eq(query.getProjProcessStatus()));
        }
        /** 自动汇报标识 精确 */
        if (!ObjectUtils.isEmpty(query.getAutoReportFlag())) {
            list.add(qdo.autoReportFlag.eq(query.getAutoReportFlag()));
        }
        /** 每期确认金额 精确 */
        if (!ObjectUtils.isEmpty(query.getReportPeriodAmt())) {
            list.add(qdo.reportPeriodAmt.eq(query.getReportPeriodAmt()));
        }
        /** 汇报开始期间 精确 */
        if (!ObjectUtils.isEmpty(query.getReportStartDate())) {
            list.add(qdo.reportStartDate.eq(query.getReportStartDate()));
        }
        /** 汇报期间数 精确 */
        if (!ObjectUtils.isEmpty(query.getReportQty())) {
            list.add(qdo.reportQty.eq(query.getReportQty()));
        }
        /** 包含客户承担费用标志 精确 */
        if (!ObjectUtils.isEmpty(query.getContainsCustomerFlag())) {
            list.add(qdo.containsCustomerFlag.eq(query.getContainsCustomerFlag()));
        }
        /** 项目难度 精确 */
        if (!ObjectUtils.isEmpty(query.getProjectDifficult())) {
            list.add(qdo.projectDifficult.eq(query.getProjectDifficult()));
        }
        /** 项目预算总开关标志 0:否 1:是 精确 */
        if (!ObjectUtils.isEmpty(query.getBudgetSwitchFlag())) {
            list.add(qdo.budgetSwitchFlag.eq(query.getBudgetSwitchFlag()));
        }
        /** 项目活动状态  精确 */
        if (!ObjectUtils.isEmpty(query.getProjActivityStatus())) {
            list.add(qdo.projActivityStatus.eq(query.getProjActivityStatus()));
        }
        /** 项目活动审批状态  精确 */
        if (!ObjectUtils.isEmpty(query.getProjActivityApprStatus())) {
            list.add(qdo.projActivityApprStatus.eq(query.getProjActivityApprStatus()));
        }
        /** 成本级别  精确 */
        if (!ObjectUtils.isEmpty(query.getCostLevel())) {
            list.add(qdo.costLevel.eq(query.getCostLevel()));
        }
        /** 关联项目编号 模糊 */
        if (!ObjectUtils.isEmpty(query.getRelatedProjNo())) {
            list.add(qdo.relatedProjNo.like(SqlUtil.toSqlLikeString(query.getRelatedProjNo())));
        }
        /** 产品编号 模糊 */
        if (!ObjectUtils.isEmpty(query.getProductNo())) {
            list.add(qdo.productNo.like(SqlUtil.toSqlLikeString(query.getProductNo())));
        }
        /** 产品编号标记 精确 */
        if (!ObjectUtils.isEmpty(query.getProductNoExit())) {
            if ("1".equals(query.getProductNoExit())) {
                list.add(qdo.productNo.isNotNull().and(qdo.productNo.isNotEmpty()));
            } else {
                list.add(qdo.productNo.isNull().or(qdo.productNo.isEmpty()));
            }
        }

        /** 易道壳项目过程文档itemid 精确 */
        if (!ObjectUtils.isEmpty(query.getProcessDocItemId())) {
            list.add(qdo.processDocItemId.eq(query.getProcessDocItemId()));
        }
        /** 易道壳项目验收文档itemid 精确 */
        if (!ObjectUtils.isEmpty(query.getAcceptanceDocItemId())) {
            list.add(qdo.acceptanceDocItemId.eq(query.getAcceptanceDocItemId()));
        }
        /** 易道壳项目总结文档itemid 精确 */
        if (!ObjectUtils.isEmpty(query.getSummaryDocItemId())) {
            list.add(qdo.summaryDocItemId.eq(query.getSummaryDocItemId()));
        }
        /** 研发补贴金额 精确 */
        if (!ObjectUtils.isEmpty(query.getSubsidyAmt())) {
            list.add(qdo.subsidyAmt.eq(query.getSubsidyAmt()));
        }
        /** 折旧月数 精确 */
        if (!ObjectUtils.isEmpty(query.getDepreciationMonths())) {
            list.add(qdo.depreciationMonths.eq(query.getDepreciationMonths()));
        }
        /** 折旧开始时间 精确 */
        if (!ObjectUtils.isEmpty(query.getDepreciationStartDate())) {
            list.add(qdo.depreciationStartDate.eq(query.getDepreciationStartDate()));
        }
        /** 项目类型  */
        if (!ObjectUtils.isEmpty(query.getExt1())) {
            list.add(qdo.ext1.eq(query.getExt1()));
        }
        /** 扩展字段2 模糊 */
        if (!ObjectUtils.isEmpty(query.getExt2())) {
            list.add(qdo.ext2.like(SqlUtil.toSqlLikeString(query.getExt2())));
        }
        /** 扩展字段3 模糊 */
        if (!ObjectUtils.isEmpty(query.getExt3())) {
            list.add(qdo.ext3.like(SqlUtil.toSqlLikeString(query.getExt3())));
        }
        /** 扩展字段4 模糊 */
        if (!ObjectUtils.isEmpty(query.getExt4())) {
            list.add(qdo.ext4.like(SqlUtil.toSqlLikeString(query.getExt4())));
        }
        /** 扩展字段5 模糊 */
        if (!ObjectUtils.isEmpty(query.getExt5())) {
            list.add(qdo.ext5.like(SqlUtil.toSqlLikeString(query.getExt5())));
        }
        /** 帮我吧项目名称 模糊 */
        if (!ObjectUtils.isEmpty(query.getBangwo8ProjName())) {
            list.add(qdo.bangwo8ProjName.like(SqlUtil.toSqlLikeString(query.getBangwo8ProjName())));
        }
        /** 项目名称/编号 关键字查询 */
        if (!ObjectUtils.isEmpty(query.getProjectSearchKey())) {
            list.add(qdo.projName.like(SqlUtil.toSqlLikeString(query.getProjectSearchKey())).or(qdo.projNo.like(SqlUtil.toSqlLikeString(query.getProjectSearchKey()))));
        }
        /** 合同编号/名称 */
        if (!ObjectUtils.isEmpty(query.getContractSearchKey())) {
            list.add(qdoSaleCon.name.like(SqlUtil.toSqlLikeString(query.getContractSearchKey())).or(qdoSaleCon.code.like(SqlUtil.toSqlLikeString(query.getContractSearchKey()))));
        }
        /** 参考合同号 */
        if (!ObjectUtils.isEmpty(query.getReferCode())) {
            list.add(qdoSaleCon.referCode.like(SqlUtil.toSqlLikeString(query.getReferCode())));
        }
        /** 交付BU_ID */
        if (!ObjectUtils.isEmpty(query.getDeliBuId())) {
            list.add(qdoSaleCon.deliBuId.eq(query.getDeliBuId()));
        }
        /** 交付BU_ID */
        if (!ObjectUtils.isEmpty(query.getDeliBuIds())) {
            list.add(qdo.deliBuId.in(query.getDeliBuIds()));
        }
        /** 交付负责人id */
        if (!ObjectUtils.isEmpty(query.getDeliUserId())) {
            list.add(qdoSaleCon.deliUserId.eq(query.getDeliUserId()));
        }
        /** 销售负责人ID */
        if (!ObjectUtils.isEmpty(query.getSaleManUserId())) {
            list.add(qdoSaleCon.saleManUserId.eq(query.getSaleManUserId()));
        }
        /** 工作类型 */
        if (!ObjectUtils.isEmpty(query.getWorkType())) {
            list.add(qdoSaleCon.workType.eq(query.getWorkType()));
        }
        /**是否筛选的全是外部项目*/
        if (query.getIsExternalProject()) {
            //i. “工作类型”筛选，若勾选了“仅外部项目”，需过滤掉 platType = 'ficitious'的项目，即平台合同类型=“虚拟合同”的数据不应展示
            list.add(qdoSaleCon.platType.ne(SaleConEnum.FICTITIOUS.getCode()));
        }
        /** 工作类型筛选 */
        if (!ObjectUtils.isEmpty(query.getWorkTypes())) {
            list.add(qdoSaleCon.workType.in(query.getWorkTypes()));
        }
        /** 计划上线日期 */
        if (!ObjectUtils.isEmpty(query.getPlanOnlineDate())) {
            list.add(qdo.planOnlineDate.isNotNull().and(qdo.planOnlineDate.loe(query.getPlanOnlineDate())));
        }
        /** 无合同项目激活后代办提示 */
        if (!ObjectUtils.isEmpty(query.getNoContractFlag())) {
            list.add(qdo.noContractFlag.eq(query.getNoContractFlag()));
        }
        /**客户id*/
        if (!ObjectUtils.isEmpty(query.getCustomerId())) {
            list.add(qdoSaleCon.custId.eq(query.getCustomerId()));
        }
        /**主子合同*/
        if (!ObjectUtils.isEmpty(query.getMainType())) {
            list.add(qdoSaleCon.mainType.eq(query.getMainType()));
        }
        // 帮我吧项目同步用
        if (!ObjectUtils.isEmpty(query.getModifyTimeGt())) {
            list.add(qdo.modifyTime.goe(query.getModifyTimeGt()));
        }
        if (query.getBriefWorkFlag() && query.getLoginUserId() != null) {
            //汇报代办提示
            BooleanExpression orExpression = qdo.pmResId.eq(query.getLoginUserId());
            list.add(orExpression);
        }
        if (query.getPermissionFlag()) {
            //需要处理权限
            BooleanExpression orExpression = qdo.pmResId.eq(query.getLoginUserId()).or(qdo.pmoResId.eq(query.getLoginUserId())).or(qdo.superResId.eq(query.getLoginUserId())).or(qdoSaleCon.deliUserId.eq(query.getLoginUserId()));
            if (!ObjectUtils.isEmpty(query.getDeliBuIds())) {
                orExpression = orExpression.or(qdoSaleCon.deliBuId.in(query.getDeliBuIds()));
            }
            list.add(orExpression);
        }
        if (query.getHwhtSyncFlag() != null) {
            list.add(qdo.hwhtSyncFlag.eq(query.getHwhtSyncFlag()));
        }
        return ExpressionUtils.allOf(list);
    }

    /**
     * 拼装查询字段
     *
     * @return jpaQuery对象
     */
    private JPAQuery<PmsProjectVO> getJpaQuerySelectByKey() {
        return jpaQueryFactory.select(Projections.bean(PmsProjectVO.class,
                qdo.id,
                qdo.remark,
                qdo.createUserId,
                qdo.creator,
                qdo.createTime,
                qdo.modifyUserId,
                qdo.updater,
                qdo.modifyTime,
                // 项目重要度
                qdo.projectImportance,
                // 预算总人天
                qdo.totalDays,
                // 费用总成本
                qdo.totalCost,
                // 工时结算周期
                qdo.timesheetPeriod,
                // 项目名称
                qdo.projName,
                // 项目状态
                qdo.projStatus,
                // 合同id
                qdo.contractId,
                // 项目模板id
                qdo.projTempId,
                // 客户行业
                qdo.custIdst,
                // 客户区域
                qdo.custRegion,
                // 预计开始日期
                qdo.planStartDate,
                // 预计结束日期
                qdo.planEndDate,
                //实际开始
                qdo.startDate,
                //实际结束
                qdo.endDate,
                // 项目经理资源id
                qdo.pmResId,
                // 项目经理当量系数
                qdo.pmEqvaRatio,
                // pmo资源负责人id
                qdo.pmoResId,
                // pmo助理资源负责人id
                qdo.pmoDeputyResId,
                // 总当量
                qdo.totalEqva,
                // 派发当量（交付负责人-项目经理）
                qdo.distEqva,
                // 派发费用（交付负责人-项目经理）
                qdo.distCost,
                // 费用总预算
                qdo.totalReimbursement,
                // 当量预估单价
                qdo.eqvaPrice,
                // 允许外包
                qdo.epibolyPermitFlag,
                // 允许转包
                qdo.subcontractPermitFlag,
                // 非结算活动需要审批
                qdo.finishApproveFlag,
                // 最低保证金
                qdo.deposit,
                // 关联项目
                qdo.relatedProjId,
                // 绩效规则
                qdo.performanceDesc,
                // 关闭原因
                qdo.closeReason,

                // 差旅餐补限额
                qdo.maxTravelFee,
                // 项目编号
                qdo.projNo,
                // 完工百分比
                qdo.compPercent,
                // 允许一人多任务包
                qdo.muiltiTaskFlag,
                //最近汇报时间
                qdo.reportTime,
                // 项目进度状态
                qdo.projProcessStatus,
                // 自动汇报标识
                qdo.autoReportFlag,
                // 每期确认金额
                qdo.reportPeriodAmt,
                // 汇报开始期间
                qdo.reportStartDate,
                // 汇报期间数
                qdo.reportQty,
                // 包含客户承担费用标志
                qdo.containsCustomerFlag,
                // 项目难度
                qdo.projectDifficult,
                // 项目预算总开关标志 0:否 1:是
                qdo.budgetSwitchFlag,
                // 项目活动状态
                qdo.projActivityStatus,
                // 项目活动审批状态
                qdo.projActivityApprStatus,
                // 关联项目编号
                qdo.relatedProjNo,
                // 产品编号
                qdo.productNo,
                // 易道壳项目过程文档itemid
                qdo.processDocItemId,
                // 易道壳项目验收文档itemid
                qdo.acceptanceDocItemId,
                // 易道壳项目总结文档itemid
                qdo.summaryDocItemId,
                // 研发补贴金额
                qdo.subsidyAmt,
                // 折旧月数
                qdo.depreciationMonths,
                // 折旧开始时间
                qdo.depreciationStartDate,
                // sow节选
                qdo.sowFiles,
                // 预算附件
                qdo.budgetFiles,
                // 绩效附件
                qdo.performanceFiles,
                // 附件
                qdo.projectFiles,
                //资源规划日期
                qdo.planUpdateDate,
                //费用承担bu
                qdo.expenseBuId,
                //慧通同步标记
                qdo.hwhtSyncFlag,
                // 扩展字段1
                qdo.ext1,
                // 项目收入确认备注
                qdo.ext2,
                // 扩展字段3
                qdo.ext3,
                // 扩展字段4
                qdo.ext4,
                // 扩展字段5
                qdo.ext5,
                // 帮我吧项目名称
                qdo.bangwo8ProjName,
                // 交付BU_ID
                qdoSaleCon.deliBuId,
                //交付负责人id
                qdoSaleCon.deliUserId,
                // 销售负责人ID
                qdoSaleCon.saleManUserId,
                //参考合同号
                qdoSaleCon.referCode,
                // 工作类型
                qdoSaleCon.workType,
                // 签单BU_ID
                qdoSaleCon.signBuId,
                // 子合同名称
                qdoSaleCon.name.as("contractName"),
                // 子合同编号
                qdoSaleCon.code.as("contractNo"),
                //平台提成百分比
                qdoSaleCon.percentage,
                // 平台合同类型
                qdoSaleCon.platType,
                // 项目总金额
                qdoSaleCon.amt.as("sumAmt"),
                // 交付地点
                qdoSaleCon.deliveryAddress,
                //签约公司ID
                // qdoSaleCon.ouId,
                qdoSaleCon.ouBookId,
                //客户承担差旅费
                qdoSaleCon.custBarExpense,
                //币种
                qdoSaleCon.currCode,
                //税率
                qdoSaleCon.taxRate,
                //有效合同金额
                qdoSaleCon.effectiveAmt,
                //客户id
                qdoSaleCon.custId,
                //财务核定额定当量
                qdoSaleCon.finRatedEqva,
                //额定费用
                qdoSaleCon.ratedCost,
                //项目执行当量
                qdoExecCondition.projExecEquiv,
                // 合同状态
                qdoSaleCon.status.as("contractStatus"),
                // 商机ID
                qdoSaleCon.oppoId,
                // 产品大类
                qdoSaleCon.productClass,
                // 签订日期
                qdoSaleCon.signDate.as("contractSignDate"),
                // 合同开始日期
                qdoSaleCon.startDate.as("contractStartDate"),
                // 合同结束日期
                qdoSaleCon.endDate.as("contractEndDate"),
                // 产品小类
                qdoSaleCon.productSubClass,
                qdoSaleCon.referCode,
                // 研发立项附件
                qdo.researchFiles,
                qdo.superResId,
                qdo.riskLevel,
                qdo.planOnlineDate,
                qdo.noContractFlag,
                qdo.subjectTempId,
                qdo.changeFlag,
                qdo.costLevel,
                qdo.jdeConfirmTime,
                qdo.jdeSummary,
                qdo.jdeDocNo,
                qdo.jdeDocTime,
                qdo.jdeErrMsg,
                qdo.jdeDocState
        )).from(qdo).leftJoin(qdoSaleCon).on(qdo.contractId.eq(qdoSaleCon.id)).leftJoin(qdoExecCondition).on(qdoExecCondition.contractId.eq(qdoSaleCon.id));
    }

    /**
     * 根据主键查询
     *
     * @param id 主键
     * @return 结果
     */
    public PmsProjectVO queryByKey(Long id) {
        JPAQuery<PmsProjectVO> jpaQuery = getJpaQuerySelectByKey();
        jpaQuery.where(qdo.id.eq(id));
        jpaQuery.where(qdo.deleteFlag.eq(0));
        return jpaQuery.fetchFirst();
    }

    /**
     * 根据主键查询
     *
     * @param ids 主键
     * @return 结果
     */
    public List<PmsProjectVO> queryByKeys(List<Long> ids) {
        JPAQuery<PmsProjectVO> jpaQuery = getJpaQuerySelect();
        jpaQuery.where(qdo.id.in(ids));
        jpaQuery.where(qdo.deleteFlag.eq(0));
        return jpaQuery.fetch();
    }

    /**
     * 根据合同主键查询
     *
     * @param contractId 合同主键
     * @return 结果
     */
    public PmsProjectVO queryByContractId(Long contractId) {
        JPAQuery<PmsProjectVO> jpaQuery = getJpaQuerySelect();
        jpaQuery.where(qdo.contractId.eq(contractId));
        jpaQuery.where(qdo.deleteFlag.eq(0));
        return jpaQuery.fetchFirst();
    }

    /**
     * 根据合同主键查询
     *
     * @param contractIds 合同主键
     * @return 结果
     */
    public List<PmsProjectVO> queryByContractIds(List<Long> contractIds) {
        JPAQuery<PmsProjectVO> jpaQuery = getJpaQuerySelect();
        jpaQuery.where(qdo.contractId.in(contractIds));
        jpaQuery.where(qdo.deleteFlag.eq(0));
        return jpaQuery.fetch();
    }

    /**
     * 动态查询集合
     *
     * @param query 查询参数
     * @return 结果集合
     */
    public List<PmsProjectVO> queryListDynamic(PmsProjectQuery query) {
        JPAQuery<PmsProjectVO> jpaQuery = getJpaQueryWhere(query);
        return jpaQuery.fetch();
    }

    /**
     * 动态查询集合
     *
     * @param query 查询参数
     * @return 结果集合
     */
    public List<PmsProjectVO> queryProjectUpdateWork(PmsProjectQuery query) {
        JPAQuery<PmsProjectVO> jpaQuery = jpaQueryFactory.select(Projections.bean(PmsProjectVO.class,
                qdo.id,
                // 项目名称
                qdo.projName,
                // 合同id
                qdo.contractId,
                //预计总当量
                qdo.totalEqva,
                //预计总费用
                qdo.totalReimbursement,
                //额定费用
                qdoSaleCon.ratedCost,
                //项目执行当量
                qdoExecCondition.projExecEquiv

        )).from(qdo).leftJoin(qdoSaleCon).on(qdo.contractId.eq(qdoSaleCon.id)).leftJoin(qdoExecCondition).on(qdoExecCondition.contractId.eq(qdoSaleCon.id));
        /** 交付负责人id */
        if (!ObjectUtils.isEmpty(query.getDeliUserId())) {
            jpaQuery.where(qdo.deliUserId.eq(query.getDeliUserId()));
        }
        /** 无合同项目激活后代办提示 */
        if (!ObjectUtils.isEmpty(query.getNoContractFlag())) {
            jpaQuery.where(qdo.noContractFlag.eq(query.getNoContractFlag()));
        }
        // 动态排序
        jpaQuery.orderBy(SqlUtil.getSortedColumn(qdo, query.getOrders()));
        jpaQuery.groupBy(qdo.id);
        return jpaQuery.fetch();
    }

    /**
     * 动态查询集合
     *
     * @param query 查询参数
     * @return 结果集合
     */
    public List<PmsProjectVO> queryListCount(PmsProjectQuery query) {
        JPAQuery<PmsProjectVO> jpaQuery = getJpaQueryWhere(query);
        return jpaQuery.fetch();
    }


    /**
     * 调用jpa的保存
     *
     * @param ado do对象
     * @return 保存后的对象
     */
    public PmsProjectDO save(PmsProjectDO ado) {
        return repo.save(ado);
    }

    /**
     * 调用jpa的保存所有
     *
     * @param dos 多个do对象
     * @return 保存后的对象集合
     */
    public List<PmsProjectDO> saveAll(List<PmsProjectDO> dos) {
        return repo.saveAll(dos);
    }

    /**
     * 按主键动态修改（只修非null字段，如果需要将某些字段修改为null，请添加nullFields）
     *
     * @param payload 要修改的对象
     * @return 修改的行数
     */
    @Transactional
    public long updateByKeyDynamic(PmsProjectPayload payload) {
        JPAUpdateClause update = jpaQueryFactory.update(qdo)
                .where(qdo.id.eq(payload.getId()));

        // 项目重要度
        if (payload.getProjectImportance() != null) {
            update.set(qdo.projectImportance, payload.getProjectImportance());
        }
        // 预算总人天
        if (payload.getTotalDays() != null) {
            update.set(qdo.totalDays, payload.getTotalDays());
        }
        // 费用总成本
        if (payload.getTotalCost() != null) {
            update.set(qdo.totalCost, payload.getTotalCost());
        }
        // 工时结算周期
        if (payload.getTimesheetPeriod() != null) {
            update.set(qdo.timesheetPeriod, payload.getTimesheetPeriod());
        }
        // 项目名称
        if (payload.getProjName() != null) {
            update.set(qdo.projName, payload.getProjName());
        }
        // 项目状态
        if (payload.getProjStatus() != null) {
            update.set(qdo.projStatus, payload.getProjStatus());
        }
        // 合同id
        if (payload.getContractId() != null) {
            update.set(qdo.contractId, payload.getContractId());
        }
        // 项目模板id
        if (payload.getProjTempId() != null) {
            update.set(qdo.projTempId, payload.getProjTempId());
        }
        // 客户行业
        if (payload.getCustIdst() != null) {
            update.set(qdo.custIdst, payload.getCustIdst());
        }
        // 客户区域
        if (payload.getCustRegion() != null) {
            update.set(qdo.custRegion, payload.getCustRegion());
        }
        // 预计开始日期
        if (payload.getPlanStartDate() != null) {
            update.set(qdo.planStartDate, payload.getPlanStartDate());
        }
        // 预计结束日期
        if (payload.getPlanEndDate() != null) {
            update.set(qdo.planEndDate, payload.getPlanEndDate());
        }
        // 开始日期
        if (payload.getStartDate() != null) {
            update.set(qdo.startDate, payload.getStartDate());
        }
        // 结束日期
        if (payload.getEndDate() != null) {
            update.set(qdo.endDate, payload.getEndDate());
        }
        // 项目经理资源id
        if (payload.getPmResId() != null) {
            update.set(qdo.pmResId, payload.getPmResId());
        }
        // 项目经理当量系数
        if (payload.getPmEqvaRatio() != null) {
            update.set(qdo.pmEqvaRatio, payload.getPmEqvaRatio());
        }
        // pmo资源负责人id
        if (payload.getPmoResId() != null) {
            update.set(qdo.pmoResId, payload.getPmoResId());
        }
        // pmo助理资源负责人id
        if (payload.getPmoDeputyResId() != null) {
            update.set(qdo.pmoDeputyResId, payload.getPmoDeputyResId());
        }
        // 总当量
        if (payload.getTotalEqva() != null) {
            update.set(qdo.totalEqva, payload.getTotalEqva());
        }
        // 派发当量（交付负责人-项目经理）
        if (payload.getDistEqva() != null) {
            update.set(qdo.distEqva, payload.getDistEqva());
        }
        // 派发费用（交付负责人-项目经理）
        if (payload.getDistCost() != null) {
            update.set(qdo.distCost, payload.getDistCost());
        }
        // 费用总预算
        if (payload.getTotalReimbursement() != null) {
            update.set(qdo.totalReimbursement, payload.getTotalReimbursement());
        }
        // 当量预估单价
        if (payload.getEqvaPrice() != null) {
            update.set(qdo.eqvaPrice, payload.getEqvaPrice());
        }
        // 允许外包
        if (payload.getEpibolyPermitFlag() != null) {
            update.set(qdo.epibolyPermitFlag, payload.getEpibolyPermitFlag());
        }
        // 允许转包
        if (payload.getSubcontractPermitFlag() != null) {
            update.set(qdo.subcontractPermitFlag, payload.getSubcontractPermitFlag());
        }
        // 非结算活动需要审批
        if (payload.getFinishApproveFlag() != null) {
            update.set(qdo.finishApproveFlag, payload.getFinishApproveFlag());
        }
        // 最低保证金
        if (payload.getDeposit() != null) {
            update.set(qdo.deposit, payload.getDeposit());
        }
        // 关联项目
        if (payload.getRelatedProjId() != null) {
            update.set(qdo.relatedProjId, payload.getRelatedProjId());
        }
        // 绩效规则
        if (payload.getPerformanceDesc() != null) {
            update.set(qdo.performanceDesc, payload.getPerformanceDesc());
        }
        // 关闭原因
        if (payload.getCloseReason() != null) {
            update.set(qdo.closeReason, payload.getCloseReason());
        }

        // 差旅餐补限额
        if (payload.getMaxTravelFee() != null) {
            update.set(qdo.maxTravelFee, payload.getMaxTravelFee());
        }
        // 项目编号
        if (payload.getProjNo() != null) {
            update.set(qdo.projNo, payload.getProjNo());
        }
        // 完工百分比
        if (payload.getCompPercent() != null) {
            update.set(qdo.compPercent, payload.getCompPercent());
        }
        // 最近汇报时间
        if (payload.getReportTime() != null) {
            update.set(qdo.reportTime, payload.getReportTime());
        }
        // 允许一人多任务包
        if (payload.getMuiltiTaskFlag() != null) {
            update.set(qdo.muiltiTaskFlag, payload.getMuiltiTaskFlag());
        }
        // 项目进度状态
        if (payload.getProjProcessStatus() != null) {
            update.set(qdo.projProcessStatus, payload.getProjProcessStatus());
        }
        // 自动汇报标识
        if (payload.getAutoReportFlag() != null) {
            update.set(qdo.autoReportFlag, payload.getAutoReportFlag());
        }
        // 每期确认金额
        if (payload.getReportPeriodAmt() != null) {
            update.set(qdo.reportPeriodAmt, payload.getReportPeriodAmt());
        }
        // 汇报开始期间
        if (payload.getReportStartDate() != null) {
            update.set(qdo.reportStartDate, payload.getReportStartDate());
        }
        // 汇报期间数
        if (payload.getReportQty() != null) {
            update.set(qdo.reportQty, payload.getReportQty());
        }
        // 包含客户承担费用标志
        if (payload.getContainsCustomerFlag() != null) {
            update.set(qdo.containsCustomerFlag, payload.getContainsCustomerFlag());
        }
        // 项目难度
        if (payload.getProjectDifficult() != null) {
            update.set(qdo.projectDifficult, payload.getProjectDifficult());
        }
        // 项目预算总开关标志 0:否 1:是
        if (payload.getBudgetSwitchFlag() != null) {
            update.set(qdo.budgetSwitchFlag, payload.getBudgetSwitchFlag());
        }
        // 项目活动状态
        if (payload.getProjActivityStatus() != null) {
            update.set(qdo.projActivityStatus, payload.getProjActivityStatus());
        }
        // 项目活动审批状态
        if (payload.getProjActivityApprStatus() != null) {
            update.set(qdo.projActivityApprStatus, payload.getProjActivityApprStatus());
        }
        // 关联项目编号
        if (payload.getRelatedProjNo() != null) {
            update.set(qdo.relatedProjNo, payload.getRelatedProjNo());
        }
        // 产品编号
        if (payload.getProductNo() != null) {
            update.set(qdo.productNo, payload.getProductNo());
        }
        // 易道壳项目过程文档itemid
        if (payload.getProcessDocItemId() != null) {
            update.set(qdo.processDocItemId, payload.getProcessDocItemId());
        }
        // 易道壳项目验收文档itemid
        if (payload.getAcceptanceDocItemId() != null) {
            update.set(qdo.acceptanceDocItemId, payload.getAcceptanceDocItemId());
        }
        // 易道壳项目总结文档itemid
        if (payload.getSummaryDocItemId() != null) {
            update.set(qdo.summaryDocItemId, payload.getSummaryDocItemId());
        }
        // 研发补贴金额
        if (payload.getSubsidyAmt() != null) {
            update.set(qdo.subsidyAmt, payload.getSubsidyAmt());
        }
        // 折旧月数
        if (payload.getDepreciationMonths() != null) {
            update.set(qdo.depreciationMonths, payload.getDepreciationMonths());
        }
        // 折旧开始时间
        if (payload.getDepreciationStartDate() != null) {
            update.set(qdo.depreciationStartDate, payload.getDepreciationStartDate());
        }
        // sow节选
        if (payload.getSowFiles() != null) {
            update.set(qdo.sowFiles, payload.getSowFiles());
        }
        // 预算附件
        if (payload.getBudgetFiles() != null) {
            update.set(qdo.budgetFiles, payload.getBudgetFiles());
        }
        // 绩效附件
        if (payload.getPerformanceFiles() != null) {
            update.set(qdo.performanceFiles, payload.getPerformanceFiles());
        }
        // 附件
        if (payload.getProjectFiles() != null) {
            update.set(qdo.projectFiles, payload.getProjectFiles());
        }
        // 变更中标志
        if (payload.getChangeFlag() != null) {
            update.set(qdo.changeFlag, payload.getChangeFlag());
        }
        // 备注
        if (payload.getRemark() != null) {
            update.set(qdo.remark, payload.getRemark());
        }
        // 删除标志
        if (payload.getDeleteFlag() != null) {
            update.set(qdo.deleteFlag, payload.getDeleteFlag());
        }
        // 资源规划更新日期
        if (payload.getPlanUpdateDate() != null) {
            update.set(qdo.planUpdateDate, payload.getPlanUpdateDate());
        }
        // 扩展字段1
        if (payload.getExt1() != null) {
            update.set(qdo.ext1, payload.getExt1());
        }
        // 项目收入确认备注
        if (payload.getExt2() != null) {
            update.set(qdo.ext2, payload.getExt2());
        }
        // 扩展字段3
        if (payload.getExt3() != null) {
            update.set(qdo.ext3, payload.getExt3());
        }
        // 扩展字段4
        if (payload.getExt4() != null) {
            update.set(qdo.ext4, payload.getExt4());
        }
        // 扩展字段5
        if (payload.getExt5() != null) {
            update.set(qdo.ext5, payload.getExt5());
        }
        // 帮我吧项目名称
        if (payload.getBangwo8ProjName() != null) {
            update.set(qdo.bangwo8ProjName, payload.getBangwo8ProjName());
        }
        // 督导
        if (payload.getSuperResId() != null) {
            update.set(qdo.superResId, payload.getSuperResId());
        }
        // 费用承担bu
        if (payload.getExpenseBuId() != null) {
            update.set(qdo.expenseBuId, payload.getExpenseBuId());
        }
        // 预计上线时间
        if (payload.getPlanOnlineDate() != null) {
            update.set(qdo.planOnlineDate, payload.getPlanOnlineDate());
        }
        // 风险等级
        if (payload.getRiskLevel() != null) {
            update.set(qdo.riskLevel, payload.getRiskLevel());
        }
        // 无合同项目激活后代办提示
        if (payload.getNoContractFlag() != null) {
            update.set(qdo.noContractFlag, payload.getNoContractFlag());
        }
        // 成本级别
        if (payload.getCostLevel() != null) {
            update.set(qdo.costLevel, payload.getCostLevel());
        }
        // JDE提交确认时间
        if (payload.getJdeConfirmTime() != null) {
            update.set(qdo.jdeConfirmTime, payload.getJdeConfirmTime());
        }
        if (payload.getJdeSummary() != null) {
            update.set(qdo.jdeSummary, payload.getJdeSummary());
        }
        if (payload.getJdeDocNo() != null) {
            update.set(qdo.jdeDocNo, payload.getJdeDocNo());
        }
        if (payload.getJdeErrMsg() != null) {
            update.set(qdo.jdeErrMsg, payload.getJdeErrMsg());
        }
        if (payload.getJdeDocState() != null) {
            update.set(qdo.jdeDocState, payload.getJdeDocState());
        }
        if (payload.getJdeDocTime() != null) {
            update.set(qdo.jdeDocTime, payload.getJdeDocTime());
        }
        // 处理要设置成空的字段
        List<String> nullFields = payload.getNullFields();
        if (nullFields != null && nullFields.size() > 0) {
            // 记录唯一ID
            if (nullFields.contains("id")) {
                update.setNull(qdo.id);
            }
            // 项目重要度
            if (nullFields.contains("projectImportance")) {
                update.setNull(qdo.projectImportance);
            }
            // 预算总人天
            if (nullFields.contains("totalDays")) {
                update.setNull(qdo.totalDays);
            }
            // 费用总成本
            if (nullFields.contains("totalCost")) {
                update.setNull(qdo.totalCost);
            }
            // 工时结算周期
            if (nullFields.contains("timesheetPeriod")) {
                update.setNull(qdo.timesheetPeriod);
            }
            // 项目名称
            if (nullFields.contains("projName")) {
                update.setNull(qdo.projName);
            }
            // 项目状态
            if (nullFields.contains("projStatus")) {
                update.setNull(qdo.projStatus);
            }
            // 合同id
            if (nullFields.contains("contractId")) {
                update.setNull(qdo.contractId);
            }
            // 项目模板id
            if (nullFields.contains("projTempId")) {
                update.setNull(qdo.projTempId);
            }
            // 客户行业
            if (nullFields.contains("custIdst")) {
                update.setNull(qdo.custIdst);
            }
            // 客户区域
            if (nullFields.contains("custRegion")) {
                update.setNull(qdo.custRegion);
            }
            // 预计开始日期
            if (nullFields.contains("planStartDate")) {
                update.setNull(qdo.planStartDate);
            }
            // 预计结束日期
            if (nullFields.contains("planEndDate")) {
                update.setNull(qdo.planEndDate);
            }
            // 项目经理资源id
            if (nullFields.contains("pmResId")) {
                update.setNull(qdo.pmResId);
            }
            // 项目经理当量系数
            if (nullFields.contains("pmEqvaRatio")) {
                update.setNull(qdo.pmEqvaRatio);
            }
            // pmo资源负责人id
            if (nullFields.contains("pmoResId")) {
                update.setNull(qdo.pmoResId);
            }
            // pmo助理资源负责人id
            if (nullFields.contains("pmoDeputyResId")) {
                update.setNull(qdo.pmoDeputyResId);
            }
            // 总当量
            if (nullFields.contains("totalEqva")) {
                update.setNull(qdo.totalEqva);
            }
            // 派发当量（交付负责人-项目经理）
            if (nullFields.contains("distEqva")) {
                update.setNull(qdo.distEqva);
            }
            // 派发费用（交付负责人-项目经理）
            if (nullFields.contains("distCost")) {
                update.setNull(qdo.distCost);
            }
            // 费用总预算
            if (nullFields.contains("totalReimbursement")) {
                update.setNull(qdo.totalReimbursement);
            }
            // 当量预估单价
            if (nullFields.contains("eqvaPrice")) {
                update.setNull(qdo.eqvaPrice);
            }
            // 允许外包
            if (nullFields.contains("epibolyPermitFlag")) {
                update.setNull(qdo.epibolyPermitFlag);
            }
            // 允许转包
            if (nullFields.contains("subcontractPermitFlag")) {
                update.setNull(qdo.subcontractPermitFlag);
            }
            // 非结算活动需要审批
            if (nullFields.contains("finishApproveFlag")) {
                update.setNull(qdo.finishApproveFlag);
            }
            // 最低保证金
            if (nullFields.contains("deposit")) {
                update.setNull(qdo.deposit);
            }
            // 关联项目
            if (nullFields.contains("relatedProjId")) {
                update.setNull(qdo.relatedProjId);
            }
            // 绩效规则
            if (nullFields.contains("performanceDesc")) {
                update.setNull(qdo.performanceDesc);
            }
            // 关闭原因
            if (nullFields.contains("closeReason")) {
                update.setNull(qdo.closeReason);
            }

            // 差旅餐补限额
            if (nullFields.contains("maxTravelFee")) {
                update.setNull(qdo.maxTravelFee);
            }
            // 项目编号
            if (nullFields.contains("projNo")) {
                update.setNull(qdo.projNo);
            }
            // 完工百分比
            if (nullFields.contains("compPercent")) {
                update.setNull(qdo.compPercent);
            }
            // 允许一人多任务包
            if (nullFields.contains("muiltiTaskFlag")) {
                update.setNull(qdo.muiltiTaskFlag);
            }
            // 项目进度状态
            if (nullFields.contains("projProcessStatus")) {
                update.setNull(qdo.projProcessStatus);
            }
            // 自动汇报标识
            if (nullFields.contains("autoReportFlag")) {
                update.setNull(qdo.autoReportFlag);
            }
            // 每期确认金额
            if (nullFields.contains("reportPeriodAmt")) {
                update.setNull(qdo.reportPeriodAmt);
            }
            // 汇报开始期间
            if (nullFields.contains("reportStartDate")) {
                update.setNull(qdo.reportStartDate);
            }
            // 汇报期间数
            if (nullFields.contains("reportQty")) {
                update.setNull(qdo.reportQty);
            }
            // 包含客户承担费用标志
            if (nullFields.contains("containsCustomerFlag")) {
                update.setNull(qdo.containsCustomerFlag);
            }
            // 项目难度
            if (nullFields.contains("projectDifficult")) {
                update.setNull(qdo.projectDifficult);
            }
            // 项目预算总开关标志 0:否 1:是
            if (nullFields.contains("budgetSwitchFlag")) {
                update.setNull(qdo.budgetSwitchFlag);
            }
            // 项目活动状态
            if (nullFields.contains("projActivityStatus")) {
                update.setNull(qdo.projActivityStatus);
            }
            // 项目活动审批状态
            if (nullFields.contains("projActivityApprStatus")) {
                update.setNull(qdo.projActivityApprStatus);
            }
            // 关联项目编号
            if (nullFields.contains("relatedProjNo")) {
                update.setNull(qdo.relatedProjNo);
            }
            // 产品编号
            if (nullFields.contains("productNo")) {
                update.setNull(qdo.productNo);
            }
            // 易道壳项目过程文档itemid
            if (nullFields.contains("processDocItemId")) {
                update.setNull(qdo.processDocItemId);
            }
            // 易道壳项目验收文档itemid
            if (nullFields.contains("acceptanceDocItemId")) {
                update.setNull(qdo.acceptanceDocItemId);
            }
            // 易道壳项目总结文档itemid
            if (nullFields.contains("summaryDocItemId")) {
                update.setNull(qdo.summaryDocItemId);
            }
            // 研发补贴金额
            if (nullFields.contains("subsidyAmt")) {
                update.setNull(qdo.subsidyAmt);
            }
            // 折旧月数
            if (nullFields.contains("depreciationMonths")) {
                update.setNull(qdo.depreciationMonths);
            }
            // 折旧开始时间
            if (nullFields.contains("depreciationStartDate")) {
                update.setNull(qdo.depreciationStartDate);
            }
            // sow节选
            if (nullFields.contains("sowFiles")) {
                update.setNull(qdo.sowFiles);
            }
            // 预算附件
            if (nullFields.contains("budgetFiles")) {
                update.setNull(qdo.budgetFiles);
            }
            // 绩效附件
            if (nullFields.contains("performanceFiles")) {
                update.setNull(qdo.performanceFiles);
            }
            // 附件
            if (nullFields.contains("projectFiles")) {
                update.setNull(qdo.projectFiles);
            }
            // 扩展字段1
            if (nullFields.contains("ext1")) {
                update.setNull(qdo.ext1);
            }
            // 项目收入确认备注
            if (nullFields.contains("ext2")) {
                update.setNull(qdo.ext2);
            }
            // 扩展字段3
            if (nullFields.contains("ext3")) {
                update.setNull(qdo.ext3);
            }
            // 扩展字段4
            if (nullFields.contains("ext4")) {
                update.setNull(qdo.ext4);
            }
            // 扩展字段5
            if (nullFields.contains("ext5")) {
                update.setNull(qdo.ext5);
            }
            // 帮我吧项目名称
            if (nullFields.contains("bangwo8ProjName")) {
                update.setNull(qdo.bangwo8ProjName);
            }

        }
        //拼装更新
        SqlUtil.updateCommonJpaQuery(update, qdo._super);
        // 执行修改
        return update.execute();
    }

    /**
     * 逻辑删除
     *
     * @param keys 主集合
     * @return 删除的行数
     */
    public long deleteSoft(List<Long> keys) {
        JPAUpdateClause update = jpaQueryFactory.update(qdo)
                .set(qdo.deleteFlag, 1)
                .where(qdo.id.in(keys));
        //拼装更新
        SqlUtil.updateCommonJpaQuery(update, qdo._super);
        return update.execute();
    }


    /**
     * 更改项目状态
     *
     * @param key
     * @param projStatus
     * @return
     */
    public long updateProjStatus(Long key, String projStatus) {
        JPAUpdateClause update = jpaQueryFactory.update(qdo)
                .set(qdo.projStatus, projStatus)
                .where(qdo.id.eq(key));
        //拼装更新
        SqlUtil.updateCommonJpaQuery(update, qdo._super);
        return update.execute();
    }

    /**
     * 更改项目状态
     *
     * @param keys
     * @param projStatus
     * @return
     */
    public long updateProjStatuss(List<Long> keys, String projStatus) {
        JPAUpdateClause update = jpaQueryFactory.update(qdo)
                .set(qdo.projStatus, projStatus)
                .where(qdo.id.in(keys));
        //拼装更新
        SqlUtil.updateCommonJpaQuery(update, qdo._super);
        return update.execute();
    }

    /**
     * 添加合同id
     *
     * @param
     * @return 修改的行数
     */
    @Transactional
    public long addContractId(long id, long contractId) {
        JPAUpdateClause update = jpaQueryFactory.update(qdo)
                .where(qdo.id.eq(id));
        update.set(qdo.contractId, contractId);
        // 执行修改
        return update.execute();
    }

    /**
     * 拼装查询字段
     *
     * @return jpaQuery对象
     */
    private JPAQuery<PmsProjectVO> getJpaQuerySelect1() {
        return jpaQueryFactory.select(Projections.bean(PmsProjectVO.class,
                qdo.id,
                qdo.projNo,
                //项目名称
                qdo.projName,
                // 预计开始日期
                qdo.planStartDate,
                // 预计结束日期
                qdo.planEndDate,
                // 工作类型
                qdoSaleCon.workType
        )).from(qdo).leftJoin(qdoSaleCon).on(qdoSaleCon.id.eq(qdo.contractId));
    }

    /**
     * 拼装查询条件
     *
     * @param query 查询参数
     * @return jpaQuery对象
     */
    public List<PmsProjectVO> projectBriefWork(PmsProjectQuery query) {
        JPAQuery<PmsProjectVO> jpaQuery = getJpaQuerySelect();
        // 条件封装
        jpaQuery.where(where(query));

        // 动态排序
        jpaQuery.orderBy(SqlUtil.getSortedColumn(qdo, query.getOrders()));

        return jpaQuery.fetch();
    }

    /**
     * 更新风险等级
     *
     * @param
     * @return 修改的行数
     */
    public long updateRiskLevel(List<Long> keys, String riskLevel) {
        JPAUpdateClause update = jpaQueryFactory.update(qdo)
                .where(qdo.id.in(keys));
        update.set(qdo.riskLevel, riskLevel);
        // 执行修改
        return update.execute();
    }

    /**
     * 查询条件封装
     *
     * @param query 条件
     * @return {@link Predicate}
     */
    private Predicate where0(PmsProjectQuery query) {
        List<Predicate> list = new ArrayList<>();
        /** 交付BU_ID */
        if (!ObjectUtils.isEmpty(query.getId())) {
            list.add(qdo.id.eq(query.getId()));
        }
        /** 交付BU_ID */
        if (!ObjectUtils.isEmpty(query.getDeliBuId())) {
            list.add(qdo.deliBuId.eq(query.getDeliBuId()));
        }
        /** 交付BU_ID */
        if (!ObjectUtils.isEmpty(query.getDeliBuIds())) {
            list.add(qdo.deliBuId.in(query.getDeliBuIds()));
        }
        /** 交付负责人id */
        if (!ObjectUtils.isEmpty(query.getDeliUserId())) {
            list.add(qdo.deliUserId.eq(query.getDeliUserId()));
        }
        /** 销售负责人ID */
        if (!ObjectUtils.isEmpty(query.getSaleManUserId())) {
            list.add(qdo.saleManUserId.eq(query.getSaleManUserId()));
        }
        /** 项目经理id */
        if (!ObjectUtils.isEmpty(query.getPmResId())) {
            list.add(qdo.pmResId.eq(query.getPmResId()));
        }
        /** 无合同项目激活后代办提示 */
        if (!ObjectUtils.isEmpty(query.getNoContractFlag())) {
            list.add(qdo.noContractFlag.eq(query.getNoContractFlag()));
        }
        /** 项目状态 */
        if (!ObjectUtils.isEmpty(query.getProjStatus())) {
            list.add(qdo.projStatus.eq(query.getProjStatus()));
        }
        /** 项目状态 */
        if (!ObjectUtils.isEmpty(query.getProjStatusList())) {
            list.add(qdo.projStatus.in(query.getProjStatusList()));
        }

        return ExpressionUtils.allOf(list);
    }

    /**
     * 统计
     *
     * @param query 查询参数
     * @return jpaQuery对象
     */
    public long count0(PmsProjectQuery query) {
        JPAQuery<Long> jpaQuery = jpaQueryFactory
                .select(qdo.count())
                .from(qdo);
        jpaQuery.where(where0(query));
        // 常用基础查询条件拼装
        SqlUtil.handleCommonJpaQuery(jpaQuery, qdo._super, query);
        long total = jpaQuery.fetchOne();
        return total;
    }

    /**
     * 统计
     *
     * @param query 查询参数
     * @return jpaQuery对象
     */
    public long count1(PmsProjectQuery query) {
        JPAQuery<Long> jpaQuery = jpaQueryFactory
                .select(qdo.count())
                .from(qdo).leftJoin(qdoBudget).on(qdo.id.eq(qdoBudget.sourceId).and(qdoBudget.sourceType.eq("PROJECT")));

        jpaQuery.where(where0(query));

        // 常用基础查询条件拼装
        SqlUtil.handleCommonJpaQuery(jpaQuery, qdo._super, query);
        long total = jpaQuery.fetchOne();
        return total;
    }

    /**
     * 动态查询集合
     *
     * @param query 查询参数
     * @return 结果集合
     */
    public List<PmsProjectVO> queryProjectUpdateBudgetWork(PmsProjectQuery query) {
        JPAQuery<PmsProjectVO> jpaQuery = jpaQueryFactory.select(Projections.bean(PmsProjectVO.class,
                qdo.id,
                // 总当量
                qdo.totalEqva,
                // 费用总预算
                qdo.totalReimbursement,
                //预算总额
                qdoBudget.planAmt.as("feeBudgetAmt"),
                //当量预算总数
                qdoBudget.planEqva.as("eqvaBudgetCnt"),
                qdo.noContractFlag

        )).from(qdo).leftJoin(qdoBudget).on(qdo.id.eq(qdoBudget.sourceId).and(qdoBudget.sourceType.eq("PROJECT")));

        // 条件封装
        jpaQuery.where(where0(query));
        // 常用基础查询条件拼装
        SqlUtil.handleCommonJpaQuery(jpaQuery, qdo._super, query);
        // 动态排序
        jpaQuery.orderBy(SqlUtil.getSortedColumn(qdo, query.getOrders()));
        return jpaQuery.fetch();
    }

    /**
     * 任务授权项目事由查询
     *
     * @param query 查询参数
     * @return 结果集合
     */
    public List<PmsProjectVO> queryTaskAuthorizedProjectList(PmsProjectQuery query) {
        JPAQuery<PmsProjectVO> jpaQuery = jpaQueryFactory.select(Projections.bean(PmsProjectVO.class,
                qdo.id,
                // 项目名称
                qdo.projName,
                // 项目编号
                qdo.projNo,
                //交付bu
                qdo.deliBuId,
                //费用承担bu
                qdo.expenseBuId,
                //项目经理
                qdo.pmResId,
                //当量预算总数
                qdoBudget.planEqva.as("eqvaBudgetCnt"),
                //以拨付当量总数
                qdoBudget.allocatedEqva.as("eqvaReleasedQty")

        )).from(qdo).leftJoin(qdoBudget).on(qdo.id.eq(qdoBudget.sourceId).and(qdoBudget.sourceType.eq(PmsReasonTypeEnum.PROJ_CONTRACT.getCode())));
        // 条件封装
        jpaQuery.where(where0(query));
        /** 项目预算状态 */
        if (!ObjectUtils.isEmpty(query.getBudgetStatus())) {
            jpaQuery.where(qdoBudget.budgetStatus.eq(query.getBudgetStatus()));
        }
        // 常用基础查询条件拼装
        SqlUtil.handleCommonJpaQuery(jpaQuery, qdo._super, query);
        // 动态排序
        jpaQuery.orderBy(SqlUtil.getSortedColumn(qdo, query.getOrders()));
        return jpaQuery.fetch();
    }

    /**
     * 拼装查询字段
     *
     * @return jpaQuery对象
     */
    private JPAQuery<PmsProjectVO> getJpaQuerySelectPaging() {
        return jpaQueryFactory.select(Projections.bean(PmsProjectVO.class,
                qdo.id,
                qdo.createUserId,
                qdo.createTime,

                // 项目重要度
                qdo.projectImportance,

                // 费用总成本
                qdo.totalCost,

                // 项目名称
                qdo.projName,
                // 项目状态
                qdo.projStatus,
                // 合同id
                qdo.contractId,
                // 项目模板id
                qdo.projTempId,
                // 客户行业
                qdo.custIdst,
                // 客户区域
                qdo.custRegion,
                // 预计开始日期
                qdo.planStartDate,
                // 预计结束日期
                qdo.planEndDate,
//                //实际开始
//                qdo.startDate,
//                //实际结束
//                qdo.endDate,
                // 项目经理资源id
                qdo.pmResId,
//                // 项目经理当量系数
//                qdo.pmEqvaRatio,
                // pmo资源负责人id
                qdo.pmoResId,
//                // pmo助理资源负责人id
//                qdo.pmoDeputyResId,
                // 总当量
                qdo.totalEqva,
//                // 派发当量（交付负责人-项目经理）
//                qdo.distEqva,
//                // 派发费用（交付负责人-项目经理）
//                qdo.distCost,
                // 费用总预算
                qdo.totalReimbursement,
//                // 当量预估单价
//                qdo.eqvaPrice,
                // 允许外包
                qdo.epibolyPermitFlag,
                // 允许转包
                qdo.subcontractPermitFlag,
                // 非结算活动需要审批
//                qdo.finishApproveFlag,
//                // 最低保证金
//                qdo.deposit,
                // 关联项目
                qdo.relatedProjId,
//                // 绩效规则
//                qdo.performanceDesc,
//                // 关闭原因
//                qdo.closeReason,
//
//                // 差旅餐补限额
//                qdo.maxTravelFee,
                // 项目编号
                qdo.projNo,
                // 完工百分比
                qdo.compPercent,
//                // 允许一人多任务包
//                qdo.muiltiTaskFlag,
                // 项目进度状态
                qdo.projProcessStatus,
                // 自动汇报标识
                qdo.autoReportFlag,
                // 每期确认金额
                qdo.reportPeriodAmt,
                // 汇报开始期间
                qdo.reportStartDate,
                // 汇报期间数
                qdo.reportQty,
                //费用承担bu
                qdo.expenseBuId,
//                // 包含客户承担费用标志
//                qdo.containsCustomerFlag,
                // 项目难度
                qdo.projectDifficult,
//                // 项目预算总开关标志 0:否 1:是
//                qdo.budgetSwitchFlag,
//                // 项目活动状态
//                qdo.projActivityStatus,
//                // 项目活动审批状态
//                qdo.projActivityApprStatus,
                // 关联项目编号
                qdo.relatedProjNo,
                // 产品编号
                qdo.productNo,
//                // 易道壳项目过程文档itemid
//                qdo.processDocItemId,
//                // 易道壳项目验收文档itemid
//                qdo.acceptanceDocItemId,
//                // 易道壳项目总结文档itemid
//                qdo.summaryDocItemId,
//                // 研发补贴金额
//                qdo.subsidyAmt,
//                // 折旧月数
//                qdo.depreciationMonths,
//                // 折旧开始时间
//                qdo.depreciationStartDate,
                // sow节选
//                qdo.sowFiles,
//                // 预算附件
//                qdo.budgetFiles,
//                // 绩效附件
//                qdo.performanceFiles,
//                // 附件
//                qdo.projectFiles,
//                // 扩展字段1
//                qdo.ext1,
//                // 扩展字段2
//                qdo.ext2,
//                // 扩展字段3
//                qdo.ext3,
//                // 扩展字段4
//                qdo.ext4,
//                // 扩展字段5
//                qdo.ext5,
                // 帮我吧项目名称
                qdo.bangwo8ProjName,
                // 交付BU_ID
                qdo.deliBuId,
                //交付负责人id
                qdo.deliUserId,
                // 销售负责人ID
                qdo.saleManUserId,
                //参考合同号
                qdoSaleCon.referCode,
                // 工作类型
                qdoSaleCon.workType,

                // 子合同名称
                qdoSaleCon.name.as("contractName"),
                // 子合同编号
                qdoSaleCon.code.as("contractNo"),
                // 平台合同类型
                qdoSaleCon.platType,
                // 项目总金额
                qdoSaleCon.amt.as("sumAmt"),
                // 交付地点
                qdoSaleCon.deliveryAddress,
                //签约公司ID
                // qdoSaleCon.ouId,
                qdoSaleCon.ouBookId,
//                //客户承担差旅费
//                qdoSaleCon.custBarExpense,
//
//                //税率
//                qdoSaleCon.taxRate,
                //有效合同金额
                qdoSaleCon.effectiveAmt,
                //客户id
                qdoSaleCon.custId,
                //财务核定额定当量
                qdoSaleCon.finRatedEqva,
                //额定费用
                qdoSaleCon.ratedCost,
                // 合同状态
                qdoSaleCon.status.as("contractStatus"),
                // 研发立项附件
                //     qdo.researchFiles,
                //当量预算总数
                qdoBudget.planEqva.as("eqvaBudgetCnt"),
                //以拨付当量总数
                qdoBudget.allocatedEqva.as("eqvaReleasedQty")

        )).from(qdo).leftJoin(qdoSaleCon).on(qdo.contractId.eq(qdoSaleCon.id)).
                leftJoin(qdoBudget).on(qdoBudget.sourceType.eq("PROJECT").and(qdo.id.eq(qdoBudget.sourceId)).and(qdoBudget.budgetStatus.eq("ACTIVE")));
    }

    /**
     * 拼装查询条件
     *
     * @param query 查询参数
     * @return jpaQuery对象
     */
    private JPAQuery<PmsProjectVO> getJpaQueryWherePaging(PmsProjectQuery query) {
        JPAQuery<PmsProjectVO> jpaQuery = getJpaQuerySelectPaging();
        // 条件封装
        jpaQuery.where(where(query));
        // 常用基础查询条件拼装
        SqlUtil.handleCommonJpaQuery(jpaQuery, qdo._super, query);
        // 动态排序
        jpaQuery.orderBy(SqlUtil.getSortedColumn(qdo, query.getOrders()));
        return jpaQuery;
    }

    /**
     * 分页查询
     *
     * @param query 查询参数
     * @return 分页结果
     */
    public PagingVO<PmsProjectVO> queryPaging(PmsProjectQuery query) {
        long total = count(query);
        if (total == 0) {
            return PagingVO.empty();
        }
        JPAQuery<PmsProjectVO> jpaQuery = getJpaQueryWhere(query);
        //JPAQuery<PmsProjectVO> jpaQuery = getJpaQueryWherePaging(query);
        List<PmsProjectVO> result = jpaQuery
                .offset(query.getPageRequest().getOffset())
                .limit(query.getPageRequest().getPageSize())
                .fetch();
        return PagingVO.<PmsProjectVO>builder().records(result).total(total).build();
    }

    /**
     * 任务授权项目事由查询
     *
     * @param query 查询参数
     * @return 结果集合
     */
    public List<PmsProjectVO> queryReasonProjectList(PmsProjectQuery query) {
        JPAQuery<PmsProjectVO> jpaQuery = jpaQueryFactory.select(Projections.bean(PmsProjectVO.class,
                qdo.id,
                // 项目名称
                qdo.projName,
                // 项目编号
                qdo.projNo,
                //交付bu
                qdo.deliBuId,
                //项目经理
                qdo.pmResId,
                //费用承担bu
                qdo.expenseBuId,
                //签约公司
                //qdoSaleCon.ouId,
                qdoSaleCon.ouBookId,
                //客户是否承担费用
                qdoSaleCon.custBarExpense,
                //客户id
                qdoSaleCon.custId

        )).from(qdo).leftJoin(qdoSaleCon).on(qdo.contractId.eq(qdoSaleCon.id)).leftJoin(qdoMembers).on(qdo.id.eq(qdoMembers.projId));
        // 条件封装
        jpaQuery.where(where0(query));
        /** 项目成员 */
        if (!ObjectUtils.isEmpty(query.getLoginUserId())) {
            jpaQuery.where(qdoMembers.resId.eq(query.getLoginUserId()));
        }
        jpaQuery.where(qdoMembers.deleteFlag.eq(0));
        // 常用基础查询条件拼装
        SqlUtil.handleCommonJpaQuery(jpaQuery, qdo._super, query);
        // 动态排序
        jpaQuery.orderBy(SqlUtil.getSortedColumn(qdo, query.getOrders()));
        jpaQuery.groupBy(qdo.id);
        return jpaQuery.fetch();
    }

    /**
     * 查询我作为项目成员的项目数据
     *
     * @param query 查询参数
     * @return 结果集合
     */
    public List<PmsProjectVO> queryProjectListByMemberId(PmsProjectQuery query) {
        JPAQuery<PmsProjectVO> jpaQuery = jpaQueryFactory.select(Projections.bean(PmsProjectVO.class,
                qdo.id,
                // 项目名称
                qdo.projName,
                // 项目编号
                qdo.projNo,
                //交付bu
                qdoSaleCon.deliBuId,
                //合同id
                qdo.contractId,
                //项目经理
                qdo.pmResId,
                //签约公司
                qdoSaleCon.ouBookId,
                //客户id
                qdoSaleCon.custId,
                //客户承担差旅费
                qdoSaleCon.custBarExpense,
                // 项目类型
                qdo.ext1,
                // 总金额
                qdoSaleCon.amt.as("sumAmt"),
                // 平台合同类型
                qdoSaleCon.platType,
                //交付BU
                qdo.deliBuId
        )).from(qdo).leftJoin(qdoSaleCon).on(qdo.contractId.eq(qdoSaleCon.id)).leftJoin(qdoMembers).on(qdo.id.eq(qdoMembers.projId));
        // 条件封装
        jpaQuery.where(where0(query));
        /** 项目成员 */
        if (!ObjectUtils.isEmpty(query.getLoginUserId())) {
            // jpaQuery.where(qdoMembers.resId.eq(query.getLoginUserId()).or(qdoMembers.resId.eq(0L)));
            jpaQuery.where(qdoMembers.resId.eq(query.getLoginUserId()));
        }
        jpaQuery.where(qdoMembers.deleteFlag.eq(0));
        // 常用基础查询条件拼装
        SqlUtil.handleCommonJpaQuery(jpaQuery, qdo._super, query);
        // 动态排序
        jpaQuery.orderBy(SqlUtil.getSortedColumn(qdo, query.getOrders()));
        jpaQuery.groupBy(qdo.id);
        return jpaQuery.fetch();
    }

    /**
     * 通过项目编号查询项目ID
     *
     * @param projectNo 项目编号
     * @return 项目Id
     */
    public PmsProjectVO findIdByNo(String projectNo) {
        return jpaQueryFactory.select(Projections.bean(PmsProjectVO.class, qdo.id, qdo.subjectTempId, qdo.projName)).from(qdo).where(qdo.deleteFlag.eq(0)
                .and(qdo.projNo.eq(projectNo))).fetchFirst();
    }

    /**
     * 更新慧通同步标记
     *
     * @param ids
     * @return
     */
    public long updateHwhtSyncFlag(List<Long> ids) {
        JPAUpdateClause updater = jpaQueryFactory.update(qdo)
                .set(qdo.hwhtSyncFlag, 1)
                .where(qdo.id.in(ids));
        return updater.execute();
    }

}

