package com.elitesland.tw.tw5.server.prd.pms.entity;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.bean.copier.CopyOptions;
import com.elitescloud.boot.model.entity.BaseModel;
import com.elitescloud.cloudt.common.annotation.Comment;
import lombok.Getter;
import lombok.Setter;
import org.hibernate.annotations.Where;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;
import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDate;

/**
 * BU项目管理
 *
 * @author carl
 * @date 2023-11-29
 */
@Entity
@Table(name = "bu_project", indexes = {
        @Index(name = "bu_proj_year_index", columnList = "bu_id,proj_year"),
})
@org.hibernate.annotations.Table(appliesTo = "bu_project", comment = "BU项目管理")
@Getter
@Setter
@Where(clause = "delete_flag= 0")
public class BuProjectDO extends BaseModel implements Serializable {
    /**
     * BU_ID
     */
    @Comment("BU_ID")
    @Column(name = "bu_id")
    private Long buId;
    /**
     * 项目年度
     */
    @Comment("项目年度")
    @Column(name = "proj_year")
    private Integer projYear;
    /**
     * 项目编号
     */
    @Comment("项目编号")
    @Column()
    private String projNo;
    /**
     * 项目名称
     */
    @Comment("项目名称")
    @Column()
    private String projName;
    /**
     * 项目状态
     */
    @Comment("项目状态")
    @Column()
    private String projStatus;
    /**
     * 项目模板id
     */
    @Comment("项目模板id")
    @Column()
    private String projTempId;
    /**
     * 科目模板id
     */
    @Comment("科目模板id")
    @Column()
    private Long subjectTempId;
    /**
     * 预计开始日期
     */
    @Comment("预计开始日期")
    @Column()
    private LocalDate planStartDate;
    /**
     * 预计结束日期
     */
    @Comment("预计结束日期")
    @Column()
    private LocalDate planEndDate;
    /**
     * 项目经理资源id
     */
    @Comment("项目经理资源id")
    @Column()
    private Long pmResId;
    /**
     * 项目经理当量系数
     */
    @Comment("项目经理当量系数")
    @Column()
    private BigDecimal pmEqvaRatio;
    /**
     * 主交付BU_ID
     */
    @Comment("主交付BU_ID")
    @Column()
    private Long deliBuId;
    /**
     * 交付用户id
     */
    @Comment("交付用户id")
    @Column()
    private Long deliUserId;
    /**
     * 预算总人天
     */
    @Comment("预算总人天")
    @Column()
    private BigDecimal totalDays;
    /**
     * 总当量
     */
    @Comment("总当量")
    @Column()
    private BigDecimal totalEqva;
    /**
     * 费用总预算
     */
    @Comment("费用总预算")
    @Column()
    private BigDecimal totalReimbursement;
    /**
     * 当量预估单价
     */
    @Comment("当量预估单价")
    @Column()
    private BigDecimal eqvaPrice;
    /**
     * 费用总成本（当量成本+费用总预算）
     */
    @Comment("费用总成本（当量成本+费用总预算）")
    @Column()
    private BigDecimal totalCost;
    /**
     * 关闭原因
     */
    @Comment("关闭原因")
    @Column()
    private String closeReason;
    /**
     * 项目进度状态
     */
    @Comment("项目进度状态")
    @Column()
    private String projProcessStatus;
    /**
     * 自动汇报标识
     */
    @Comment("自动汇报标识")
    @Column()
    private Integer autoReportFlag;

    @Comment("慧通同步标记")
    @Column(columnDefinition = "tinyint  DEFAULT 0")
    private Integer hwhtSyncFlag;
    /**
     * 扩展字段1
     */
    @Comment("扩展字段1")
    @Column()
    private String ext1;
    /**
     * 扩展字段2
     */
    @Comment("扩展字段2")
    @Column()
    private String ext2;
    /**
     * 扩展字段3
     */
    @Comment("扩展字段3")
    @Column()
    private String ext3;
    /**
     * 扩展字段4
     */
    @Comment("扩展字段4")
    @Column()
    private String ext4;
    /**
     * 扩展字段5
     */
    @Comment("扩展字段5")
    @Column()
    private String ext5;

    public void copy(BuProjectDO source) {
        BeanUtil.copyProperties(source, this, CopyOptions.create().setIgnoreNullValue(true));
    }
}
