package com.elitesland.tw.tw5.server.prd.pms.service;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.pms.service.PmsConContractService;
import com.elitesland.tw.tw5.api.prd.salecon.query.SaleConContractQuery;
import com.elitesland.tw.tw5.api.prd.salecon.vo.SaleConContractVO;
import com.elitesland.tw.tw5.api.prd.system.vo.PrdSystemSelectionVO;
import com.elitesland.tw.tw5.server.prd.common.CacheUtil;
import com.elitesland.tw.tw5.server.prd.common.GlobalUtil;
import com.elitesland.tw.tw5.server.prd.common.functionEnum.RoleEnum;
import com.elitesland.tw.tw5.server.prd.pms.dao.PmsConContractDAO;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

@Service
@RequiredArgsConstructor
@Slf4j
public class PmsConContractServiceImpl implements PmsConContractService {

    //    private final PmsConContractRepo repo;
    private final PmsConContractDAO pmsConContractDAO;
    private final CacheUtil cacheUtil;
    @Override
    public PagingVO<SaleConContractVO> findCountByCustProp(SaleConContractQuery query) {
        List<String> custPropList = new ArrayList<>();
        PrdSystemSelectionVO systemSelection = cacheUtil.getSystemSelection("crm:company_nature");
        List<PrdSystemSelectionVO> children = systemSelection.getChildren();
        if(cacheUtil.hasSystemRolePermission(Arrays.asList(RoleEnum.A_CUST_NATURE.getCode()))){
            children.forEach(item->{
                if(item.getExtString1().equals(RoleEnum.A_CUST_NATURE.getCode())){
                    custPropList.add(item.getSelectionValue());
                }
            });
        }
        if(cacheUtil.hasSystemRolePermission(Arrays.asList(RoleEnum.B_CUST_NATURE.getCode()))){
            children.forEach(item->{
                if(item.getExtString1().equals(RoleEnum.B_CUST_NATURE.getCode())){
                    custPropList.add(item.getSelectionValue());
                }
            });
        }
        query.setCustPropList(custPropList);
        return pmsConContractDAO.queryPaging(query);
    }

    @Override
    public long findCountByCustProp(List<String> custPropList) {
        SaleConContractQuery query = new SaleConContractQuery();
        query.setCustPropList(custPropList);
        return pmsConContractDAO.count(query);
    }

}
