package com.elitesland.tw.tw5.server.prd.purchase.controller;

import com.elitesland.tw.tw5.api.prd.purchase.payload.PurchaseAgreementAssociationPayload;
import com.elitesland.tw.tw5.api.prd.purchase.query.PurchaseAgreementAssociationQuery;
import com.elitesland.tw.tw5.api.prd.purchase.vo.PurchaseAgreementAssociationVO;
import com.elitesland.tw.tw5.api.prd.purchase.service.PurchaseAgreementAssociationService;
import com.elitesland.tw.tw5.server.common.TwOutputUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;

import com.elitesland.tw.tw5.server.udc.UdcNameClass;
import com.elitescloud.cloudt.common.base.PagingVO;

import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import java.io.IOException;
import javax.servlet.http.HttpServletResponse;
import org.springframework.web.bind.annotation.*;

import java.util.Arrays;
import java.util.List;

/**
 * 采购协议关联协议
 *
 * @author Echo
 * @date 2023-06-08
 */
@Api(tags = "采购协议关联协议")
@RestController
@RequiredArgsConstructor
@RequestMapping("/api/purchaseAgreementAssociation")
@Slf4j
public class PurchaseAgreementAssociationController {

private final PurchaseAgreementAssociationService purchaseAgreementAssociationService;

    /**
     * 采购协议关联协议-新增
     *
     * @param payload 有效载荷
     * @return {@link TwOutputUtil}
     */
    @PostMapping
    @ApiOperation("采购协议关联协议-新增")
    public TwOutputUtil<PurchaseAgreementAssociationVO> insert(@RequestBody PurchaseAgreementAssociationPayload payload){
         return TwOutputUtil.ok(purchaseAgreementAssociationService.insert(payload));
    }

    /**
     * 采购协议关联协议-更新
     *
     * @param payload 有效载荷
     * @return {@link TwOutputUtil}
     */
    @PutMapping
    @ApiOperation("采购协议关联协议-更新")
    public TwOutputUtil<PurchaseAgreementAssociationVO> update(@RequestBody PurchaseAgreementAssociationPayload payload){
        return TwOutputUtil.ok(purchaseAgreementAssociationService.update(payload));
    }

    /**
     * 采购协议关联协议-更新,支持置空,置空的字段需需要借助 protected List<String> nullFields;
     *
     * @param payload 有效载荷
     * @return {@link TwOutputUtil}
     */
    @PutMapping("update")
    @ApiOperation("采购协议关联协议-更新,支持置空 置空的字段需需要借助 protected List<String> nullFields;")
    public TwOutputUtil<Long> updateByKeyDynamic(@RequestBody PurchaseAgreementAssociationPayload payload){
        return TwOutputUtil.ok(purchaseAgreementAssociationService.updateByKeyDynamic(payload));
    }

    /**
     * 采购协议关联协议-主键查询
     *
     * @param key 关键
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/{key}")
    // @UdcNameClass
    @ApiOperation("采购协议关联协议-主键查询")
    public TwOutputUtil<PurchaseAgreementAssociationVO> queryOneByKey(@PathVariable Long key) {
        return TwOutputUtil.ok(purchaseAgreementAssociationService.queryByKey(key));
    }

    /**
     * 采购协议关联协议-分页
     *
     * @param query 查询
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/paging")
    // @UdcNameClass
    @ApiOperation("采购协议关联协议-分页")
    public TwOutputUtil<PagingVO<PurchaseAgreementAssociationVO>> paging(PurchaseAgreementAssociationQuery query) {
        return TwOutputUtil.ok(purchaseAgreementAssociationService.queryPaging(query));
    }

    /**
     * 采购协议关联协议-查询列表
     *
     * @param query 查询
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/list")
    // @UdcNameClass
    @ApiOperation("采购协议关联协议-查询列表")
    public TwOutputUtil<List<PurchaseAgreementAssociationVO>> queryList(PurchaseAgreementAssociationQuery query) {
        return TwOutputUtil.ok(purchaseAgreementAssociationService.queryListDynamic(query));
    }

    /**
     * 采购协议关联协议-删除
     *
     * @param keys 主键id
     * @return result
     */
    @DeleteMapping("/deleteSoft")
    @ApiOperation("采购协议关联协议-删除")
    public TwOutputUtil deleteSoft(Long[] keys) {
         purchaseAgreementAssociationService.deleteSoft(Arrays.asList(keys));
        return TwOutputUtil.ok();
    }

}

