package com.elitesland.tw.tw5.server.prd.purchase.service;

import com.elitescloud.boot.core.base.BaseServiceImpl;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.purchase.payload.PurchaseAgreementAssociationPayload;
import com.elitesland.tw.tw5.api.prd.purchase.query.PurchaseAgreementAssociationQuery;
import com.elitesland.tw.tw5.api.prd.purchase.query.PurchaseAgreementQuery;
import com.elitesland.tw.tw5.api.prd.purchase.service.PurchaseAgreementAssociationService;
import com.elitesland.tw.tw5.api.prd.purchase.service.PurchaseAgreementService;
import com.elitesland.tw.tw5.api.prd.purchase.vo.PurchaseAgreementAssociationVO;
import com.elitesland.tw.tw5.api.prd.purchase.vo.PurchaseAgreementVO;
import com.elitesland.tw.tw5.server.prd.purchase.convert.PurchaseAgreementAssociationConvert;
import com.elitesland.tw.tw5.server.prd.purchase.dao.PurchaseAgreementAssociationDAO;
import com.elitesland.tw.tw5.server.prd.purchase.entity.PurchaseAgreementAssociationDO;
import com.elitesland.tw.tw5.server.prd.purchase.repo.PurchaseAgreementAssociationRepo;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;

import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * 采购协议关联协议
 *
 * @author Echo
 * @date 2023-06-08
 */
@Service
@RequiredArgsConstructor
@Slf4j
public class PurchaseAgreementAssociationServiceImpl extends BaseServiceImpl implements PurchaseAgreementAssociationService {

    private final PurchaseAgreementAssociationRepo purchaseAgreementAssociationRepo;
    private final PurchaseAgreementAssociationDAO purchaseAgreementAssociationDAO;
    @Autowired
    private PurchaseAgreementService purchaseAgreementService;

    @Override
    public PagingVO<PurchaseAgreementAssociationVO> queryPaging(PurchaseAgreementAssociationQuery query) {
        return purchaseAgreementAssociationDAO.queryPaging(query);
    }

    @Override
    public List<PurchaseAgreementAssociationVO> queryListDynamic(PurchaseAgreementAssociationQuery query) {
        List<PurchaseAgreementAssociationVO> purchaseAgreementAssociationVOS = purchaseAgreementAssociationDAO.queryListDynamic(query);
        List<Long> associationAgreementIds = purchaseAgreementAssociationVOS.stream().map(PurchaseAgreementAssociationVO::getAssociationAgreementId).collect(Collectors.toList());
        PurchaseAgreementQuery purchaseAgreementQuery = new PurchaseAgreementQuery();
        purchaseAgreementQuery.setIds(associationAgreementIds);
        List<PurchaseAgreementVO> purchaseAgreementVOS = purchaseAgreementService.queryListDynamic(purchaseAgreementQuery);
        Map<Long, PurchaseAgreementVO> purchaseAgreementVOMap = purchaseAgreementVOS.stream().collect(Collectors.toMap(PurchaseAgreementVO::getId, Function.identity()));
        for (PurchaseAgreementAssociationVO purchaseAgreementAssociation : purchaseAgreementAssociationVOS) {
            Long associationAgreementId = purchaseAgreementAssociation.getAssociationAgreementId();
            PurchaseAgreementVO purchaseAgreementVO = purchaseAgreementVOMap.get(associationAgreementId);
            if (ObjectUtils.isEmpty(purchaseAgreementVO)) {
                continue;
            }
            purchaseAgreementAssociation.setAgreementName(purchaseAgreementVO.getPurchaseAgreementName());
            purchaseAgreementAssociation.setAgreementCode(purchaseAgreementVO.getPurchaseAgreementNo());
            purchaseAgreementAssociation.setAssociationContentDescription(purchaseAgreementVO.getAgreementContentDescription());
            purchaseAgreementAssociation.setSupplierBookId(purchaseAgreementVO.getSupplierBookId());
            purchaseAgreementAssociation.setSupplierName(purchaseAgreementVO.getSupplierName());
        }
        return purchaseAgreementAssociationVOS;
    }

    @Override
    public PurchaseAgreementAssociationVO queryByKey(Long key) {
        PurchaseAgreementAssociationDO entity = purchaseAgreementAssociationRepo.findById(key).orElseGet(PurchaseAgreementAssociationDO::new);
        Assert.notNull(entity.getId(), "不存在");
        PurchaseAgreementAssociationVO vo = PurchaseAgreementAssociationConvert.INSTANCE.toVo(entity);
        return vo;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public PurchaseAgreementAssociationVO insert(PurchaseAgreementAssociationPayload payload) {
        PurchaseAgreementAssociationDO entityDo = PurchaseAgreementAssociationConvert.INSTANCE.toDo(payload);
        return PurchaseAgreementAssociationConvert.INSTANCE.toVo(purchaseAgreementAssociationRepo.save(entityDo));
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public PurchaseAgreementAssociationVO update(PurchaseAgreementAssociationPayload payload) {
        PurchaseAgreementAssociationDO entity = purchaseAgreementAssociationRepo.findById(payload.getId()).orElseGet(PurchaseAgreementAssociationDO::new);
        Assert.notNull(entity.getId(), "不存在");
        PurchaseAgreementAssociationDO entityDo = PurchaseAgreementAssociationConvert.INSTANCE.toDo(payload);
        entity.copy(entityDo);
        return PurchaseAgreementAssociationConvert.INSTANCE.toVo(purchaseAgreementAssociationRepo.save(entity));
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public long updateByKeyDynamic(PurchaseAgreementAssociationPayload payload) {
        PurchaseAgreementAssociationDO entity = purchaseAgreementAssociationRepo.findById(payload.getId()).orElseGet(PurchaseAgreementAssociationDO::new);
        Assert.notNull(entity.getId(), "不存在");
        long result = purchaseAgreementAssociationDAO.updateByKeyDynamic(payload);
        return result;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void deleteSoft(List<Long> keys) {
        if (!keys.isEmpty()) {
            purchaseAgreementAssociationDAO.deleteSoft(keys);
        }
    }

    @Override
    public void deleteSoftByDocumentIdList(List<Long> documentIdList) {
        purchaseAgreementAssociationDAO.deleteSoftByDocumentIdList(documentIdList);
    }

}
