package com.elitesland.tw.tw5.server.prd.salecon.entity;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.bean.copier.CopyOptions;
import com.elitescloud.cloudt.common.annotation.Comment;
import com.elitescloud.boot.model.entity.BaseModel;
import lombok.Getter;
import lombok.Setter;
import org.hibernate.annotations.Where;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import java.io.Serializable;
import java.math.BigDecimal;

/**
 * 合同收款明细
 *
 * @author lemon
 * @date 2023-09-05
 */
@Entity
@Table(name = "con_receivable_d", indexes = {
})
@org.hibernate.annotations.Table(appliesTo = "con_receivable_d", comment = "合同收款明细")
@Getter
@Setter
@Where(clause = "delete_flag= 0")
public class ConReceivableDDO extends BaseModel implements Serializable  {
    /** 收款主表ID */
    @Comment("收款主表ID")
    @Column()
    private Long recvId;
    /** 收款计划ID */
    @Comment("收款计划ID")
    @Column()
    private Long recvplanId;
    /** 收款金额 */
    @Comment("收款金额")
    @Column()
    private BigDecimal recvAmt;

    /** 4.0id */
    @Comment("4.0id")
    @Column()
    private Long conReceivableDIdV4;

    public void copy(ConReceivableDDO source){
        BeanUtil.copyProperties(source,this, CopyOptions.create().setIgnoreNullValue(true));
    }
}
