package com.elitesland.tw.tw5.server.prd.salecon.entity;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.bean.copier.CopyOptions;
import com.elitescloud.boot.model.entity.BaseModel;
import com.elitescloud.cloudt.common.annotation.Comment;
import com.elitesland.workflow.enums.ProcInstStatus;
import lombok.Getter;
import lombok.Setter;
import org.hibernate.annotations.Where;

import javax.persistence.*;
import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;

/**
 * @author sunxw
 * @description 销售合同执行情况
 * @Date 2023/11/24
 */
@Entity
@Table(name = "sale_con_exec_condition", indexes = {
        @Index(name = "idx_contract_id", columnList = "contract_id")
})
@org.hibernate.annotations.Table(appliesTo = "sale_con_exec_condition", comment = "销售合同执行情况")
@Getter
@Setter
@Where(clause = "delete_flag= 0")
public class SaleConExecConditionDO extends BaseModel implements Serializable {

    @Comment("合同ID")
    @Column(name = "contract_id")
    private Long contractId;

    @Comment("签单金额")
    @Column()
    private BigDecimal signAmt;

    @Comment("税率")
    @Column()
    private BigDecimal taxRate;

    @Comment("销售费用")
    @Column()
    private BigDecimal saleExpense;

    @Comment("项目费用")
    @Column()
    private BigDecimal projExpense;

    @Comment("合同采购金额")
    @Column()
    private BigDecimal purchaseAmt;

    @Comment("过单毛利")
    @Column()
    private BigDecimal overOrderGross;

    @Comment("部门毛利")
    @Column()
    private BigDecimal buGross;

    @Comment("有效合同金额")
    @Column()
    private BigDecimal effectConAmt;

    @Comment("核算有效金额")
    @Column()
    private BigDecimal calcEffectAmt;

    @Comment("合同价格评级")
    @Column()
    private String conPriceLevel;

    @Comment("项目计算当量")
    @Column()
    private BigDecimal calcProjEquiv;

    @Comment("项目计算核定当量")
    @Column()
    private BigDecimal calcCheckProjEquiv;

    @Comment("最经济交付当量")
    @Column()
    private BigDecimal economicEquiv;

    @Comment("项目执行当量")
    @Column()
    private BigDecimal projExecEquiv;

    @Comment("统计日期")
    @Column()
    private LocalDate statisticDate;
    /**
     * 流程实例ID
     */
    @Comment("流程实例ID")
    @Column()
    private String procInstId;
    /**
     * 流程审批状态
     */
    @Comment("流程审批状态")
    @Column()
    @Enumerated(EnumType.STRING)
    private ProcInstStatus procInstStatus;
    /**
     * 提交时间
     */
    @Comment("提交时间")
    @Column()
    private LocalDateTime submitTime;
    /**
     * 审批时间
     */
    @Comment("审批时间")
    @Column()
    private LocalDateTime approvedTime;

    /**
     * 合同预算工作待办
     */
    @Comment("合同预算工作待办")
    @Column()
    private Boolean workAgentFlag;


    public void copy(SaleConExecConditionDO source) {
        BeanUtil.copyProperties(source, this, CopyOptions.create().setIgnoreNullValue(true));
    }

}
