package com.elitesland.tw.tw5.server.prd.salecon.service;


import com.elitesland.tw.tw5.api.prd.salecon.payload.ConInvSettingMonthPayload;
import com.elitesland.tw.tw5.api.prd.salecon.query.ConInvBatchQuery;
import com.elitesland.tw.tw5.api.prd.salecon.query.ConInvSettingMonthQuery;
import com.elitesland.tw.tw5.api.prd.salecon.query.ConReceivablePlanQuery;
import com.elitesland.tw.tw5.api.prd.salecon.service.ConInvBatchService;
import com.elitesland.tw.tw5.api.prd.salecon.service.ConInvSettingMonthService;
import com.elitesland.tw.tw5.api.prd.salecon.service.ConReceivablePlanService;
import com.elitesland.tw.tw5.api.prd.salecon.vo.ConInvBatchVO;
import com.elitesland.tw.tw5.api.prd.salecon.vo.ConInvSettingMonthVO;
import com.elitesland.tw.tw5.api.prd.salecon.vo.ConInvSettingVO;
import com.elitesland.tw.tw5.api.prd.salecon.vo.ConReceivablePlanVO;
import com.elitesland.tw.tw5.server.prd.salecon.controller.ConInvBatchController;
import com.elitesland.tw.tw5.server.prd.salecon.convert.ConInvSettingMonthConvert;
import com.elitesland.tw.tw5.server.prd.salecon.dao.ConInvBatchDAO;
import com.elitesland.tw.tw5.server.prd.salecon.dao.ConInvSettingMonthDAO;
import com.elitesland.tw.tw5.server.prd.salecon.entity.ConInvSettingMonthDO;
import com.elitesland.tw.tw5.server.prd.salecon.repo.ConInvSettingMonthRepo;
import org.springframework.stereotype.Service;
import com.elitescloud.boot.core.base.BaseServiceImpl;
import org.springframework.transaction.annotation.Transactional;
import com.elitescloud.cloudt.common.base.PagingVO;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;

import javax.servlet.http.HttpServletResponse;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.YearMonth;
import java.util.*;
import java.util.stream.Collectors;

/**
 * ConInvSettingMonthController
 *
 * @author zoey
 * @date 2024-03-14
 */
@Service
@RequiredArgsConstructor
@Slf4j
public class ConInvSettingMonthServiceImpl extends BaseServiceImpl implements ConInvSettingMonthService {

    private final ConInvSettingMonthRepo conInvSettingMonthRepo;
    private final ConInvSettingMonthDAO conInvSettingMonthDAO;
    private final ConInvBatchService invBatchService;
    private final ConReceivablePlanService conReceivablePlanService;

    @Override
    public PagingVO<ConInvSettingMonthVO> queryPaging(ConInvSettingMonthQuery query){
        return conInvSettingMonthDAO.queryPaging(query);
    }

    @Override
    public List<ConInvSettingMonthVO> queryListDynamic(ConInvSettingMonthQuery query){
        return conInvSettingMonthDAO.queryListDynamic(query);
    }

    @Override
    public ConInvSettingMonthVO queryByKey(Long key) {
        ConInvSettingMonthDO entity = conInvSettingMonthRepo.findById(key).orElseGet(ConInvSettingMonthDO::new);
        Assert.notNull(entity.getId(), "不存在");
        ConInvSettingMonthVO vo = ConInvSettingMonthConvert.INSTANCE.toVo(entity);
        return vo;
    }

    @Override
    public List<ConInvSettingMonthVO> queryByInvSetting(ConInvSettingVO invSettingVO){
        List<ConInvSettingMonthVO> vo = new ArrayList<>();
        List<ConInvSettingMonthDO> entityList = conInvSettingMonthRepo.findByInvSettingId(invSettingVO.getId());
        if(!CollectionUtils.isEmpty(entityList)){
            vo = ConInvSettingMonthConvert.INSTANCE.toVoList(entityList);
        }
        Long invOuId = invSettingVO.getInvOuId();
        Integer invYear = invSettingVO.getInvYear();
        // 获取该年的第一天日期
        LocalDate firstDay = LocalDate.of(invYear, 1, 1);
        // 获取该年的最后一天日期
        LocalDate lastDay = LocalDate.of(invYear, 12, 31);

        // 获取某个公司整年的开票数据
        ConReceivablePlanQuery conReceivablePlanQuery = new ConReceivablePlanQuery();
        conReceivablePlanQuery.setInvDate(Arrays.asList(firstDay,lastDay));
        conReceivablePlanQuery.setInvOuId(invOuId);
        conReceivablePlanQuery.setReceStatusList(Arrays.asList("2","3","4"));
        List<ConReceivablePlanVO> conReceivablePlanVOS = conReceivablePlanService.queryListDynamic(conReceivablePlanQuery);

        // 获取某个公司整年的开票中数据
        ConInvBatchQuery invBatchQuery = new ConInvBatchQuery();
        invBatchQuery.setInvOuId(invOuId);
        //开票日期
        invBatchQuery.setBatchDate(Arrays.asList(firstDay,lastDay));
        invBatchQuery.setBatchStatusList(Arrays.asList("1","2","3","5"));
        List<ConInvBatchVO> conInvBatchVOS = invBatchService.queryListDynamic(invBatchQuery);


        for (ConInvSettingMonthVO conInvSettingMonthVO : vo) {
            Integer invMonth = conInvSettingMonthVO.getInvMonth();
            // 获取该月的第一天日期
            LocalDate monthFirstDay = YearMonth.of(invYear, invMonth).atDay(1);
            // 获取该月的最后一天日期
            LocalDate monthLastDay = YearMonth.of(invYear, invMonth).atEndOfMonth();
            // 筛选当 当月所有的收款计划
            List<ConReceivablePlanVO> filteredReceivablePlans = conReceivablePlanVOS.stream()
                    .filter(plan -> (plan.getInvDate()!=null && !plan.getInvDate().isBefore(monthFirstDay) && !plan.getInvDate().isAfter(monthLastDay)))
                    .collect(Collectors.toList());

            // 计算已开票金额的总和
            BigDecimal invoicedAmt = filteredReceivablePlans.stream()
                    .map(ConReceivablePlanVO::getAlreadyInvAmt)
                    .filter(Objects::nonNull)  // 过滤掉空值
                    .reduce(BigDecimal.ZERO, BigDecimal::add);


            // 筛选出 当月所有开票中的开票
            List<ConInvBatchVO> filteredBatchVOS = conInvBatchVOS.stream()
                    .filter(batch -> (batch.getBatchDate()!=null && !batch.getBatchDate().isBefore(monthFirstDay) && !batch.getBatchDate().isAfter(monthLastDay)))
                    .collect(Collectors.toList());

            // 计算开票占用金额的总和
            BigDecimal occupyAmt = filteredBatchVOS.stream()
                    .map(ConInvBatchVO::getInvAmt)
                    .filter(Objects::nonNull)  // 过滤掉空值
                    .reduce(BigDecimal.ZERO, BigDecimal::add);

            BigDecimal effectiveAmt = conInvSettingMonthVO.getInvLimit().subtract(invoicedAmt).subtract(occupyAmt);

            // 已开票金额
            conInvSettingMonthVO.setInvoicedAmt(invoicedAmt);
            // 已占用金额
            conInvSettingMonthVO.setOccupyAmt(occupyAmt);
            // 可用金额
            conInvSettingMonthVO.setEffectiveAmt(effectiveAmt);
        }


        // 计算剩余金额

        return vo;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public ConInvSettingMonthVO insert(ConInvSettingMonthPayload payload) {
        Assert.notNull(payload.getInvSettingId(),"配置主数据不存在，请先保存配置主数据！");
        ConInvSettingMonthDO entityDo = ConInvSettingMonthConvert.INSTANCE.toDo(payload);
        return ConInvSettingMonthConvert.INSTANCE.toVo(conInvSettingMonthRepo.save(entityDo));
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public ConInvSettingMonthVO update(ConInvSettingMonthPayload payload) {
        ConInvSettingMonthDO entity = conInvSettingMonthRepo.findById(payload.getId()).orElseGet(ConInvSettingMonthDO::new);
        Assert.notNull(entity.getId(), "不存在");
        ConInvSettingMonthDO entityDo = ConInvSettingMonthConvert.INSTANCE.toDo(payload);
        entity.copy(entityDo);
        return ConInvSettingMonthConvert.INSTANCE.toVo(conInvSettingMonthRepo.save(entity));
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public long updateByKeyDynamic(ConInvSettingMonthPayload payload) {
        ConInvSettingMonthDO entity = conInvSettingMonthRepo.findById(payload.getId()).orElseGet(ConInvSettingMonthDO::new);
        Assert.notNull(entity.getId(), "不存在");
        long result = conInvSettingMonthDAO.updateByKeyDynamic(payload);
        return result;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void deleteSoft(List<Long> keys) {
        if (!keys.isEmpty()) {
            conInvSettingMonthDAO.deleteSoft(keys);
        }
    }

}
