package com.elitesland.tw.tw5.server.prd.salecon.service;

import com.elitescloud.boot.core.base.BaseServiceImpl;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.salecon.payload.ConReceivablePlanConfirmPayload;
import com.elitesland.tw.tw5.api.prd.salecon.payload.ConRecvplanChangeLogPayload;
import com.elitesland.tw.tw5.api.prd.salecon.query.ConReceivablePlanConfirmQuery;
import com.elitesland.tw.tw5.api.prd.salecon.query.ConReceivablePlanQuery;
import com.elitesland.tw.tw5.api.prd.salecon.query.ConRecvplanChangeLogQuery;
import com.elitesland.tw.tw5.api.prd.salecon.service.ConReceivablePlanConfirmService;
import com.elitesland.tw.tw5.api.prd.salecon.service.ConReceivablePlanService;
import com.elitesland.tw.tw5.api.prd.salecon.vo.ConReceivablePlanConfirmVO;
import com.elitesland.tw.tw5.api.prd.salecon.vo.ConReceivablePlanVO;
import com.elitesland.tw.tw5.api.prd.salecon.vo.ConRecvplanChangeLogVO;
import com.elitesland.tw.tw5.api.prd.system.service.PrdMessageConfigService;
import com.elitesland.tw.tw5.api.prd.system.service.PrdSystemRoleService;
import com.elitesland.tw.tw5.api.prd.system.service.PrdSystemSettingService;
import com.elitesland.tw.tw5.api.prd.system.vo.PrdMessageConfigVO;
import com.elitesland.tw.tw5.api.prd.system.vo.PrdSystemSettingVO;
import com.elitesland.tw.tw5.server.common.TwException;
import com.elitesland.tw.tw5.server.common.service.TransactionUtilService;
import com.elitesland.tw.tw5.server.common.workFlow.ProcDefKey;
import com.elitesland.tw.tw5.server.prd.common.CacheUtil;
import com.elitesland.tw.tw5.server.prd.common.WorkflowUtil;
import com.elitesland.tw.tw5.server.prd.common.functionEnum.RoleEnum;
import com.elitesland.tw.tw5.server.prd.org.dao.PrdOrgEmployeeDAO;
import com.elitesland.tw.tw5.server.prd.org.dao.PrdOrgOrganizationDAO;
import com.elitesland.tw.tw5.server.prd.org.entity.PrdOrgEmployeeDO;
import com.elitesland.tw.tw5.server.prd.salecon.convert.ConReceivablePlanConfirmConvert;
import com.elitesland.tw.tw5.server.prd.salecon.dao.ConReceivablePlanConfirmDAO;
import com.elitesland.tw.tw5.server.prd.salecon.dao.ConReceivablePlanDAO;
import com.elitesland.tw.tw5.server.prd.salecon.dao.ConRecvplanChangeLogDAO;
import com.elitesland.tw.tw5.server.prd.salecon.entity.ConReceivablePlanConfirmDO;
import com.elitesland.tw.tw5.server.prd.salecon.repo.ConReceivablePlanConfirmRepo;
import com.elitesland.tw.tw5.server.prd.salecon.saleConEnum.SaleConEnum;
import com.elitesland.tw.tw5.server.prd.system.constant.SystemSettingsItemEnum;
import com.elitesland.tw.tw5.server.prd.system.dao.PrdSystemRoleDAO;
import com.elitesland.workflow.ProcessInfo;
import com.elitesland.workflow.payload.SetVariablesPayload;
import com.elitesland.workflow.payload.StartProcessPayload;
import com.xxl.job.core.log.XxlJobLogger;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.*;
import java.util.stream.Collectors;

/**
 * 收款计划确认单
 *
 * @author lemon
 * @date 2023-12-23
 */
@Service
@RequiredArgsConstructor
@Slf4j
public class ConReceivablePlanConfirmServiceImpl extends BaseServiceImpl implements ConReceivablePlanConfirmService {

    private final ConReceivablePlanConfirmRepo conReceivablePlanConfirmRepo;
    private final ConReceivablePlanConfirmDAO conReceivablePlanConfirmDAO;
    private final ConReceivablePlanDAO conReceivablePlanDAO;

    private final PrdOrgEmployeeDAO employeeDAO;
    private final ConRecvplanChangeLogDAO conRecvplanChangeLogDAO;

    @Value("${tw5.workflow.enabled}")
    private Boolean workflow_enabled;

    private final PrdOrgOrganizationDAO daoOrg;

    private final TransactionUtilService transactionUtilService;

    private final WorkflowUtil workflowUtil;

    private final CacheUtil cacheUtil;

    private final PrdSystemSettingService prdSystemSettingService;

    private final PrdSystemRoleDAO systemRoleDAO;

    private final PrdMessageConfigService messageConfigService;

    private final PrdSystemRoleService roleService;
    private final ConReceivablePlanService conReceivablePlanService;
    @Override
    public PagingVO<ConReceivablePlanConfirmVO> queryPaging(ConReceivablePlanConfirmQuery query) {
        return conReceivablePlanConfirmDAO.queryPaging(query);
    }

    @Override
    public List<ConReceivablePlanConfirmVO> queryListDynamic(ConReceivablePlanConfirmQuery query) {
        return conReceivablePlanConfirmDAO.queryListDynamic(query);
    }

    @Override
    public ConReceivablePlanConfirmVO queryByKey(Long key) {
        ConReceivablePlanConfirmDO entity = conReceivablePlanConfirmRepo.findById(key).orElseGet(ConReceivablePlanConfirmDO::new);
        Assert.notNull(entity.getId(), "不存在");
        ConReceivablePlanConfirmVO vo = ConReceivablePlanConfirmConvert.INSTANCE.toVo(entity);
        return vo;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public ConReceivablePlanConfirmVO insert(ConReceivablePlanConfirmPayload payload) {
        ConReceivablePlanConfirmDO entityDo = ConReceivablePlanConfirmConvert.INSTANCE.toDo(payload);
        return ConReceivablePlanConfirmConvert.INSTANCE.toVo(conReceivablePlanConfirmRepo.save(entityDo));
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public ConReceivablePlanConfirmVO update(ConReceivablePlanConfirmPayload payload) {
        ConReceivablePlanConfirmDO entity = conReceivablePlanConfirmRepo.findById(payload.getId()).orElseGet(ConReceivablePlanConfirmDO::new);
        Assert.notNull(entity.getId(), "不存在");
        ConReceivablePlanConfirmDO entityDo = ConReceivablePlanConfirmConvert.INSTANCE.toDo(payload);
        ConReceivablePlanConfirmDO save = conReceivablePlanConfirmDAO.save(entityDo);
        // todo流程修改
        if (StringUtils.hasText(payload.getProcInstId())) {
            SetVariablesPayload setVariablesPayload = new SetVariablesPayload();
            setVariablesPayload.setProcInstId(payload.getProcInstId());
            HashMap<String, Object> variables = new HashMap<>();
            ConReceivablePlanVO planVO = conReceivablePlanDAO.queryByKey(save.getRecePlanId());
            // 是否需要财务确认
            getProcessApproval(save, planVO, variables);

            setVariablesPayload.setVariables(variables);
            workflowUtil.setVaribales(setVariablesPayload);
        }
        return ConReceivablePlanConfirmConvert.INSTANCE.toVo(save);
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public long updateByKeyDynamic(ConReceivablePlanConfirmPayload payload) {
        ConReceivablePlanConfirmDO entity = conReceivablePlanConfirmRepo.findById(payload.getId()).orElseGet(ConReceivablePlanConfirmDO::new);
        Assert.notNull(entity.getId(), "不存在");
        long result = conReceivablePlanConfirmDAO.updateByKeyDynamic(payload);
        return result;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void deleteSoft(List<Long> keys) {
        if (!keys.isEmpty()) {
            conReceivablePlanConfirmDAO.deleteSoft(keys);
        }
    }

    @Override
    @Transactional(propagation = Propagation.NOT_SUPPORTED)
    public int autoCreateFlow(Long signBuId) {
        // 系统自动提醒临近收款计划的提前天数，即此天数阈值内的收款计划，都将做为需要提醒收款的对象。
        int sysWarmRecvDtLt = getSysWarmRecvDtLt();
        // 收款计划变更历史升级审批次数
        int maxSizeChangeLog = getMaxSizeChangeLog();
        // 收款计划预计收款日期调整最大天数(未开票)
        int maxRecvDtDelaydays = getMaxRecvDtDelaydays();
        // 收款计划预计收款日期调整最大天数(已开票)
        int maxRecvDtDelaydays2 = getMaxRecvDtDelaydays2();

        ConReceivablePlanQuery query = new ConReceivablePlanQuery();
        final LocalDate now = LocalDate.now();
        // 根据配置查询天数
        final LocalDate endDate = now.plusDays(sysWarmRecvDtLt);
        query.setExpectRecvDateEnd(endDate);
        query.setSignBuId(signBuId);
        // 查询未来2周内的收款计划数据
        List<ConReceivablePlanVO> conReceivablePlanVOS = conReceivablePlanDAO.queryListDynamic(query);
        if (!CollectionUtils.isEmpty(conReceivablePlanVOS)) {
            List<ConReceivablePlanConfirmDO> rcvpConfirmEntityList = new ArrayList<>();
            conReceivablePlanVOS.forEach(recvPlan -> {

                // modify by 2022年07月27日16:23:07   需求人：董海峰、何申霞
                /**
                 *      * 调整 2022 07 27  干系人：董海峰 何申夏
                 *      * 收款计划流程的自动触发调整，需要临时调整下。
                 *      *
                 *      *        1，调整为：仅需要对已开票未收款的收款计划触发流程。
                 *      *
                 *      *               暂时不对未开票的收款计划触发流程，触发逻辑的代码保留，仅目前不做触发。
                 *      *
                 *      *        2，合同里标注了“项目异常”字样的，都不做触发。
                 */
                XxlJobLogger.log("处理收款计划： " + recvPlan.getReceNo());
                final String contractRemark = recvPlan.getContractRemark();
                if (StringUtils.hasText(contractRemark) && contractRemark.trim().equals("项目异常")) {
                    XxlJobLogger.log("子合同备注【项目异常】；跳过收款计划： " + recvPlan.getReceNo() + "; 子合同编号：" + recvPlan.getSaleConCode());
                    return;
                }
                //未开票的
                if ("1".equals(recvPlan.getReceStatus())) {
                    XxlJobLogger.log("暂时不对未开票的收款计划触发流程，触发逻辑的代码保留，仅目前不做触发；跳过收款计划： " + recvPlan.getReceNo() + "; 子合同编号：" + recvPlan.getSaleConCode());
                    return;
                }

                // 预计收款日期
                final LocalDate expectRecvDate = recvPlan.getExpectReceDate();
                final Long recvPlanId = recvPlan.getId();
                /**
                 * 1，此收款计划，预计收款日期临近，请确认收款日期准确性 （未开票,预计收款日期>now）
                 * 2，此收款计划，预计收款日期已过，请调整收款日期准确性  （未开票，预计收款日期<=now）
                 * 3，此收款计划，已经开出发票，预计收款日期已过，尚未收到款项，请调整收款日期准确性！
                 * 4，此收款计划，已经开出发票，预计收款日期已过，只收到了部分款项，请调整收款日期准确性！
                 *
                 * 5，对收款计划历史次数的判断；如果调整历史已经有两次(系统配置参数)以上，则追加此提示。
                 * 追加 。。。并且已经合计调整预计收款日期两次，将提示销售BU负责人，交付负责人做重点关注。
                 */
                ConReceivablePlanConfirmDO conReceivablePlanConfirmDO = new ConReceivablePlanConfirmDO();
                // todo 编号规则
//                conReceivablePlanConfirmDO.setConfirmNo(genManager.nextSeq(RCVP_CONFIRM_CODE.name(), null));
                conReceivablePlanConfirmDO.setContractId(recvPlan.getSaleConId() != null ? recvPlan.getSaleConId() : null);
                conReceivablePlanConfirmDO.setRecePlanId(recvPlanId != null ? recvPlanId : null);
                conReceivablePlanConfirmDO.setReceNo(recvPlan.getReceNo());
                conReceivablePlanConfirmDO.setExpectReceDate(expectRecvDate);

                if (recvPlan.getSaleManUserId() == null) {
                    // 销售负责人为空的话 找副签单负责人
                    if (null != recvPlan.getCoSignUserId()) {
                        recvPlan.setSaleManUserId(recvPlan.getCoSignUserId());
                    } else {
                        log.error("未开票收款确认统计异常,合同未设置销售人员or副签单负责人! 合同主键：{};合同编号：{}", recvPlan.getSaleConId(), recvPlan.getSaleConCode());
                        return;
                    }
                }
                // 如果签单资源Id或销售负责人 资源状态为【离职中、已离职】审批人为项目经理,如果项目经理不存在，审批人改成交付负责人
                PrdOrgEmployeeDO prdOrgEmployeeDO = employeeDAO.queryByUserId(recvPlan.getSaleManUserId());//获取资源状态
                if ("4".equals(prdOrgEmployeeDO.getResourceStatus()) || "6".equals(prdOrgEmployeeDO.getResourceStatus())) {
                    // 2022-04-19 销售负责人SALESMAN_RES_ID  离职中、已离职的话，找副签单负责人 CO_RES_ID
                    if (null != recvPlan.getCoSignUserId()) {
                        PrdOrgEmployeeDO resStatusCoUserId = employeeDAO.queryByUserId(recvPlan.getCoSignUserId());//获取资源状态
                        if ("4".equals(resStatusCoUserId.getResourceStatus()) || "6".equals(prdOrgEmployeeDO.getResourceStatus())) {
                            // 当副签单负责人状态为离职中或离职，则找替换的审批人：项目经理or交付负责人
                            Long approvalResId = getApprovalResId(recvPlan.getReceNo());
                            if (null != approvalResId) {
                                recvPlan.setSaleManUserId(approvalResId);
                            }
                        } else {
                            recvPlan.setSaleManUserId(recvPlan.getDeliUserId());
                        }
                    } else {
                        // 当销售状态为离职中或离职，则找替换的审批人：项目经理or交付负责人
                        Long approvalResId = getApprovalResId(recvPlan.getReceNo());
                        if (null != approvalResId) {
                            recvPlan.setSaleManUserId(approvalResId);
                        }
                    }
                }
                conReceivablePlanConfirmDO.setApplyUserId(recvPlan.getSaleManUserId());
                //未开票的
                if ("1".equals(recvPlan.getReceStatus())) {
                    // 1，此收款计划，预计收款日期临近，请确认收款日期准确性 （未开票,预计收款日期>now）
                    if (expectRecvDate.isAfter(now)) {
                        // 1，此收款计划，预计收款日期临近，请确认收款日期准确性 （未开票,预计收款日期>now）
                        conReceivablePlanConfirmDO.setTipsType(SaleConEnum.RcvpConfirmTipsType.NO_INVOICE_WARN.getCode());
                        conReceivablePlanConfirmDO.setTips(maxRecvDtDelaydays + "," + maxSizeChangeLog);
                    } else if (expectRecvDate.isBefore(now) || expectRecvDate.isEqual(now)) {
                        // 2，此收款计划，预计收款日期已过，请调整收款日期准确性  （未开票，预计收款日期<=now）
                        conReceivablePlanConfirmDO.setTipsType(SaleConEnum.RcvpConfirmTipsType.NO_INVOICE_OVERDUE.getCode());
                        conReceivablePlanConfirmDO.setTips(maxRecvDtDelaydays + "," + maxSizeChangeLog);
                    } else {
                        log.error("未开票收款确认统计异常：");
                        log.error("收款日期范围异常：运行时间：{},收款日期：{},收款号：{}", now, expectRecvDate, recvPlan.getReceNo());
                    }
                } else if ("4".equals(recvPlan.getReceStatus()) && (expectRecvDate.isBefore(now)) || expectRecvDate.isEqual(now)) {
                    // 3，此收款计划，已经开出发票，预计收款日期已过，尚未收到款项，请调整收款日期准确性！
                    conReceivablePlanConfirmDO.setTipsType(SaleConEnum.RcvpConfirmTipsType.OK_INVOICE_OVERDUE_NULL_PAYMENT.getCode());
                    conReceivablePlanConfirmDO.setTips(maxRecvDtDelaydays2 + "," + maxSizeChangeLog);
                } else if ("2".equals(recvPlan.getReceStatus()) && (expectRecvDate.isBefore(now) || expectRecvDate.isBefore(now))) {
                    // 4，此收款计划，已经开出发票，预计收款日期已过，只收到了部分款项，请调整收款日期准确性！
                    conReceivablePlanConfirmDO.setTipsType(SaleConEnum.RcvpConfirmTipsType.OK_INVOICE_OVERDUE_PART_PAYMENT.getCode());
                    conReceivablePlanConfirmDO.setTips(maxRecvDtDelaydays2 + "," + maxSizeChangeLog);
                } else {
                    log.error("收款确认统计异常：收款状态：{}", recvPlan.getReceStatus());
                    log.error("收款日期范围异常：运行时间：{},收款日期：{},收款号：{}", now, expectRecvDate, recvPlan.getReceNo());
                    XxlJobLogger.log("收款确认统计异常：收款号：{" + recvPlan.getReceNo() + "}；收款状态： " + recvPlan.getReceStatus() + "; 子合同编号：" + recvPlan.getSaleConCode());
                    XxlJobLogger.log("收款日期范围异常：运行时间：{" + now + "},收款日期：{" + expectRecvDate + "},收款号：{" + recvPlan.getReceNo() + "}");
                    return;
                }
                if (StringUtils.hasText(conReceivablePlanConfirmDO.getTipsType())) {
                    rcvpConfirmEntityList.add(conReceivablePlanConfirmDO);
                }
            });

            // 自动发起流程 如果需要发起流程 调用saveAndStartProcessWithWorkFlow方法
            rcvpConfirmEntityList.forEach(entity -> {
                saveAndStartProcess(entity);
            });
            return rcvpConfirmEntityList.size();

        }

        return 0;

    }

    /**
     * 当销售状态为离职中或离职，则找替换的审批人：项目经理or交付负责人
     *
     * @param recvNo recv没有
     * @return {@link Long}
     */
    private Long getApprovalResId(String recvNo) {
        ConReceivablePlanQuery query = new ConReceivablePlanQuery();
        query.setReceNo(recvNo);
        List<ConReceivablePlanVO> contractRecvplan = conReceivablePlanDAO.queryListDynamic(query);
        if (!CollectionUtils.isEmpty(contractRecvplan)) {
            ConReceivablePlanVO twContractRecvplanListView = contractRecvplan.get(0);
//            TwContractRecvplanListView view = edpCdsNameResolver.resolveCdcNames(twContractRecvplanListView);
            // 如果项目经理不存在，审批人改成交付负责人
            final Long pmResId = twContractRecvplanListView.getPmUserId();
            if (null != pmResId) {
                return pmResId;
            } else {
                // 交付负责人
                Long deliUserId = twContractRecvplanListView.getDeliUserId();
                return deliUserId;
            }
        }
        return null;
    }


    /**
     * 保存
     *
     * @param confirmDO 实体
     * @return int
     */
    @Transactional
    public int saveAndStartProcess(ConReceivablePlanConfirmDO confirmDO) {
        int result = 0;
        ConReceivablePlanConfirmVO vo = ConReceivablePlanConfirmConvert.INSTANCE.toVo(conReceivablePlanConfirmDAO.save(confirmDO));
        if (ObjectUtils.isEmpty(vo.getId())) {
            log.error("SysAltRcvpConfirmEntity保存失败");
        }
        finish(vo);
        return result;
    }

    private void finish(ConReceivablePlanConfirmVO view) {
        if ((view.getFinanceConfirm() != null && view.getFinanceConfirm() == 1) || (view.getReceDateConfirm() != null && view.getReceDateConfirm() ==1)) {
            log.debug("已付款需财务确认");
            log.debug("预计收款日期无误");
        }else{
            // 流程走完 记录变革记录 并 变更收款计划
            ConRecvplanChangeLogPayload logEntity = new ConRecvplanChangeLogPayload();
            logEntity.setRcvpConfirmId(view.getId());
            logEntity.setFlag1(view.getSendPaymentRequest()==1?true:false);
            logEntity.setRecvplanId(view.getRecePlanId());
            logEntity.setOldRecvOrInvDate(view.getExpectReceDate());
            logEntity.setRecvOrInvDate(view.getAdjExpectReceDate());
            logEntity.setType("RECV");
            logEntity.setApplyUserId(view.getApplyUserId());
            if (null != view.getPmConfirm() && view.getPmConfirm()==1) {
                logEntity.setReason(view.getPmRemark());
            } else {
                logEntity.setReason(view.getSalesRemark());
            }
            conReceivablePlanService.updateRecvOrInvDate(logEntity);
        }
    }


    /**
     * 保存并开始流程
     *
     * @param confirmDO 实体
     * @return int
     */
    public int saveAndStartProcessWithWorkFlow(ConReceivablePlanConfirmDO confirmDO) {
        int result = 0;
        ConReceivablePlanConfirmDO save = conReceivablePlanConfirmDAO.save(confirmDO);
        if (!ObjectUtils.isEmpty(save.getId())) {
            // 创建流程
            startProcess(confirmDO);
            result++;
        } else {
            log.error("SysAltRcvpConfirmEntity保存失败");
        }
        return result;
    }
    private void startProcess(ConReceivablePlanConfirmDO confirmDO) {
        ProcessInfo processInfo = new ProcessInfo();
        ConReceivablePlanVO planVO = conReceivablePlanDAO.queryByKey(confirmDO.getRecePlanId());
//        String status = WorkFlowStatusEnum.INVALID.getCode();
        if (workflow_enabled) {
//            status = WorkFlowStatusEnum.APPROVING_WORK.getCode();
            HashMap<String, Object> variables = new HashMap<>();
            getProcessApproval(confirmDO, planVO, variables);
            // 获取用户名称
            String applyUserName = cacheUtil.getUserName(confirmDO.getApplyUserId());

            //发起流程审批
            processInfo = workflowUtil.startProcess(StartProcessPayload.of(
                    ProcDefKey.CON_PROMPT.name(),
                    planVO.getSaleConName() + "-" + planVO.getReceStage() + "-收款计划确认" + planVO.getReceAmt() + "-" + applyUserName,
                    confirmDO.getId() + "",
                    variables), confirmDO.getApplyUserId()
            );
//            processInfo = workflowUtil.startProcess(StartProcessPayload.of(
//                    ProcDefKey.CON_PROMPT.name(),
//                    planVO.getSaleConName() + "-" + planVO.getReceStage() + "-收款计划确认" + planVO.getReceAmt() + "-" + applyUserName,
//                    confirmDO.getId() + "",
//                    variables)
//            );
        }
        //流程启动成功后，回写业务表数据
        ConReceivablePlanConfirmPayload payload = new ConReceivablePlanConfirmPayload();
        payload.setProcInstId(processInfo.getProcInstId());
        payload.setId(confirmDO.getId());
        payload.setProcInstStatus(processInfo.getProcInstStatus());
        payload.setSubmitTime(LocalDateTime.now());
//        payload.setStatus(status);是修改审批状态
        transactionUtilService.executeWithRunnable(() -> {
            conReceivablePlanConfirmDAO.updateByKeyDynamic(payload);
        });
    }

    private void getProcessApproval(ConReceivablePlanConfirmDO confirmDO, ConReceivablePlanVO planVO, HashMap<String, Object> variables) {
        // 销售填写
        variables.put("Activity_01h68it", confirmDO.getApplyUserId());
        // 项目经理填写
        Long pmUserId = getApprovalResId(confirmDO.getReceNo());
        variables.put("Activity_02unqub", pmUserId);
        // 是否需要财务确认
        boolean financeConfirm = confirmDO.getFinanceConfirm() != null && confirmDO.getFinanceConfirm() == 1 ? true : false;
        variables.put("financeConfirm", financeConfirm);
        // 出纳确认到账
        List<Long> userIdsByRole = systemRoleDAO.queryUserIdByRoleCodes(Arrays.asList(RoleEnum.FINANCE_MEMBER.getCode()));
//            List<Long> userIds = roleService.queryUserIdByRoleCode(RoleEnum.PROJ_CHANGE_FINANCE_APPROVER.getCode());
        if (ObjectUtils.isEmpty(userIdsByRole)) {
            throw TwException.error("", "出纳审批角色人员不存在");
        }
        variables.put("Activity_1qoee9k", userIdsByRole);
        // 调整历史是否超过阈值,是否需要销售bu负责人审批
        boolean second = false;
        // 财务确认的话 流程就结束了
        if (!financeConfirm) {
            // 收款计划变更历史升级审批次数
            int maxSizeChangeLog = getMaxSizeChangeLog();
            // 判断收款变更记录是否超过阀值
            ConRecvplanChangeLogQuery logQuery = new ConRecvplanChangeLogQuery();
            logQuery.setRecvplanId(confirmDO.getRecePlanId());
            List<ConRecvplanChangeLogVO> list = conRecvplanChangeLogDAO.queryListDynamic(logQuery);
            if (!CollectionUtils.isEmpty(list) && list.size() > maxSizeChangeLog) {
                second = true;
            }
            if (second) {
                // todo 超过阈值知会 平台财务负责人、财务经理
                visitNotice(confirmDO,planVO);
                // 平台财务负责人
//                    Long platFinPicUserId = roleMapper.selectOneUserIdByUserFlowRole(TwFlowRole.PLAT_FIN_PIC.getCode());//根据流程角色查询useId
//                    // 财务经理
//                    Long finFinanceDirectorUserId = roleMapper.selectOneUserIdByUserFlowRole(TwFlowRole.FIN_FINANCE_DIRECTOR.getCode());//根据流程角色查询useId
//                    List<EdpBpmTaskEntity> taskEntities = bpmTaskMapper.getProcessTasks(procId);
//                    if (taskEntities != null && taskEntities.size() > 0) {
//                        Long taskId = taskEntities.get(0).getId();
//                        //知会平台财务负责人
//                        Optional.of(view).ifPresent(
//                                v -> {
//                                    if (null != platFinPicUserId) {
//                                        bpmTaskMapper.createCcTask(taskId, platFinPicUserId);
//                                    }
//                                    if (null != finFinanceDirectorUserId) {
//                                        bpmTaskMapper.createCcTask(taskId, finFinanceDirectorUserId);
//                                    }
//                                }
//                        );
//                    }
            } else {
//                    // 判断当前登录人是否拥有角色【财务负责人	FIN_PIC】
//                    List<Long> userIdsByRole = systemRoleDAO.queryUserIdByRoleCodes(
//                            Arrays.asList(RoleEnum.SYS.getCode(), "FIN_PIC"));
//                    if (!CollectionUtils.isEmpty(userIdsByRole) && userIdsByRole.contains(loginUserId)) {
//                        variables.put("isFinPic", true);
//                    }
//                    // 判断当前登录人是否拥有角色【商务负责人	BUSINESS_MANAGER】
//                    List<Long> userIdsByRole1 = systemRoleDAO.queryUserIdByRoleCodes(
//                            Arrays.asList(RoleEnum.SYS.getCode(), "BUSINESS_MANAGER"));
//                    if (!CollectionUtils.isEmpty(userIdsByRole1) && userIdsByRole1.contains(loginUserId)) {
//                        variables.put("isFinPic", false);
//                    }
            }
        }
        variables.put("second", second);
        variables.put("financeConfirm", financeConfirm);
        // 是否发送催款函
        boolean sendPaymentRequest = confirmDO.getSendPaymentRequest() != null && confirmDO.getSendPaymentRequest() == 1 ? true : false;
        variables.put("sendPaymentRequest", sendPaymentRequest);
        // 销售bu负责人
        // 节点人员逻辑调整 2021年11月29日15:02:55  需求人：董海峰
        // 当T_CONTRACT 合作签单BU 不为空则取CO_BU_ID 否则取SIGN_BU_ID 的负责人
        // todo 当销售BU负责人状态为：离职中 或者 已离职，则跳过此节点，直接到 交付负责人节点；
        Long buId = ObjectUtils.isEmpty(planVO.getCoSignBuId()) ? planVO.getSignBuId() : planVO.getCoSignBuId();
        Long buIdManager = daoOrg.queryManageIdById(buId);
        variables.put("Activity_1f73s5s", buIdManager);
        // 交付负责人
        Long deliUserId = planVO.getDeliUserId();
        variables.put("Activity_1aypjz1", deliUserId);
        // pmo
        Long pmoUserId = planVO.getPmoUserId();
        variables.put("Activity_0b6mbas", pmoUserId);
    }

    public void visitNotice(ConReceivablePlanConfirmDO confirmDO, ConReceivablePlanVO planVO) {
        PrdMessageConfigVO configVO = messageConfigService.queryByMessageCode("MC20231226000001");
        Map<String, Object> result = new HashMap<>();
        result.put("contractName", planVO.getSaleConName());
        result.put("receNo", planVO.getReceNo());
        // 通知人列表
        List<Long> noticeSourceList = new ArrayList<>();
        // 平台财务负责人、财务经理
        noticeSourceList = roleService.queryUserIdByRoleCodes(Arrays.asList(RoleEnum.PLAT_FIN_MANAGER.getCode(), RoleEnum.PLAT_FIN_PIC.getCode()));
        String noticeSourceListStr = String.join(",", noticeSourceList.stream().map(String::valueOf).collect(Collectors.toList()));
        messageConfigService.sendMessageConfig(configVO, result, "appoint_people", noticeSourceListStr);
    }

    /**
     * 系统自动提醒临近收款计划的提前天数，即此天数阈值内的收款计划，都将做为需要提醒收款的对象。
     *
     * @return int
     */
    private int getSysWarmRecvDtLt() {
        int sysWarmRecvDtLt = 14;
        PrdSystemSettingVO systemSettingByKey = prdSystemSettingService.getSystemSettingByKey(SystemSettingsItemEnum.SYS_WARM_RECV_DT_LT.getCode());
        if (systemSettingByKey != null) {
            String settingValue = systemSettingByKey.getSettingValue();
            try {
                sysWarmRecvDtLt = Integer.parseInt(settingValue);
            } catch (NumberFormatException ignored) {
                log.error("系统设置项-【SYS_WARM_RECV_DT_LT】配置有误，请检查");
            }
        }
        return sysWarmRecvDtLt;
    }

    /**
     * 收款计划预计收款日期调整最大天数(未开票)
     *
     * @return {@link String}
     */
    private int getMaxRecvDtDelaydays() {
        int maxRecvDtDelaydays = 14;
        PrdSystemSettingVO systemSettingByKey = prdSystemSettingService.getSystemSettingByKey(SystemSettingsItemEnum.MAX_RECV_DT_DELAYDAYS.getCode());
        if (systemSettingByKey != null) {
            String settingValue = systemSettingByKey.getSettingValue();
            try {
                maxRecvDtDelaydays = Integer.parseInt(settingValue);
            } catch (NumberFormatException ignored) {
                log.error("系统设置项-【MAX_RECV_DT_DELAYDAYS】配置有误，请检查");
            }
        }
        return maxRecvDtDelaydays;
    }

    /**
     * 收款计划预计收款日期调整最大天数(已开票)
     *
     * @return {@link String}
     */
    private int getMaxRecvDtDelaydays2() {
        int maxRecvDtDelaydays2 = 30;
        PrdSystemSettingVO systemSettingByKey = prdSystemSettingService.getSystemSettingByKey(SystemSettingsItemEnum.MAX_RECV_DT_DELAYDAYS_2.getCode());
        if (null != systemSettingByKey) {
            String settingValue = systemSettingByKey.getSettingValue();
            try {
                maxRecvDtDelaydays2 = Integer.parseInt(settingValue);
            } catch (NumberFormatException ignored) {
                log.error("系统设置项-【MAX_RECV_DT_DELAYDAYS_2】配置有误，请检查");
            }
        }
        return maxRecvDtDelaydays2;
    }

    /**
     * 收款计划变更历史升级审批次数
     *
     * @return int
     */
    public int getMaxSizeChangeLog() {
        int maxSizeChangeLog = 2;
        PrdSystemSettingVO systemSettingByKey = prdSystemSettingService.getSystemSettingByKey(SystemSettingsItemEnum.MAX_CHAGE_RECE_DATE.getCode());
        if (null != systemSettingByKey) {
            String settingValue = systemSettingByKey.getSettingValue();
            try {
                maxSizeChangeLog = Integer.parseInt(settingValue);
            } catch (NumberFormatException ignored) {
                log.error("系统设置项-【MAX_CHAGE_RECE_DATE】配置有误，请检查");
            }
        }
        return maxSizeChangeLog;
    }

}
