/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5.server.common.aspect;

import com.elitesland.tw.tw5.server.common.TwException;
import com.elitesland.tw.tw5.server.common.annotation.ReSubmitCheck;
import com.elitesland.tw.tw5.server.common.util.ExpressionUtils;
import com.elitesland.tw.tw5.server.prd.common.GlobalUtil;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import lombok.NonNull;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Before;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.core.annotation.Order;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Component;

@Component
@Aspect
@Order(value=-1)
@ConditionalOnProperty(name={"enabled"}, prefix="resubmit-check", havingValue="true", matchIfMissing=true)
public class ReSubmitCheckAspect {
    private static final Logger log = LoggerFactory.getLogger(ReSubmitCheckAspect.class);
    private static final String REDIS_SEPARATOR = "::";
    private static final String RESUBMIT_CHECK_KEY_PREFIX = "ReSubmitCheckKey::";
    @Resource
    private RedisTemplate<String, String> redisTemplate;
    @Resource
    private HttpServletRequest request;

    @Before(value="@annotation(annotation)")
    public void beforeReSubmitCheck(JoinPoint joinPoint, ReSubmitCheck annotation) {
        String[] conditionExpressions;
        Object[] args = joinPoint.getArgs();
        if (!ExpressionUtils.getConditionValue((Object)args, conditionExpressions = annotation.conditionExpressions()) || ArrayUtils.isEmpty((Object[])args)) {
            return;
        }
        this.doCheck(annotation, args);
    }

    private void doCheck(@NonNull ReSubmitCheck annotation, Object[] args) {
        T[] argsForKey;
        if (annotation == null) {
            throw new NullPointerException("annotation is marked non-null but is null");
        }
        String[] argExpressions = annotation.argExpressions();
        String message = annotation.message();
        boolean withUserInfoInKey = annotation.withUserInfoInKey();
        boolean onlyInCurrentSession = annotation.onlyInCurrentSession();
        String methodDesc = this.request.getMethod();
        String uri = this.request.getRequestURI();
        StringBuilder stringBuilder = new StringBuilder(64);
        for (Object obj : argsForKey = ExpressionUtils.getExpressionValue((Object)args, argExpressions)) {
            stringBuilder.append(obj != null ? obj.toString() : "");
        }
        StringBuilder keyBuilder = new StringBuilder();
        keyBuilder.append(RESUBMIT_CHECK_KEY_PREFIX).append((String)(withUserInfoInKey ? this.getLoginUserId() + REDIS_SEPARATOR : "")).append((String)(onlyInCurrentSession ? this.request.getSession().getId() + REDIS_SEPARATOR : "")).append(uri).append(REDIS_SEPARATOR).append(methodDesc).append(REDIS_SEPARATOR).append((CharSequence)stringBuilder);
        if (this.redisTemplate.opsForValue().get((Object)keyBuilder.toString()) != null) {
            throw TwException.error("", StringUtils.isBlank((CharSequence)message) ? "\u8bf7\u52ff\u91cd\u590d\u64cd\u4f5c" : message);
        }
        this.redisTemplate.opsForValue().set((Object)keyBuilder.toString(), (Object)"", annotation.interval(), annotation.timeUnit());
    }

    public Long getLoginUserId() {
        try {
            return GlobalUtil.getLoginUserId();
        }
        catch (Exception e) {
            return 0L;
        }
    }
}

