/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5.server.common.util;

import cn.zhxu.bs.FieldOp;
import cn.zhxu.bs.FieldOps;
import cn.zhxu.bs.util.FieldFns;
import cn.zhxu.bs.util.MapBuilder;
import com.elitescloud.boot.common.param.BaseViewModel;
import com.elitescloud.boot.model.entity.QBaseModel;
import com.elitescloud.cloudt.common.base.param.OrderItem;
import com.elitesland.tw.tw5.api.common.TwQueryParam;
import com.elitesland.tw.tw5.server.common.TwException;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Order;
import com.querydsl.core.types.OrderSpecifier;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.dsl.EntityPathBase;
import com.querydsl.core.types.dsl.Expressions;
import com.querydsl.core.types.dsl.SimplePath;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAUpdateClause;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.data.domain.PageRequest;
import org.springframework.util.ObjectUtils;

public class SqlUtil {
    private static List<OrderItem> orderse = null;
    private static Map<String, List<String>> fieldMap = new HashMap<String, List<String>>();

    public static String toSqlLikeString(String value) {
        return "%" + value + "%";
    }

    public static List<OrderItem> getOrderse() {
        if (orderse == null) {
            orderse = new ArrayList<OrderItem>();
            orderse.add(OrderItem.asc((String)"sortIndex"));
            orderse.add(OrderItem.desc((String)"createTime"));
        }
        return orderse;
    }

    public static <T> OrderSpecifier<?>[] getSortedColumn(EntityPathBase<T> pathBase, List<OrderItem> orders) {
        if (orders == null || orders.size() == 0) {
            SimplePath fieldPath = Expressions.path(String.class, pathBase, (String)"createTime");
            return new OrderSpecifier[]{new OrderSpecifier(Order.DESC, (Expression)fieldPath)};
        }
        OrderSpecifier[] orderSpecifiers = new OrderSpecifier[orders.size()];
        for (int i = 0; i < orders.size(); ++i) {
            OrderItem orderItem = orders.get(i);
            Order order = orderItem.isAsc() ? Order.ASC : Order.DESC;
            SimplePath fieldPath = Expressions.path(String.class, pathBase, (String)orderItem.getColumn());
            orderSpecifiers[i] = new OrderSpecifier(order, (Expression)fieldPath);
        }
        return orderSpecifiers;
    }

    public static OrderSpecifier<?>[] getSortedColumn(List<OrderItem> orders, EntityPathBase ... pathBase) {
        if (orders == null || orders.size() == 0) {
            SimplePath fieldPath = Expressions.path(String.class, (Path)pathBase[0], (String)"createTime");
            return new OrderSpecifier[]{new OrderSpecifier(Order.DESC, (Expression)fieldPath)};
        }
        OrderSpecifier[] orderSpecifiers = new OrderSpecifier[orders.size()];
        for (int i = 0; i < orders.size(); ++i) {
            OrderItem orderItem = orders.get(i);
            Order order = orderItem.isAsc() ? Order.ASC : Order.DESC;
            EntityPathBase ownerEntity = SqlUtil.getOwnerEntity(orderItem.getColumn(), pathBase);
            if (ownerEntity == null) {
                throw TwException.error("", "\u4e0d\u5b58\u5728\u8981\u6392\u5e8f\u7684\u5b57\u6bb5");
            }
            SimplePath fieldPath = Expressions.path(String.class, (Path)ownerEntity, (String)orderItem.getColumn());
            orderSpecifiers[i] = new OrderSpecifier(order, (Expression)fieldPath);
        }
        return orderSpecifiers;
    }

    private static EntityPathBase getOwnerEntity(String column, EntityPathBase ... pathBase) {
        EntityPathBase result = null;
        for (int i = 0; i < pathBase.length; ++i) {
            EntityPathBase path = pathBase[i];
            String className = path.getClass().getName();
            List<String> stringFields = fieldMap.get(className);
            if (stringFields == null) {
                Field[] declaredFields = path.getClass().getDeclaredFields();
                ArrayList<String> stringList = new ArrayList<String>(declaredFields.length);
                for (int j = 0; j < declaredFields.length; ++j) {
                    Field declaredField = declaredFields[j];
                    if (!Path.class.isAssignableFrom(declaredField.getType())) continue;
                    stringList.add(declaredField.getName());
                }
                stringFields = stringList;
                fieldMap.put(className, stringList);
            }
            if (!stringFields.contains(column)) continue;
            result = path;
            break;
        }
        return result;
    }

    public static <T> void handleCommonJpaQuery(JPAQuery<T> jpaQuery, QBaseModel qBaseModel, TwQueryParam query) {
        jpaQuery.where((Predicate)qBaseModel.deleteFlag.eq((Object)0));
        if (!ObjectUtils.isEmpty((Object)query.getId())) {
            jpaQuery.where((Predicate)qBaseModel.id.eq((Object)query.getId()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getCreateUserId())) {
            jpaQuery.where((Predicate)qBaseModel.createUserId.eq((Object)query.getCreateUserId()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getCreateTimeStart())) {
            jpaQuery.where((Predicate)qBaseModel.createTime.goe((Comparable)query.getCreateTimeStart()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getCreateTimeEnd())) {
            jpaQuery.where((Predicate)qBaseModel.createTime.loe((Comparable)query.getCreateTimeEnd()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getModifyTimeStart())) {
            jpaQuery.where((Predicate)qBaseModel.modifyTime.goe((Comparable)query.getModifyTimeStart()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getModifyTimeEnd())) {
            jpaQuery.where((Predicate)qBaseModel.modifyTime.loe((Comparable)query.getModifyTimeEnd()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getRemark())) {
            jpaQuery.where((Predicate)qBaseModel.remark.like(SqlUtil.toSqlLikeString(query.getRemark())));
        }
    }

    public static void updateCommonJpaQuery(JPAUpdateClause update, QBaseModel qBaseModel) {
    }

    public static void handleCommonBSQuery(MapBuilder builder, TwQueryParam query) {
        ((MapBuilder)builder.field(BaseViewModel::getDeleteFlag, new Object[]{0})).op((FieldOp)FieldOps.Equal);
        if (!ObjectUtils.isEmpty((Object)query.getId())) {
            ((MapBuilder)builder.field(BaseViewModel::getId, new Object[]{query.getId()})).op((FieldOp)FieldOps.Equal);
        }
        if (!ObjectUtils.isEmpty((Object)query.getCreateUserId())) {
            ((MapBuilder)builder.field(BaseViewModel::getCreateUserId, new Object[]{query.getCreateUserId()})).op((FieldOp)FieldOps.Equal);
        }
        if (!ObjectUtils.isEmpty((Object)query.getCreateTimeStart()) && !ObjectUtils.isEmpty((Object)query.getCreateTimeEnd())) {
            ((MapBuilder)builder.field(BaseViewModel::getCreateTime, new FieldFns.FieldFn[0])).sql("$1 > ? and $1 < ?", new Object[]{query.getCreateTimeStart(), query.getCreateTimeEnd()});
        }
        if (!ObjectUtils.isEmpty((Object)query.getRemark())) {
            ((MapBuilder)builder.field(BaseViewModel::getRemark, new Object[]{query.getRemark()})).op((FieldOp)FieldOps.Contain);
        }
    }

    public static void handleSortedBS(MapBuilder builder, List<OrderItem> orders) {
        if (orders == null || orders.isEmpty()) {
            builder.orderBy("createTime").desc();
        } else {
            for (OrderItem orderItem : orders) {
                builder.orderBy(orderItem.getColumn());
                if (orderItem.isAsc()) {
                    builder.asc();
                    continue;
                }
                builder.desc();
            }
        }
    }

    public static void handlePageBS(MapBuilder builder, PageRequest pageRequest) {
        if (pageRequest == null || pageRequest.getPageSize() < 0 || pageRequest.getPageNumber() < 0) {
            builder.page(0L, 10);
        } else {
            builder.page((long)pageRequest.getPageNumber(), pageRequest.getPageSize());
        }
    }

    public static void handleBS(MapBuilder builder, TwQueryParam query) {
        SqlUtil.handleCommonBSQuery(builder, query);
        SqlUtil.handleSortedBS(builder, query.getOrders());
        SqlUtil.handlePageBS(builder, query.getPageRequest());
        SqlUtil.handleFunctionBS(builder, query);
    }

    public static void handleFunctionBS(MapBuilder builder, TwQueryParam query) {
        builder.put("_FunctionCode", (Object)query.get_functionCode());
    }
}

