/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5.server.prd.adm.service;

import com.elitescloud.boot.core.base.BaseServiceImpl;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.adm.payload.AdmBusitripApplyPayload;
import com.elitesland.tw.tw5.api.prd.adm.query.AdmBusitripApplyDetailQuery;
import com.elitesland.tw.tw5.api.prd.adm.query.AdmBusitripApplyQuery;
import com.elitesland.tw.tw5.api.prd.adm.query.AdmTripTicketQuery;
import com.elitesland.tw.tw5.api.prd.adm.service.AdmBusitripApplyDetailService;
import com.elitesland.tw.tw5.api.prd.adm.service.AdmBusitripApplyService;
import com.elitesland.tw.tw5.api.prd.adm.service.AdmTripTicketService;
import com.elitesland.tw.tw5.api.prd.adm.vo.AdmBusitripApplyVO;
import com.elitesland.tw.tw5.api.prd.crm.query.CrmOpportunityQuery;
import com.elitesland.tw.tw5.api.prd.crm.service.CrmOpportunityService;
import com.elitesland.tw.tw5.api.prd.crm.vo.CrmOpportunityListVO;
import com.elitesland.tw.tw5.api.prd.org.vo.PrdOrgEmployeeRefVO;
import com.elitesland.tw.tw5.api.prd.org.vo.PrdOrgEmployeeVO;
import com.elitesland.tw.tw5.api.prd.org.vo.PrdOrgOrganizationVO;
import com.elitesland.tw.tw5.api.prd.pms.service.BuProjectService;
import com.elitesland.tw.tw5.api.prd.pms.service.PmsProjectService;
import com.elitesland.tw.tw5.api.prd.pms.vo.BuProjectVO;
import com.elitesland.tw.tw5.api.prd.pms.vo.PmsProjectVO;
import com.elitesland.tw.tw5.api.prd.system.service.PrdSystemRoleService;
import com.elitesland.tw.tw5.server.common.TwException;
import com.elitesland.tw.tw5.server.common.service.TransactionUtilService;
import com.elitesland.tw.tw5.server.prd.adm.convert.AdmBusitripApplyConvert;
import com.elitesland.tw.tw5.server.prd.adm.dao.AdmBusitripApplyDAO;
import com.elitesland.tw.tw5.server.prd.adm.entity.AdmBusitripApplyDO;
import com.elitesland.tw.tw5.server.prd.adm.repo.AdmBusitripApplyRepo;
import com.elitesland.tw.tw5.server.prd.common.CacheUtil;
import com.elitesland.tw.tw5.server.prd.common.GlobalUtil;
import com.elitesland.tw.tw5.server.prd.common.WorkflowUtil;
import com.elitesland.tw.tw5.server.prd.common.functionEnum.BusitripApplyStatusEnum;
import com.elitesland.tw.tw5.server.prd.common.functionEnum.RoleEnum;
import com.elitesland.tw.tw5.server.prd.common.functionEnum.WorkFlowStatusEnum;
import com.elitesland.tw.tw5.server.prd.pms.common.functionEnum.PmsReasonTypeEnum;
import com.elitesland.tw.tw5.server.prd.pms.common.functionEnum.TaskStatusEnum;
import com.elitesland.workflow.ProcessInfo;
import com.elitesland.workflow.enums.ProcInstStatus;
import com.elitesland.workflow.payload.DeleteProcessPayload;
import com.elitesland.workflow.payload.ProcessStatusChangePayload;
import com.elitesland.workflow.payload.SetVariablesPayload;
import com.elitesland.workflow.payload.StartProcessPayload;
import com.google.common.collect.Lists;
import java.time.LocalDate;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

@Service
public class AdmBusitripApplyServiceImpl
extends BaseServiceImpl
implements AdmBusitripApplyService {
    private static final Logger log = LoggerFactory.getLogger(AdmBusitripApplyServiceImpl.class);
    private final AdmBusitripApplyRepo admBusitripApplyRepo;
    private final AdmBusitripApplyDAO admBusitripApplyDAO;
    private final AdmBusitripApplyDetailService admBusitripApplyDetailService;
    private final WorkflowUtil workflowUtil;
    private final TransactionUtilService transactionUtilService;
    private final CacheUtil cacheUtil;
    private final PmsProjectService pmsProjectService;
    private final PrdSystemRoleService roleService;
    private final AdmTripTicketService admTripTicketService;
    private final BuProjectService buProjectService;
    private final CrmOpportunityService opportunityService;

    @Transactional(rollbackFor={Exception.class})
    public AdmBusitripApplyVO insertOrUpdate(AdmBusitripApplyPayload payload) {
        AdmBusitripApplyVO admBusitripApplyVO = this.checkData(payload);
        String appName = "";
        Long pmResId = 0L;
        Long deliUserId = 0L;
        Long deliBuId = 0L;
        Long preSaleUserId = 0L;
        if (payload.getReasonType().equals(PmsReasonTypeEnum.PROJ_CONTRACT.getCode())) {
            PmsProjectVO pmsProjectVO = this.pmsProjectService.queryByKey(payload.getReasonId());
            if (payload.getExpenseBuId() == null) {
                payload.setExpenseBuId(pmsProjectVO.getDeliBuId());
            }
            appName = pmsProjectVO.getProjName();
            pmResId = pmsProjectVO.getPmResId();
            deliUserId = pmsProjectVO.getDeliUserId();
            deliBuId = pmsProjectVO.getDeliBuId();
        }
        if (payload.getReasonType().equals(PmsReasonTypeEnum.PROJ_BU.getCode())) {
            BuProjectVO buProjectVO = this.buProjectService.queryByKey(payload.getReasonId());
            if (payload.getExpenseBuId() == null) {
                payload.setExpenseBuId(buProjectVO.getDeliBuId());
            }
            appName = buProjectVO.getProjName();
            pmResId = buProjectVO.getPmResId();
            deliUserId = buProjectVO.getDeliUserId();
            PrdOrgOrganizationVO org = this.cacheUtil.getOrg(buProjectVO.getDeliBuId());
            if (org != null) {
                preSaleUserId = org.getManageId();
            }
        }
        if (payload.getReasonType().equals(PmsReasonTypeEnum.PROJ_OPPO.getCode())) {
            CrmOpportunityQuery query = new CrmOpportunityQuery();
            query.setProjectId(payload.getReasonId());
            List crmOpportunityListVOS = this.opportunityService.queryListDynamic(query);
            if (!ObjectUtils.isEmpty((Object)crmOpportunityListVOS)) {
                if (payload.getExpenseBuId() == null) {
                    payload.setExpenseBuId(this.cacheUtil.getDefaultOrgIdByUserId(payload.getApplyResId()));
                }
                appName = ((CrmOpportunityListVO)crmOpportunityListVOS.get(0)).getProjectName();
                PrdOrgOrganizationVO org = this.cacheUtil.getOrg(((CrmOpportunityListVO)crmOpportunityListVOS.get(0)).getPreSaleOrgId());
                if (org != null) {
                    preSaleUserId = org.getManageId();
                }
            } else {
                throw TwException.error("", "\u4e8b\u7531\u4e0d\u5b58\u5728");
            }
        }
        if (admBusitripApplyVO == null) {
            String code = this.generateSeqNum("AMD_BUSITRIP_APPLY", new String[0]);
            payload.setApplyNo(code);
            payload.setApplyDate(LocalDate.now());
            payload.setApplyStatus(BusitripApplyStatusEnum.CREATE.getCode());
        } else {
            payload.setApplyStatus(admBusitripApplyVO.getApplyStatus());
            payload.setProcInstId(admBusitripApplyVO.getProcInstId());
            payload.setApplyDate(admBusitripApplyVO.getApplyDate());
        }
        if (payload.getOuId() == null) {
            throw TwException.error("", "\u8d39\u7528\u627f\u62c5\u516c\u53f8\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        AdmBusitripApplyDO entityDo = AdmBusitripApplyConvert.INSTANCE.toDo(payload);
        AdmBusitripApplyDO save = (AdmBusitripApplyDO)this.admBusitripApplyRepo.save(entityDo);
        if (!ObjectUtils.isEmpty((Object)payload.getDelDetailIds())) {
            this.admBusitripApplyDetailService.deleteSoft(payload.getDelDetailIds());
        }
        if (!ObjectUtils.isEmpty((Object)payload.getDetailPayloads())) {
            payload.getDetailPayloads().forEach(act -> act.setApplyId(save.getId()));
            this.admBusitripApplyDetailService.bacthInsert(payload.getDetailPayloads());
        } else if (admBusitripApplyVO == null) {
            throw TwException.error("", "\u51fa\u5dee\u4eba\u660e\u7ec6\u4fe1\u606f");
        }
        String apprStatus = WorkFlowStatusEnum.APPROVING_WORK.getCode();
        String applyStatus = BusitripApplyStatusEnum.APPLYING.getCode();
        String procInstId = null;
        if (admBusitripApplyVO != null) {
            procInstId = admBusitripApplyVO.getProcInstId();
        }
        HashMap<String, Object> variables = this.getVariables(payload, pmResId, deliUserId, deliBuId, preSaleUserId);
        if (procInstId == null) {
            Object procName = "";
            procName = "A05.\u51fa\u5dee\u7533\u8bf7-" + this.cacheUtil.getUserName(payload.getApplyResId()) + "-" + appName + "-" + payload.getBeginDate() + "~" + payload.getEndDate();
            ProcessInfo processInfo = this.workflowUtil.startProcess(StartProcessPayload.of((String)"AMD_BUSITRIP_APPLY", (String)procName, (String)("" + entityDo.getId()), variables), new Long[0]);
            procInstId = processInfo.getProcInstId();
            apprStatus = processInfo.getProcInstStatus().name();
            if (apprStatus.equals(ProcInstStatus.APPROVED.name())) {
                applyStatus = BusitripApplyStatusEnum.APPROVED.getCode();
                procInstId = null;
            }
        } else {
            Integer rejectType = admBusitripApplyVO.getRejectType();
            variables.put("rejectType", rejectType != null && rejectType != 0);
            this.workflowUtil.setVariables(SetVariablesPayload.of((String)procInstId, variables));
        }
        AdmBusitripApplyPayload payload0 = new AdmBusitripApplyPayload();
        payload0.setId(entityDo.getId());
        payload0.setProcInstId(procInstId);
        payload0.setApprStatus(apprStatus);
        payload0.setApplyStatus(applyStatus);
        this.transactionUtilService.executeWithRunnable(() -> this.admBusitripApplyDAO.updateByKeyDynamic(payload0));
        return AdmBusitripApplyConvert.INSTANCE.toVo(save);
    }

    HashMap<String, Object> getVariables(AdmBusitripApplyPayload payload, Long pmResId, Long deliUserId, Long deliBuId, Long preSaleUserId) {
        if (null == pmResId) {
            throw TwException.error("", "\u9879\u76ee\u7ecf\u7406\u672a\u8bbe\u7f6e");
        }
        if (null == deliUserId) {
            throw TwException.error("", "\u4ea4\u4ed8\u8d1f\u8d23\u4eba\u672a\u8bbe\u7f6e");
        }
        HashMap<String, Object> batchMap = new HashMap<String, Object>();
        batchMap.put("rejectType", false);
        PrdOrgEmployeeRefVO userDefaultOrg = this.cacheUtil.getUserDefaultOrg(payload.getApplyResId());
        PrdOrgEmployeeVO employee = this.cacheUtil.getEmployee(payload.getApplyResId());
        batchMap.put("insideRes", true);
        if (StringUtils.hasText((String)employee.getExtString6()) && employee.getExtString6().equals("EXTERNAL_RES")) {
            batchMap.put("insideRes", false);
        }
        batchMap.put("Activity_1vc7jrp", Lists.newArrayList((Object[])new Long[]{userDefaultOrg.getParentId()}));
        batchMap.put("reasonType", payload.getReasonType());
        batchMap.put("Activity_1t8iywq", Lists.newArrayList((Object[])new Long[]{preSaleUserId}));
        if (payload.getReasonType().equals(PmsReasonTypeEnum.PROJ_CONTRACT.getCode())) {
            Boolean managerFlag = pmResId.equals(payload.getApplyResId());
            Boolean deliUserFlag = deliUserId.equals(payload.getApplyResId());
            Boolean deliBuFlag = userDefaultOrg.getManageId().equals(payload.getApplyResId());
            batchMap.put("managerFlag", managerFlag);
            batchMap.put("deliUserFlag", deliUserFlag);
            batchMap.put("deliBuFlag", deliBuFlag);
        }
        Boolean ticketFlag = false;
        if (payload.getBookTicketFlag() != null && payload.getBookTicketFlag() == 1) {
            ticketFlag = true;
        }
        batchMap.put("Activity_09w2nl2", Lists.newArrayList((Object[])new Long[]{pmResId}));
        batchMap.put("Activity_09sx2tb", Lists.newArrayList((Object[])new Long[]{deliUserId}));
        PrdOrgOrganizationVO org = this.cacheUtil.getOrg(deliBuId);
        batchMap.put("Activity_1qhep9c", Lists.newArrayList((Object[])new Long[]{0L}));
        if (org != null) {
            batchMap.put("Activity_1qhep9c", Lists.newArrayList((Object[])new Long[]{org.getManageId()}));
        }
        batchMap.put("ticketFlag", ticketFlag);
        batchMap.put("Activity_0i0aafe", this.roleService.queryUserIdByRoleCode(RoleEnum.PLAT_TICKET_ASSIS_PROJ.getCode()));
        batchMap.put("Activity_1ft0fbg", this.roleService.queryUserIdByRoleCode(RoleEnum.PLAT_TICKET_ASSIS.getCode()));
        return batchMap;
    }

    AdmBusitripApplyVO checkData(AdmBusitripApplyPayload payload) {
        if (!StringUtils.hasText((String)payload.getReasonType())) {
            throw TwException.error("", "\u4e8b\u7531\u7c7b\u578b\u4e0d\u53ef\u4e3a\u7a7a\uff0c\u8bf7\u6838\u9a8c\uff01");
        }
        if (payload.getReasonId() == null) {
            throw TwException.error("", "\u5f52\u5c5e\u4e8b\u7531\u4e0d\u53ef\u4e3a\u7a7a\uff0c\u8bf7\u6838\u9a8c\uff01");
        }
        if (!StringUtils.hasText((String)payload.getReasonName())) {
            throw TwException.error("", "\u5f52\u5c5e\u4e8b\u7531\u540d\u79f0\u4e0d\u53ef\u4e3a\u7a7a\uff0c\u8bf7\u6838\u9a8c\uff01");
        }
        if (!payload.getReasonType().equals(PmsReasonTypeEnum.PROJ_CONTRACT.getCode()) && payload.getExpenseBuId() == null) {
            throw TwException.error("", "\u8d39\u7528\u627f\u62c5bu\u4e0d\u53ef\u4e3a\u7a7a");
        }
        if (payload.getApplyResId() == null) {
            throw TwException.error("", "\u7533\u8bf7\u4eba\u4e0d\u53ef\u4e3a\u7a7a\uff0c\u8bf7\u6838\u9a8c\uff01");
        }
        PrdOrgEmployeeRefVO userDefaultOrg = this.cacheUtil.getUserDefaultOrg(payload.getApplyResId());
        payload.setApplyBuId(userDefaultOrg.getOrgId());
        AdmBusitripApplyVO admBusitripApplyVO = null;
        if (payload.getId() != null) {
            admBusitripApplyVO = this.admBusitripApplyDAO.queryByKey(payload.getId());
            if (admBusitripApplyVO == null) {
                throw TwException.error("", "\u4fee\u6539\u6570\u636e\u4e0d\u5b58\u5728");
            }
            if (!admBusitripApplyVO.getApplyStatus().equals(BusitripApplyStatusEnum.CREATE.getCode()) && !admBusitripApplyVO.getApplyStatus().equals(BusitripApplyStatusEnum.REJECTED.getCode())) {
                throw TwException.error("", "\u4ec5\u652f\u6301\u65b0\u5efa\u6216\u5df2\u62d2\u7edd\u72b6\u6001\u4fee\u6539");
            }
        }
        return admBusitripApplyVO;
    }

    public PagingVO<AdmBusitripApplyVO> queryPaging(AdmBusitripApplyQuery query) {
        PagingVO<AdmBusitripApplyVO> result = this.admBusitripApplyDAO.queryPaging(query);
        result.stream().forEach(e -> e.setCustName(this.cacheUtil.getCompanyNameByBookId(e.getCustId())));
        return result;
    }

    public List<AdmBusitripApplyVO> queryListDynamic(AdmBusitripApplyQuery query) {
        List<AdmBusitripApplyVO> admBusitripApplyVOS = this.admBusitripApplyDAO.queryListDynamic(query);
        if (!ObjectUtils.isEmpty(admBusitripApplyVOS)) {
            List pmsProjectVOS;
            List reasonIds = admBusitripApplyVOS.stream().filter(item -> item.getReasonId() != null && StringUtils.hasText((String)item.getReasonType()) && item.getReasonType().equals(PmsReasonTypeEnum.PROJ_CONTRACT.getCode())).map(p -> p.getReasonId()).collect(Collectors.toList());
            Map<Object, Object> pmsProjectVOMap = new HashMap();
            if (!CollectionUtils.isEmpty(reasonIds) && !CollectionUtils.isEmpty((Collection)(pmsProjectVOS = this.pmsProjectService.queryListByReasonIdList(reasonIds)))) {
                pmsProjectVOMap = pmsProjectVOS.stream().collect(Collectors.groupingBy(PmsProjectVO::getId));
            }
            HashMap finalPmsProjectVOMap = pmsProjectVOMap;
            admBusitripApplyVOS.forEach(vo -> {
                vo.setOuName(this.cacheUtil.getCompanyNameByBookId(vo.getOuId()));
                vo.setCustName(this.cacheUtil.getCompanyNameByBookId(vo.getCustId()));
                if (!CollectionUtils.isEmpty((Map)finalPmsProjectVOMap) && finalPmsProjectVOMap.containsKey(vo.getReasonId())) {
                    vo.setRecvedAmt(((PmsProjectVO)((List)finalPmsProjectVOMap.get(vo.getReasonId())).get(0)).getRecvedAmt());
                    vo.setPlatType(((PmsProjectVO)((List)finalPmsProjectVOMap.get(vo.getReasonId())).get(0)).getPlatType());
                    vo.setProjStatus(((PmsProjectVO)((List)finalPmsProjectVOMap.get(vo.getReasonId())).get(0)).getProjStatus());
                }
            });
        }
        return admBusitripApplyVOS;
    }

    public List<AdmBusitripApplyVO> queryListDynamicSimple(AdmBusitripApplyQuery query) {
        return this.admBusitripApplyDAO.queryListDynamic(query);
    }

    public AdmBusitripApplyVO queryByKey(Long key) {
        AdmBusitripApplyVO admBusitripApplyVO = this.admBusitripApplyDAO.queryByKey(key);
        admBusitripApplyVO.setCustName(this.cacheUtil.getCompanyNameByBookId(admBusitripApplyVO.getCustId()));
        AdmBusitripApplyDetailQuery queryDetail = new AdmBusitripApplyDetailQuery();
        queryDetail.setApplyId(key);
        List admBusitripApplyDetailVOS = this.admBusitripApplyDetailService.queryListDynamic(queryDetail);
        AdmTripTicketQuery query = new AdmTripTicketQuery();
        query.setApplyId(key);
        List admTripTicketVOS = this.admTripTicketService.queryListDynamic(query);
        String companyName = this.cacheUtil.getCompanyNameByBookId(admBusitripApplyVO.getOuId());
        admBusitripApplyVO.setOuName(companyName);
        admBusitripApplyVO.setCustName(this.cacheUtil.getCompanyNameByBookId(admBusitripApplyVO.getCustId()));
        admBusitripApplyVO.setDetailVOs(admBusitripApplyDetailVOS);
        admBusitripApplyVO.setTripTicketVOs(admTripTicketVOS);
        PrdOrgEmployeeVO employee = this.cacheUtil.getEmployee(admBusitripApplyVO.getApplyResId());
        String applyResLevel = "";
        if (employee != null) {
            applyResLevel = employee.getExtString1();
        }
        admBusitripApplyVO.setApplyResLevel(applyResLevel);
        if (admBusitripApplyVO.getApplyBuId() == null) {
            Long defaultOrgIdByUserId = this.cacheUtil.getDefaultOrgIdByUserId(admBusitripApplyVO.getApplyResId());
            admBusitripApplyVO.setApplyBuId(defaultOrgIdByUserId);
        }
        return admBusitripApplyVO;
    }

    @Transactional(rollbackFor={Exception.class})
    public AdmBusitripApplyVO update(AdmBusitripApplyPayload payload) {
        return null;
    }

    @Transactional(rollbackFor={Exception.class})
    public long updateByKeyDynamic(AdmBusitripApplyPayload payload) {
        long result = this.admBusitripApplyDAO.updateByKeyDynamic(payload);
        return result;
    }

    @Transactional(rollbackFor={Exception.class})
    public void deleteSoft(List<Long> keys) {
        List<AdmBusitripApplyVO> admBusitripApplyVOS;
        if (!keys.isEmpty() && !ObjectUtils.isEmpty(admBusitripApplyVOS = this.admBusitripApplyDAO.queryByKeys(keys))) {
            Long loginUserId = GlobalUtil.getLoginUserId();
            admBusitripApplyVOS.forEach(vo -> {
                if (!vo.getApplyStatus().equals(TaskStatusEnum.CREATE.getCode())) {
                    throw TwException.error("", "\u4ec5\u652f\u6301\u65b0\u5efa\u72b6\u6001\u7684\u5220\u9664");
                }
                try {
                    if (StringUtils.hasText((String)vo.getProcInstId())) {
                        this.workflowUtil.deleteProcess(DeleteProcessPayload.of((String)vo.getProcInstId(), (String)""));
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            });
            this.admBusitripApplyDAO.deleteSoft(keys);
            this.admBusitripApplyDetailService.deleteSoftByApplyId(keys);
        }
    }

    public void processStatusChange(ProcessStatusChangePayload payload) {
        String businessKey = payload.getBusinessKey();
        ProcInstStatus procInstStatus = payload.getProcInstStatus();
        AdmBusitripApplyVO admBusitripApplyVO = this.admBusitripApplyDAO.queryByKey(Long.valueOf(businessKey));
        if (admBusitripApplyVO != null) {
            AdmBusitripApplyPayload busitripApplyPayload = new AdmBusitripApplyPayload();
            busitripApplyPayload.setId(Long.valueOf(Long.parseLong(businessKey)));
            busitripApplyPayload.setApprStatus(procInstStatus.name());
            int rejectType = 0;
            switch (procInstStatus) {
                case NOTSUBMIT: {
                    busitripApplyPayload.setApplyStatus(BusitripApplyStatusEnum.CREATE.getCode());
                    break;
                }
                case INTERRUPT: {
                    busitripApplyPayload.setProcInstId(null);
                    busitripApplyPayload.setNullFields(List.of("procInstId"));
                    busitripApplyPayload.setApplyStatus(BusitripApplyStatusEnum.CREATE.getCode());
                    break;
                }
                case INVALID: {
                    busitripApplyPayload.setDeleteFlag(Integer.valueOf(1));
                    busitripApplyPayload.setApplyStatus(BusitripApplyStatusEnum.CREATE.getCode());
                    break;
                }
                case REJECTED: {
                    busitripApplyPayload.setApplyStatus(BusitripApplyStatusEnum.REJECTED.getCode());
                    String taskDefKey = payload.getCommentInfo().getTaskDefKey();
                    if (!taskDefKey.equals("Activity_0i0aafe") && !taskDefKey.equals("Activity_1ft0fbg")) break;
                    rejectType = 1;
                    break;
                }
                case APPROVED: {
                    busitripApplyPayload.setApplyStatus(BusitripApplyStatusEnum.APPROVED.getCode());
                    break;
                }
                case APPROVING: {
                    busitripApplyPayload.setApplyStatus(BusitripApplyStatusEnum.APPLYING.getCode());
                }
            }
            busitripApplyPayload.setRejectType(Integer.valueOf(rejectType));
            this.admBusitripApplyDAO.updateByKeyDynamic(busitripApplyPayload);
        }
    }

    public AdmBusitripApplyVO queryOneByKey(Long key) {
        return this.admBusitripApplyDAO.queryByKey(key);
    }

    public void unbindReim(Long reimId) {
        this.admBusitripApplyDAO.unbindReim(reimId);
    }

    @Transactional
    public Long updateHwhtSyncFlag(List<Long> ids) {
        if (ObjectUtils.isEmpty(ids)) {
            log.warn("\u5f85\u66f4\u65b0\u6570\u636eid\u4e3a\u7a7a\uff01");
            return -1L;
        }
        return this.admBusitripApplyDAO.updateHwhtSyncFlag(ids);
    }

    public AdmBusitripApplyServiceImpl(AdmBusitripApplyRepo admBusitripApplyRepo, AdmBusitripApplyDAO admBusitripApplyDAO, AdmBusitripApplyDetailService admBusitripApplyDetailService, WorkflowUtil workflowUtil, TransactionUtilService transactionUtilService, CacheUtil cacheUtil, PmsProjectService pmsProjectService, PrdSystemRoleService roleService, AdmTripTicketService admTripTicketService, BuProjectService buProjectService, CrmOpportunityService opportunityService) {
        this.admBusitripApplyRepo = admBusitripApplyRepo;
        this.admBusitripApplyDAO = admBusitripApplyDAO;
        this.admBusitripApplyDetailService = admBusitripApplyDetailService;
        this.workflowUtil = workflowUtil;
        this.transactionUtilService = transactionUtilService;
        this.cacheUtil = cacheUtil;
        this.pmsProjectService = pmsProjectService;
        this.roleService = roleService;
        this.admTripTicketService = admTripTicketService;
        this.buProjectService = buProjectService;
        this.opportunityService = opportunityService;
    }
}

