/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5.server.prd.adm.service;

import com.elitescloud.boot.core.base.BaseServiceImpl;
import com.elitesland.tw.tw5.api.prd.adm.service.AdmReasonService;
import com.elitesland.tw.tw5.api.prd.adm.vo.AdmReasonVO;
import com.elitesland.tw.tw5.api.prd.crm.query.CrmOpportunityQuery;
import com.elitesland.tw.tw5.api.prd.crm.service.CrmOpportunityService;
import com.elitesland.tw.tw5.api.prd.pms.query.PmsProjectQuery;
import com.elitesland.tw.tw5.api.prd.pms.vo.PmsProjectVO;
import com.elitesland.tw.tw5.server.prd.common.CacheUtil;
import com.elitesland.tw.tw5.server.prd.common.GlobalUtil;
import com.elitesland.tw.tw5.server.prd.pms.common.functionEnum.PmsReasonTypeEnum;
import com.elitesland.tw.tw5.server.prd.pms.common.functionEnum.ProjectStatusEnum;
import com.elitesland.tw.tw5.server.prd.pms.dao.PmsProjectDAO;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class AdmReasonServiceImpl
extends BaseServiceImpl
implements AdmReasonService {
    private static final Logger log = LoggerFactory.getLogger(AdmReasonServiceImpl.class);
    private final CacheUtil cacheUtil;
    private final CrmOpportunityService opportunityService;
    private final PmsProjectDAO pmsProjectDAO;
    @Value(value="${tw5.sys_default.ou_id:1001}")
    private Long ou_id;

    public List<AdmReasonVO> queryReasonInfos(String reasonType) {
        Long loginUserId = GlobalUtil.getLoginUserId();
        ArrayList<AdmReasonVO> list = new ArrayList<AdmReasonVO>();
        if (reasonType.equals(PmsReasonTypeEnum.PROJ_OPPO.getCode())) {
            CrmOpportunityQuery query = new CrmOpportunityQuery();
            List crmOpportunityListVOS = this.opportunityService.queryListDynamic(query);
            if (crmOpportunityListVOS != null) {
                crmOpportunityListVOS.forEach(vo -> {
                    AdmReasonVO reasonVO = new AdmReasonVO();
                    reasonVO.setId(vo.getId());
                    reasonVO.setName(vo.getProjectName());
                    reasonVO.setCode(vo.getProjectNo());
                    reasonVO.setExpenseBuId(vo.getPreSaleOrgId());
                    reasonVO.setExpenseBuName(this.cacheUtil.getOrgName(vo.getPreSaleOrgId()));
                    reasonVO.setExpenseCompanyId(this.ou_id);
                    reasonVO.setExpenseCompanyName(this.cacheUtil.getCompanyNameByBookId(this.ou_id));
                    reasonVO.setCustId(vo.getCustBookId());
                    reasonVO.setCustName(this.cacheUtil.getCompanyNameByBookId(vo.getCustBookId()));
                    reasonVO.setRemark("\u5546\u673a");
                    list.add(reasonVO);
                });
            }
        } else {
            PmsProjectQuery query = new PmsProjectQuery();
            query.setLoginUserId(loginUserId);
            query.setProjStatus(ProjectStatusEnum.ACTIVE.getCode());
            List<PmsProjectVO> pmsProjectVOS = this.pmsProjectDAO.queryReasonProjectList(query);
            if (pmsProjectVOS != null) {
                pmsProjectVOS.forEach(vo -> {
                    AdmReasonVO reasonVO = new AdmReasonVO();
                    reasonVO.setId(vo.getId());
                    reasonVO.setName(vo.getProjName());
                    reasonVO.setCode(vo.getProjNo());
                    reasonVO.setExpenseBuId(vo.getDeliBuId());
                    reasonVO.setExpenseBuName(this.cacheUtil.getOrgName(vo.getDeliBuId()));
                    reasonVO.setExpenseCompanyId(vo.getOuBookId());
                    reasonVO.setExpenseCompanyName(this.cacheUtil.getCompanyNameByBookId(vo.getOuBookId()));
                    reasonVO.setCustId(vo.getCustId());
                    reasonVO.setCustName(this.cacheUtil.getCompanyNameByBookId(vo.getCustId()));
                    reasonVO.setCustBarExpense(vo.getCustBarExpense());
                    list.add(reasonVO);
                });
            }
        }
        return list;
    }

    public AdmReasonServiceImpl(CacheUtil cacheUtil, CrmOpportunityService opportunityService, PmsProjectDAO pmsProjectDAO) {
        this.cacheUtil = cacheUtil;
        this.opportunityService = opportunityService;
        this.pmsProjectDAO = pmsProjectDAO;
    }
}

