/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5.server.prd.borrow.workflow;

import com.elitesland.tw.tw5.api.prd.borrow.payload.BorrowMoneyPayload;
import com.elitesland.tw.tw5.api.prd.borrow.service.BorrowMoneyService;
import com.elitesland.tw.tw5.api.prd.borrow.vo.BorrowMoneyVO;
import com.elitesland.tw.tw5.server.prd.borrow.constant.BorrowStatusEnum;
import com.elitesland.workflow.WorkflowCallBack;
import com.elitesland.workflow.WorkflowResult;
import com.elitesland.workflow.enums.ProcInstStatus;
import com.elitesland.workflow.payload.ProcessStatusChangePayload;
import com.elitesland.workflow.payload.TaskAssigneePayload;
import com.elitesland.workflow.payload.TaskCompletedPayload;
import com.elitesland.workflow.payload.TaskCreatedPayload;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="TW_WORKFLOW_CALLBACK_BORROW_MONEY")
public class BorrowMoneyWorkflowCallBackController
implements WorkflowCallBack {
    private static final Logger log = LoggerFactory.getLogger(BorrowMoneyWorkflowCallBackController.class);
    @Autowired
    private BorrowMoneyService service;

    public WorkflowResult<ArrayList<String>> taskAssignee(TaskAssigneePayload payload) {
        log.info("customer taskAssignee:{}", (Object)payload);
        return WorkflowResult.success(null);
    }

    public WorkflowResult<Void> taskCreated(TaskCreatedPayload payload) {
        log.info("customer taskCreated:{}", (Object)payload);
        return WorkflowResult.success(null);
    }

    public WorkflowResult<Void> taskCompleted(TaskCompletedPayload payload) {
        log.info("customer taskCompleted:{}", (Object)payload);
        return WorkflowResult.success(null);
    }

    public WorkflowResult<Void> processStatusChange(ProcessStatusChangePayload payload) {
        log.info("customer processStatusChange:{}", (Object)payload);
        String businessKey = payload.getBusinessKey();
        ProcInstStatus procInstStatus = payload.getProcInstStatus();
        BorrowMoneyPayload borrowMoneyPayload = new BorrowMoneyPayload();
        borrowMoneyPayload.setId(Long.valueOf(Long.parseLong(businessKey)));
        BorrowMoneyVO borrowMoneyVO = this.service.queryByKey(Long.valueOf(businessKey));
        if (borrowMoneyVO != null) {
            switch (procInstStatus) {
                case NOTSUBMIT: {
                    borrowMoneyPayload.setProcInstStatus(ProcInstStatus.NOTSUBMIT);
                    borrowMoneyPayload.setApprStatus(BorrowStatusEnum.CREATE.getCode());
                    break;
                }
                case INTERRUPT: {
                    borrowMoneyPayload.setNullFields(Arrays.asList("procInstStatus", "procInstId", "submitTime"));
                    break;
                }
                case INVALID: {
                    borrowMoneyPayload.setDeleteFlag(Integer.valueOf(1));
                    borrowMoneyPayload.setProcInstStatus(ProcInstStatus.INVALID);
                    break;
                }
                case REJECTED: {
                    borrowMoneyPayload.setProcInstStatus(ProcInstStatus.REJECTED);
                    break;
                }
                case APPROVED: {
                    borrowMoneyPayload.setProcInstStatus(ProcInstStatus.APPROVED);
                    borrowMoneyPayload.setApprovedTime(LocalDateTime.now());
                    borrowMoneyPayload.setApprStatus(BorrowStatusEnum.PAID.getCode());
                    break;
                }
                case APPROVING: {
                    borrowMoneyPayload.setProcInstStatus(ProcInstStatus.APPROVING);
                    borrowMoneyPayload.setApprStatus(BorrowStatusEnum.APPROVING.getCode());
                }
            }
            this.service.updateByKeyDynamic(borrowMoneyPayload);
        }
        return WorkflowResult.success(null);
    }
}

