/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5.server.prd.common;

import com.elitescloud.cloudt.system.vo.SysUserDTO;
import com.elitesland.tw.tw5.api.common.util.TreeListUtil;
import com.elitesland.tw.tw5.api.prd.org.service.PrdOrgOrganizationService;
import com.elitesland.tw.tw5.api.prd.org.vo.PrdOrgDataRefVO;
import com.elitesland.tw.tw5.api.prd.org.vo.PrdOrgEmployeeRefVO;
import com.elitesland.tw.tw5.api.prd.org.vo.PrdOrgEmployeeVO;
import com.elitesland.tw.tw5.api.prd.org.vo.PrdOrgOrganizationRefVO;
import com.elitesland.tw.tw5.api.prd.org.vo.PrdOrgOrganizationVO;
import com.elitesland.tw.tw5.api.prd.partner.common.vo.BusinessPartnerVO;
import com.elitesland.tw.tw5.api.prd.system.query.PrdSystemFunctionDataQuery;
import com.elitesland.tw.tw5.api.prd.system.query.PrdSystemFunctionQuery;
import com.elitesland.tw.tw5.api.prd.system.query.PrdSystemFunctionSpecialQuery;
import com.elitesland.tw.tw5.api.prd.system.query.PrdSystemRemindQuery;
import com.elitesland.tw.tw5.api.prd.system.query.PrdSystemSelectionQuery;
import com.elitesland.tw.tw5.api.prd.system.query.PrdSystemSettingQuery;
import com.elitesland.tw.tw5.api.prd.system.query.PrdSystemTagQuery;
import com.elitesland.tw.tw5.api.prd.system.vo.PrdSystemConfigVO;
import com.elitesland.tw.tw5.api.prd.system.vo.PrdSystemFunctionDataVO;
import com.elitesland.tw.tw5.api.prd.system.vo.PrdSystemFunctionSpecialVO;
import com.elitesland.tw.tw5.api.prd.system.vo.PrdSystemFunctionVO;
import com.elitesland.tw.tw5.api.prd.system.vo.PrdSystemRemindVO;
import com.elitesland.tw.tw5.api.prd.system.vo.PrdSystemSelectionVO;
import com.elitesland.tw.tw5.api.prd.system.vo.PrdSystemSettingVO;
import com.elitesland.tw.tw5.api.prd.system.vo.PrdSystemShortcutVO;
import com.elitesland.tw.tw5.api.prd.system.vo.PrdSystemTagVO;
import com.elitesland.tw.tw5.server.common.TwException;
import com.elitesland.tw.tw5.server.common.util.RedisUtils;
import com.elitesland.tw.tw5.server.prd.common.GlobalUtil;
import com.elitesland.tw.tw5.server.prd.common.functionEnum.OrgEnum;
import com.elitesland.tw.tw5.server.prd.common.functionEnum.RoleEnum;
import com.elitesland.tw.tw5.server.prd.my.dao.PrdUserDAO;
import com.elitesland.tw.tw5.server.prd.org.convert.PrdOrgEmployeeConvert;
import com.elitesland.tw.tw5.server.prd.org.convert.PrdOrgOrganizationConvert;
import com.elitesland.tw.tw5.server.prd.org.dao.PrdOrgEmployeeDAO;
import com.elitesland.tw.tw5.server.prd.org.dao.PrdOrgOrganizationDAO;
import com.elitesland.tw.tw5.server.prd.org.entity.PrdOrgEmployeeDO;
import com.elitesland.tw.tw5.server.prd.org.entity.PrdOrgOrganizationDO;
import com.elitesland.tw.tw5.server.prd.partner.common.dao.BusinessPartnerDAO;
import com.elitesland.tw.tw5.server.prd.system.dao.PrdSystemConfigDAO;
import com.elitesland.tw.tw5.server.prd.system.dao.PrdSystemFunctionDAO;
import com.elitesland.tw.tw5.server.prd.system.dao.PrdSystemFunctionDataDAO;
import com.elitesland.tw.tw5.server.prd.system.dao.PrdSystemFunctionSpecialDAO;
import com.elitesland.tw.tw5.server.prd.system.dao.PrdSystemNewFunctionDAO;
import com.elitesland.tw.tw5.server.prd.system.dao.PrdSystemRemindDAO;
import com.elitesland.tw.tw5.server.prd.system.dao.PrdSystemRoleDAO;
import com.elitesland.tw.tw5.server.prd.system.dao.PrdSystemSelectionDAO;
import com.elitesland.tw.tw5.server.prd.system.dao.PrdSystemSettingDAO;
import com.elitesland.tw.tw5.server.prd.system.dao.PrdSystemTagDAO;
import com.elitesland.tw.tw5.server.yeedoc.service.YeedocService;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Component;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

@Component
public class CacheUtil {
    @Autowired
    private PrdSystemRemindDAO systemRemindDAO;
    @Autowired
    private PrdSystemSelectionDAO prdSystemSelectionDAO;
    @Autowired
    private PrdSystemTagDAO prdSystemTagDAO;
    @Autowired
    private PrdSystemSettingDAO prdSystemSettingDAO;
    @Autowired
    private RedisUtils redisUtils;
    @Autowired
    private PrdSystemFunctionDAO prdSystemFunctionDAO;
    @Autowired
    private PrdSystemFunctionSpecialDAO prdSystemFunctionSpecialDAO;
    @Autowired
    private PrdSystemFunctionDataDAO prdSystemFunctionDataDAO;
    @Autowired
    private PrdSystemConfigDAO prdSystemConfigDAO;
    @Autowired
    private PrdSystemNewFunctionDAO prdSystemNewFunctionDAO;
    @Autowired
    private PrdOrgEmployeeDAO employeeDAO;
    @Autowired
    private PrdOrgOrganizationDAO orgOrganizationDAO;
    @Autowired
    private PrdSystemRoleDAO systemRoleDAO;
    @Autowired
    private PrdUserDAO prdUserDAO;
    @Autowired
    private YeedocService yeedocService;
    @Autowired
    private BusinessPartnerDAO businessPartnerDAO;
    @Lazy
    @Autowired
    private PrdOrgOrganizationService organizationService;
    private final Map<Long, String> userRoleMaps = new HashMap<Long, String>();
    private final Map<String, PrdSystemRemindVO> remindCacheMap = new HashMap<String, PrdSystemRemindVO>();
    private final Map<String, PrdSystemSelectionVO> systemSelectionCacheMap = new HashMap<String, PrdSystemSelectionVO>();
    private final List<PrdSystemTagVO> systemTagCacheMap = new ArrayList<PrdSystemTagVO>();
    private final Map<String, PrdSystemSettingVO> systemSettingCacheMap = new HashMap<String, PrdSystemSettingVO>();
    private final Map<String, PrdSystemFunctionVO> systemFunctionCacheMap = new HashMap<String, PrdSystemFunctionVO>();
    private final Map<Long, PrdSystemFunctionVO> systemFunctionCacheMap0 = new HashMap<Long, PrdSystemFunctionVO>();
    private final Map<String, PrdSystemFunctionSpecialVO> systemFunctionSpecialCacheMap = new HashMap<String, PrdSystemFunctionSpecialVO>();
    private final Map<Long, List<PrdSystemFunctionDataVO>> systemFunctionDataCacheMap = new HashMap<Long, List<PrdSystemFunctionDataVO>>();
    private final Map<String, PrdSystemConfigVO> systemConfigCacheMap = new HashMap<String, PrdSystemConfigVO>();
    private final Map<Long, PrdOrgEmployeeVO> employeeCacheMap = new HashMap<Long, PrdOrgEmployeeVO>();
    private final Map<Long, PrdOrgOrganizationRefVO> buLevel1Map = new HashMap<Long, PrdOrgOrganizationRefVO>();
    private final Map<Long, List<Long>> orgChildMap = new HashMap<Long, List<Long>>();
    private final Map<String, Long> objFunctionMap = new HashMap<String, Long>();
    private final Map<Long, List<Long>> allOrgChildMap = new HashMap<Long, List<Long>>();
    private final List<PrdSystemShortcutVO> systemShortcutCache = new ArrayList<PrdSystemShortcutVO>();
    private final Map<Long, BusinessPartnerVO> companyCacheMap = new HashMap<Long, BusinessPartnerVO>();
    private final Map<Long, BusinessPartnerVO> companyBookCacheMap = new HashMap<Long, BusinessPartnerVO>();
    private final Map<Long, PrdOrgEmployeeRefVO> orgEmployeeRefCacheMap = new HashMap<Long, PrdOrgEmployeeRefVO>();
    private final Map<String, List<Long>> roleCodeUserIdsMap = new HashMap<String, List<Long>>();
    private static final String ORGANIZATION_CACHE_KEY = "ORGANIZATION_CACHE_KEY";
    private static final String EMPLOYEES_ORGANIZATION_CACHE_KEY = "EMPLOYEES_ORGANIZATION_CACHE_KEY";
    private static final String EMPLOYEES_CACHE_KEY = "EMPLOYEES_CACHE_KEY";
    private static final String EMPLOYEES_DEFAULT_ORGANIZATION_INFO_CACHE_KEY = "EMPLOYEES_DEFAULT_ORGANIZATION_INFO_CACHE_KEY";
    private static long lastLoadTimeRemind = 0L;
    private static long lastLoadTimeSystemSelection = 0L;
    private static long lastLoadTimeSystemSetting = 0L;
    private static long lastLoadTimeSystemFunction = 0L;
    private static long lastLoadTimeSystemFunctionSpecial = 0L;
    private static long lastLoadTimeSystemFunctionData = 0L;
    private static long lastLoadTimeSystemConfig = 0L;
    private static long lastLoadTimeSystemTag = 0L;
    private static long lastLoadTimeSystemNewFunction = 0L;
    private static long lastLoadTimeSystemResStatus = 0L;
    private static long lastLoadTimeBULevel1 = 0L;

    public void clearSystemCache(Integer clearType) {
        if (clearType == null || clearType == 0) {
            this.remindCacheMap.clear();
            this.systemSelectionCacheMap.clear();
            this.systemTagCacheMap.clear();
            this.systemTagCacheMap.clear();
            this.systemSettingCacheMap.clear();
            this.systemFunctionCacheMap.clear();
            this.systemFunctionCacheMap0.clear();
            this.systemFunctionSpecialCacheMap.clear();
            this.systemFunctionDataCacheMap.clear();
            this.systemConfigCacheMap.clear();
            this.objFunctionMap.clear();
            this.userRoleMaps.clear();
            this.employeeCacheMap.clear();
            this.orgChildMap.clear();
            this.allOrgChildMap.clear();
            this.companyCacheMap.clear();
            this.companyBookCacheMap.clear();
            this.orgEmployeeRefCacheMap.clear();
            this.buLevel1Map.clear();
        } else if (clearType == 1) {
            this.remindCacheMap.clear();
            this.systemSelectionCacheMap.clear();
            this.systemTagCacheMap.clear();
            this.systemTagCacheMap.clear();
            this.systemSettingCacheMap.clear();
            this.systemFunctionCacheMap.clear();
            this.systemFunctionCacheMap0.clear();
            this.systemFunctionSpecialCacheMap.clear();
            this.systemFunctionDataCacheMap.clear();
            this.systemConfigCacheMap.clear();
            this.objFunctionMap.clear();
        } else if (clearType == 2) {
            this.userRoleMaps.clear();
            this.employeeCacheMap.clear();
            this.orgChildMap.clear();
            this.allOrgChildMap.clear();
            this.companyCacheMap.clear();
            this.companyBookCacheMap.clear();
            this.orgEmployeeRefCacheMap.clear();
            this.buLevel1Map.clear();
        }
    }

    public void loadSystemTagCache() {
        this.systemTagCacheMap.clear();
        List<PrdSystemTagVO> functionVOs = this.prdSystemTagDAO.queryListDynamic(new PrdSystemTagQuery());
        functionVOs.forEach(functionVO -> this.systemTagCacheMap.add((PrdSystemTagVO)functionVO));
        lastLoadTimeSystemTag = new Date().getTime();
    }

    public List<PrdSystemTagVO> getSystemTag(Long id) {
        if (id == null) {
            if ((this.systemTagCacheMap == null || this.systemTagCacheMap.size() == 0) && this.shouldLoadCache(lastLoadTimeSystemTag)) {
                this.loadSystemTagCache();
            }
            return this.systemTagCacheMap;
        }
        List<PrdSystemTagVO> functionVOs = this.systemTagCacheMap.stream().filter(systemTag -> systemTag.getId().longValue() == id.longValue()).collect(Collectors.toList());
        if ((functionVOs == null || functionVOs.size() == 0) && this.shouldLoadCache(lastLoadTimeSystemTag)) {
            this.loadSystemTagCache();
            List<PrdSystemTagVO> functionVO0 = this.systemTagCacheMap.stream().filter(systemTag -> systemTag.getId().longValue() == id.longValue()).collect(Collectors.toList());
            return functionVO0;
        }
        return functionVOs;
    }

    public void loadSystemConfigCache() {
        this.systemConfigCacheMap.clear();
        List<PrdSystemConfigVO> functionVOs = this.prdSystemConfigDAO.queryListDynamic();
        functionVOs.forEach(functionVO -> this.systemConfigCacheMap.put(functionVO.getConfigCode(), (PrdSystemConfigVO)functionVO));
        lastLoadTimeSystemConfig = new Date().getTime();
    }

    public PrdSystemConfigVO getSystemConfig(String code) {
        PrdSystemConfigVO functionVO = this.systemConfigCacheMap.get(code);
        if (functionVO == null && this.shouldLoadCache(lastLoadTimeSystemConfig)) {
            this.loadSystemConfigCache();
            return this.systemConfigCacheMap.get(code);
        }
        return functionVO;
    }

    public void loadSystemFunctionDataCache() {
        this.systemFunctionDataCacheMap.clear();
        PrdSystemFunctionDataQuery query = new PrdSystemFunctionDataQuery();
        List<PrdSystemFunctionDataVO> functionVOs = this.prdSystemFunctionDataDAO.queryListDynamic(query);
        functionVOs.forEach(functionVO -> {
            Long functionId = functionVO.getFunctionId();
            List<PrdSystemFunctionDataVO> list = this.systemFunctionDataCacheMap.get(functionId);
            if (list != null && list.size() > 0) {
                list.add((PrdSystemFunctionDataVO)functionVO);
            } else {
                list = new ArrayList<PrdSystemFunctionDataVO>();
                list.add((PrdSystemFunctionDataVO)functionVO);
                this.systemFunctionDataCacheMap.put(functionId, list);
            }
        });
        lastLoadTimeSystemFunctionData = new Date().getTime();
    }

    public List<PrdSystemFunctionDataVO> getFunctionData(Long functionId) {
        List<PrdSystemFunctionDataVO> list = this.systemFunctionDataCacheMap.get(functionId);
        if (list == null && this.shouldLoadCache(lastLoadTimeSystemFunctionData)) {
            this.loadSystemFunctionDataCache();
            return this.systemFunctionDataCacheMap.get(functionId);
        }
        return list;
    }

    public void loadSystemFunctionSpecialCache() {
        this.systemFunctionSpecialCacheMap.clear();
        PrdSystemFunctionSpecialQuery query = new PrdSystemFunctionSpecialQuery();
        List<PrdSystemFunctionSpecialVO> functionVOs = this.prdSystemFunctionSpecialDAO.queryListDynamic(query);
        functionVOs.forEach(functionVO -> this.systemFunctionSpecialCacheMap.put(functionVO.getSpecialUrl(), (PrdSystemFunctionSpecialVO)functionVO));
        lastLoadTimeSystemFunctionSpecial = new Date().getTime();
    }

    public PrdSystemFunctionSpecialVO getFunctionSpecial(String url) {
        PrdSystemFunctionSpecialVO functionVO = this.systemFunctionSpecialCacheMap.get(url);
        if (functionVO == null && this.shouldLoadCache(lastLoadTimeSystemFunctionSpecial)) {
            this.loadSystemFunctionSpecialCache();
            return this.systemFunctionSpecialCacheMap.get(url);
        }
        return functionVO;
    }

    public void loadSystemFunctionCache() {
        this.systemFunctionCacheMap.clear();
        this.systemFunctionCacheMap0.clear();
        PrdSystemFunctionQuery query = new PrdSystemFunctionQuery();
        List<PrdSystemFunctionVO> functionVOs = this.prdSystemFunctionDAO.queryListDynamic(query);
        functionVOs.forEach(functionVO -> {
            this.systemFunctionCacheMap.put(functionVO.getFunctionCode(), (PrdSystemFunctionVO)functionVO);
            this.systemFunctionCacheMap0.put(functionVO.getId(), (PrdSystemFunctionVO)functionVO);
        });
        TreeListUtil.toTree(functionVOs);
        lastLoadTimeSystemFunction = new Date().getTime();
    }

    public PrdSystemFunctionVO getFunctionById(Long id) {
        PrdSystemFunctionVO functionVO = this.systemFunctionCacheMap0.get(id);
        if (functionVO == null && this.shouldLoadCache(lastLoadTimeSystemFunction)) {
            this.loadSystemFunctionCache();
            return this.systemFunctionCacheMap0.get(id);
        }
        return functionVO;
    }

    public PrdSystemFunctionVO getFunction(String functionCode) {
        PrdSystemFunctionVO functionVO = this.systemFunctionCacheMap.get(functionCode);
        if (functionVO == null && this.shouldLoadCache(lastLoadTimeSystemFunction)) {
            this.loadSystemFunctionCache();
            return this.systemFunctionCacheMap.get(functionCode);
        }
        return functionVO;
    }

    public void loadRemindCache() {
        this.remindCacheMap.clear();
        PrdSystemRemindQuery query = new PrdSystemRemindQuery();
        List<PrdSystemRemindVO> remindViews = this.systemRemindDAO.queryListDynamic(query);
        remindViews.forEach(remindView -> this.remindCacheMap.put(remindView.getRemindCode(), (PrdSystemRemindVO)remindView));
        lastLoadTimeRemind = new Date().getTime();
    }

    public PrdSystemRemindVO getRemind(String remindCode) {
        PrdSystemRemindVO remindView = this.remindCacheMap.get(remindCode);
        if (remindView == null && this.shouldLoadCache(lastLoadTimeRemind)) {
            this.loadRemindCache();
            return this.remindCacheMap.get(remindCode);
        }
        return remindView;
    }

    private boolean shouldLoadCache(long lastLoadTime) {
        long interval = 3600000L;
        return new Date().getTime() - lastLoadTime > interval;
    }

    public void loadSystemSelectionCache() {
        this.systemSelectionCacheMap.clear();
        PrdSystemSelectionQuery query = new PrdSystemSelectionQuery();
        List<PrdSystemSelectionVO> selectionViews = this.prdSystemSelectionDAO.queryListDynamic(query);
        selectionViews.forEach(selectionView -> this.systemSelectionCacheMap.put(selectionView.getSelectionKey(), (PrdSystemSelectionVO)selectionView));
        TreeListUtil.toTree(selectionViews);
        lastLoadTimeSystemSelection = new Date().getTime();
    }

    public String transferSystemSelection(String selectionKey, String value) {
        if (value == null) {
            return null;
        }
        PrdSystemSelectionVO selection = this.getSystemSelection(selectionKey);
        String result = value;
        if (selection == null) {
            return result;
        }
        ArrayList<PrdSystemSelectionVO> children = new ArrayList<PrdSystemSelectionVO>();
        this.getAllChildren(selection, children);
        if (children != null && children.size() > 0) {
            for (PrdSystemSelectionVO selectionView : children) {
                if (!value.equals(selectionView.getSelectionValue())) continue;
                result = selectionView.getSelectionName();
            }
        }
        return result;
    }

    public PrdSystemSelectionVO querySystemSelection(String selectionKey, String value) {
        if (value == null) {
            return null;
        }
        PrdSystemSelectionVO selection = this.getSystemSelection(selectionKey);
        PrdSystemSelectionVO result = null;
        if (selection == null) {
            return result;
        }
        ArrayList<PrdSystemSelectionVO> children = new ArrayList<PrdSystemSelectionVO>();
        this.getAllChildren(selection, children);
        if (children != null && children.size() > 0) {
            for (PrdSystemSelectionVO selectionView : children) {
                if (!value.equals(selectionView.getSelectionValue())) continue;
                result = selectionView;
            }
        }
        return result;
    }

    public BigDecimal queryEqvaRatioByJob(String job) {
        if (!StringUtils.hasText((String)job)) {
            throw TwException.error("", "\u5c97\u4f4d\u4e0d\u53ef\u4e3a\u7a7a");
        }
        PrdSystemSelectionVO prdSystemSelectionVO = this.querySystemSelection("org:employee:job", job);
        if (prdSystemSelectionVO == null) {
            throw TwException.error("", "\u5c97\u4f4d\u6570\u636e\u672a\u5339\u914d");
        }
        String extString1 = prdSystemSelectionVO.getExtString1();
        if (StringUtils.hasText((String)extString1)) {
            return new BigDecimal(extString1);
        }
        throw TwException.error("", "\u672a\u6b63\u786e\u914d\u7f6e\u5c97\u4f4d\u548c\u7cfb\u6570\u5bf9\u5e94\u5173\u7cfb\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458");
    }

    public PrdSystemSelectionVO transferSystemObjByName(String selectionKey, String name) {
        if (name == null) {
            return null;
        }
        PrdSystemSelectionVO selection = this.getSystemSelection(selectionKey);
        if (selection == null) {
            return null;
        }
        ArrayList<PrdSystemSelectionVO> children = new ArrayList<PrdSystemSelectionVO>();
        this.getAllChildren(selection, children);
        if (children != null && children.size() > 0) {
            for (PrdSystemSelectionVO selectionView : children) {
                if (!name.equals(selectionView.getSelectionName())) continue;
                selection = selectionView;
                break;
            }
        }
        return selection;
    }

    public void getAllChildren(PrdSystemSelectionVO parent, List<PrdSystemSelectionVO> allChildren) {
        if (CollectionUtils.isEmpty((Collection)parent.getChildren())) {
            return;
        }
        allChildren.addAll(parent.getChildren());
        for (PrdSystemSelectionVO child : parent.getChildren()) {
            this.getAllChildren(child, allChildren);
        }
    }

    public String getSystemSelectionValueByName(String selectionKey, String name) {
        if (!StringUtils.hasText((String)name)) {
            return null;
        }
        name = name.trim();
        PrdSystemSelectionVO selection = this.getSystemSelection(selectionKey);
        String result = name;
        if (selection == null) {
            return result;
        }
        List children = selection.getChildren();
        if (children != null && children.size() > 0) {
            for (PrdSystemSelectionVO selectionView : children) {
                if (!name.equals(selectionView.getSelectionName())) continue;
                result = selectionView.getSelectionValue();
            }
        }
        return result;
    }

    public String getSystemSelectionNameByValue(String selectionKey, String value) {
        if (!StringUtils.hasText((String)value)) {
            return null;
        }
        value = value.trim();
        PrdSystemSelectionVO selection = this.getSystemSelection(selectionKey);
        String result = value;
        if (selection == null) {
            return result;
        }
        List children = selection.getChildren();
        if (children != null && children.size() > 0) {
            for (PrdSystemSelectionVO selectionView : children) {
                if (!value.equals(selectionView.getSelectionValue())) continue;
                result = selectionView.getSelectionName();
            }
        }
        return result;
    }

    public Integer transferSystemSelectionSortIndex(String selectionKey, String value) {
        if (value == null) {
            return null;
        }
        PrdSystemSelectionVO selection = this.getSystemSelection(selectionKey);
        Integer result = 0;
        if (selection == null) {
            return result;
        }
        List children = selection.getChildren();
        if (children != null && children.size() > 0) {
            for (PrdSystemSelectionVO selectionView : children) {
                if (!value.equals(selectionView.getSelectionValue())) continue;
                result = selectionView.getSortNo() == null ? 0 : selectionView.getSortNo();
            }
        }
        return result;
    }

    public PrdSystemSelectionVO getSystemSelection(String selectionKey) {
        PrdSystemSelectionVO prdSystemSelectionVO = this.systemSelectionCacheMap.get(selectionKey);
        if (prdSystemSelectionVO == null && this.shouldLoadCache(lastLoadTimeSystemSelection)) {
            this.loadSystemSelectionCache();
            return this.systemSelectionCacheMap.get(selectionKey);
        }
        return prdSystemSelectionVO;
    }

    public void loadSystemSettingCache() {
        this.systemSettingCacheMap.clear();
        PrdSystemSettingQuery query = new PrdSystemSettingQuery();
        List<PrdSystemSettingVO> systemSettingViews = this.prdSystemSettingDAO.queryListDynamic(query);
        systemSettingViews.forEach(systemSettingView -> this.systemSettingCacheMap.put(systemSettingView.getSettingKey(), (PrdSystemSettingVO)systemSettingView));
        lastLoadTimeSystemSetting = new Date().getTime();
    }

    public PrdSystemSettingVO getSystemSetting(String settingKey) {
        PrdSystemSettingVO systemSettingView = this.systemSettingCacheMap.get(settingKey);
        if (systemSettingView == null && this.shouldLoadCache(lastLoadTimeSystemSetting)) {
            this.loadSystemSettingCache();
            return this.systemSettingCacheMap.get(settingKey);
        }
        return systemSettingView;
    }

    public String getUserName(Long userId) {
        if (userId == null) {
            return "";
        }
        PrdOrgEmployeeVO employeeVO = this.employeeCacheMap.get(userId);
        if (employeeVO == null) {
            PrdOrgEmployeeVO prdOrgEmployeeVO = this.employeeDAO.queryWholeByUserId(userId);
            if (prdOrgEmployeeVO == null) {
                return null;
            }
            this.employeeCacheMap.put(userId, prdOrgEmployeeVO);
            employeeVO = this.employeeCacheMap.get(userId);
        }
        return employeeVO.getEmployeeName();
    }

    public Long getUserIdByName(String employeeName) {
        String key = "EMPLOYEES_CACHE_KEY:" + employeeName;
        PrdOrgEmployeeVO vo = (PrdOrgEmployeeVO)this.redisUtils.get(key);
        if (vo == null) {
            PrdOrgEmployeeDO employeeDO = this.employeeDAO.queryByUserName(employeeName);
            if (employeeDO == null) {
                return null;
            }
            PrdOrgEmployeeVO orgEmployeeVO = PrdOrgEmployeeConvert.INSTANCE.toVo(employeeDO);
            this.redisUtils.set(key, orgEmployeeVO, 10L, TimeUnit.MINUTES);
            return orgEmployeeVO.getUserId();
        }
        return vo.getUserId();
    }

    public List<String> queryRepeatedNameByUserName(List<String> employeeNameList) {
        return this.employeeDAO.queryRepeatedNameByUserName(employeeNameList);
    }

    public Long getDefaultOrgIdByUserId(Long userId) {
        List list;
        List<PrdOrgDataRefVO> prdOrgDataRefVOS;
        if (null == userId) {
            return null;
        }
        String key = "EMPLOYEES_ORGANIZATION_CACHE_KEY:" + userId;
        Long orgId = (Long)this.redisUtils.get(key);
        if (orgId == null && !org.springframework.util.CollectionUtils.isEmpty(prdOrgDataRefVOS = this.prdUserDAO.queryOrgListByKey(userId)) && !org.springframework.util.CollectionUtils.isEmpty(list = prdOrgDataRefVOS.stream().filter(prdOrgDataRefVO -> prdOrgDataRefVO.getIsDefault().equals(0)).collect(Collectors.toList()))) {
            Long orgIdDb = ((PrdOrgDataRefVO)list.get(0)).getOrgId();
            if (null == orgIdDb) {
                return null;
            }
            this.redisUtils.set(key, orgIdDb, 10L, TimeUnit.MINUTES);
            return orgIdDb;
        }
        return orgId;
    }

    public String getOrgName(Long ordId) {
        if (ordId == null) {
            return "";
        }
        String key = "ORGANIZATION_CACHE_KEY:" + ordId;
        PrdOrgOrganizationVO vo = (PrdOrgOrganizationVO)this.redisUtils.get(key);
        if (vo == null) {
            PrdOrgOrganizationVO prdOrgOrganizationVO = this.orgOrganizationDAO.queryByIdWhole(ordId);
            if (prdOrgOrganizationVO == null) {
                return null;
            }
            this.redisUtils.set(key, prdOrgOrganizationVO, 10L, TimeUnit.MINUTES);
            return prdOrgOrganizationVO.getOrgName();
        }
        return vo.getOrgName();
    }

    public PrdOrgOrganizationVO getOrg(Long orgId) {
        if (orgId == null) {
            return null;
        }
        String key = "ORGANIZATION_CACHE_KEY:" + orgId;
        Object object = this.redisUtils.get(key);
        if (object == null) {
            PrdOrgOrganizationVO prdOrgOrganizationVO = this.orgOrganizationDAO.queryByIdWhole(orgId);
            if (prdOrgOrganizationVO == null) {
                return null;
            }
            this.redisUtils.set(key, prdOrgOrganizationVO, 10L, TimeUnit.MINUTES);
            return prdOrgOrganizationVO;
        }
        PrdOrgOrganizationVO vo = (PrdOrgOrganizationVO)object;
        return vo;
    }

    public Long getOrgIdByOrgName(String orgName) {
        String key = "ORGANIZATION_CACHE_KEY:" + orgName;
        PrdOrgOrganizationVO vo = (PrdOrgOrganizationVO)this.redisUtils.get(key);
        if (vo == null) {
            PrdOrgOrganizationDO prdOrgOrganizationDO = this.orgOrganizationDAO.queryByName(orgName);
            if (prdOrgOrganizationDO == null) {
                return null;
            }
            PrdOrgOrganizationVO prdOrgOrganizationVO = PrdOrgOrganizationConvert.INSTANCE.toVo(prdOrgOrganizationDO);
            this.redisUtils.set(key, prdOrgOrganizationVO, 10L, TimeUnit.MINUTES);
            return prdOrgOrganizationVO.getId();
        }
        return vo.getId();
    }

    public PrdOrgEmployeeVO getEmployee(Long userId) {
        PrdOrgEmployeeVO employeeVO = this.employeeCacheMap.get(userId);
        if (employeeVO == null || this.shouldLoadCache(lastLoadTimeSystemResStatus)) {
            PrdOrgEmployeeVO prdOrgEmployeeVO = this.employeeDAO.queryWholeByUserId(userId);
            if (prdOrgEmployeeVO == null) {
                return null;
            }
            this.employeeCacheMap.put(userId, prdOrgEmployeeVO);
            employeeVO = this.employeeCacheMap.get(userId);
            lastLoadTimeSystemResStatus = new Date().getTime();
        }
        return employeeVO;
    }

    public Boolean hasSystemRolePermission(List<String> roleList) {
        Long loginUserId = GlobalUtil.getLoginUserId();
        String longString = this.userRoleMaps.get(loginUserId);
        if (!StringUtils.hasText((String)longString) || this.shouldLoadCache(Long.valueOf(longString.split(",")[0]))) {
            this.loadSystemRoleCache(loginUserId);
            return this.hasSystemRolePermission(roleList);
        }
        List<String> stringList = Arrays.asList(longString.split(","));
        for (String roleCode : roleList) {
            if (!stringList.contains(roleCode)) continue;
            return true;
        }
        return false;
    }

    public Boolean hasSystemRolePermission(String ... args) {
        if (!ObjectUtils.isEmpty((Object[])args)) {
            return this.hasSystemRolePermission(Arrays.asList(args));
        }
        return false;
    }

    public boolean isSystemAdmin() {
        return GlobalUtil.getLoginGeneralUser().isSystemAdmin() || this.hasSystemRolePermission(RoleEnum.SYS.getCode()) != false;
    }

    public List<String> getSystemRoleCodes(Long userId) {
        String roleCodesStr = this.userRoleMaps.get(userId);
        if (!StringUtils.hasText((String)roleCodesStr) || this.shouldLoadCache(Long.valueOf(roleCodesStr.split(",")[0]))) {
            this.loadSystemRoleCache(userId);
            roleCodesStr = this.userRoleMaps.get(userId);
        }
        if (StringUtils.hasText((String)roleCodesStr)) {
            List<String> roleCodes = Arrays.asList(roleCodesStr.split(","));
            return roleCodes;
        }
        return new ArrayList<String>();
    }

    public void loadSystemRoleCache(Long loginUserId) {
        List<String> roleCodes = this.systemRoleDAO.queryUserRoleCodes(loginUserId);
        Object str = "" + new Date().getTime();
        if (!ObjectUtils.isEmpty(roleCodes)) {
            str = ((String)str).concat(",").concat(StringUtils.collectionToCommaDelimitedString(roleCodes));
        }
        this.userRoleMaps.put(loginUserId, (String)str);
    }

    public PrdOrgDataRefVO getDefaultOrgInfoByUserId(Long userId) {
        List list;
        List<PrdOrgDataRefVO> prdOrgDataRefVOS;
        if (null == userId) {
            return null;
        }
        String key = "EMPLOYEES_DEFAULT_ORGANIZATION_INFO_CACHE_KEY:" + userId;
        PrdOrgDataRefVO result = (PrdOrgDataRefVO)this.redisUtils.get(key);
        if (result == null && !org.springframework.util.CollectionUtils.isEmpty(prdOrgDataRefVOS = this.prdUserDAO.queryOrgListByKey(userId)) && !org.springframework.util.CollectionUtils.isEmpty(list = prdOrgDataRefVOS.stream().filter(prdOrgDataRefVO -> prdOrgDataRefVO.getIsDefault().equals(0)).collect(Collectors.toList()))) {
            PrdOrgDataRefVO prdOrgDataRefVO2 = (PrdOrgDataRefVO)list.get(0);
            if (null == prdOrgDataRefVO2) {
                return null;
            }
            this.redisUtils.set(key, prdOrgDataRefVO2, 10L, TimeUnit.MINUTES);
            return prdOrgDataRefVO2;
        }
        return result;
    }

    public Long getObjectIdByFunctionCode(String code) {
        Long objectId = this.objFunctionMap.get(code);
        if (ObjectUtils.isEmpty((Object)objectId) && this.shouldLoadCache(lastLoadTimeSystemNewFunction)) {
            this.loadSystemNewFunctionCache(code);
            return this.objFunctionMap.get(code);
        }
        return objectId;
    }

    private void loadSystemNewFunctionCache(String code) {
        Long objectId = this.prdSystemNewFunctionDAO.getObjectIdByFunctionCode(code);
        this.objFunctionMap.put(code, objectId);
        lastLoadTimeSystemNewFunction = new Date().getTime();
    }

    public List<Long> getAllChildOrgIds(Long orgId) {
        if (this.orgChildMap.containsKey(orgId)) {
            return this.orgChildMap.get(orgId);
        }
        Set<Long> childOrgIds = this.orgOrganizationDAO.queryAllChildOrgs(Collections.singleton(orgId));
        if (org.springframework.util.CollectionUtils.isEmpty(childOrgIds)) {
            return new ArrayList<Long>();
        }
        this.orgChildMap.put(orgId, new ArrayList<Long>(childOrgIds));
        return this.orgChildMap.get(orgId);
    }

    public String getCompanyName(Long companyId) {
        if (companyId == null) {
            return null;
        }
        BusinessPartnerVO businessPartnerVO = this.companyCacheMap.get(companyId);
        if (businessPartnerVO == null) {
            businessPartnerVO = this.businessPartnerDAO.findById(companyId);
            if (businessPartnerVO == null) {
                return null;
            }
            this.companyCacheMap.put(companyId, businessPartnerVO);
        }
        return businessPartnerVO.getPartnerName();
    }

    public String getCompanyNameByBookId(Long bookId) {
        if (bookId == null) {
            return null;
        }
        BusinessPartnerVO businessPartnerVO = this.companyBookCacheMap.get(bookId);
        if (businessPartnerVO == null) {
            List<BusinessPartnerVO> businessPartnerVOList = this.businessPartnerDAO.queryByBookId(bookId);
            if (org.springframework.util.CollectionUtils.isEmpty(businessPartnerVOList)) {
                return null;
            }
            businessPartnerVO = businessPartnerVOList.get(0);
            this.companyBookCacheMap.put(bookId, businessPartnerVO);
        }
        return businessPartnerVO.getPartnerName();
    }

    public List<Long> getUserIdByRoleCodes(List<String> roleCodes) {
        if (roleCodes == null) {
            return null;
        }
        HashSet userIds = new HashSet();
        roleCodes.forEach(code -> {
            List<Long> longs = this.roleCodeUserIdsMap.get(code);
            if (ObjectUtils.isEmpty(longs)) {
                longs = this.systemRoleDAO.queryUserIdByRoleCode((String)code);
            }
            if (ObjectUtils.isEmpty(longs)) {
                this.roleCodeUserIdsMap.put((String)code, longs);
                userIds.addAll(new HashSet<Long>(longs));
            }
        });
        return new ArrayList<Long>(userIds);
    }

    public PrdOrgOrganizationRefVO getUserBuLevel1(Long userId) {
        if (userId == null) {
            return null;
        }
        PrdOrgEmployeeRefVO employeeRefVO = this.orgEmployeeRefCacheMap.get(userId);
        if (employeeRefVO == null) {
            employeeRefVO = this.employeeDAO.queryUserOrgData(userId);
            if (employeeRefVO == null) {
                return null;
            }
            this.orgEmployeeRefCacheMap.put(userId, employeeRefVO);
        }
        return this.getBULevel1ByOrgId(employeeRefVO.getOrgId());
    }

    public PrdOrgEmployeeRefVO getUserDefaultOrg(Long userId) {
        if (userId == null) {
            return null;
        }
        PrdOrgEmployeeRefVO employeeRefVO = this.orgEmployeeRefCacheMap.get(userId);
        if (employeeRefVO == null) {
            employeeRefVO = this.employeeDAO.queryUserOrgData(userId);
            if (employeeRefVO == null) {
                return null;
            }
            this.orgEmployeeRefCacheMap.put(userId, employeeRefVO);
        }
        return employeeRefVO;
    }

    public PrdOrgOrganizationRefVO getBULevel1ByOrgId(Long orgId) {
        if (orgId == null) {
            return null;
        }
        PrdOrgOrganizationRefVO prdOrgOrganizationRefVO = this.buLevel1Map.get(orgId);
        if (prdOrgOrganizationRefVO == null || this.shouldLoadCache(lastLoadTimeBULevel1)) {
            lastLoadTimeBULevel1 = new Date().getTime();
            List prdOrgOrganizationRefVOS = this.organizationService.queryAllFatherOrgByOrgId(orgId);
            Optional<PrdOrgOrganizationRefVO> first = prdOrgOrganizationRefVOS.stream().filter(vo -> StringUtils.hasText((String)vo.getBuLevel()) && vo.getBuLevel().equals(OrgEnum.BuLevel.BU_LEVEL1.getCode()) && vo.getOrgStatus().equalsIgnoreCase(OrgEnum.OrgStatus.ACTIVE.getCode())).findFirst();
            if (first.isPresent()) {
                this.buLevel1Map.put(orgId, first.get());
                return first.get();
            }
        }
        return prdOrgOrganizationRefVO;
    }

    public List<PrdOrgOrganizationRefVO> getAllFatherOrgByOrgId(Long orgId) {
        if (orgId == null) {
            return null;
        }
        List prdOrgOrganizationRefVOS = this.organizationService.queryAllFatherOrgByOrgId(orgId);
        return prdOrgOrganizationRefVOS;
    }

    public List<Long> getOrgIdsByManageId(Long userId) {
        if (userId == null) {
            return null;
        }
        return this.orgOrganizationDAO.queryByManageIdOrgIds(userId);
    }

    public String getYeedocJwt(SysUserDTO loginUser) {
        if (loginUser == null) {
            return null;
        }
        String yeedocJwt = this.yeedocService.getYeedocJwt(loginUser);
        return yeedocJwt;
    }

    public String getYeedocJwt() {
        SysUserDTO loginUser = GlobalUtil.getLoginUser();
        if (loginUser == null) {
            return null;
        }
        String yeedocJwt = this.yeedocService.getYeedocJwt(loginUser);
        return yeedocJwt;
    }

    public List<String> getSystemRoleCodesNoCache(Long userId) {
        if (null == userId) {
            userId = GlobalUtil.getLoginUserId();
        }
        List<String> roleCodes = this.systemRoleDAO.queryUserRoleCodes(userId);
        return roleCodes;
    }

    public List<Long> getAllChildOrgByUserId(Long userId) {
        if (null == userId) {
            userId = GlobalUtil.getLoginUserId();
        }
        if (this.allOrgChildMap.containsKey(userId)) {
            return this.allOrgChildMap.get(userId);
        }
        List organization = this.organizationService.queryAllChildOrgByUserId(userId);
        if (!org.springframework.util.CollectionUtils.isEmpty((Collection)organization)) {
            List<Long> orgIds = organization.stream().map(PrdOrgOrganizationRefVO::getOrgId).toList();
            this.allOrgChildMap.put(userId, orgIds);
            return orgIds;
        }
        this.allOrgChildMap.put(userId, Collections.emptyList());
        return this.allOrgChildMap.get(userId);
    }
}

