/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5.server.prd.crm.dao;

import com.elitesland.tw.tw5.api.prd.crm.payload.CrmPotentialCustomerPayload;
import com.elitesland.tw.tw5.api.prd.crm.query.CrmPotentialCustomerQuery;
import com.elitesland.tw.tw5.server.common.util.PageUtil;
import com.elitesland.tw.tw5.server.common.util.SqlUtil;
import com.elitesland.tw.tw5.server.prd.crm.entity.CrmOpenseaDO;
import com.elitesland.tw.tw5.server.prd.crm.entity.CrmPotentialCustomerDO;
import com.elitesland.tw.tw5.server.prd.crm.entity.QCrmPotentialCustomerDO;
import com.elitesland.tw.tw5.server.prd.crm.repo.CrmPotentialCustomerRepo;
import com.elitesland.tw.tw5.server.prd.prj.entity.PrjProjectDO;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import com.querydsl.jpa.impl.JPAQueryFactory;
import com.querydsl.jpa.impl.JPAUpdateClause;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Join;
import javax.persistence.criteria.JoinType;
import org.apache.commons.lang3.StringUtils;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.ObjectUtils;

@Repository
public class CrmPotentialCustomerDAO {
    private final CrmPotentialCustomerRepo repo;
    private final JPAQueryFactory jpaQueryFactory;
    private final QCrmPotentialCustomerDO qdo = QCrmPotentialCustomerDO.crmPotentialCustomerDO;
    private final EntityManager em;

    public CrmPotentialCustomerDO save(CrmPotentialCustomerDO ado) {
        return (CrmPotentialCustomerDO)((Object)this.repo.save((Object)ado));
    }

    public List<CrmPotentialCustomerDO> saveAll(List<CrmPotentialCustomerDO> dos) {
        return this.repo.saveAll(dos);
    }

    @Transactional(rollbackFor={Exception.class})
    public void batchInsert(List<CrmPotentialCustomerDO> dos) {
        for (CrmPotentialCustomerDO entity : dos) {
            this.em.persist((Object)entity);
        }
        this.em.flush();
        this.em.clear();
    }

    @Transactional(rollbackFor={Exception.class})
    public void batchUpdate(List<CrmPotentialCustomerDO> dos) {
        for (CrmPotentialCustomerDO entity : dos) {
            this.em.merge((Object)entity);
        }
        this.em.flush();
        this.em.clear();
    }

    public Specification<CrmPotentialCustomerDO> getSpec(CrmPotentialCustomerQuery query) {
        Specification & Serializable querySpecifi = (Specification & Serializable)(root, criteriaQuery, cb) -> {
            CriteriaBuilder.In in;
            javax.persistence.criteria.Path path;
            String[] split;
            ArrayList<javax.persistence.criteria.Predicate> predicates = new ArrayList<javax.persistence.criteria.Predicate>();
            Join openseaJoin = root.join("opensea", JoinType.LEFT);
            if (!ObjectUtils.isEmpty((Object)query.getOpenseaId()) && query.getOpenseaId() != 0L) {
                predicates.add(cb.equal(openseaJoin.get("id").as(String.class), (Object)query.getOpenseaId()));
            }
            if (!StringUtils.isEmpty((CharSequence)query.getOpenseaIds())) {
                split = query.getOpenseaIds().split(",");
                path = openseaJoin.get("id");
                in = cb.in((Expression)path);
                for (int i = 0; i < split.length; ++i) {
                    in.value((Object)Long.valueOf(split[i]));
                }
                predicates.add(cb.and(new javax.persistence.criteria.Predicate[]{in}));
            }
            if (!StringUtils.isEmpty((CharSequence)query.getTagIds())) {
                split = query.getTagIds().split(",");
                javax.persistence.criteria.Predicate[] predicatesArray = new javax.persistence.criteria.Predicate[split.length];
                for (int i = 0; i < split.length; ++i) {
                    predicatesArray[i] = cb.like(root.get("tagIds").as(String.class), SqlUtil.toSqlLikeString(split[i]));
                }
                predicates.add(cb.or(predicatesArray));
            }
            if (!StringUtils.isEmpty((CharSequence)query.getCustomerName())) {
                predicates.add(cb.like(root.get("customerName").as(String.class), SqlUtil.toSqlLikeString(query.getCustomerName())));
            }
            if (!StringUtils.isEmpty((CharSequence)query.getCustomerNameEqual())) {
                predicates.add(cb.equal(root.get("customerName").as(String.class), (Object)query.getCustomerNameEqual()));
            }
            if (!StringUtils.isEmpty((CharSequence)query.getDemandProduct())) {
                predicates.add(cb.equal(root.get("demandProduct").as(String.class), (Object)query.getDemandProduct()));
            }
            if (!StringUtils.isEmpty((CharSequence)query.getCustomerContacts())) {
                predicates.add(cb.like(root.get("customerContacts").as(String.class), SqlUtil.toSqlLikeString(query.getCustomerContacts())));
            }
            if (!StringUtils.isEmpty((CharSequence)query.getCustomerGrade())) {
                predicates.add(cb.equal(root.get("customerGrade").as(String.class), (Object)query.getCustomerGrade()));
            }
            if (!StringUtils.isEmpty((CharSequence)query.getCustomerIndustry())) {
                predicates.add(cb.equal(root.get("customerIndustry").as(String.class), (Object)query.getCustomerIndustry()));
            }
            Join marketJoin = root.join("market", JoinType.LEFT);
            if (!ObjectUtils.isEmpty((Object)query.getMarketId())) {
                predicates.add(cb.equal(marketJoin.get("id").as(String.class), (Object)query.getMarketId()));
            }
            if (!StringUtils.isEmpty((CharSequence)query.getCustomerPhone())) {
                predicates.add(cb.like(root.get("customerPhone").as(String.class), SqlUtil.toSqlLikeString(query.getCustomerPhone())));
            }
            if (!StringUtils.isEmpty((CharSequence)query.getCustomerStatus())) {
                predicates.add(cb.equal(root.get("customerStatus").as(String.class), (Object)query.getCustomerStatus()));
            }
            if (!ObjectUtils.isEmpty((Object)query.getCreateTimeStart())) {
                predicates.add(cb.greaterThanOrEqualTo(root.get("createTime").as(LocalDateTime.class), (Comparable)query.getCreateTimeStart()));
            }
            if (!ObjectUtils.isEmpty((Object)query.getCreateTimeEnd())) {
                predicates.add(cb.lessThanOrEqualTo(root.get("createTime").as(LocalDateTime.class), (Comparable)query.getCreateTimeEnd()));
            }
            if (!StringUtils.isEmpty((CharSequence)query.getCustomerLocationCityName())) {
                predicates.add(cb.like(root.get("customerLocationCityName").as(String.class), SqlUtil.toSqlLikeString(query.getCustomerLocationCityName())));
            }
            if (!StringUtils.isEmpty((CharSequence)query.getArea())) {
                predicates.add(cb.like(root.get("customerLocationCityName").as(String.class), SqlUtil.toSqlLikeString(query.getArea())));
            }
            if (!StringUtils.isEmpty((CharSequence)query.getMarketChannel())) {
                predicates.add(cb.equal(root.get("marketChannel").as(String.class), (Object)query.getMarketChannel()));
            }
            if (!StringUtils.isEmpty((CharSequence)query.getCustomerEmail())) {
                predicates.add(cb.like(root.get("customerEmail").as(String.class), SqlUtil.toSqlLikeString(query.getCustomerEmail())));
            }
            if (!StringUtils.isEmpty((CharSequence)query.getCustRegion())) {
                predicates.add(cb.equal(root.get("custRegion").as(String.class), (Object)query.getCustRegion()));
            }
            if (!ObjectUtils.isEmpty((Object[])query.getPotentialCustomerIds())) {
                path = root.get("id");
                in = cb.in((Expression)path);
                for (Long id : query.getPotentialCustomerIds()) {
                    in.value((Object)id);
                }
                predicates.add(cb.and(new javax.persistence.criteria.Predicate[]{in}));
            }
            if (!ObjectUtils.isEmpty((Object)query.getPotentialCustomerIdsForFollow())) {
                path = root.get("id");
                in = cb.in((Expression)path);
                for (Long id : query.getPotentialCustomerIdsForFollow()) {
                    in.value((Object)id);
                }
                predicates.add(cb.and(new javax.persistence.criteria.Predicate[]{in}));
            }
            criteriaQuery.distinct(true);
            return cb.and(predicates.toArray(new javax.persistence.criteria.Predicate[predicates.size()]));
        };
        return querySpecifi;
    }

    public List<CrmPotentialCustomerDO> findAll(Specification<CrmPotentialCustomerDO> spec) {
        return this.repo.findAll(spec);
    }

    public Page<CrmPotentialCustomerDO> findAll(Specification<CrmPotentialCustomerDO> spec, Pageable pageable) {
        pageable = PageUtil.defaultSort(pageable);
        return this.repo.findAll(spec, pageable);
    }

    public long countAll(Specification<CrmPotentialCustomerDO> spec) {
        return this.repo.count(spec);
    }

    public CrmPotentialCustomerDO queryById(Long id) {
        return this.repo.findById(id).orElse(null);
    }

    @Transactional(rollbackFor={Exception.class})
    public void updateProvinceCityDistrict(CrmPotentialCustomerPayload payload) {
        this.jpaQueryFactory.update((EntityPath)this.qdo).set((Path)this.qdo.customerLocationProvince, (Object)payload.getCustomerLocationProvince()).set((Path)this.qdo.customerLocationProvinceName, (Object)payload.getCustomerLocationProvinceName()).set((Path)this.qdo.customerLocationCity, (Object)payload.getCustomerLocationCity()).set((Path)this.qdo.customerLocationCityName, (Object)payload.getCustomerLocationCityName()).set((Path)this.qdo.customerLocationDistrict, (Object)payload.getCustomerLocationDistrict()).set((Path)this.qdo.customerLocationDistrictName, (Object)payload.getCustomerLocationDistrictName()).where(new Predicate[]{this.qdo.id.eq((Object)payload.getId())}).execute();
    }

    public void updateByKeyDynamic(CrmPotentialCustomerPayload payload) {
        CrmPotentialCustomerDO pCustomer = this.repo.findById(payload.getId()).orElse(null);
        if (pCustomer != null) {
            List nullFields;
            if (payload.getCustomerStatus() != null) {
                pCustomer.setCustomerStatus(payload.getCustomerStatus());
            }
            if (payload.getTransferReason() != null) {
                pCustomer.setTransferReason(payload.getTransferReason());
            }
            if (payload.getRemark() != null) {
                pCustomer.setRemark(payload.getRemark());
            }
            if (payload.getCustomerName() != null) {
                pCustomer.setCustomerName(payload.getCustomerName());
            }
            if (payload.getCustomerGrade() != null) {
                pCustomer.setCustomerGrade(payload.getCustomerGrade());
            }
            if (payload.getCustomerIndustry() != null) {
                pCustomer.setCustomerIndustry(payload.getCustomerIndustry());
            }
            if (payload.getCustomerContacts() != null) {
                pCustomer.setCustomerContacts(payload.getCustomerContacts());
            }
            if (payload.getCustomerPhone() != null) {
                pCustomer.setCustomerPhone(payload.getCustomerPhone());
            }
            if (payload.getCustomerEmail() != null) {
                pCustomer.setCustomerEmail(payload.getCustomerEmail());
            }
            if (payload.getCustomerLocationProvince() != null) {
                pCustomer.setCustomerLocationProvince(payload.getCustomerLocationProvince());
            }
            if (payload.getCustomerLocationCity() != null) {
                pCustomer.setCustomerLocationCity(payload.getCustomerLocationCity());
                pCustomer.setCustomerLocationProvinceName(null);
            }
            if (payload.getCustomerLocationDistrict() != null) {
                pCustomer.setCustomerLocationDistrict(payload.getCustomerLocationDistrict());
            }
            if (payload.getCustomerLocationDetail() != null) {
                pCustomer.setCustomerLocationDetail(payload.getCustomerLocationDetail());
            }
            if (payload.getCustomerLocationProvinceName() != null) {
                pCustomer.setCustomerLocationProvinceName(payload.getCustomerLocationProvinceName());
            }
            if (payload.getCustomerLocationCityName() != null) {
                pCustomer.setCustomerLocationCityName(payload.getCustomerLocationCityName());
            }
            if (payload.getCustomerLocationDistrictName() != null) {
                pCustomer.setCustomerLocationDistrictName(payload.getCustomerLocationDistrictName());
            }
            if (payload.getTagIds() != null) {
                pCustomer.setTagIds(payload.getTagIds());
            }
            if (payload.getDemandProduct() != null) {
                pCustomer.setDemandProduct(payload.getDemandProduct());
            }
            if (payload.getMarketId() != null) {
                PrjProjectDO market = new PrjProjectDO();
                market.setId(payload.getMarketId());
                pCustomer.setMarket(market);
            }
            if (payload.getOpenseaId() != null) {
                CrmOpenseaDO opensea = new CrmOpenseaDO();
                opensea.setId(payload.getOpenseaId());
                pCustomer.setOpensea(opensea);
            }
            if (payload.getCustRegion() != null) {
                pCustomer.setCustRegion(payload.getCustRegion());
            }
            if (payload.getMarketChannel() != null) {
                pCustomer.setMarketChannel(payload.getMarketChannel());
            }
            if (payload.getContactsDepartment() != null) {
                pCustomer.setContactsDepartment(payload.getContactsDepartment());
            }
            if (payload.getContactsPosition() != null) {
                pCustomer.setContactsPosition(payload.getContactsPosition());
            }
            if ((nullFields = payload.getNullFields()) != null && nullFields.size() > 0) {
                if (nullFields.contains("customerGrade")) {
                    pCustomer.setCustomerGrade(null);
                }
                if (nullFields.contains("customerIndustry")) {
                    pCustomer.setCustomerIndustry(null);
                }
                if (nullFields.contains("customerContacts")) {
                    pCustomer.setCustomerContacts(null);
                }
                if (nullFields.contains("customerPhone")) {
                    pCustomer.setCustomerPhone(null);
                }
                if (nullFields.contains("customerEmail")) {
                    pCustomer.setCustomerEmail(null);
                }
                if (nullFields.contains("customerLocationProvince")) {
                    pCustomer.setCustomerLocationProvince(null);
                }
                if (nullFields.contains("customerLocationCity")) {
                    pCustomer.setCustomerLocationCity(null);
                }
                if (nullFields.contains("customerLocationDistrict")) {
                    pCustomer.setCustomerLocationDistrict(null);
                }
                if (nullFields.contains("customerLocationDetail")) {
                    pCustomer.setCustomerLocationDetail(null);
                }
                if (nullFields.contains("tagIds")) {
                    pCustomer.setTagIds(null);
                }
                if (nullFields.contains("customerStatus")) {
                    pCustomer.setCustomerStatus(null);
                }
                if (nullFields.contains("contactsDepartment")) {
                    pCustomer.setContactsDepartment(null);
                }
                if (nullFields.contains("contactsPosition")) {
                    pCustomer.setContactsPosition(null);
                }
                if (nullFields.contains("custRegion")) {
                    pCustomer.setCustRegion(null);
                }
                if (nullFields.contains("demandProduct")) {
                    pCustomer.setDemandProduct(null);
                }
                if (nullFields.contains("remark")) {
                    pCustomer.setRemark(null);
                }
                if (nullFields.contains("marketChannel")) {
                    pCustomer.setMarketChannel(null);
                }
                if (nullFields.contains("customerLocationProvinceName")) {
                    pCustomer.setCustomerLocationProvinceName(null);
                }
                if (nullFields.contains("customerLocationProvinceName")) {
                    pCustomer.setCustomerLocationCityName(null);
                }
                if (nullFields.contains("customerLocationProvinceName")) {
                    pCustomer.setCustomerLocationDistrictName(null);
                }
            }
            CrmPotentialCustomerDO save = (CrmPotentialCustomerDO)((Object)this.repo.save((Object)pCustomer));
            System.out.println(111);
        }
    }

    public List<CrmPotentialCustomerDO> queryByOpenseaId(Long openseaId) {
        return this.repo.findByOpensea_Id(openseaId);
    }

    public long deleteSoft(Long[] keys) {
        JPAUpdateClause update = this.jpaQueryFactory.update((EntityPath)this.qdo).set(this.qdo.deleteFlag, (Object)1).where(new Predicate[]{this.qdo.id.in((Object[])keys)});
        return update.execute();
    }

    public void updateCustomerGrade(List<Long> potentialCustomerIds, String grade) {
        this.repo.updateCustomerGrade(potentialCustomerIds, grade);
    }

    public CrmPotentialCustomerDO findById(Long id) {
        return this.repo.findById(id).orElse(null);
    }

    public CrmPotentialCustomerDAO(CrmPotentialCustomerRepo repo, JPAQueryFactory jpaQueryFactory, EntityManager em) {
        this.repo = repo;
        this.jpaQueryFactory = jpaQueryFactory;
        this.em = em;
    }
}

