/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5.server.prd.crm.service;

import cn.hutool.core.lang.Snowflake;
import cn.hutool.core.util.IdUtil;
import com.alibaba.excel.EasyExcel;
import com.alibaba.excel.read.builder.ExcelReaderSheetBuilder;
import com.alibaba.excel.write.builder.ExcelWriterBuilder;
import com.alibaba.excel.write.builder.ExcelWriterSheetBuilder;
import com.alibaba.excel.write.handler.WriteHandler;
import com.alibaba.excel.write.style.column.LongestMatchColumnWidthStyleStrategy;
import com.el.coordinator.boot.fsm.service.FileService;
import com.el.coordinator.core.common.api.ApiResult;
import com.elitescloud.boot.core.base.BaseServiceImpl;
import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.boot.model.entity.BaseModel;
import com.elitescloud.cloudt.common.base.ApiCode;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.common.base.param.OrderItem;
import com.elitesland.tw.tw5.api.prd.crm.payload.CrmFollowPayload;
import com.elitesland.tw.tw5.api.prd.crm.payload.CrmLeadsCustomerPayload;
import com.elitesland.tw.tw5.api.prd.crm.payload.CrmLeadsDetailPayload;
import com.elitesland.tw.tw5.api.prd.crm.payload.CrmLeadsPayload;
import com.elitesland.tw.tw5.api.prd.crm.payload.CrmOpenseaPayload;
import com.elitesland.tw.tw5.api.prd.crm.payload.CrmPotentialCustomerListExcelExport;
import com.elitesland.tw.tw5.api.prd.crm.payload.CrmPotentialCustomerPayload;
import com.elitesland.tw.tw5.api.prd.crm.query.CrmFollowQuery;
import com.elitesland.tw.tw5.api.prd.crm.query.CrmLeadsOffshoreQuery;
import com.elitesland.tw.tw5.api.prd.crm.query.CrmOpenseaQuery;
import com.elitesland.tw.tw5.api.prd.crm.query.CrmPotentialCustomerQuery;
import com.elitesland.tw.tw5.api.prd.crm.service.CrmCommonService;
import com.elitesland.tw.tw5.api.prd.crm.service.CrmFollowService;
import com.elitesland.tw.tw5.api.prd.crm.service.CrmLeadsService;
import com.elitesland.tw.tw5.api.prd.crm.service.CrmOpenseaService;
import com.elitesland.tw.tw5.api.prd.crm.service.CrmPotentialCustomerService;
import com.elitesland.tw.tw5.api.prd.crm.vo.CrmFollowVO;
import com.elitesland.tw.tw5.api.prd.crm.vo.CrmLeadsVO;
import com.elitesland.tw.tw5.api.prd.crm.vo.CrmPotentialCustomerListVO;
import com.elitesland.tw.tw5.api.prd.crm.vo.CrmPotentialCustomerVO;
import com.elitesland.tw.tw5.api.prd.partner.identity.service.BusinessCustomerInfoService;
import com.elitesland.tw.tw5.api.prd.prj.payload.PrjProjectPayload;
import com.elitesland.tw.tw5.api.prd.prj.query.PrjProjectQuery;
import com.elitesland.tw.tw5.api.prd.prj.vo.PrjProjectVO;
import com.elitesland.tw.tw5.api.prd.system.query.PrdSystemLogQuery;
import com.elitesland.tw.tw5.api.prd.system.service.PrdSystemLogService;
import com.elitesland.tw.tw5.api.prd.system.service.PrdSystemSelectionService;
import com.elitesland.tw.tw5.api.prd.system.vo.PrdSystemLogVO;
import com.elitesland.tw.tw5.api.prd.system.vo.PrdSystemTagVO;
import com.elitesland.tw.tw5.server.common.ExcelEntityDataListener;
import com.elitesland.tw.tw5.server.common.ExcelUtil;
import com.elitesland.tw.tw5.server.common.TwException;
import com.elitesland.tw.tw5.server.common.util.ChangeFieldLogUtil;
import com.elitesland.tw.tw5.server.prd.common.CacheUtil;
import com.elitesland.tw.tw5.server.prd.common.GlobalUtil;
import com.elitesland.tw.tw5.server.prd.common.functionEnum.CrmFollowObjectEnum;
import com.elitesland.tw.tw5.server.prd.common.functionEnum.FunctionSelectionEnum;
import com.elitesland.tw.tw5.server.prd.common.functionEnum.PrdSystemObjectEnum;
import com.elitesland.tw.tw5.server.prd.common.functionEnum.RoleEnum;
import com.elitesland.tw.tw5.server.prd.crm.convert.CrmLeadsConvert;
import com.elitesland.tw.tw5.server.prd.crm.convert.CrmPotentialCustomerConvert;
import com.elitesland.tw.tw5.server.prd.crm.dao.CrmLeadsDAO;
import com.elitesland.tw.tw5.server.prd.crm.dao.CrmLeadsOffshoreDAO;
import com.elitesland.tw.tw5.server.prd.crm.dao.CrmOffshoreDAO;
import com.elitesland.tw.tw5.server.prd.crm.dao.CrmOpenseaDAO;
import com.elitesland.tw.tw5.server.prd.crm.dao.CrmPotentialCustomerDAO;
import com.elitesland.tw.tw5.server.prd.crm.entity.CrmLeadsDO;
import com.elitesland.tw.tw5.server.prd.crm.entity.CrmLeadsOffshoreDO;
import com.elitesland.tw.tw5.server.prd.crm.entity.CrmOffshoreDO;
import com.elitesland.tw.tw5.server.prd.crm.entity.CrmPotentialCustomerDO;
import com.elitesland.tw.tw5.server.prd.prj.dao.PrjProjectDAO;
import com.elitesland.tw.tw5.server.prd.system.dao.PrdSystemLogDAO;
import com.elitesland.tw.tw5.server.prd.system.dao.PrdSystemRoleDAO;
import com.elitesland.tw.tw5.server.udc.UdcUtil;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URLEncoder;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.usermodel.WorkbookFactory;
import org.apache.poi.xssf.usermodel.XSSFCell;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.core.io.ClassPathResource;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.web.multipart.MultipartFile;

@Service
public class CrmPotentialCustomerServiceImpl
extends BaseServiceImpl
implements CrmPotentialCustomerService {
    private static final Logger log = LoggerFactory.getLogger(CrmPotentialCustomerServiceImpl.class);
    private final CrmPotentialCustomerDAO dao;
    private final CacheUtil cacheUtil;
    private final PrdSystemLogService logService;
    private final CrmLeadsService leadsService;
    private final CrmLeadsDAO leadsDAO;
    private final PrdSystemLogDAO logDAO;
    private final PrjProjectDAO marketDAO;
    private final CrmOpenseaDAO openseaDAO;
    private final CrmOpenseaService openseaService;
    private final CrmFollowService followService;
    private final ExcelUtil excelUtil;
    private final PrdSystemSelectionService selectionService;
    private final FileService fileService;
    private final CrmCommonService crmCommonService;
    private final PrdSystemRoleDAO systemRoleDAO;
    private final CrmFollowService crmFollowService;
    private final CrmLeadsOffshoreDAO leadsOffshoreDAO;
    private final CrmPotentialCustomerDAO potentialCustomerDAO;
    private final ChangeFieldLogUtil changeFieldLogUtil;
    private final CrmOffshoreDAO offshoreDAO;
    private final UdcUtil udcUtil;
    private final BusinessCustomerInfoService businessCustomerInfoService;

    @Transactional(propagation=Propagation.REQUIRED)
    public CrmPotentialCustomerVO saveOne(CrmPotentialCustomerPayload payload) {
        CrmPotentialCustomerDO ado = new CrmPotentialCustomerDO();
        CrmOpenseaPayload opensea = new CrmOpenseaPayload();
        CrmPotentialCustomerDO oldEntity = null;
        if (payload.getId() == null) {
            String customerNo = this.generateSeqNum("PCUSTOMER", new String[0]);
            PrjProjectPayload market = new PrjProjectPayload();
            market.setId(payload.getMarketId());
            opensea.setId(payload.getOpenseaId());
            payload.setCustomerNo(customerNo);
            payload.setMarket(market);
            payload.setOpensea(opensea);
            payload.setCustomerStatus("new");
        } else {
            oldEntity = this.dao.findById(payload.getId());
        }
        ado = CrmPotentialCustomerConvert.INSTANCE.toDo(payload);
        ado = this.dao.save(ado);
        this.countPotentialCustomers(opensea);
        String fieldsLog = "";
        if (payload.getId() == null) {
            this.logService.saveNewLog(ado.getId(), PrdSystemObjectEnum.Potential_customer.getCode(), "\u65b0\u5efa " + ado.getCustomerName());
            fieldsLog = this.changeFieldLogUtil.getFieldsCreateLog(ado);
        } else {
            fieldsLog = this.changeFieldLogUtil.getFieldsUpdateLog(ado, oldEntity);
        }
        if (fieldsLog != null && fieldsLog.length() > 0) {
            this.logService.saveNewLog(ado.getId(), PrdSystemObjectEnum.Potential_customer.getCode(), fieldsLog);
        }
        return CrmPotentialCustomerConvert.INSTANCE.toVo(ado);
    }

    public void saveAll(List<CrmPotentialCustomerPayload> crmPotentialCustomerPayloadList) throws InterruptedException {
        Snowflake snowflake = IdUtil.getSnowflake((long)16L, (long)16L);
        ArrayList<CrmPotentialCustomerDO> resList = new ArrayList<CrmPotentialCustomerDO>();
        crmPotentialCustomerPayloadList.forEach(p -> resList.add(this.conver((CrmPotentialCustomerPayload)p, snowflake)));
        this.dao.batchInsert(resList);
        for (CrmPotentialCustomerDO potentialCustomerDO : resList) {
            this.logService.saveNewLog(potentialCustomerDO.getId(), PrdSystemObjectEnum.Potential_customer.getCode(), "\u5bfc\u5165 " + potentialCustomerDO.getCustomerName());
            String fieldsLog = this.changeFieldLogUtil.getFieldsCreateLog(potentialCustomerDO);
            if (fieldsLog == null || fieldsLog.length() <= 0) continue;
            this.logService.saveNewLog(potentialCustomerDO.getId(), PrdSystemObjectEnum.Potential_customer.getCode(), fieldsLog);
        }
        List openSeaIdList = resList.stream().map(crmPotentialCustomerDO -> crmPotentialCustomerDO.getOpensea().getId()).distinct().collect(Collectors.toList());
        for (Long openSeaId : openSeaIdList) {
            int num = this.openseaDAO.countPotentialCustomers(openSeaId);
            CrmOpenseaPayload openseaPayload = new CrmOpenseaPayload();
            openseaPayload.setId(openSeaId);
            openseaPayload.setCustomerNum(Integer.valueOf(num));
            this.openseaDAO.updateByKeyDynamic(openseaPayload);
        }
    }

    private CrmPotentialCustomerDO conver(CrmPotentialCustomerPayload payload, Snowflake snowflake) {
        CrmOpenseaPayload opensea = new CrmOpenseaPayload();
        if (payload.getId() == null) {
            String customerNo = snowflake.nextIdStr();
            PrjProjectPayload market = new PrjProjectPayload();
            market.setId(payload.getMarketId());
            opensea.setId(payload.getOpenseaId());
            payload.setCustomerNo(customerNo);
            payload.setMarket(market);
            payload.setOpensea(opensea);
            payload.setCustomerStatus("new");
        }
        return CrmPotentialCustomerConvert.INSTANCE.toDo(payload);
    }

    private void countPotentialCustomers(CrmOpenseaPayload openseaPayload) {
        int num = this.openseaDAO.countPotentialCustomers(openseaPayload.getId());
        openseaPayload.setCustomerNum(Integer.valueOf(num));
        this.openseaDAO.updateByKeyDynamic(openseaPayload);
    }

    public List<PrdSystemLogVO> queryLogList(Long potentialCustomerId) {
        return this.logService.queryLogList(potentialCustomerId, PrdSystemObjectEnum.Potential_customer.getCode());
    }

    public PagingVO<PrdSystemLogVO> pageLog(PrdSystemLogQuery query) {
        query.setLogObject(PrdSystemObjectEnum.Potential_customer.getCode());
        return this.logService.pageLog(query);
    }

    @Transactional
    public List<CrmPotentialCustomerListVO> queryList(CrmPotentialCustomerQuery query) {
        Specification<CrmPotentialCustomerDO> spec = this.dao.getSpec(query);
        List<CrmPotentialCustomerDO> all = this.dao.findAll(spec);
        return all.stream().map(e -> CrmPotentialCustomerConvert.INSTANCE.toListVo((CrmPotentialCustomerDO)((Object)e))).collect(Collectors.toList());
    }

    public long countByActivityId(Long activityId) {
        CrmPotentialCustomerQuery query = new CrmPotentialCustomerQuery();
        query.setMarketId(activityId);
        Specification<CrmPotentialCustomerDO> spec = this.dao.getSpec(query);
        return this.dao.countAll(spec);
    }

    @Transactional(readOnly=true)
    public PagingVO<CrmPotentialCustomerListVO> paging(CrmPotentialCustomerQuery query) {
        if (null != query.getFollowCreateTimeStart() || null != query.getFollowCreateTimeEnd()) {
            ArrayList<Long> de = new ArrayList<Long>();
            de.add(9999L);
            query.setPotentialCustomerIdsForFollow(de);
            CrmFollowQuery crmFollowQuery = new CrmFollowQuery();
            OrderItem orderItem = OrderItem.desc((String)"createTime");
            crmFollowQuery.defaultOrder(orderItem);
            crmFollowQuery.setCreateTimeStart(query.getFollowCreateTimeStart());
            crmFollowQuery.setCreateTimeEnd(query.getFollowCreateTimeEnd());
            crmFollowQuery.setFollowObject(CrmFollowObjectEnum.Potential_customer.name());
            List crmFollowVOList = this.crmFollowService.list(crmFollowQuery);
            List potentialCustomerIdsForFollow = crmFollowVOList.stream().map(crmFollowVO -> crmFollowVO.getObjectId()).collect(Collectors.toList());
            if (!CollectionUtils.isEmpty(potentialCustomerIdsForFollow)) {
                query.setPotentialCustomerIdsForFollow(potentialCustomerIdsForFollow);
            }
        }
        Specification<CrmPotentialCustomerDO> spec = this.dao.getSpec(query);
        Page<CrmPotentialCustomerDO> all = this.dao.findAll(spec, (Pageable)query.getPageRequest());
        List content = all.getContent();
        List<CrmPotentialCustomerListVO> collect = content.stream().map(e -> CrmPotentialCustomerConvert.INSTANCE.toListVo((CrmPotentialCustomerDO)((Object)e))).collect(Collectors.toList());
        this.transferList(collect, query.getQueryFirstFollow());
        all.getTotalPages();
        PagingVO pagingVO = new PagingVO(all.getTotalElements(), collect);
        return pagingVO;
    }

    @Transactional
    public void transferPotentialCustomerOpensea(CrmPotentialCustomerPayload payload) {
        CrmPotentialCustomerDO potentialCustomerDO = this.dao.queryById(payload.getId());
        CrmOpenseaPayload oldOpensea = new CrmOpenseaPayload();
        if (potentialCustomerDO.getOpensea() != null) {
            oldOpensea.setId(potentialCustomerDO.getOpensea().getId());
            int num = this.openseaDAO.countPotentialCustomers(oldOpensea.getId());
            oldOpensea.setCustomerNum(Integer.valueOf(num - 1));
            this.openseaDAO.updateByKeyDynamic(oldOpensea);
        }
        this.dynamicUpdate(payload);
        if (payload.getOpenseaId() != null) {
            CrmOpenseaPayload newOpensea = new CrmOpenseaPayload();
            newOpensea.setId(payload.getOpenseaId());
            this.countPotentialCustomers(newOpensea);
        }
    }

    @Transactional
    public void transferPotentialCustomerOpenseaBatch(List<CrmPotentialCustomerPayload> payloads) {
        for (CrmPotentialCustomerPayload payload : payloads) {
            this.transferPotentialCustomerOpensea(payload);
        }
    }

    @Transactional
    public Long transferPotentialCustomerOffshore(CrmLeadsDetailPayload payload) {
        CrmPotentialCustomerPayload potentialCustomer = new CrmPotentialCustomerPayload();
        potentialCustomer = CrmPotentialCustomerConvert.INSTANCE.to2(payload);
        potentialCustomer.setId(payload.getPotentialCustomerId());
        potentialCustomer.setTransferReason(payload.getPotentialCustomerTransferReason());
        potentialCustomer.setCustomerStatus("offshore");
        this.dao.updateByKeyDynamic(potentialCustomer);
        CrmLeadsPayload leadsPayload = CrmLeadsConvert.INSTANCE.toPayLoad(payload);
        CrmLeadsCustomerPayload leadsCustomerPayload = new CrmLeadsCustomerPayload();
        leadsCustomerPayload.setCustomerName(payload.getCustomerName());
        leadsCustomerPayload.setCustomerIndustry(payload.getCustomerIndustry());
        leadsCustomerPayload.setCustomerGrade(payload.getCustomerGrade());
        leadsCustomerPayload.setCustomerContacts(payload.getCustomerContacts());
        leadsCustomerPayload.setContactsPhone(payload.getCustomerPhone());
        leadsCustomerPayload.setContactsEmail(payload.getCustomerEmail());
        leadsCustomerPayload.setContactsPosition(payload.getContactsPosition());
        leadsCustomerPayload.setContactsDepartment(payload.getContactsDepartment());
        leadsCustomerPayload.setCustRegion(payload.getCustRegion());
        leadsPayload.setCustomer(leadsCustomerPayload);
        leadsPayload.setLeadsTagIds(payload.getTagIds());
        PrjProjectPayload market = new PrjProjectPayload();
        Long marketId = payload.getMarketId();
        market.setId(marketId);
        leadsPayload.setMarket(market);
        CrmLeadsVO crmLeadsVO = this.leadsService.saveOne(leadsPayload);
        CrmPotentialCustomerDO potentialCustomerDO = this.dao.queryById(payload.getPotentialCustomerId());
        List offshoreIds = payload.getOffshoreIds();
        if (!ObjectUtils.isEmpty((Object)offshoreIds)) {
            CrmOffshoreDO offshoreDO = this.offshoreDAO.queryById((Long)offshoreIds.get(0));
            this.logService.saveNewLog(payload.getPotentialCustomerId(), PrdSystemObjectEnum.Potential_customer.getCode(), potentialCustomerDO.getCustomerName() + " \u7531 " + potentialCustomerDO.getOpensea().getOpenseaName() + " \u8f6c\u79fb\u5230 " + offshoreDO.getOffshoreName());
            this.logService.saveNewLog(crmLeadsVO.getId(), PrdSystemObjectEnum.Leads.getCode(), crmLeadsVO.getLeadsName() + " \u7531 " + potentialCustomerDO.getOpensea().getOpenseaName() + " \u8f6c\u79fb\u5230 " + offshoreDO.getOffshoreName());
        }
        return crmLeadsVO.getId();
    }

    public void updateFollow(CrmFollowPayload payload) {
        payload.setFollowObject(CrmFollowObjectEnum.Potential_customer.getCode());
        this.followService.addFollow(payload);
    }

    @Transactional
    public CrmPotentialCustomerVO queryDetail(Long id) {
        CrmPotentialCustomerDO detail = this.dao.queryById(id);
        CrmPotentialCustomerVO potentialCustomerVO = CrmPotentialCustomerConvert.INSTANCE.toVo(detail);
        this.transferDetail(Collections.singletonList(potentialCustomerVO));
        return potentialCustomerVO;
    }

    @Transactional
    public void dynamicUpdate(CrmPotentialCustomerPayload payload) {
        CrmLeadsDO leadsDO;
        CrmPotentialCustomerDO crmPotentialCustomerDO = this.dao.queryById(payload.getId());
        CrmPotentialCustomerDO entityLog = new CrmPotentialCustomerDO();
        BeanUtils.copyProperties((Object)((Object)crmPotentialCustomerDO), (Object)((Object)entityLog));
        if (payload.getCustomerGrade() != null && (leadsDO = this.leadsDAO.findByPotentialCustomerId(crmPotentialCustomerDO.getId())) != null && leadsDO.getFormalCustomerId() != null) {
            this.businessCustomerInfoService.changeCustomerGrade(leadsDO.getFormalCustomerId(), payload.getCustomerGrade());
        }
        this.dao.updateByKeyDynamic(payload);
        crmPotentialCustomerDO = this.dao.queryById(payload.getId());
        String fieldsLog = this.changeFieldLogUtil.getFieldsUpdateLog(crmPotentialCustomerDO, entityLog);
        if (fieldsLog != null && fieldsLog.length() > 0) {
            this.logService.saveNewLog(payload.getId(), PrdSystemObjectEnum.Potential_customer.getCode(), fieldsLog);
        }
    }

    @Transactional
    public void updateProvinceCityDistrict(CrmPotentialCustomerPayload payload) {
        CrmPotentialCustomerDO crmPotentialCustomerDO = this.dao.queryById(payload.getId());
        CrmPotentialCustomerDO entityLog = new CrmPotentialCustomerDO();
        BeanUtils.copyProperties((Object)((Object)crmPotentialCustomerDO), (Object)((Object)entityLog));
        this.dao.updateProvinceCityDistrict(payload);
        crmPotentialCustomerDO = this.dao.queryById(payload.getId());
        String fieldsLog = this.changeFieldLogUtil.getFieldsUpdateLog(crmPotentialCustomerDO, entityLog);
        if (fieldsLog != null && fieldsLog.length() > 0) {
            this.logService.saveNewLog(payload.getId(), PrdSystemObjectEnum.Potential_customer.getCode(), fieldsLog);
        }
    }

    @Transactional
    public void deletePotentialCustomerSoft(Long[] asList) {
        Long userId = GlobalUtil.getLoginUserId();
        List<Long> userIdsByRole = this.systemRoleDAO.queryUserIdByRoleCodes(Arrays.asList(RoleEnum.SYS.getCode(), RoleEnum.MARKET_ADMIN.getCode()));
        if (userIdsByRole == null || userIdsByRole.isEmpty() || !userIdsByRole.contains(userId)) {
            throw TwException.error("", "\u60a8\u6ca1\u6709\u6743\u9650\u5220\u9664\u8fd1\u6d77\u7ebf\u7d22\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\uff01");
        }
        for (Long aLong : asList) {
            CrmPotentialCustomerDO potentialCustomerDO = this.dao.queryById(aLong);
            String customerStatus = potentialCustomerDO.getCustomerStatus();
            if (customerStatus.equals("new")) continue;
            throw TwException.error("", "\u53ea\u6709\u65b0\u5efa\u72b6\u6001\u7684\u6f5c\u5728\u5ba2\u6237\u624d\u53ef\u4ee5\u5220\u9664\uff01");
        }
        this.dao.deleteSoft(asList);
    }

    private void transferList(List<CrmPotentialCustomerListVO> list, Boolean queryFirstFollow) {
        for (CrmPotentialCustomerListVO vo : list) {
            if (!ObjectUtils.isEmpty((Object)vo.getCreateUserId())) {
                vo.setCreateUserName(this.cacheUtil.getUserName(vo.getCreateUserId()));
            }
            vo.setCustomerStatusDesc(this.cacheUtil.transferSystemSelection(FunctionSelectionEnum.CrmPotentialCustomerStatus.getCode(), vo.getCustomerStatus()));
            vo.setCustomerGradeDesc(this.cacheUtil.transferSystemSelection(FunctionSelectionEnum.CrmCustomerGrade.getCode(), vo.getCustomerGrade()));
            vo.setCustomerIndustryDesc(this.cacheUtil.transferSystemSelection(FunctionSelectionEnum.CrmCustomerIndustry.getCode(), vo.getCustomerIndustry()));
            vo.setDemandProductDesc(this.cacheUtil.transferSystemSelection(FunctionSelectionEnum.CrmLeadsDemandProduct.getCode(), vo.getDemandProduct()));
            vo.setCustRegionDesc(this.cacheUtil.transferSystemSelection(FunctionSelectionEnum.CrmCustomerRegion.getCode(), vo.getCustRegion()));
            if (vo.getMarketChannel() != null) {
                String marketChannel = vo.getMarketChannel();
                String[] split = marketChannel.split(",");
                if (split.length < 2) {
                    vo.setMarketChannelDesc(this.cacheUtil.transferSystemSelection(FunctionSelectionEnum.CrmLeadsChannel.getCode(), split[0]));
                } else {
                    String s1 = this.cacheUtil.transferSystemSelection(FunctionSelectionEnum.CrmLeadsChannel.getCode(), split[0]);
                    Object s2 = "";
                    switch (split[0]) {
                        case "baidu": {
                            s2 = this.cacheUtil.transferSystemSelection(FunctionSelectionEnum.CrmLeadsChannelBaidu.getCode(), split[1]);
                            break;
                        }
                        case "sem_360": {
                            s2 = this.cacheUtil.transferSystemSelection(FunctionSelectionEnum.CrmLeadsChannel360.getCode(), split[1]);
                            break;
                        }
                        case "offline_activity": {
                            s2 = this.cacheUtil.transferSystemSelection(FunctionSelectionEnum.CrmLeadsChannelOfflineActivity.getCode(), split[1]);
                            break;
                        }
                        case "thrid_party_data": {
                            s2 = this.cacheUtil.transferSystemSelection(FunctionSelectionEnum.CrmLeadsChannelThirdPartyData.getCode(), split[1]);
                        }
                    }
                    vo.setMarketChannelDesc((String)(((String)s2).equals("") ? s1 : s1 + "/" + (String)s2));
                }
            }
            String tagIds = vo.getTagIds();
            ArrayList<PrdSystemTagVO> tagVOS = new ArrayList<PrdSystemTagVO>();
            if (tagIds != null && !tagIds.isEmpty()) {
                String[] tags = tagIds.split(",");
                for (String tag : tags) {
                    List<PrdSystemTagVO> systemTags = this.cacheUtil.getSystemTag(Long.parseLong(tag));
                    tagVOS.addAll(systemTags);
                }
            }
            vo.setTags(tagVOS);
            if (queryFirstFollow != null && (queryFirstFollow == null || !queryFirstFollow.booleanValue())) continue;
            CrmFollowQuery crmFollowQuery = new CrmFollowQuery();
            crmFollowQuery.setObjectId(vo.getId());
            crmFollowQuery.setFollowObject(CrmFollowObjectEnum.Potential_customer.name());
            crmFollowQuery.setSize(Integer.valueOf(1));
            OrderItem orderItem = OrderItem.desc((String)"createTime");
            crmFollowQuery.defaultOrder(orderItem);
            PagingVO crmFollowVOPagingVO = this.crmFollowService.listPage(crmFollowQuery);
            if (crmFollowVOPagingVO.getRecords() == null || crmFollowVOPagingVO.getRecords().size() != 1) continue;
            CrmFollowVO crmFollowVO = (CrmFollowVO)crmFollowVOPagingVO.getRecords().get(0);
            vo.setFollow(crmFollowVO);
        }
    }

    private void transferDetail(List<CrmPotentialCustomerVO> list) {
        for (CrmPotentialCustomerVO vo : list) {
            if (!ObjectUtils.isEmpty((Object)vo.getCreateUserId())) {
                vo.setCreateUserName(this.cacheUtil.getUserName(vo.getCreateUserId()));
            }
            vo.setCustomerStatusDesc(this.cacheUtil.transferSystemSelection(FunctionSelectionEnum.CrmPotentialCustomerStatus.getCode(), vo.getCustomerStatus()));
            vo.setCustomerGradeDesc(this.cacheUtil.transferSystemSelection(FunctionSelectionEnum.CrmCustomerGrade.getCode(), vo.getCustomerGrade()));
            vo.setCustomerIndustryDesc(this.cacheUtil.transferSystemSelection(FunctionSelectionEnum.CrmCustomerIndustry.getCode(), vo.getCustomerIndustry()));
            vo.setCustRegionDesc(this.cacheUtil.transferSystemSelection(FunctionSelectionEnum.CrmCustomerRegion.getCode(), vo.getCustRegion()));
            if (vo.getMarketChannel() == null) continue;
            String marketChannel = vo.getMarketChannel();
            String[] split = marketChannel.split(",");
            if (split.length < 2) {
                vo.setMarketChannelDesc(this.cacheUtil.transferSystemSelection(FunctionSelectionEnum.CrmLeadsChannel.getCode(), split[0]));
                continue;
            }
            String s1 = this.cacheUtil.transferSystemSelection(FunctionSelectionEnum.CrmLeadsChannel.getCode(), split[0]);
            String s2 = "";
            switch (split[0]) {
                case "baidu": {
                    s2 = this.cacheUtil.transferSystemSelection(FunctionSelectionEnum.CrmLeadsChannelBaidu.getCode(), split[1]);
                    break;
                }
                case "sem_360": {
                    s2 = this.cacheUtil.transferSystemSelection(FunctionSelectionEnum.CrmLeadsChannel360.getCode(), split[1]);
                    break;
                }
                case "offline_activity": {
                    s2 = this.cacheUtil.transferSystemSelection(FunctionSelectionEnum.CrmLeadsChannelOfflineActivity.getCode(), split[1]);
                    break;
                }
                case "thrid_party_data": {
                    s2 = this.cacheUtil.transferSystemSelection(FunctionSelectionEnum.CrmLeadsChannelThirdPartyData.getCode(), split[1]);
                }
            }
            vo.setMarketChannelDesc((String)(s2.equals("") ? s1 : s1 + "/" + s2));
        }
    }

    public void deleteOpenseaSoft(Long openseaId, Long newOpenseaId) {
        List<CrmPotentialCustomerDO> potentialCustomerDOS = this.dao.queryByOpenseaId(openseaId);
        if (potentialCustomerDOS != null && !potentialCustomerDOS.isEmpty()) {
            if (newOpenseaId == null) {
                throw TwException.error("", "\u672a\u63a5\u6536\u5230\u65b0\u7684\u516c\u6d77\uff0c\u65e0\u6cd5\u8f6c\u79fb\u5f53\u524d\u516c\u6d77\u7684\u6f5c\u5728\u5ba2\u6237");
            }
            for (CrmPotentialCustomerDO potentialCustomerDO : potentialCustomerDOS) {
                CrmPotentialCustomerPayload potentialCustomerPayload = new CrmPotentialCustomerPayload();
                potentialCustomerPayload.setId(potentialCustomerDO.getId());
                potentialCustomerPayload.setOpenseaId(newOpenseaId);
                potentialCustomerPayload.setTransferReason("\u539f\u516c\u6d77\u5220\u9664\uff0c\u7ebf\u7d22\u8f6c\u79fb\u5230\u672c\u516c\u6d77");
                this.transferPotentialCustomerOpensea(potentialCustomerPayload);
            }
        }
        this.openseaDAO.deleteSoft(Collections.singletonList(openseaId));
    }

    public Workbook getVol() {
        ClassPathResource classPathResource = new ClassPathResource("template/crmPotentialCustomerBatch.xlsx");
        try {
            InputStream inputStream = classPathResource.getInputStream();
            Workbook workbook = WorkbookFactory.create((InputStream)inputStream);
            XSSFSheet pCustomerSheet = (XSSFSheet)workbook.getSheet("\u6f5c\u5728\u5ba2\u6237\u6570\u636e");
            Sheet lovSheet = workbook.getSheet("LOV");
            Sheet openseaSheet = workbook.getSheet("\u516c\u6d77\u5217\u8868");
            Sheet marketSheet = workbook.getSheet("\u5e02\u573a\u6d3b\u52a8\u5217\u8868");
            List customerGradeSelectionVOS = this.selectionService.selectByCondition(FunctionSelectionEnum.CrmCustomerGrade.getCode());
            this.excelUtil.insertLOVdata(lovSheet, customerGradeSelectionVOS, 2);
            List customerIndustrySelectionVOS = this.selectionService.selectByCondition(FunctionSelectionEnum.CrmCustomerIndustry.getCode());
            this.excelUtil.insertLOVdata(lovSheet, customerIndustrySelectionVOS, 4);
            List custRegionVOS = this.selectionService.selectByCondition(FunctionSelectionEnum.CrmCustomerRegion.getCode());
            this.excelUtil.insertLOVdata(lovSheet, custRegionVOS, 6);
            List leadsChannelVOs = this.selectionService.selectByCondition(FunctionSelectionEnum.CrmLeadsChannel.getCode());
            this.excelUtil.insertLOVdata(lovSheet, leadsChannelVOs, 8);
            List crmOpenseaListVOS = this.openseaService.queryList(new CrmOpenseaQuery());
            this.excelUtil.insertListData(openseaSheet, crmOpenseaListVOS, "id", "openseaName", 0);
            List<PrjProjectVO> prjProjectVOS = this.marketDAO.queryListDynamic(new PrjProjectQuery());
            this.excelUtil.insertListData(marketSheet, prjProjectVOS, "id", "projectName", 0);
            this.excelUtil.generateRangeList(pCustomerSheet, 1, 1, "\u516c\u6d77\u5217\u8868", 2, "A");
            this.excelUtil.generateRangeList(pCustomerSheet, 2, 1, "\u5e02\u573a\u6d3b\u52a8\u5217\u8868", 2, "A");
            this.excelUtil.generateRangeList(pCustomerSheet, 4, 1, "LOV", 2, "C");
            this.excelUtil.generateRangeList(pCustomerSheet, 5, 1, "LOV", 2, "E");
            this.excelUtil.generateRangeList(pCustomerSheet, 9, 1, "LOV", 2, "G");
            this.excelUtil.generateRangeList(pCustomerSheet, 11, 1, "LOV", 2, "I");
            this.excelUtil.setCellFormulas((Row)(pCustomerSheet.getRow(1) == null ? pCustomerSheet.createRow(1) : pCustomerSheet.getRow(1)), 25, "VLOOKUP(B:rowNo,\u516c\u6d77\u5217\u8868!A:B,2,FALSE)");
            this.excelUtil.setCellFormulas((Row)(pCustomerSheet.getRow(1) == null ? pCustomerSheet.createRow(1) : pCustomerSheet.getRow(1)), 26, "VLOOKUP(C:rowNo,\u5e02\u573a\u6d3b\u52a8\u5217\u8868!A:B,2,FALSE)");
            this.excelUtil.setCellFormulas((Row)(pCustomerSheet.getRow(1) == null ? pCustomerSheet.createRow(1) : pCustomerSheet.getRow(1)), 27, "VLOOKUP(E:rowNo,LOV!C:D,2,FALSE)");
            this.excelUtil.setCellFormulas((Row)(pCustomerSheet.getRow(1) == null ? pCustomerSheet.createRow(1) : pCustomerSheet.getRow(1)), 28, "VLOOKUP(F:rowNo,LOV!E:F,2,FALSE)");
            this.excelUtil.setCellFormulas((Row)(pCustomerSheet.getRow(1) == null ? pCustomerSheet.createRow(1) : pCustomerSheet.getRow(1)), 29, "VLOOKUP(J:rowNo,LOV!G:H,2,FALSE)");
            this.excelUtil.setCellFormulas((Row)(pCustomerSheet.getRow(1) == null ? pCustomerSheet.createRow(1) : pCustomerSheet.getRow(1)), 30, "VLOOKUP(L:rowNo,LOV!I:J,2,FALSE)");
            return workbook;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public void downloadBatch(HttpServletResponse response, CrmPotentialCustomerQuery query) {
        try {
            Workbook workbook = null;
            Object fileName = "";
            if (org.springframework.util.StringUtils.hasText((String)query.getDownloadType()) && query.getDownloadType().equals("model")) {
                workbook = this.getVol();
                fileName = "\u6f5c\u5728\u5ba2\u6237\u5bfc\u5165\u6a21\u677f-" + LocalDate.now();
                ExcelUtil.writeResponse(response, (String)fileName, workbook);
            } else {
                fileName = "\u6f5c\u5728\u5ba2\u6237\u6570\u636e-" + LocalDate.now();
                ArrayList<OrderItem> orderItems = new ArrayList<OrderItem>();
                OrderItem openseaId = OrderItem.desc((String)"opensea_id");
                orderItems.add(openseaId);
                query.setOrders(orderItems);
                query.setQueryFirstFollow(Boolean.valueOf(false));
                log.info("=============================\u5f00\u59cb\u67e5\u8be2=======================================");
                log.info("=============================\u5f00\u59cb\u67e5\u8be2=======================================");
                log.info("=============================\u5f00\u59cb\u67e5\u8be2=======================================");
                log.info("=============================\u5f00\u59cb\u67e5\u8be2=======================================");
                log.info("=============================\u5f00\u59cb\u67e5\u8be2=======================================");
                log.info("=============================\u5f00\u59cb\u67e5\u8be2=======================================");
                log.info("=============================\u5f00\u59cb\u67e5\u8be2=======================================");
                log.info("=============================\u5f00\u59cb\u67e5\u8be2=======================================");
                PagingVO<CrmPotentialCustomerListVO> paging = this.paging(query);
                log.info("=============================\u7ed3\u675f\u67e5\u8be2=======================================");
                log.info("=============================\u7ed3\u675f\u67e5\u8be2=======================================");
                log.info("=============================\u7ed3\u675f\u67e5\u8be2=======================================");
                log.info("=============================\u7ed3\u675f\u67e5\u8be2=======================================");
                log.info("=============================\u7ed3\u675f\u67e5\u8be2=======================================");
                log.info("=============================\u7ed3\u675f\u67e5\u8be2=======================================");
                log.info("=============================\u7ed3\u675f\u67e5\u8be2=======================================");
                log.info("=============================\u7ed3\u675f\u67e5\u8be2=======================================");
                log.info("=============================\u7ed3\u675f\u67e5\u8be2=======================================");
                List records = paging.getRecords();
                this.download(records, response);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void download(List<CrmPotentialCustomerListVO> records, HttpServletResponse response) throws IOException {
        int order = 1;
        String sheetName = "\u6f5c\u5728\u5ba2\u6237\u6570\u636e";
        for (CrmPotentialCustomerListVO record : records) {
            record.setOpenseaName(record.getOpensea().getOpenseaName());
            record.setMarketName(record.getMarket().getProjectName());
            record.setOrder(String.valueOf(order));
            ++order;
        }
        List resultList = CrmPotentialCustomerConvert.INSTANCE.voListVoExcelExport(records);
        resultList = this.udcUtil.translateList(resultList);
        String fileName = URLEncoder.encode(sheetName + System.currentTimeMillis() + ".xlsx", "UTF-8");
        response.setContentType("application/vnd.openxmlformats-officedocument.spreadsheetml.sheet");
        response.setCharacterEncoding("utf-8");
        response.addHeader("Content-Disposition", "attachment;filename=" + fileName);
        ExcelWriterSheetBuilder sheet = ((ExcelWriterBuilder)EasyExcel.write((OutputStream)response.getOutputStream(), CrmPotentialCustomerListExcelExport.class).registerWriteHandler((WriteHandler)new LongestMatchColumnWidthStyleStrategy())).sheet(sheetName);
        com.elitesland.tw.tw5.server.common.excel.ExcelUtil.excelHelper(sheet, CrmPotentialCustomerListExcelExport.class, null);
        sheet.doWrite(resultList);
    }

    @Transactional(propagation=Propagation.REQUIRED)
    public Map<String, Object> importBatch(HttpServletResponse response, MultipartFile file, Boolean force) {
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        if (file == null) {
            throw TwException.error("", "\u4e0a\u4f20\u6587\u4ef6\u5f02\u5e38");
        }
        Workbook workbook = null;
        try {
            workbook = WorkbookFactory.create((InputStream)file.getInputStream());
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error(e.getMessage());
            throw TwException.error("", "\u6587\u4ef6\u89e3\u6790\u5f02\u5e38");
        }
        Sheet sheet = workbook.getSheet("\u6f5c\u5728\u5ba2\u6237\u6570\u636e");
        if (sheet == null) {
            throw TwException.error("", "\u8868\u7ed3\u6784\u9519\u8bef");
        }
        int dataStartRow = 1;
        ArrayList<CrmPotentialCustomerPayload> potentialCustomerPayloads = new ArrayList<CrmPotentialCustomerPayload>();
        for (int i = dataStartRow; i <= sheet.getLastRowNum(); ++i) {
            List phone;
            Object importError = "";
            Object importWarn = "";
            Row row = sheet.getRow(i);
            CrmPotentialCustomerPayload potentialCustomerPayload = new CrmPotentialCustomerPayload();
            String openseaIdStr = ExcelUtil.getCellFormatValue(row.getCell(25));
            if (org.springframework.util.StringUtils.hasText((String)openseaIdStr) && openseaIdStr.length() > 0) {
                potentialCustomerPayload.setOpenseaId(Long.valueOf(Long.parseLong(openseaIdStr)));
                potentialCustomerPayload.setOpenseaName(ExcelUtil.getCellFormatValue(row.getCell(1)));
            } else {
                importError = (String)importError + "\u516c\u6d77\u4e0d\u80fd\u4e3a\u7a7a;";
            }
            String marketId = ExcelUtil.getCellFormatValue(row.getCell(26));
            if (org.springframework.util.StringUtils.hasText((String)marketId) && marketId.length() > 0) {
                PrjProjectPayload prjProjectPayload = new PrjProjectPayload();
                prjProjectPayload.setId(Long.valueOf(Long.parseLong(marketId)));
                potentialCustomerPayload.setMarket(prjProjectPayload);
                potentialCustomerPayload.setMarketId(Long.valueOf(Long.parseLong(marketId)));
                potentialCustomerPayload.setMarketIdDesc(ExcelUtil.getCellFormatValue(row.getCell(2)));
            }
            String customerName = ExcelUtil.getCellFormatValue(row.getCell(3));
            List company = new ArrayList();
            if (customerName != null && customerName.length() > 0 && (company = this.crmCommonService.checkRepeat("company", customerName)) != null && !company.isEmpty()) {
                Iterator iterator = company.iterator();
                while (iterator.hasNext()) {
                    Map stringObjectMap;
                    stringObjectMap.put("salesMan", (stringObjectMap = (Map)iterator.next()).get("salesMan") == null ? "" : stringObjectMap.get("salesMan"));
                    importWarn = (String)importWarn + "\u91cd\u590d\u7c7b\u578b\uff1a" + stringObjectMap.get("repeatType") + ",\u4f01\u4e1a\u540d\u79f0\uff1a" + stringObjectMap.get("companyName") + ",\u8054\u7cfb\u4eba\uff1a" + stringObjectMap.get("contactsName") + ",\u8054\u7cfb\u4eba\u7535\u8bdd\uff1a" + stringObjectMap.get("contactsPhone") + "\uff0c\u9500\u552e\u4eba\u5458\uff1a" + stringObjectMap.get("salesMan") + ";";
                }
            }
            potentialCustomerPayload.setCustomerName(customerName);
            potentialCustomerPayload.setCustomerGrade(ExcelUtil.getCellFormatValue(row.getCell(27)));
            potentialCustomerPayload.setCustomerGradeDesc(ExcelUtil.getCellFormatValue(row.getCell(4)));
            potentialCustomerPayload.setCustomerIndustry(ExcelUtil.getCellFormatValue(row.getCell(28)));
            potentialCustomerPayload.setCustomerIndustryDesc(ExcelUtil.getCellFormatValue(row.getCell(5)));
            potentialCustomerPayload.setCustomerContacts(ExcelUtil.getCellFormatValue(row.getCell(6)));
            String customerPhone = ExcelUtil.getCellFormatValue(row.getCell(7));
            if (customerPhone != null && customerPhone.length() > 0 && (phone = this.crmCommonService.checkRepeat("phone", customerPhone)) != null && !phone.isEmpty()) {
                for (Map stringObjectMap : phone) {
                    boolean repeatFlag = false;
                    for (Map companyMap : company) {
                        if (!companyMap.get("id").equals(stringObjectMap.get("id")) || !companyMap.get("repeatType").equals(stringObjectMap.get("repeatType"))) continue;
                        repeatFlag = true;
                        break;
                    }
                    if (repeatFlag) continue;
                    stringObjectMap.put("salesMan", stringObjectMap.get("salesMan") == null ? "" : stringObjectMap.get("salesMan"));
                    importWarn = (String)importWarn + "\u91cd\u590d\u7c7b\u578b\uff1a" + stringObjectMap.get("repeatType") + ",\u4f01\u4e1a\u540d\u79f0\uff1a" + stringObjectMap.get("companyName") + ",\u8054\u7cfb\u4eba\uff1a" + stringObjectMap.get("contactsName") + ",\u8054\u7cfb\u4eba\u7535\u8bdd\uff1a" + stringObjectMap.get("contactsPhone") + "\uff0c\u9500\u552e\u4eba\u5458\uff1a" + stringObjectMap.get("salesMan") + ";";
                }
            }
            potentialCustomerPayload.setCustomerPhone(ExcelUtil.getCellFormatValue(row.getCell(7)));
            potentialCustomerPayload.setCustomerEmail(ExcelUtil.getCellFormatValue(row.getCell(8)));
            potentialCustomerPayload.setCustRegion(ExcelUtil.getCellFormatValue(row.getCell(29)));
            potentialCustomerPayload.setCustomerLocationCityName(ExcelUtil.getCellFormatValue(row.getCell(10)));
            potentialCustomerPayload.setMarketChannel(ExcelUtil.getCellFormatValue(row.getCell(30)));
            potentialCustomerPayload.setCustomerLocationDetail(ExcelUtil.getCellFormatValue(row.getCell(12)));
            String createTime = ExcelUtil.getCellFormatValue(row.getCell(13));
            if (createTime != null && createTime != "") {
                try {
                    LocalDate parse = LocalDate.parse(createTime);
                    potentialCustomerPayload.setCreateTime(parse.atStartOfDay());
                }
                catch (Exception e) {
                    importError = (String)importError + "\u521b\u5efa\u65f6\u95f4\u5fc5\u987b\u662f\u65e5\u671f\u7c7b\u578b";
                }
            }
            potentialCustomerPayload.setRemark(ExcelUtil.getCellFormatValue(row.getCell(14)));
            potentialCustomerPayload.setContactsDepartment(ExcelUtil.getCellFormatValue(row.getCell(15)));
            potentialCustomerPayload.setContactsPosition(ExcelUtil.getCellFormatValue(row.getCell(16)));
            potentialCustomerPayload.setImoprtError((String)importError);
            potentialCustomerPayload.setImportWarn((String)importWarn);
            potentialCustomerPayloads.add(potentialCustomerPayload);
        }
        int warnNum = 0;
        int errorNum = 0;
        for (CrmPotentialCustomerPayload potentialCustomerPayload : potentialCustomerPayloads) {
            if (org.springframework.util.StringUtils.hasText((String)potentialCustomerPayload.getImoprtError()) && potentialCustomerPayload.getImoprtError().length() > 0) {
                ++errorNum;
            }
            if (!org.springframework.util.StringUtils.hasText((String)potentialCustomerPayload.getImportWarn()) && potentialCustomerPayload.getImportWarn().length() <= 0 || force.booleanValue()) continue;
            ++warnNum;
        }
        if (errorNum > 0) {
            resultMap.put("ok", "error");
            resultMap.put("errorNum", errorNum);
            resultMap.put("warnNum", warnNum);
            resultMap.put("downloadUrl", this.downloadModelWithData(potentialCustomerPayloads));
        } else if (warnNum > 0) {
            resultMap.put("ok", "warn");
            resultMap.put("warnNum", warnNum);
            resultMap.put("downloadUrl", this.downloadModelWithData(potentialCustomerPayloads));
        } else {
            for (CrmPotentialCustomerPayload potentialCustomerPayload : potentialCustomerPayloads) {
                CrmPotentialCustomerVO crmPotentialCustomerVO = this.saveOne(potentialCustomerPayload);
                this.logService.saveNewLog(crmPotentialCustomerVO.getId(), PrdSystemObjectEnum.Potential_customer.getCode(), "\u5bfc\u5165 " + crmPotentialCustomerVO.getCustomerName());
            }
            resultMap.put("ok", "ok");
        }
        return resultMap;
    }

    @Transactional(propagation=Propagation.REQUIRED)
    public Map<String, Object> importBatchPro(MultipartFile file, Boolean force) throws InterruptedException {
        ExcelEntityDataListener dataListener = new ExcelEntityDataListener();
        try {
            ((ExcelReaderSheetBuilder)EasyExcel.read((InputStream)file.getInputStream(), CrmPotentialCustomerPayload.class, dataListener).sheet(Integer.valueOf(0)).headRowNumber(Integer.valueOf(1))).doRead();
        }
        catch (Exception e) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u5bfc\u5165\u6570\u636e\u5f02\u5e38\uff0c\u8bf7\u68c0\u67e5\u5bfc\u5165 excel\u7684\u5217\u503c\u662f\u5426\u4e0e\u6a21\u677f\u5bf9\u5e94");
        }
        List<CrmPotentialCustomerPayload> crmPotentialCustomerPayloadList = dataListener.getDatas();
        if (CollectionUtils.isEmpty(crmPotentialCustomerPayloadList)) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u5bfc\u5165\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        CrmPotentialCustomerQuery crmPotentialCustomerQuery = new CrmPotentialCustomerQuery();
        CrmLeadsOffshoreQuery leadsQuery = new CrmLeadsOffshoreQuery();
        List<CrmPotentialCustomerDO> crmPotentialCustomerDOList = this.queryPotentialCustomerList(crmPotentialCustomerQuery);
        List<CrmLeadsOffshoreDO> crmLeadsOffshoreDOList = this.queryLeadsList(leadsQuery);
        HashMap<String, List<BaseModel>> map = new HashMap<String, List<BaseModel>>();
        map.put("crmLeadsOffshoreDOList", crmLeadsOffshoreDOList);
        map.put("crmPotentialCustomerDOList", crmPotentialCustomerDOList);
        for (CrmPotentialCustomerPayload payload : crmPotentialCustomerPayloadList) {
            String createTimeStr;
            List phone;
            String customerPhone;
            StringBuilder importError = new StringBuilder();
            StringBuilder importWarn = new StringBuilder();
            if (null == payload.getOpenseaId()) {
                importError.append("\u516c\u6d77id\u4e0d\u80fd\u4e3a\u7a7a;");
            }
            if (StringUtils.isEmpty((CharSequence)payload.getOpenseaName())) {
                importError.append("\u516c\u6d77\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a;");
            }
            List company = new ArrayList();
            String customerName = payload.getCustomerName();
            if (org.springframework.util.StringUtils.hasText((String)customerName) && (company = this.crmCommonService.checkRepeatPro(map, "company", customerName)) != null && !company.isEmpty()) {
                Iterator iterator = company.iterator();
                while (iterator.hasNext()) {
                    Map stringObjectMap;
                    stringObjectMap.put("salesMan", (stringObjectMap = (Map)iterator.next()).get("salesMan") == null ? "" : stringObjectMap.get("salesMan"));
                    importWarn.append("\u91cd\u590d\u7c7b\u578b\uff1a" + stringObjectMap.get("repeatType") + ",\u4f01\u4e1a\u540d\u79f0\uff1a" + stringObjectMap.get("companyName") + ",\u8054\u7cfb\u4eba\uff1a" + stringObjectMap.get("contactsName") + ",\u8054\u7cfb\u4eba\u7535\u8bdd\uff1a" + stringObjectMap.get("contactsPhone") + "\uff0c\u9500\u552e\u4eba\u5458\uff1a" + stringObjectMap.get("salesMan") + ";");
                }
            }
            if (org.springframework.util.StringUtils.hasText((String)(customerPhone = payload.getCustomerPhone())) && (phone = this.crmCommonService.checkRepeatPro(map, "phone", customerPhone)) != null && !phone.isEmpty()) {
                for (Map stringObjectMap : phone) {
                    boolean repeatFlag = false;
                    for (Map companyMap : company) {
                        if (!companyMap.get("id").equals(stringObjectMap.get("id")) || !companyMap.get("repeatType").equals(stringObjectMap.get("repeatType"))) continue;
                        repeatFlag = true;
                        break;
                    }
                    if (repeatFlag) continue;
                    stringObjectMap.put("salesMan", stringObjectMap.get("salesMan") == null ? "" : stringObjectMap.get("salesMan"));
                    importWarn.append("\u91cd\u590d\u7c7b\u578b\uff1a" + stringObjectMap.get("repeatType") + ",\u4f01\u4e1a\u540d\u79f0\uff1a" + stringObjectMap.get("companyName") + ",\u8054\u7cfb\u4eba\uff1a" + stringObjectMap.get("contactsName") + ",\u8054\u7cfb\u4eba\u7535\u8bdd\uff1a" + stringObjectMap.get("contactsPhone") + "\uff0c\u9500\u552e\u4eba\u5458\uff1a" + stringObjectMap.get("salesMan") + ";");
                }
            }
            if (org.springframework.util.StringUtils.hasText((String)(createTimeStr = payload.getCreateTimeStr()))) {
                try {
                    LocalDate parse = LocalDate.parse(createTimeStr);
                    payload.setCreateTime(parse.atStartOfDay());
                }
                catch (Exception e) {
                    importError.append("\u521b\u5efa\u65f6\u95f4\u5fc5\u987b\u662f\u65e5\u671f\u7c7b\u578b");
                }
            }
            payload.setImoprtError(importError.toString());
            payload.setImportWarn(importWarn.toString());
        }
        int warnNum = 0;
        int errorNum = 0;
        for (CrmPotentialCustomerPayload potentialCustomerPayload : crmPotentialCustomerPayloadList) {
            if (org.springframework.util.StringUtils.hasText((String)potentialCustomerPayload.getImoprtError())) {
                ++errorNum;
            }
            if (!org.springframework.util.StringUtils.hasText((String)potentialCustomerPayload.getImportWarn()) || force.booleanValue()) continue;
            ++warnNum;
        }
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        if (errorNum > 0) {
            resultMap.put("ok", "error");
            resultMap.put("errorNum", errorNum);
            resultMap.put("warnNum", warnNum);
            resultMap.put("downloadUrl", this.downloadModelWithData(crmPotentialCustomerPayloadList));
        } else if (warnNum > 0) {
            resultMap.put("ok", "warn");
            resultMap.put("warnNum", warnNum);
            resultMap.put("downloadUrl", this.downloadModelWithData(crmPotentialCustomerPayloadList));
        } else {
            this.saveAll(crmPotentialCustomerPayloadList);
            resultMap.put("ok", "ok");
        }
        return resultMap;
    }

    public List<CrmLeadsOffshoreDO> queryLeadsList(CrmLeadsOffshoreQuery leadsOffshoreQuery) {
        Specification<CrmLeadsOffshoreDO> spec = this.leadsOffshoreDAO.getSpec(leadsOffshoreQuery);
        List<CrmLeadsOffshoreDO> content = this.leadsOffshoreDAO.findAll(spec);
        return content;
    }

    public List<CrmPotentialCustomerDO> queryPotentialCustomerList(CrmPotentialCustomerQuery query) {
        Specification<CrmPotentialCustomerDO> spec = this.potentialCustomerDAO.getSpec(query);
        return this.potentialCustomerDAO.findAll(spec);
    }

    private Object downloadModelWithData(List<CrmPotentialCustomerPayload> records) {
        Workbook workbook = this.getVol();
        try {
            XSSFSheet batchProjectSheet = (XSSFSheet)workbook.getSheet("\u6f5c\u5728\u5ba2\u6237\u6570\u636e");
            if (!CollectionUtils.isEmpty(records) && batchProjectSheet != null) {
                XSSFCell errorCell = batchProjectSheet.getRow(0).getCell(17) == null ? batchProjectSheet.getRow(0).createCell(17) : batchProjectSheet.getRow(0).getCell(17);
                errorCell.setCellValue("\u5bfc\u5165\u9519\u8bef");
                XSSFCell warnCell = batchProjectSheet.getRow(0).getCell(18) == null ? batchProjectSheet.getRow(0).createCell(18) : batchProjectSheet.getRow(0).getCell(18);
                warnCell.setCellValue("\u5bfc\u5165\u8b66\u544a");
                int nextRow = 1;
                for (CrmPotentialCustomerPayload dataPayload : records) {
                    XSSFRow row = batchProjectSheet.getRow(nextRow);
                    if (row == null) {
                        row = batchProjectSheet.createRow(nextRow);
                    }
                    this.excelUtil.setCellValueNew((Row)row, 0, nextRow);
                    this.excelUtil.setCellValueNew((Row)row, 1, dataPayload.getOpenseaName());
                    this.excelUtil.setCellValueNew((Row)row, 25, dataPayload.getOpenseaId());
                    this.excelUtil.setCellValueNew((Row)row, 2, dataPayload.getMarketIdDesc());
                    this.excelUtil.setCellValueNew((Row)row, 26, dataPayload.getMarketId());
                    this.excelUtil.setCellValueNew((Row)row, 3, dataPayload.getCustomerName());
                    this.excelUtil.setCellValueNew((Row)row, 4, dataPayload.getCustomerGradeDesc());
                    this.excelUtil.setCellValueNew((Row)row, 27, dataPayload.getCustomerGrade());
                    this.excelUtil.setCellValueNew((Row)row, 5, dataPayload.getCustomerIndustryDesc());
                    this.excelUtil.setCellValueNew((Row)row, 28, dataPayload.getCustomerIndustry());
                    this.excelUtil.setCellValueNew((Row)row, 6, dataPayload.getCustomerContacts());
                    this.excelUtil.setCellValueNew((Row)row, 7, dataPayload.getCustomerPhone());
                    this.excelUtil.setCellValueNew((Row)row, 8, dataPayload.getCustomerEmail());
                    this.excelUtil.setCellValueNew((Row)row, 29, dataPayload.getCustRegion());
                    this.excelUtil.setCellValueNew((Row)row, 10, dataPayload.getCustomerLocationCityName());
                    this.excelUtil.setCellValueNew((Row)row, 30, dataPayload.getMarketChannel());
                    this.excelUtil.setCellValueNew((Row)row, 12, dataPayload.getCustomerLocationDetail());
                    this.excelUtil.setCellValueNew((Row)row, 13, dataPayload.getCreateTime());
                    this.excelUtil.setCellValueNew((Row)row, 14, dataPayload.getRemark());
                    this.excelUtil.setCellValueNew((Row)row, 15, dataPayload.getContactsDepartment());
                    this.excelUtil.setCellValueNew((Row)row, 16, dataPayload.getContactsPosition());
                    this.excelUtil.setCellValueNew((Row)row, 17, dataPayload.getImoprtError());
                    this.excelUtil.setCellValueNew((Row)row, 18, dataPayload.getImportWarn());
                    ++nextRow;
                }
            }
            String fileName = "\u6f5c\u5728\u5ba2\u6237\u6570\u636e\u5bfc\u5165-" + UUID.randomUUID() + ".xlsx";
            File file = ExcelUtil.workbookToFile(workbook, fileName);
            ApiResult upload = this.fileService.upload(file);
            return upload.getData();
        }
        catch (Exception e) {
            e.printStackTrace();
            return -1;
        }
    }

    public void batchAddTags(Long[] keys, String tagIds) {
        String newTags = "";
        for (Long key : keys) {
            CrmPotentialCustomerPayload payload = new CrmPotentialCustomerPayload();
            payload.setId(key);
            CrmPotentialCustomerDO potentialCustomerDO = this.dao.queryById(key);
            String existingTagIds = potentialCustomerDO.getTagIds();
            if (existingTagIds != null && !existingTagIds.isEmpty() && tagIds != null && !tagIds.isEmpty()) {
                ArrayList<String> tagIdList = new ArrayList<String>(Arrays.asList(existingTagIds.split(",")));
                tagIdList.addAll(new ArrayList<String>(Arrays.asList(tagIds.split(","))));
                newTags = String.join((CharSequence)",", tagIdList.stream().distinct().collect(Collectors.toList()));
            } else {
                newTags = tagIds;
            }
            payload.setTagIds(newTags);
            this.dao.updateByKeyDynamic(payload);
        }
    }

    public void batchDelTags(Long[] keys, String tagIds) {
        String newTags = "";
        for (Long key : keys) {
            CrmPotentialCustomerPayload payload = new CrmPotentialCustomerPayload();
            payload.setId(key);
            CrmPotentialCustomerDO potentialCustomerDO = this.dao.queryById(key);
            String existingTagIds = potentialCustomerDO.getTagIds();
            if (existingTagIds != null && !existingTagIds.isEmpty()) {
                if (tagIds != null && !tagIds.isEmpty()) {
                    ArrayList<String> tagIdList = new ArrayList<String>(Arrays.asList(existingTagIds.split(",")));
                    tagIdList.removeAll(new ArrayList<String>(Arrays.asList(tagIds.split(","))));
                    newTags = String.join((CharSequence)",", tagIdList.stream().distinct().collect(Collectors.toList()));
                } else {
                    newTags = existingTagIds;
                }
            } else {
                newTags = null;
            }
            payload.setTagIds(newTags);
            this.dao.updateByKeyDynamic(payload);
        }
    }

    public CrmPotentialCustomerServiceImpl(CrmPotentialCustomerDAO dao, CacheUtil cacheUtil, PrdSystemLogService logService, CrmLeadsService leadsService, CrmLeadsDAO leadsDAO, PrdSystemLogDAO logDAO, PrjProjectDAO marketDAO, CrmOpenseaDAO openseaDAO, CrmOpenseaService openseaService, CrmFollowService followService, ExcelUtil excelUtil, PrdSystemSelectionService selectionService, FileService fileService, CrmCommonService crmCommonService, PrdSystemRoleDAO systemRoleDAO, CrmFollowService crmFollowService, CrmLeadsOffshoreDAO leadsOffshoreDAO, CrmPotentialCustomerDAO potentialCustomerDAO, ChangeFieldLogUtil changeFieldLogUtil, CrmOffshoreDAO offshoreDAO, UdcUtil udcUtil, BusinessCustomerInfoService businessCustomerInfoService) {
        this.dao = dao;
        this.cacheUtil = cacheUtil;
        this.logService = logService;
        this.leadsService = leadsService;
        this.leadsDAO = leadsDAO;
        this.logDAO = logDAO;
        this.marketDAO = marketDAO;
        this.openseaDAO = openseaDAO;
        this.openseaService = openseaService;
        this.followService = followService;
        this.excelUtil = excelUtil;
        this.selectionService = selectionService;
        this.fileService = fileService;
        this.crmCommonService = crmCommonService;
        this.systemRoleDAO = systemRoleDAO;
        this.crmFollowService = crmFollowService;
        this.leadsOffshoreDAO = leadsOffshoreDAO;
        this.potentialCustomerDAO = potentialCustomerDAO;
        this.changeFieldLogUtil = changeFieldLogUtil;
        this.offshoreDAO = offshoreDAO;
        this.udcUtil = udcUtil;
        this.businessCustomerInfoService = businessCustomerInfoService;
    }
}

