/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5.server.prd.pms.dao;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.common.TwQueryParam;
import com.elitesland.tw.tw5.api.prd.pms.payload.BuProjectPayload;
import com.elitesland.tw.tw5.api.prd.pms.query.BuProjectQuery;
import com.elitesland.tw.tw5.api.prd.pms.vo.BuProjectVO;
import com.elitesland.tw.tw5.server.common.util.SqlUtil;
import com.elitesland.tw.tw5.server.prd.pms.entity.BuProjectDO;
import com.elitesland.tw.tw5.server.prd.pms.entity.QBuProjectDO;
import com.elitesland.tw.tw5.server.prd.pms.entity.QBuProjectMembersDO;
import com.elitesland.tw.tw5.server.prd.pms.repo.BuProjectRepo;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.core.types.dsl.BooleanExpression;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import com.querydsl.jpa.impl.JPAUpdateClause;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.ObjectUtils;

@Repository
public class BuProjectDAO {
    private final JPAQueryFactory jpaQueryFactory;
    private final BuProjectRepo repo;
    private final QBuProjectDO qdo = QBuProjectDO.buProjectDO;
    private final QBuProjectMembersDO qdoMembers = QBuProjectMembersDO.buProjectMembersDO;

    private JPAQuery<BuProjectVO> getJpaQuerySelect() {
        return (JPAQuery)((JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)Projections.bean(BuProjectVO.class, (Expression[])new Expression[]{this.qdo.id, this.qdo.remark, this.qdo.createUserId, this.qdo.creator, this.qdo.createTime, this.qdo.buId, this.qdo.projYear, this.qdo.projNo, this.qdo.projName, this.qdo.projStatus, this.qdo.projTempId, this.qdo.subjectTempId, this.qdo.planStartDate, this.qdo.planEndDate, this.qdo.pmResId, this.qdo.pmEqvaRatio, this.qdo.deliBuId, this.qdo.deliUserId, this.qdo.totalDays, this.qdo.totalEqva, this.qdo.totalReimbursement, this.qdo.eqvaPrice, this.qdo.totalCost, this.qdo.closeReason, this.qdo.projProcessStatus, this.qdo.autoReportFlag, this.qdo.ext1, this.qdo.ext2, this.qdo.ext3, this.qdo.ext4, this.qdo.ext5})).from((EntityPath)this.qdo)).leftJoin((EntityPath)this.qdoMembers)).on((Predicate)this.qdoMembers.projId.eq(this.qdo.id));
    }

    private JPAQuery<BuProjectVO> getJpaQueryWhere(BuProjectQuery query) {
        JPAQuery<BuProjectVO> jpaQuery = this.getJpaQuerySelect();
        jpaQuery.where(this.where(query));
        SqlUtil.handleCommonJpaQuery(jpaQuery, this.qdo._super, (TwQueryParam)query);
        jpaQuery.orderBy(SqlUtil.getSortedColumn(this.qdo, query.getOrders()));
        jpaQuery.groupBy(this.qdo.id);
        return jpaQuery;
    }

    public long count(BuProjectQuery query) {
        JPAQuery jpaQuery = (JPAQuery)((JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)this.qdo.count()).from((EntityPath)this.qdo)).leftJoin((EntityPath)this.qdoMembers)).on((Predicate)this.qdoMembers.projId.eq(this.qdo.id));
        jpaQuery.where(this.where(query));
        SqlUtil.handleCommonJpaQuery(jpaQuery, this.qdo._super, (TwQueryParam)query);
        jpaQuery.groupBy(this.qdo.id);
        List fetch = jpaQuery.fetch();
        return fetch.size();
    }

    private Predicate where(BuProjectQuery query) {
        List<Predicate> list = this.whereCommon(query);
        if (query.getPermissionFlag().booleanValue()) {
            list.add((Predicate)this.qdoMembers.deleteFlag.eq((Object)0));
            list.add((Predicate)this.qdoMembers.resId.eq((Object)query.getLoginUserId()));
            BooleanExpression orExpression = this.qdo.pmResId.eq((Object)query.getLoginUserId()).or((Predicate)this.qdo.deliUserId.eq((Object)query.getLoginUserId()));
            list.add((Predicate)orExpression);
        }
        if (query.getPermissionFlagForTimesheet().booleanValue()) {
            list.add((Predicate)this.qdoMembers.deleteFlag.eq((Object)0));
            list.add((Predicate)this.qdoMembers.resId.eq((Object)query.getLoginUserId()));
        }
        return ExpressionUtils.allOf(list);
    }

    @NotNull
    private List<Predicate> whereCommon(BuProjectQuery query) {
        ArrayList<Predicate> list = new ArrayList<Predicate>();
        if (!ObjectUtils.isEmpty((Object)query.getId())) {
            list.add((Predicate)this.qdo.id.eq((Object)query.getId()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getIds())) {
            list.add((Predicate)this.qdo.id.in((Collection)query.getIds()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getBuId())) {
            list.add((Predicate)this.qdo.buId.eq((Object)query.getBuId()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getProjYear())) {
            list.add((Predicate)this.qdo.projYear.eq((Object)query.getProjYear()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getProjNo())) {
            list.add((Predicate)this.qdo.projNo.like(SqlUtil.toSqlLikeString(query.getProjNo())));
        }
        if (!ObjectUtils.isEmpty((Object)query.getProjName())) {
            list.add((Predicate)this.qdo.projName.like(SqlUtil.toSqlLikeString(query.getProjName())));
        }
        if (!ObjectUtils.isEmpty((Object)query.getProjStatus())) {
            list.add((Predicate)this.qdo.projStatus.eq((Object)query.getProjStatus()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getProjTempId())) {
            list.add((Predicate)this.qdo.projTempId.eq((Object)query.getProjTempId()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getSubjectTempId())) {
            list.add((Predicate)this.qdo.subjectTempId.eq((Object)query.getSubjectTempId()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getPlanStartDate())) {
            list.add((Predicate)this.qdo.planStartDate.eq((Object)query.getPlanStartDate()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getPlanEndDate())) {
            list.add((Predicate)this.qdo.planEndDate.eq((Object)query.getPlanEndDate()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getPmResId())) {
            list.add((Predicate)this.qdo.pmResId.eq((Object)query.getPmResId()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getPmEqvaRatio())) {
            list.add((Predicate)this.qdo.pmEqvaRatio.eq((Object)query.getPmEqvaRatio()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getDeliBuId())) {
            list.add((Predicate)this.qdo.deliBuId.eq((Object)query.getDeliBuId()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getDeliUserId())) {
            list.add((Predicate)this.qdo.deliUserId.eq((Object)query.getDeliUserId()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getTotalDays())) {
            list.add((Predicate)this.qdo.totalDays.eq((Object)query.getTotalDays()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getTotalEqva())) {
            list.add((Predicate)this.qdo.totalEqva.eq((Object)query.getTotalEqva()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getTotalReimbursement())) {
            list.add((Predicate)this.qdo.totalReimbursement.eq((Object)query.getTotalReimbursement()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getEqvaPrice())) {
            list.add((Predicate)this.qdo.eqvaPrice.eq((Object)query.getEqvaPrice()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getTotalCost())) {
            list.add((Predicate)this.qdo.totalCost.eq((Object)query.getTotalCost()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getCloseReason())) {
            list.add((Predicate)this.qdo.closeReason.eq((Object)query.getCloseReason()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getProjProcessStatus())) {
            list.add((Predicate)this.qdo.projProcessStatus.eq((Object)query.getProjProcessStatus()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getAutoReportFlag())) {
            list.add((Predicate)this.qdo.autoReportFlag.eq((Object)query.getAutoReportFlag()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getExt1())) {
            list.add((Predicate)this.qdo.ext1.eq((Object)query.getExt1()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getExt2())) {
            list.add((Predicate)this.qdo.ext2.eq((Object)query.getExt2()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getExt3())) {
            list.add((Predicate)this.qdo.ext3.eq((Object)query.getExt3()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getExt4())) {
            list.add((Predicate)this.qdo.ext4.eq((Object)query.getExt4()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getExt5())) {
            list.add((Predicate)this.qdo.ext5.eq((Object)query.getExt5()));
        }
        if (query.getHwhtSyncFlag() != null) {
            list.add((Predicate)this.qdo.hwhtSyncFlag.eq((Object)query.getHwhtSyncFlag()));
        }
        return list;
    }

    public BuProjectVO queryByKey(Long id) {
        JPAQuery<BuProjectVO> jpaQuery = this.getJpaQuerySelect();
        jpaQuery.where((Predicate)this.qdo.id.eq((Object)id));
        jpaQuery.where((Predicate)this.qdo.deleteFlag.eq((Object)0));
        return (BuProjectVO)jpaQuery.fetchFirst();
    }

    public List<BuProjectVO> queryListDynamic(BuProjectQuery query) {
        JPAQuery<BuProjectVO> jpaQuery = this.getJpaQueryWhere(query);
        return jpaQuery.fetch();
    }

    public PagingVO<BuProjectVO> queryPaging(BuProjectQuery query) {
        long total = this.count(query);
        if (total == 0L) {
            return PagingVO.empty();
        }
        JPAQuery<BuProjectVO> jpaQuery = this.getJpaQueryWhere(query);
        List result = ((JPAQuery)((JPAQuery)jpaQuery.offset(query.getPageRequest().getOffset())).limit((long)query.getPageRequest().getPageSize())).fetch();
        return PagingVO.builder().records(result).total(total).build();
    }

    public BuProjectDO save(BuProjectDO ado) {
        return (BuProjectDO)this.repo.save(ado);
    }

    public List<BuProjectDO> saveAll(List<BuProjectDO> dos) {
        return this.repo.saveAll(dos);
    }

    @Transactional
    public long updateByKeyDynamic(BuProjectPayload payload) {
        List nullFields;
        JPAUpdateClause update = this.jpaQueryFactory.update((EntityPath)this.qdo).where(new Predicate[]{this.qdo.id.eq((Object)payload.getId())});
        if (payload.getId() != null) {
            update.set(this.qdo.id, (Object)payload.getId());
        }
        if (payload.getBuId() != null) {
            update.set(this.qdo.buId, (Object)payload.getBuId());
        }
        if (payload.getProjYear() != null) {
            update.set(this.qdo.projYear, (Object)payload.getProjYear());
        }
        if (payload.getProjNo() != null) {
            update.set((Path)this.qdo.projNo, (Object)payload.getProjNo());
        }
        if (payload.getProjName() != null) {
            update.set((Path)this.qdo.projName, (Object)payload.getProjName());
        }
        if (payload.getProjStatus() != null) {
            update.set((Path)this.qdo.projStatus, (Object)payload.getProjStatus());
        }
        if (payload.getProjTempId() != null) {
            update.set((Path)this.qdo.projTempId, (Object)payload.getProjTempId());
        }
        if (payload.getSubjectTempId() != null) {
            update.set(this.qdo.subjectTempId, (Object)payload.getSubjectTempId());
        }
        if (payload.getPlanStartDate() != null) {
            update.set(this.qdo.planStartDate, (Object)payload.getPlanStartDate());
        }
        if (payload.getPlanEndDate() != null) {
            update.set(this.qdo.planEndDate, (Object)payload.getPlanEndDate());
        }
        if (payload.getPmResId() != null) {
            update.set(this.qdo.pmResId, (Object)payload.getPmResId());
        }
        if (payload.getPmEqvaRatio() != null) {
            update.set(this.qdo.pmEqvaRatio, (Object)payload.getPmEqvaRatio());
        }
        if (payload.getDeliBuId() != null) {
            update.set(this.qdo.deliBuId, (Object)payload.getDeliBuId());
        }
        if (payload.getDeliUserId() != null) {
            update.set(this.qdo.deliUserId, (Object)payload.getDeliUserId());
        }
        if (payload.getTotalDays() != null) {
            update.set(this.qdo.totalDays, (Object)payload.getTotalDays());
        }
        if (payload.getTotalEqva() != null) {
            update.set(this.qdo.totalEqva, (Object)payload.getTotalEqva());
        }
        if (payload.getTotalReimbursement() != null) {
            update.set(this.qdo.totalReimbursement, (Object)payload.getTotalReimbursement());
        }
        if (payload.getEqvaPrice() != null) {
            update.set(this.qdo.eqvaPrice, (Object)payload.getEqvaPrice());
        }
        if (payload.getTotalCost() != null) {
            update.set(this.qdo.totalCost, (Object)payload.getTotalCost());
        }
        if (payload.getCloseReason() != null) {
            update.set((Path)this.qdo.closeReason, (Object)payload.getCloseReason());
        }
        if (payload.getProjProcessStatus() != null) {
            update.set((Path)this.qdo.projProcessStatus, (Object)payload.getProjProcessStatus());
        }
        if (payload.getAutoReportFlag() != null) {
            update.set(this.qdo.autoReportFlag, (Object)payload.getAutoReportFlag());
        }
        if (payload.getExt1() != null) {
            update.set((Path)this.qdo.ext1, (Object)payload.getExt1());
        }
        if (payload.getExt2() != null) {
            update.set((Path)this.qdo.ext2, (Object)payload.getExt2());
        }
        if (payload.getExt3() != null) {
            update.set((Path)this.qdo.ext3, (Object)payload.getExt3());
        }
        if (payload.getExt4() != null) {
            update.set((Path)this.qdo.ext4, (Object)payload.getExt4());
        }
        if (payload.getExt5() != null) {
            update.set((Path)this.qdo.ext5, (Object)payload.getExt5());
        }
        if ((nullFields = payload.getNullFields()) != null && nullFields.size() > 0) {
            if (nullFields.contains("id")) {
                update.setNull(this.qdo.id);
            }
            if (nullFields.contains("buId")) {
                update.setNull(this.qdo.buId);
            }
            if (nullFields.contains("projYear")) {
                update.setNull(this.qdo.projYear);
            }
            if (nullFields.contains("projNo")) {
                update.setNull((Path)this.qdo.projNo);
            }
            if (nullFields.contains("projName")) {
                update.setNull((Path)this.qdo.projName);
            }
            if (nullFields.contains("projStatus")) {
                update.setNull((Path)this.qdo.projStatus);
            }
            if (nullFields.contains("projTempId")) {
                update.setNull((Path)this.qdo.projTempId);
            }
            if (nullFields.contains("subjectTempId")) {
                update.setNull(this.qdo.subjectTempId);
            }
            if (nullFields.contains("planStartDate")) {
                update.setNull(this.qdo.planStartDate);
            }
            if (nullFields.contains("planEndDate")) {
                update.setNull(this.qdo.planEndDate);
            }
            if (nullFields.contains("pmResId")) {
                update.setNull(this.qdo.pmResId);
            }
            if (nullFields.contains("pmEqvaRatio")) {
                update.setNull(this.qdo.pmEqvaRatio);
            }
            if (nullFields.contains("deliBuId")) {
                update.setNull(this.qdo.deliBuId);
            }
            if (nullFields.contains("deliUserId")) {
                update.setNull(this.qdo.deliUserId);
            }
            if (nullFields.contains("totalDays")) {
                update.setNull(this.qdo.totalDays);
            }
            if (nullFields.contains("totalEqva")) {
                update.setNull(this.qdo.totalEqva);
            }
            if (nullFields.contains("totalReimbursement")) {
                update.setNull(this.qdo.totalReimbursement);
            }
            if (nullFields.contains("eqvaPrice")) {
                update.setNull(this.qdo.eqvaPrice);
            }
            if (nullFields.contains("totalCost")) {
                update.setNull(this.qdo.totalCost);
            }
            if (nullFields.contains("closeReason")) {
                update.setNull((Path)this.qdo.closeReason);
            }
            if (nullFields.contains("projProcessStatus")) {
                update.setNull((Path)this.qdo.projProcessStatus);
            }
            if (nullFields.contains("autoReportFlag")) {
                update.setNull(this.qdo.autoReportFlag);
            }
            if (nullFields.contains("ext1")) {
                update.setNull((Path)this.qdo.ext1);
            }
            if (nullFields.contains("ext2")) {
                update.setNull((Path)this.qdo.ext2);
            }
            if (nullFields.contains("ext3")) {
                update.setNull((Path)this.qdo.ext3);
            }
            if (nullFields.contains("ext4")) {
                update.setNull((Path)this.qdo.ext4);
            }
            if (nullFields.contains("ext5")) {
                update.setNull((Path)this.qdo.ext5);
            }
        }
        SqlUtil.updateCommonJpaQuery(update, this.qdo._super);
        return update.execute();
    }

    public long deleteSoft(List<Long> keys) {
        JPAUpdateClause update = this.jpaQueryFactory.update((EntityPath)this.qdo).set(this.qdo.deleteFlag, (Object)1).where(new Predicate[]{this.qdo.id.in(keys)});
        SqlUtil.updateCommonJpaQuery(update, this.qdo._super);
        return update.execute();
    }

    public BuProjectVO queryByBuIdAndYear(Long buId, Integer year) {
        JPAQuery<BuProjectVO> jpaQuery = this.getJpaQuerySelect();
        jpaQuery.where((Predicate)this.qdo.buId.eq((Object)buId));
        jpaQuery.where((Predicate)this.qdo.projYear.eq((Object)year));
        jpaQuery.where((Predicate)this.qdo.deleteFlag.eq((Object)0));
        return (BuProjectVO)jpaQuery.fetchFirst();
    }

    public List<BuProjectVO> queryListDynamicSimple(BuProjectQuery query) {
        JPAQuery jpaQuery = (JPAQuery)this.jpaQueryFactory.select((Expression)Projections.bean(BuProjectVO.class, (Expression[])new Expression[]{this.qdo.id, this.qdo.remark, this.qdo.createUserId, this.qdo.creator, this.qdo.createTime, this.qdo.buId, this.qdo.projYear, this.qdo.projNo, this.qdo.projName, this.qdo.projStatus, this.qdo.projTempId, this.qdo.subjectTempId, this.qdo.planStartDate, this.qdo.planEndDate, this.qdo.pmResId, this.qdo.pmEqvaRatio, this.qdo.deliBuId, this.qdo.deliUserId, this.qdo.totalDays, this.qdo.totalEqva, this.qdo.totalReimbursement, this.qdo.eqvaPrice, this.qdo.totalCost, this.qdo.closeReason, this.qdo.projProcessStatus, this.qdo.autoReportFlag, this.qdo.hwhtSyncFlag, this.qdo.ext1, this.qdo.ext2, this.qdo.ext3, this.qdo.ext4, this.qdo.ext5})).from((EntityPath)this.qdo);
        List<Predicate> predicates = this.whereCommon(query);
        Predicate predicate = ExpressionUtils.allOf(predicates);
        jpaQuery.where(predicate);
        return jpaQuery.fetch();
    }

    public long updateHwhtSyncFlag(List<Long> ids) {
        JPAUpdateClause updater = this.jpaQueryFactory.update((EntityPath)this.qdo).set(this.qdo.hwhtSyncFlag, (Object)1).where(new Predicate[]{this.qdo.id.in(ids)});
        return updater.execute();
    }

    public BuProjectDAO(JPAQueryFactory jpaQueryFactory, BuProjectRepo repo) {
        this.jpaQueryFactory = jpaQueryFactory;
        this.repo = repo;
    }
}

