/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5.server.prd.salecon.service;

import com.elitescloud.boot.core.base.BaseServiceImpl;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.org.service.PrdOrgOrganizationService;
import com.elitesland.tw.tw5.api.prd.personplan.payload.PersonPlanDtlPayload;
import com.elitesland.tw.tw5.api.prd.personplan.payload.PersonPlanPayload;
import com.elitesland.tw.tw5.api.prd.personplan.service.PersonPlanService;
import com.elitesland.tw.tw5.api.prd.personplan.vo.PersonPlanVO;
import com.elitesland.tw.tw5.api.prd.salecon.payload.SaleConExecConditionPayload;
import com.elitesland.tw.tw5.api.prd.salecon.query.OrgGrossProfitRateSettingQuery;
import com.elitesland.tw.tw5.api.prd.salecon.query.SaleConExecConditionQuery;
import com.elitesland.tw.tw5.api.prd.salecon.service.ConPurchaseDemandService;
import com.elitesland.tw.tw5.api.prd.salecon.service.OrgGrossProfitRateSettingService;
import com.elitesland.tw.tw5.api.prd.salecon.service.SaleConContractService;
import com.elitesland.tw.tw5.api.prd.salecon.service.SaleConExecConditionService;
import com.elitesland.tw.tw5.api.prd.salecon.vo.ConPurchaseDemandVO;
import com.elitesland.tw.tw5.api.prd.salecon.vo.OrgGrossProfitRateSettingVO;
import com.elitesland.tw.tw5.api.prd.salecon.vo.SaleConContractVO;
import com.elitesland.tw.tw5.api.prd.salecon.vo.SaleConExecConditionVO;
import com.elitesland.tw.tw5.api.prd.system.service.PrdSystemRoleService;
import com.elitesland.tw.tw5.server.common.service.TransactionUtilService;
import com.elitesland.tw.tw5.server.common.workFlow.ProcDefKey;
import com.elitesland.tw.tw5.server.prd.common.CacheUtil;
import com.elitesland.tw.tw5.server.prd.common.GlobalUtil;
import com.elitesland.tw.tw5.server.prd.common.WorkflowUtil;
import com.elitesland.tw.tw5.server.prd.common.functionEnum.FunctionSelectionEnum;
import com.elitesland.tw.tw5.server.prd.common.functionEnum.RoleEnum;
import com.elitesland.tw.tw5.server.prd.personplan.constants.PersonPlanTypeEnum;
import com.elitesland.tw.tw5.server.prd.salecon.convert.SaleConExecConditionConvert;
import com.elitesland.tw.tw5.server.prd.salecon.dao.SaleConExecConditionDAO;
import com.elitesland.tw.tw5.server.prd.salecon.entity.SaleConExecConditionDO;
import com.elitesland.tw.tw5.server.prd.salecon.repo.SaleConExecConditionRepo;
import com.elitesland.workflow.ProcessInfo;
import com.elitesland.workflow.payload.StartProcessPayload;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

@Service
public class SaleConExecConditionServiceImpl
extends BaseServiceImpl
implements SaleConExecConditionService {
    private static final Logger log = LoggerFactory.getLogger(SaleConExecConditionServiceImpl.class);
    private final ConPurchaseDemandService purchaseDemandService;
    private final SaleConContractService saleConContractService;
    private final CacheUtil cacheUtil;
    private final SaleConExecConditionRepo saleConExecConditionRepo;
    private final SaleConExecConditionDAO saleConExecConditionDAO;
    @Value(value="${tw5.workflow.enabled}")
    private Boolean workflow_enabled;
    private final WorkflowUtil workflowUtil;
    private final TransactionUtilService transactionUtilService;
    private final OrgGrossProfitRateSettingService orgGrossProfitRateSettingService;
    private final PrdSystemRoleService roleService;
    private final PrdOrgOrganizationService prdOrgOrganizationService;
    private final PersonPlanService personPlanService;

    public PagingVO<SaleConExecConditionVO> queryPaging(SaleConExecConditionQuery query) {
        PagingVO<SaleConExecConditionVO> saleConExecConditionPaging = this.saleConExecConditionDAO.queryPaging(query);
        if (!CollectionUtils.isEmpty((Collection)saleConExecConditionPaging.getRecords())) {
            this.translateList(saleConExecConditionPaging.getRecords());
        }
        return saleConExecConditionPaging;
    }

    public List<SaleConExecConditionVO> queryListDynamic(SaleConExecConditionQuery query) {
        List<SaleConExecConditionVO> saleConExecConditionVOS = this.saleConExecConditionDAO.queryListDynamic(query);
        if (!CollectionUtils.isEmpty(saleConExecConditionVOS)) {
            this.translateList(saleConExecConditionVOS);
        }
        return saleConExecConditionVOS;
    }

    public SaleConExecConditionVO queryByKey(Long key) {
        SaleConExecConditionVO saleConExecConditionVO = this.saleConExecConditionDAO.queryByKey(key);
        if (saleConExecConditionVO != null) {
            BigDecimal amt = saleConExecConditionVO.getAmt() == null ? BigDecimal.ZERO : saleConExecConditionVO.getAmt();
            BigDecimal taxRate = saleConExecConditionVO.getTaxRate() == null ? BigDecimal.ZERO : saleConExecConditionVO.getTaxRate();
            BigDecimal notTaxAmt = amt.divide(BigDecimal.ONE.add(taxRate), 2, RoundingMode.HALF_UP);
            saleConExecConditionVO.setNotTaxAmt(notTaxAmt);
            this.translateList(Collections.singletonList(saleConExecConditionVO));
        }
        return saleConExecConditionVO;
    }

    @Transactional
    public SaleConExecConditionVO insertOrUpdate(SaleConExecConditionPayload payload) {
        this.checkConExecCondition(payload);
        this.buildConExecCondition(payload);
        SaleConExecConditionDO entityDo = SaleConExecConditionConvert.INSTANCE.toDo(payload);
        if (ObjectUtils.isEmpty((Object)payload.getId())) {
            PersonPlanVO personPlanVO;
            SaleConExecConditionDO save = (SaleConExecConditionDO)this.saleConExecConditionRepo.save(entityDo);
            SaleConContractVO saleConContractVO = this.saleConContractService.queryByKey(payload.getContractId(), new Boolean[0]);
            Long oppoId = saleConContractVO.getOppoId();
            if (oppoId != null && (personPlanVO = this.personPlanService.getByObjIdAndPlanType(oppoId, Arrays.asList(PersonPlanTypeEnum.DELIVERY.getCode(), PersonPlanTypeEnum.PRE_SALES.getCode()))) != null) {
                PersonPlanPayload personPlanPayload = new PersonPlanPayload();
                BeanUtils.copyProperties((Object)personPlanVO, (Object)personPlanPayload);
                personPlanPayload.setId(null);
                personPlanPayload.setVersion("0");
                personPlanPayload.setPlanType(PersonPlanTypeEnum.BUDGET.getCode());
                personPlanPayload.setObjId(saleConContractVO.getId());
                personPlanPayload.setObjName(saleConContractVO.getName());
                List personPlanDtlVOList = personPlanVO.getPersonPlanDtlVOList();
                if (!CollectionUtils.isEmpty((Collection)personPlanDtlVOList)) {
                    ArrayList personPlanDtlPayloadList = new ArrayList();
                    personPlanDtlVOList.stream().forEach(personPlanDtlVO -> {
                        PersonPlanDtlPayload personPlanDtlPayload = new PersonPlanDtlPayload();
                        BeanUtils.copyProperties((Object)personPlanDtlVO, (Object)personPlanDtlPayload);
                        personPlanDtlPayload.setId(null);
                        personPlanDtlPayload.setPlanId(null);
                        personPlanDtlPayloadList.add(personPlanDtlPayload);
                    });
                    personPlanPayload.setPersonPlanDtlPayloadList(personPlanDtlPayloadList);
                }
                this.personPlanService.save(personPlanPayload);
            }
            return SaleConExecConditionConvert.INSTANCE.toVo(save);
        }
        this.saleConExecConditionDAO.updateByKeyDynamic(payload);
        return SaleConExecConditionConvert.INSTANCE.toVo(entityDo);
    }

    @Transactional
    public SaleConExecConditionVO update(SaleConExecConditionPayload payload) {
        SaleConExecConditionDO entity = this.saleConExecConditionRepo.findById(payload.getId()).orElseGet(SaleConExecConditionDO::new);
        Assert.notNull((Object)entity.getId(), (String)"\u4e0d\u5b58\u5728");
        SaleConExecConditionDO entityDo = SaleConExecConditionConvert.INSTANCE.toDo(payload);
        entity.copy(entityDo);
        return SaleConExecConditionConvert.INSTANCE.toVo((SaleConExecConditionDO)this.saleConExecConditionRepo.save(entity));
    }

    @Transactional
    public long updateByKeyDynamic(SaleConExecConditionPayload payload) {
        SaleConExecConditionDO entity = this.saleConExecConditionRepo.findById(payload.getId()).orElseGet(SaleConExecConditionDO::new);
        Assert.notNull((Object)entity.getId(), (String)"\u4e0d\u5b58\u5728");
        return this.saleConExecConditionDAO.updateByKeyDynamic(payload);
    }

    @Transactional
    public void deleteSoft(List<Long> keys) {
        if (!keys.isEmpty()) {
            this.saleConExecConditionDAO.deleteSoft(keys);
        }
    }

    private void checkConExecCondition(SaleConExecConditionPayload payload) {
        Assert.notNull((Object)payload, (String)"\u672a\u4f20payload\u5bf9\u8c61");
        Assert.notNull((Object)payload.getContractId(), (String)"\u5408\u540cid\u4e3a\u7a7a");
    }

    public SaleConExecConditionPayload buildConExecCondition(SaleConExecConditionPayload payload) {
        List<OrgGrossProfitRateSettingVO> orgGrossProfitRateSettingVOS;
        SaleConContractVO conContractVO = this.saleConContractService.queryByKey(payload.getContractId(), new Boolean[0]);
        Long contractId = payload.getContractId();
        BigDecimal demandTotalAmt = this.getConPurchaseAmt(contractId);
        payload.setContractId(contractId);
        payload.setSignAmt(conContractVO.getAmt());
        payload.setTaxRate(conContractVO.getTaxRate());
        payload.setPurchaseAmt(demandTotalAmt);
        payload.setEffectConAmt(conContractVO.getEffectiveAmt());
        String conPriceLevel = payload.getConPriceLevel();
        if (StringUtils.hasText((String)conPriceLevel)) {
            String selectionValue = this.cacheUtil.transferSystemSelection(FunctionSelectionEnum.SaleConPriceLevel.getCode(), conPriceLevel);
            payload.setConPriceLevel(selectionValue);
        }
        payload.setStatisticDate(LocalDate.now());
        if (payload.getId() == null && !CollectionUtils.isEmpty(orgGrossProfitRateSettingVOS = this.queryOrgGrossProfitRateSetting(conContractVO))) {
            payload.setBuGross(orgGrossProfitRateSettingVOS.get(0).getOrgGrossProfitRate() == null ? BigDecimal.ZERO : orgGrossProfitRateSettingVOS.get(0).getOrgGrossProfitRate());
            payload.setOverOrderGross(orgGrossProfitRateSettingVOS.get(0).getOrderGrossProfitRate() == null ? BigDecimal.ZERO : orgGrossProfitRateSettingVOS.get(0).getOrderGrossProfitRate());
        }
        return payload;
    }

    List<OrgGrossProfitRateSettingVO> queryOrgGrossProfitRateSetting(SaleConContractVO conContractVO) {
        OrgGrossProfitRateSettingQuery orgGrossProfitRateSettingQuery = new OrgGrossProfitRateSettingQuery();
        Long deliBuId = conContractVO.getDeliBuId();
        List prdOrgOrganizationRefVOS = this.prdOrgOrganizationService.queryAllFatherOrgByOrgId(deliBuId);
        List orgIdList = prdOrgOrganizationRefVOS.stream().map(e -> e.getOrgId()).collect(Collectors.toList());
        orgGrossProfitRateSettingQuery.setOrgIdList(orgIdList);
        orgGrossProfitRateSettingQuery.setWorkType(conContractVO.getWorkType());
        orgGrossProfitRateSettingQuery.setStartDate(LocalDate.parse(conContractVO.getCreateTime().format(DateTimeFormatter.ofPattern("yyyy-MM-dd"))));
        orgGrossProfitRateSettingQuery.setEndDate(LocalDate.parse(conContractVO.getCreateTime().format(DateTimeFormatter.ofPattern("yyyy-MM-dd"))));
        List orgGrossProfitRateSettingVOS = this.orgGrossProfitRateSettingService.queryListDynamic(orgGrossProfitRateSettingQuery);
        return orgGrossProfitRateSettingVOS;
    }

    public SaleConExecConditionVO queryByContractId(Long contractId) {
        SaleConExecConditionVO vo = this.saleConExecConditionDAO.queryByContractId(contractId);
        if (ObjectUtils.isEmpty((Object)vo)) {
            return new SaleConExecConditionVO();
        }
        String conPriceLevel = vo.getConPriceLevel();
        String selectionValue = this.cacheUtil.getSystemSelectionValueByName(FunctionSelectionEnum.SaleConPriceLevel.getCode(), conPriceLevel);
        vo.setConPriceLevel(selectionValue);
        vo.setConPriceLevelDesc(conPriceLevel);
        return vo;
    }

    public BigDecimal calcEffectAmt(SaleConExecConditionPayload payload) {
        SaleConContractVO conContractVO = this.saleConContractService.queryByKey(payload.getContractId(), new Boolean[0]);
        BigDecimal calcTaxRate = new BigDecimal(1).add(conContractVO.getTaxRate());
        BigDecimal demandTotalAmt = this.getConPurchaseAmt(payload.getContractId());
        if (payload.getSaleExpense() == null) {
            payload.setSaleExpense(BigDecimal.ZERO);
        }
        BigDecimal calcEffectAmt = conContractVO.getAmt().divide(calcTaxRate, 2, RoundingMode.HALF_UP).subtract(payload.getSaleExpense()).subtract(payload.getProjExpense());
        if (demandTotalAmt.compareTo(BigDecimal.ZERO) > 0) {
            calcEffectAmt = calcEffectAmt.subtract(demandTotalAmt.divide(calcTaxRate, 2, RoundingMode.HALF_UP));
        }
        return calcEffectAmt;
    }

    @Transactional
    public void saleConExecConditionApply(SaleConExecConditionVO vo, SaleConContractVO saleConContractVO) {
        Long id = null;
        if (vo == null || vo.getId() == null) {
            SaleConExecConditionPayload saleConExecConditionPayload = new SaleConExecConditionPayload();
            saleConExecConditionPayload.setContractId(saleConContractVO.getId());
            vo = this.insertOrUpdate(saleConExecConditionPayload);
            id = vo.getId();
        } else {
            id = vo.getId();
        }
        if (vo.getProcInstId() == null) {
            ProcessInfo processInfo = new ProcessInfo();
            if (this.workflow_enabled.booleanValue()) {
                HashMap<String, Object> variables = new HashMap<String, Object>();
                Long deliBuLeader = this.prdOrgOrganizationService.queryManageIdById(saleConContractVO.getDeliBuId());
                variables.put("Activity_030x3nk", deliBuLeader);
                List<OrgGrossProfitRateSettingVO> orgGrossProfitRateSettingVOS = this.queryOrgGrossProfitRateSetting(saleConContractVO);
                List collect = ObjectUtils.isEmpty(orgGrossProfitRateSettingVOS) ? this.roleService.queryUserIdByRoleCode(RoleEnum.PLAT_RESOURCE_DIRECTOR.getCode()) : orgGrossProfitRateSettingVOS.stream().map(OrgGrossProfitRateSettingVO::getResManagerId).collect(Collectors.toList());
                variables.put("Activity_1klbasn", collect);
                List finclist = this.roleService.queryUserIdByRoleCode(RoleEnum.PLAT_FIN_CHECK.getCode());
                variables.put("Activity_1qkxzp9", finclist);
                List cfolist = this.roleService.queryUserIdByRoleCode(RoleEnum.PLAT_CFO.getCode());
                variables.put("Activity_1lhuzn9", cfolist);
                Boolean amtFlag = false;
                if (saleConContractVO.getAmt() != null && saleConContractVO.getAmt().compareTo(new BigDecimal(500000)) > 0) {
                    amtFlag = true;
                }
                variables.put("amtFlag", amtFlag);
                List planFinlist = this.roleService.queryUserIdByRoleCode(RoleEnum.PLAT_FIN_PIC.getCode());
                variables.put("Activity_18pk6yw", planFinlist);
                processInfo = this.workflowUtil.startProcess(StartProcessPayload.of((String)ProcDefKey.SALE_CON_BUDGET.name(), (String)(saleConContractVO.getName() + "-\u5408\u540c\u9884\u7b97\u6d41\u7a0b"), (String)("" + id), variables), deliBuLeader);
            }
            SaleConExecConditionPayload payload = new SaleConExecConditionPayload();
            payload.setProcInstId(processInfo.getProcInstId());
            payload.setId(id);
            payload.setProcInstStatus(processInfo.getProcInstStatus());
            payload.setSubmitTime(LocalDateTime.now());
            this.transactionUtilService.executeWithRunnable(() -> this.saleConExecConditionDAO.updateByKeyDynamic(payload));
        }
    }

    public PagingVO<SaleConExecConditionVO> queryWorkAgentFlagPaging(SaleConExecConditionQuery query) {
        Long loginUserId = GlobalUtil.getLoginUserId();
        query.setLoginUserId(loginUserId);
        query.setWorkAgentFlag(Boolean.valueOf(true));
        return this.saleConExecConditionDAO.queryWorkAgentFlagPaging(query);
    }

    public Long queryWorkAgentFlagCount(Long userId) {
        SaleConExecConditionQuery query = new SaleConExecConditionQuery();
        query.setLoginUserId(userId);
        query.setWorkAgentFlag(Boolean.valueOf(true));
        return this.saleConExecConditionDAO.queryWorkAgentFlagCount(query);
    }

    private BigDecimal getConPurchaseAmt(Long contractId) {
        BigDecimal demandTotalAmt = BigDecimal.ZERO;
        ConPurchaseDemandVO conPurchaseDemandVO = this.purchaseDemandService.queryBySaleConId(contractId);
        if (!ObjectUtils.isEmpty((Object)conPurchaseDemandVO) && !ObjectUtils.isEmpty((Object)conPurchaseDemandVO.getConPurchaseDemandDVOS())) {
            demandTotalAmt = conPurchaseDemandVO.getConPurchaseDemandDVOS().stream().map(obj -> Optional.ofNullable(obj.getNotTaxAmt()).orElse(BigDecimal.ZERO)).reduce(BigDecimal.ZERO, BigDecimal::add);
        }
        return demandTotalAmt;
    }

    private void translateList(List<SaleConExecConditionVO> voList) {
        voList.stream().forEach(e -> {
            String conPriceLevel = e.getConPriceLevel();
            if (StringUtils.hasText((String)conPriceLevel)) {
                String selectionValue = this.cacheUtil.getSystemSelectionValueByName(FunctionSelectionEnum.SaleConPriceLevel.getCode(), conPriceLevel);
                e.setConPriceLevelDesc(selectionValue);
            }
        });
    }

    public SaleConExecConditionServiceImpl(ConPurchaseDemandService purchaseDemandService, SaleConContractService saleConContractService, CacheUtil cacheUtil, SaleConExecConditionRepo saleConExecConditionRepo, SaleConExecConditionDAO saleConExecConditionDAO, WorkflowUtil workflowUtil, TransactionUtilService transactionUtilService, OrgGrossProfitRateSettingService orgGrossProfitRateSettingService, PrdSystemRoleService roleService, PrdOrgOrganizationService prdOrgOrganizationService, PersonPlanService personPlanService) {
        this.purchaseDemandService = purchaseDemandService;
        this.saleConContractService = saleConContractService;
        this.cacheUtil = cacheUtil;
        this.saleConExecConditionRepo = saleConExecConditionRepo;
        this.saleConExecConditionDAO = saleConExecConditionDAO;
        this.workflowUtil = workflowUtil;
        this.transactionUtilService = transactionUtilService;
        this.orgGrossProfitRateSettingService = orgGrossProfitRateSettingService;
        this.roleService = roleService;
        this.prdOrgOrganizationService = prdOrgOrganizationService;
        this.personPlanService = personPlanService;
    }
}

