/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5.server.prd.ts.service;

import com.elitescloud.boot.core.base.BaseServiceImpl;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.system.vo.PrdSystemSelectionVO;
import com.elitesland.tw.tw5.api.prd.ts.payload.TsNotaskApprovalConfigRulePayload;
import com.elitesland.tw.tw5.api.prd.ts.query.TsNotaskApprovalConfigRuleQuery;
import com.elitesland.tw.tw5.api.prd.ts.service.TsNotaskApprovalConfigRuleService;
import com.elitesland.tw.tw5.api.prd.ts.vo.TsNotaskApprovalConfigRuleVO;
import com.elitesland.tw.tw5.server.prd.common.CacheUtil;
import com.elitesland.tw.tw5.server.prd.ts.convert.TsNotaskApprovalConfigRuleConvert;
import com.elitesland.tw.tw5.server.prd.ts.dao.TsNotaskApprovalConfigRuleDAO;
import com.elitesland.tw.tw5.server.prd.ts.entity.TsNotaskApprovalConfigRuleDO;
import com.elitesland.tw.tw5.server.prd.ts.repo.TsNotaskApprovalConfigRuleRepo;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class TsNotaskApprovalConfigRuleServiceImpl
extends BaseServiceImpl
implements TsNotaskApprovalConfigRuleService {
    private static final Logger log = LoggerFactory.getLogger(TsNotaskApprovalConfigRuleServiceImpl.class);
    private final TsNotaskApprovalConfigRuleRepo tsNotaskApprovalConfigRuleRepo;
    private final TsNotaskApprovalConfigRuleDAO tsNotaskApprovalConfigRuleDAO;
    private final CacheUtil cacheUtil;

    public PagingVO<TsNotaskApprovalConfigRuleVO> queryPaging(TsNotaskApprovalConfigRuleQuery query) {
        return this.tsNotaskApprovalConfigRuleDAO.queryPaging(query);
    }

    public List<TsNotaskApprovalConfigRuleVO> queryListDynamic(TsNotaskApprovalConfigRuleQuery query) {
        List<TsNotaskApprovalConfigRuleVO> tsNotaskApprovalConfigRuleVOS = this.tsNotaskApprovalConfigRuleDAO.queryListDynamic(query);
        if (!CollectionUtils.isEmpty(tsNotaskApprovalConfigRuleVOS)) {
            this.translateList(tsNotaskApprovalConfigRuleVOS);
        }
        return tsNotaskApprovalConfigRuleVOS;
    }

    public TsNotaskApprovalConfigRuleVO queryByKey(Long key) {
        TsNotaskApprovalConfigRuleDO entity = this.tsNotaskApprovalConfigRuleRepo.findById(key).orElseGet(TsNotaskApprovalConfigRuleDO::new);
        Assert.notNull((Object)entity.getId(), (String)"\u4e0d\u5b58\u5728");
        TsNotaskApprovalConfigRuleVO vo = TsNotaskApprovalConfigRuleConvert.INSTANCE.toVo(entity);
        return vo;
    }

    @Transactional(rollbackFor={Exception.class})
    public TsNotaskApprovalConfigRuleVO insert(TsNotaskApprovalConfigRulePayload payload) {
        TsNotaskApprovalConfigRuleDO entityDo = TsNotaskApprovalConfigRuleConvert.INSTANCE.toDo(payload);
        return TsNotaskApprovalConfigRuleConvert.INSTANCE.toVo((TsNotaskApprovalConfigRuleDO)this.tsNotaskApprovalConfigRuleRepo.save(entityDo));
    }

    @Transactional(rollbackFor={Exception.class})
    public TsNotaskApprovalConfigRuleVO update(TsNotaskApprovalConfigRulePayload payload) {
        TsNotaskApprovalConfigRuleDO entity = this.tsNotaskApprovalConfigRuleRepo.findById(payload.getId()).orElseGet(TsNotaskApprovalConfigRuleDO::new);
        Assert.notNull((Object)entity.getId(), (String)"\u4e0d\u5b58\u5728");
        TsNotaskApprovalConfigRuleDO entityDo = TsNotaskApprovalConfigRuleConvert.INSTANCE.toDo(payload);
        entity.copy(entityDo);
        return TsNotaskApprovalConfigRuleConvert.INSTANCE.toVo((TsNotaskApprovalConfigRuleDO)this.tsNotaskApprovalConfigRuleRepo.save(entity));
    }

    @Transactional(rollbackFor={Exception.class})
    public long updateByKeyDynamic(TsNotaskApprovalConfigRulePayload payload) {
        TsNotaskApprovalConfigRuleDO entity = this.tsNotaskApprovalConfigRuleRepo.findById(payload.getId()).orElseGet(TsNotaskApprovalConfigRuleDO::new);
        Assert.notNull((Object)entity.getId(), (String)"\u4e0d\u5b58\u5728");
        long result = this.tsNotaskApprovalConfigRuleDAO.updateByKeyDynamic(payload);
        return result;
    }

    @Transactional(rollbackFor={Exception.class})
    public void deleteSoft(List<Long> keys) {
        if (!keys.isEmpty()) {
            this.tsNotaskApprovalConfigRuleDAO.deleteSoft(keys);
        }
    }

    @Transactional(rollbackFor={Exception.class})
    public void deleteSoftByConfigId(List<Long> configIds) {
        if (!configIds.isEmpty()) {
            this.tsNotaskApprovalConfigRuleDAO.deleteSoftByConfigId(configIds);
        }
    }

    public List<TsNotaskApprovalConfigRuleVO> queryByConfigId(Long key) {
        ArrayList vo = new ArrayList();
        TsNotaskApprovalConfigRuleQuery query = new TsNotaskApprovalConfigRuleQuery();
        query.setConfigId(key);
        return this.queryListDynamic(query);
    }

    private void translateList(List<TsNotaskApprovalConfigRuleVO> voList) {
        for (TsNotaskApprovalConfigRuleVO vo : voList) {
            if (StringUtils.hasText((String)vo.getUsers())) {
                ArrayList<String> userNames = new ArrayList<String>();
                for (String sourceId : vo.getUsers().split(",")) {
                    String userName = this.cacheUtil.getUserName(Long.parseLong(sourceId));
                    userNames.add(userName);
                }
                String userName = String.join((CharSequence)",", userNames);
                vo.setUsersName(userName);
            }
            if (!StringUtils.hasText((String)vo.getActivity())) continue;
            PrdSystemSelectionVO systemSelection = this.cacheUtil.getSystemSelection("prd:timesheet:notask");
            List selectionChildren = systemSelection.getChildren();
            ArrayList<String> activitys = new ArrayList<String>();
            for (String activity : vo.getActivity().split(",")) {
                for (PrdSystemSelectionVO selectionChild : selectionChildren) {
                    if (!selectionChild.getSelectionValue().equals(activity)) continue;
                    activitys.add(selectionChild.getSelectionName());
                }
            }
            String activityName = String.join((CharSequence)",", activitys);
            vo.setActivityName(activityName);
        }
    }

    public TsNotaskApprovalConfigRuleServiceImpl(TsNotaskApprovalConfigRuleRepo tsNotaskApprovalConfigRuleRepo, TsNotaskApprovalConfigRuleDAO tsNotaskApprovalConfigRuleDAO, CacheUtil cacheUtil) {
        this.tsNotaskApprovalConfigRuleRepo = tsNotaskApprovalConfigRuleRepo;
        this.tsNotaskApprovalConfigRuleDAO = tsNotaskApprovalConfigRuleDAO;
        this.cacheUtil = cacheUtil;
    }
}

