/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5.server.prd.acc.service;

import com.elitescloud.boot.core.base.BaseServiceImpl;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.acc.payload.AccFinancialSubjectPayload;
import com.elitesland.tw.tw5.api.prd.acc.query.AccFinancialSubjectQuery;
import com.elitesland.tw.tw5.api.prd.acc.service.AccFinancialSubjectService;
import com.elitesland.tw.tw5.api.prd.acc.vo.AccFinancialSubjectVO;
import com.elitesland.tw.tw5.server.common.ExcelUtil;
import com.elitesland.tw.tw5.server.common.TwException;
import com.elitesland.tw.tw5.server.common.service.TransactionUtilService;
import com.elitesland.tw.tw5.server.prd.acc.convert.AccFinancialSubjectConvert;
import com.elitesland.tw.tw5.server.prd.acc.dao.AccFinancialSubjectDAO;
import com.elitesland.tw.tw5.server.prd.acc.entity.AccFinancialSubjectDO;
import com.elitesland.tw.tw5.server.prd.acc.repo.AccFinancialSubjectRepo;
import com.elitesland.tw.tw5.server.udc.UdcUtil;
import java.io.InputStream;
import java.lang.invoke.CallSite;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import javax.servlet.http.HttpServletResponse;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.usermodel.WorkbookFactory;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.ClassPathResource;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.multipart.MultipartFile;

@Service
public class AccFinancialSubjectServiceImpl
extends BaseServiceImpl
implements AccFinancialSubjectService {
    private static final Logger log = LoggerFactory.getLogger(AccFinancialSubjectServiceImpl.class);
    private final AccFinancialSubjectRepo accFinancialSubjectRepo;
    private final AccFinancialSubjectDAO accFinancialSubjectDAO;
    private final ExcelUtil excelUtil;
    private final UdcUtil udcUtil;
    private final TransactionUtilService transactionUtilService;

    public PagingVO<AccFinancialSubjectVO> queryPaging(AccFinancialSubjectQuery query) {
        return this.accFinancialSubjectDAO.queryPaging(query);
    }

    public List<AccFinancialSubjectVO> queryListDynamic(AccFinancialSubjectQuery query) {
        return this.accFinancialSubjectDAO.queryListDynamic(query);
    }

    public AccFinancialSubjectVO queryByKey(Long key) {
        return this.accFinancialSubjectDAO.queryByKey(key);
    }

    @Transactional(rollbackFor={Exception.class})
    public AccFinancialSubjectVO insert(AccFinancialSubjectPayload payload) {
        this.checkData(payload);
        List<Long> ids = this.accFinancialSubjectDAO.queryByCodeAndName(payload.getAccCode(), payload.getAccName());
        if (ObjectUtils.isEmpty(ids)) {
            if (!StringUtils.hasText((String)payload.getAccStatus())) {
                payload.setAccStatus("ACTIVE");
            }
            payload.setAccLevel(Integer.valueOf(1));
            if (!ObjectUtils.isEmpty((Object)payload.getParentId())) {
                AccFinancialSubjectVO accFinancialSubjectVO = this.accFinancialSubjectDAO.queryByKey(payload.getParentId());
                payload.setAccLevel(Integer.valueOf(accFinancialSubjectVO.getAccLevel() + 1));
            }
            AccFinancialSubjectDO entityDo = AccFinancialSubjectConvert.INSTANCE.toDo(payload);
            return AccFinancialSubjectConvert.INSTANCE.toVo((AccFinancialSubjectDO)this.accFinancialSubjectRepo.save(entityDo));
        }
        throw TwException.error("", "\u79d1\u76ee\u7f16\u53f7\u548c\u540d\u79f0\u4e0d\u53ef\u91cd\u590d");
    }

    void checkData(AccFinancialSubjectPayload payload) {
        if (!StringUtils.hasText((String)payload.getAccCode()) || !StringUtils.hasText((String)payload.getAccName())) {
            throw TwException.error("", "\u79d1\u76ee\u7f16\u53f7\u548c\u540d\u79f0\u4e0d\u53ef\u4e3a\u7a7a");
        }
    }

    @Transactional(rollbackFor={Exception.class})
    public long updateByKeyDynamic(AccFinancialSubjectPayload payload) {
        List<Long> ids = this.accFinancialSubjectDAO.queryByCodeAndName(payload.getAccCode(), payload.getAccName());
        if (ObjectUtils.isEmpty(ids) || ids.size() == 1 && ids.get(0).equals(payload.getId())) {
            payload.setAccLevel(Integer.valueOf(1));
            if (!ObjectUtils.isEmpty((Object)payload.getParentId())) {
                AccFinancialSubjectVO accFinancialSubjectVO = this.accFinancialSubjectDAO.queryByKey(payload.getParentId());
                payload.setAccLevel(Integer.valueOf(accFinancialSubjectVO.getAccLevel() + 1));
            }
            long result = this.accFinancialSubjectDAO.updateByKeyDynamic(payload);
            return result;
        }
        throw TwException.error("", "\u79d1\u76ee\u7f16\u53f7\u548c\u540d\u79f0\u4e0d\u53ef\u91cd\u590d");
    }

    @Transactional(rollbackFor={Exception.class})
    public void deleteSoft(List<Long> keys) {
        if (!keys.isEmpty()) {
            this.accFinancialSubjectDAO.deleteSoft(keys);
        }
    }

    public void downloadPlus(HttpServletResponse response, AccFinancialSubjectQuery query) {
        ClassPathResource classPathResource = new ClassPathResource("template/accFinancialSubject.xlsx");
        try {
            InputStream inputStream = classPathResource.getInputStream();
            Workbook workbook = WorkbookFactory.create((InputStream)inputStream);
            XSSFSheet batchProjectSheet = (XSSFSheet)workbook.getSheet("\u79d1\u76ee\u6570\u636e");
            this.excelUtil.generateRangeList(batchProjectSheet, 4, 1, "LOV", 2, "C");
            this.excelUtil.generateRangeList(batchProjectSheet, 10, 1, "LOV", 2, "A");
            this.excelUtil.generateRangeList(batchProjectSheet, 3, 1, "\u79d1\u76ee\u6570\u636e", 2, "C");
            String fileName = "\u4f1a\u8ba1\u79d1\u76ee\u6570\u636e-" + LocalDate.now();
            Boolean isHave = false;
            if (!StringUtils.hasText((String)query.getDownloadType()) || query.getDownloadType().equals("data")) {
                List accFinancialSubjectVOS = this.accFinancialSubjectDAO.queryListDynamic(query);
                if (!ObjectUtils.isEmpty(accFinancialSubjectVOS)) {
                    accFinancialSubjectVOS = this.udcUtil.translateList(accFinancialSubjectVOS);
                    isHave = true;
                    int nextRow = 1;
                    for (AccFinancialSubjectVO accFinancialSubjectVO : accFinancialSubjectVOS) {
                        XSSFRow row = batchProjectSheet.createRow(nextRow);
                        Optional<AccFinancialSubjectVO> first = accFinancialSubjectVOS.stream().filter(vo -> vo.getId().equals(accFinancialSubjectVO.getParentId())).findFirst();
                        if (first.isPresent()) {
                            this.excelUtil.setCellValue((Row)row, 3, first.get().getAccName());
                        }
                        this.excelUtil.setCellValue((Row)row, 0, nextRow);
                        this.excelUtil.setCellValue((Row)row, 1, accFinancialSubjectVO.getAccCode());
                        this.excelUtil.setCellValue((Row)row, 2, accFinancialSubjectVO.getAccName());
                        this.excelUtil.setCellValue((Row)row, 4, accFinancialSubjectVO.getAccStatusDesc());
                        this.excelUtil.setCellValue((Row)row, 5, accFinancialSubjectVO.getAccType1());
                        this.excelUtil.setCellValue((Row)row, 6, accFinancialSubjectVO.getAccType2());
                        this.excelUtil.setCellValue((Row)row, 7, accFinancialSubjectVO.getAccType3());
                        this.excelUtil.setCellValue((Row)row, 8, accFinancialSubjectVO.getDtlAcc());
                        String sumFlag = "\u662f";
                        if (accFinancialSubjectVO.getSumFlag() == null || accFinancialSubjectVO.getSumFlag() == 0) {
                            sumFlag = "\u5426";
                        }
                        this.excelUtil.setCellValue((Row)row, 9, sumFlag);
                        this.excelUtil.setCellValue((Row)row, 10, accFinancialSubjectVO.getLedgerType());
                        this.excelUtil.setCellValue((Row)row, 11, accFinancialSubjectVO.getRemark());
                        ++nextRow;
                    }
                }
            } else {
                fileName = "\u4f1a\u8ba1\u79d1\u76ee\u5bfc\u5165\u6a21\u677f-" + LocalDate.now();
            }
            if (!isHave.booleanValue()) {
                this.excelUtil.setColumnFormulas(batchProjectSheet, 12, "VLOOKUP(D:rowNo,B:C,1,FALSE)");
                this.excelUtil.setColumnFormulas(batchProjectSheet, 13, "VLOOKUP(E:rowNo,LOV!C:D,2,FALSE)");
                this.excelUtil.setColumnFormulas(batchProjectSheet, 14, "VLOOKUP(J:rowNo,LOV!A:B,2,FALSE)");
            }
            batchProjectSheet.setColumnHidden(12, true);
            batchProjectSheet.setColumnHidden(13, true);
            batchProjectSheet.setColumnHidden(14, true);
            ExcelUtil.writeResponse(response, fileName, workbook);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Transactional(rollbackFor={Exception.class})
    public boolean batchImport(MultipartFile file) {
        if (file == null) {
            throw TwException.error("", "\u4e0a\u4f20\u6587\u4ef6\u5f02\u5e38");
        }
        Workbook workbook = null;
        try {
            workbook = WorkbookFactory.create((InputStream)file.getInputStream());
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error(e.getMessage());
            throw TwException.error("", "\u6587\u4ef6\u89e3\u6790\u5f02\u5e38");
        }
        Sheet sheet = workbook.getSheet("\u79d1\u76ee\u6570\u636e");
        if (sheet == null) {
            throw TwException.error("", "\u8868\u7ed3\u6784\u9519\u8bef");
        }
        int dataStartRow = 1;
        ArrayList<CallSite> codeNames = new ArrayList<CallSite>();
        HashMap<String, String> map = new HashMap<String, String>();
        ArrayList<AccFinancialSubjectPayload> accFinancialSubjectPayloads = new ArrayList<AccFinancialSubjectPayload>();
        for (int i = dataStartRow; i <= sheet.getLastRowNum(); ++i) {
            String sumFlag;
            String codeNameStr;
            Row row = sheet.getRow(i);
            String accCode = ExcelUtil.getCellFormatValue(row.getCell(1));
            String accName = ExcelUtil.getCellFormatValue(row.getCell(2));
            if (!StringUtils.hasText((String)accCode) || !StringUtils.hasText((String)accName)) break;
            if (!StringUtils.hasText((String)((String)map.get(accName)))) {
                map.put(accName, accCode);
            }
            if (codeNames.contains(codeNameStr = "," + accCode + "-" + accName + ",")) {
                throw TwException.error("", "\u79d1\u76ee\u7f16\u53f7\u6216\u540d\u79f0\u4e0d\u53ef\u91cd\u590d:\u3010" + codeNameStr + "\u3011");
            }
            codeNames.add((CallSite)((Object)codeNameStr));
            String upperName = ExcelUtil.getCellFormatValue(row.getCell(3));
            String accType1 = ExcelUtil.getCellFormatValue(row.getCell(5));
            String accType2 = ExcelUtil.getCellFormatValue(row.getCell(6));
            String accType3 = ExcelUtil.getCellFormatValue(row.getCell(7));
            String dtlAcc = ExcelUtil.getCellFormatValue(row.getCell(8));
            String ledgerType = ExcelUtil.getCellFormatValue(row.getCell(10));
            String remark = ExcelUtil.getCellFormatValue(row.getCell(11));
            String upperCode = ExcelUtil.getCellFormatValue(row.getCell(12));
            String accStatus = ExcelUtil.getCellFormatValue(row.getCell(13));
            if (!StringUtils.hasText((String)accStatus)) {
                accStatus = "ACTIVE";
            }
            if (!StringUtils.hasText((String)(sumFlag = ExcelUtil.getCellFormatValue(row.getCell(14))))) {
                sumFlag = "0";
            }
            AccFinancialSubjectPayload accFinancialSubjectPayload2 = new AccFinancialSubjectPayload();
            accFinancialSubjectPayload2.setAccName(accName);
            accFinancialSubjectPayload2.setAccCode(accCode);
            accFinancialSubjectPayload2.setAccStatus(accStatus);
            accFinancialSubjectPayload2.setUpperCode(upperCode);
            accFinancialSubjectPayload2.setUpperName(upperName);
            accFinancialSubjectPayload2.setAccType1(accType1);
            accFinancialSubjectPayload2.setAccType2(accType2);
            accFinancialSubjectPayload2.setAccType3(accType3);
            accFinancialSubjectPayload2.setLedgerType(ledgerType);
            accFinancialSubjectPayload2.setSumFlag(Integer.valueOf(sumFlag));
            accFinancialSubjectPayload2.setRemark(remark);
            accFinancialSubjectPayload2.setDtlAcc(dtlAcc);
            if (!StringUtils.hasText((String)upperName) && !StringUtils.hasText((String)upperCode)) {
                accFinancialSubjectPayload2.setAccLevel(Integer.valueOf(1));
            }
            accFinancialSubjectPayloads.add(accFinancialSubjectPayload2);
        }
        ArrayList<AccFinancialSubjectDO> accFinancialSubjectDOs = new ArrayList<AccFinancialSubjectDO>();
        accFinancialSubjectPayloads.forEach(accFinancialSubjectPayload -> {
            String s;
            String upperName = accFinancialSubjectPayload.getUpperName();
            String upperCode = accFinancialSubjectPayload.getUpperCode();
            if (StringUtils.hasText((String)upperName) && !StringUtils.hasText((String)upperCode) && !(s = (String)map.get(upperName)).equals(accFinancialSubjectPayload.getAccCode())) {
                accFinancialSubjectPayload.setUpperCode(s);
                this.setLevel((List<AccFinancialSubjectPayload>)accFinancialSubjectPayloads, (AccFinancialSubjectPayload)accFinancialSubjectPayload);
            }
            accFinancialSubjectDOs.add(AccFinancialSubjectConvert.INSTANCE.toDo((AccFinancialSubjectPayload)accFinancialSubjectPayload));
        });
        List<AccFinancialSubjectDO> accFinancialSubjectDOS = this.accFinancialSubjectDAO.saveAll(accFinancialSubjectDOs);
        ArrayList updataDOs = new ArrayList();
        accFinancialSubjectDOS.forEach(accFinancialSubjectDO -> {
            if (StringUtils.hasText((String)accFinancialSubjectDO.getUpperCode())) {
                Optional<AccFinancialSubjectDO> first = accFinancialSubjectDOS.stream().filter(masPayload -> masPayload.getAccCode().equals(accFinancialSubjectDO.getUpperCode())).findFirst();
                if (first.isPresent()) {
                    AccFinancialSubjectDO updataDO = first.get();
                    accFinancialSubjectDO.setParentId(updataDO.getId());
                } else {
                    accFinancialSubjectDO.setUpperCode(null);
                }
                updataDOs.add(accFinancialSubjectDO);
            }
        });
        this.transactionUtilService.executeWithRunnable(() -> this.accFinancialSubjectDAO.saveAll(updataDOs));
        return true;
    }

    void setLevel(List<AccFinancialSubjectPayload> accFinancialSubjectPayloads, AccFinancialSubjectPayload accFinancialSubjectPayload) {
        Optional<AccFinancialSubjectPayload> optional = accFinancialSubjectPayloads.stream().filter(masPayload -> masPayload.getAccCode().equals(accFinancialSubjectPayload.getUpperCode())).findFirst();
        if (optional.isPresent()) {
            AccFinancialSubjectPayload payload = optional.get();
            if (payload.getAccLevel() == null) {
                this.setLevel(accFinancialSubjectPayloads, payload);
            }
            accFinancialSubjectPayload.setAccLevel(Integer.valueOf(payload.getAccLevel() + 1));
        } else {
            accFinancialSubjectPayload.setAccLevel(Integer.valueOf(1));
        }
    }

    public AccFinancialSubjectServiceImpl(AccFinancialSubjectRepo accFinancialSubjectRepo, AccFinancialSubjectDAO accFinancialSubjectDAO, ExcelUtil excelUtil, UdcUtil udcUtil, TransactionUtilService transactionUtilService) {
        this.accFinancialSubjectRepo = accFinancialSubjectRepo;
        this.accFinancialSubjectDAO = accFinancialSubjectDAO;
        this.excelUtil = excelUtil;
        this.udcUtil = udcUtil;
        this.transactionUtilService = transactionUtilService;
    }
}

