/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5.server.prd.budget.dao;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.common.TwQueryParam;
import com.elitesland.tw.tw5.api.prd.budget.payload.BudgetPayload;
import com.elitesland.tw.tw5.api.prd.budget.query.BudgetQuery;
import com.elitesland.tw.tw5.api.prd.budget.vo.BudgetVO;
import com.elitesland.tw.tw5.server.common.util.SqlUtil;
import com.elitesland.tw.tw5.server.prd.budget.entity.BudgetDO;
import com.elitesland.tw.tw5.server.prd.budget.entity.QBudgetDO;
import com.elitesland.tw.tw5.server.prd.budget.repo.BudgetRepo;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.core.types.dsl.BooleanExpression;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import com.querydsl.jpa.impl.JPAUpdateClause;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

@Repository
public class BudgetDAO {
    private final JPAQueryFactory jpaQueryFactory;
    private final BudgetRepo repo;
    private final QBudgetDO qdo = QBudgetDO.budgetDO;

    private JPAQuery<BudgetVO> getJpaQuerySelect() {
        return (JPAQuery)this.jpaQueryFactory.select((Expression)Projections.bean(BudgetVO.class, (Expression[])new Expression[]{this.qdo.id, this.qdo.remark, this.qdo.createUserId, this.qdo.creator, this.qdo.createTime, this.qdo.modifyUserId, this.qdo.updater, this.qdo.modifyTime, this.qdo.budgetName, this.qdo.budgetStatus, this.qdo.versionNo, this.qdo.procInstName, this.qdo.procInstId, this.qdo.procInstStatus, this.qdo.approvedTime, this.qdo.selectFlag, this.qdo.budgetCode, this.qdo.sourceType, this.qdo.sourceId, this.qdo.controlType, this.qdo.budgetStartDate, this.qdo.budgetEndDate, this.qdo.applyResId, this.qdo.applyDate, this.qdo.extVarchar1, this.qdo.extVarchar2, this.qdo.extVarchar3, this.qdo.extVarchar4, this.qdo.extVarchar5, this.qdo.extVarchar6, this.qdo.extVarchar7, this.qdo.extVarchar8, this.qdo.extVarchar9, this.qdo.budgetFiles, this.qdo.procDefKey, this.qdo.finYear, this.qdo.totalAmt, this.qdo.originalTotalAmt, this.qdo.planAmt, this.qdo.originalPlanAmt, this.qdo.planEqva, this.qdo.planEqvaAmt, this.qdo.originalPlanEqva, this.qdo.originalPlanEqvaAmt, this.qdo.allocatedAmt, this.qdo.allocatedEqva, this.qdo.allocatedEqvaAmt, this.qdo.allocatedTotalAmt, this.qdo.sourceCode, this.qdo.sourceName, this.qdo.deliBuId, this.qdo.subjectTempId, this.qdo.eqvaPrice, this.qdo.usedAmt, this.qdo.occupyAmt, this.qdo.occupyEqva, this.qdo.usedEqva, this.qdo.usedEqvaProportion, this.qdo.usedAmtProportion, this.qdo.allocatedAppropriation, this.qdo.totalCost, this.qdo.grossMargin})).from((EntityPath)this.qdo);
    }

    private JPAQuery<BudgetVO> getJpaQueryWhere(BudgetQuery query) {
        JPAQuery<BudgetVO> jpaQuery = this.getJpaQuerySelect();
        jpaQuery.where(this.where(query));
        SqlUtil.handleCommonJpaQuery(jpaQuery, this.qdo._super, (TwQueryParam)query);
        jpaQuery.orderBy(SqlUtil.getSortedColumn(this.qdo, query.getOrders()));
        return jpaQuery;
    }

    public long count(BudgetQuery query) {
        JPAQuery jpaQuery = (JPAQuery)this.jpaQueryFactory.select((Expression)this.qdo.count()).from((EntityPath)this.qdo);
        jpaQuery.where(this.where(query));
        SqlUtil.handleCommonJpaQuery(jpaQuery, this.qdo._super, (TwQueryParam)query);
        Long total = (Long)jpaQuery.fetchOne();
        total = total == null ? 0L : total;
        return total;
    }

    private Predicate where(BudgetQuery query) {
        ArrayList<BooleanExpression> list = new ArrayList<BooleanExpression>();
        if (!ObjectUtils.isEmpty((Object)query.getId())) {
            list.add(this.qdo.id.eq((Object)query.getId()));
        }
        if (StringUtils.hasText((String)query.getKeyword())) {
            list.add(this.qdo.budgetName.like(SqlUtil.toSqlLikeString(query.getKeyword())).or((Predicate)this.qdo.budgetCode.like(SqlUtil.toSqlLikeString(query.getKeyword()))));
        }
        if (!ObjectUtils.isEmpty((Object)query.getBudgetName())) {
            list.add(this.qdo.budgetName.eq((Object)query.getBudgetName()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getBudgetStatus())) {
            list.add(this.qdo.budgetStatus.eq((Object)query.getBudgetStatus()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getSourceCode())) {
            list.add(this.qdo.sourceCode.eq((Object)query.getSourceCode()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getSourceName())) {
            list.add(this.qdo.sourceName.eq((Object)query.getSourceName()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getDeliBuId())) {
            list.add(this.qdo.deliBuId.eq((Object)query.getDeliBuId()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getVersionNo())) {
            list.add(this.qdo.versionNo.eq((Object)query.getVersionNo()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getProcInstName())) {
            list.add(this.qdo.procInstName.eq((Object)query.getProcInstName()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getProcInstId())) {
            list.add(this.qdo.procInstId.eq((Object)query.getProcInstId()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getProcInstStatus())) {
            list.add(this.qdo.procInstStatus.eq((Object)query.getProcInstStatus()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getApprovedTime())) {
            list.add(this.qdo.approvedTime.eq((Object)query.getApprovedTime()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getSelectFlag())) {
            list.add(this.qdo.selectFlag.eq(query.getSelectFlag()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getBudgetCode())) {
            list.add(this.qdo.budgetCode.eq((Object)query.getBudgetCode()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getSourceType())) {
            list.add(this.qdo.sourceType.eq((Object)query.getSourceType()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getSourceId())) {
            list.add(this.qdo.sourceId.eq((Object)query.getSourceId()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getControlType())) {
            list.add(this.qdo.controlType.eq((Object)query.getControlType()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getBudgetStartDate())) {
            list.add(this.qdo.budgetStartDate.eq((Object)query.getBudgetStartDate()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getBudgetEndDate())) {
            list.add(this.qdo.budgetEndDate.eq((Object)query.getBudgetEndDate()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getApplyResId())) {
            list.add(this.qdo.applyResId.eq((Object)query.getApplyResId()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getApplyDate())) {
            list.add(this.qdo.applyDate.eq((Object)query.getApplyDate()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getExtVarchar1())) {
            list.add(this.qdo.extVarchar1.eq((Object)query.getExtVarchar1()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getExtVarchar2())) {
            list.add(this.qdo.extVarchar2.eq((Object)query.getExtVarchar2()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getExtVarchar3())) {
            list.add(this.qdo.extVarchar3.eq((Object)query.getExtVarchar3()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getExtVarchar4())) {
            list.add(this.qdo.extVarchar4.eq((Object)query.getExtVarchar4()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getExtVarchar5())) {
            list.add(this.qdo.extVarchar5.eq((Object)query.getExtVarchar5()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getExtVarchar6())) {
            list.add(this.qdo.extVarchar6.eq((Object)query.getExtVarchar6()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getExtVarchar7())) {
            list.add(this.qdo.extVarchar7.eq((Object)query.getExtVarchar7()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getExtVarchar8())) {
            list.add(this.qdo.extVarchar8.eq((Object)query.getExtVarchar8()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getExtVarchar9())) {
            list.add(this.qdo.extVarchar9.eq((Object)query.getExtVarchar9()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getBudgetFiles())) {
            list.add(this.qdo.budgetFiles.eq((Object)query.getBudgetFiles()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getProcDefKey())) {
            list.add(this.qdo.procDefKey.eq((Object)query.getProcDefKey()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getFinYear())) {
            list.add(this.qdo.finYear.eq((Object)query.getFinYear()));
        }
        return ExpressionUtils.allOf(list);
    }

    public BudgetVO queryByKey(Long id) {
        JPAQuery<BudgetVO> jpaQuery = this.getJpaQuerySelect();
        jpaQuery.where((Predicate)this.qdo.id.eq((Object)id));
        jpaQuery.where((Predicate)this.qdo.deleteFlag.eq((Object)0));
        return (BudgetVO)jpaQuery.fetchFirst();
    }

    public List<BudgetVO> queryByKeys(List<Long> ids) {
        JPAQuery<BudgetVO> jpaQuery = this.getJpaQuerySelect();
        jpaQuery.where((Predicate)this.qdo.id.in(ids));
        jpaQuery.where((Predicate)this.qdo.deleteFlag.eq((Object)0));
        return jpaQuery.fetch();
    }

    public List<BudgetVO> queryListDynamic(BudgetQuery query) {
        JPAQuery<BudgetVO> jpaQuery = this.getJpaQueryWhere(query);
        return jpaQuery.fetch();
    }

    public PagingVO<BudgetVO> queryPaging(BudgetQuery query) {
        long total = this.count(query);
        if (total == 0L) {
            return PagingVO.empty();
        }
        JPAQuery<BudgetVO> jpaQuery = this.getJpaQueryWhere(query);
        List result = ((JPAQuery)((JPAQuery)jpaQuery.offset(query.getPageRequest().getOffset())).limit((long)query.getPageRequest().getPageSize())).fetch();
        return PagingVO.builder().records(result).total(total).build();
    }

    public BudgetDO save(BudgetDO ado) {
        return (BudgetDO)this.repo.save(ado);
    }

    public List<BudgetDO> saveAll(List<BudgetDO> dos) {
        return this.repo.saveAll(dos);
    }

    @Transactional
    public long updateByKeyDynamic(BudgetPayload payload) {
        List nullFields;
        JPAUpdateClause update = this.jpaQueryFactory.update((EntityPath)this.qdo).where(new Predicate[]{this.qdo.id.eq((Object)payload.getId())});
        if (payload.getId() != null) {
            update.set(this.qdo.id, (Object)payload.getId());
        }
        if (payload.getBudgetName() != null) {
            update.set((Path)this.qdo.budgetName, (Object)payload.getBudgetName());
        }
        if (payload.getSourceType() != null) {
            update.set((Path)this.qdo.sourceType, (Object)payload.getSourceType());
        }
        if (payload.getSourceId() != null) {
            update.set(this.qdo.sourceId, (Object)payload.getSourceId());
        }
        if (payload.getSourceCode() != null) {
            update.set((Path)this.qdo.sourceCode, (Object)payload.getSourceCode());
        }
        if (payload.getSourceName() != null) {
            update.set((Path)this.qdo.sourceName, (Object)payload.getSourceName());
        }
        if (payload.getDeliBuId() != null) {
            update.set(this.qdo.deliBuId, (Object)payload.getDeliBuId());
        }
        if (payload.getSubjectTempId() != null) {
            update.set(this.qdo.subjectTempId, (Object)payload.getSubjectTempId());
        }
        if (payload.getBudgetStatus() != null) {
            update.set((Path)this.qdo.budgetStatus, (Object)payload.getBudgetStatus());
        }
        if (payload.getVersionNo() != null) {
            update.set(this.qdo.versionNo, (Object)payload.getVersionNo());
        }
        if (payload.getProcInstName() != null) {
            update.set((Path)this.qdo.procInstName, (Object)payload.getProcInstName());
        }
        if (payload.getProcInstId() != null) {
            update.set((Path)this.qdo.procInstId, (Object)payload.getProcInstId());
        }
        if (payload.getProcInstStatus() != null) {
            update.set(this.qdo.procInstStatus, (Object)payload.getProcInstStatus());
        }
        if (payload.getApprovedTime() != null) {
            update.set(this.qdo.approvedTime, (Object)payload.getApprovedTime());
        }
        if (payload.getSelectFlag() != null) {
            update.set((Path)this.qdo.selectFlag, (Object)payload.getSelectFlag());
        }
        if (payload.getBudgetCode() != null) {
            update.set((Path)this.qdo.budgetCode, (Object)payload.getBudgetCode());
        }
        if (payload.getControlType() != null) {
            update.set((Path)this.qdo.controlType, (Object)payload.getControlType());
        }
        if (payload.getBudgetStartDate() != null) {
            update.set(this.qdo.budgetStartDate, (Object)payload.getBudgetStartDate());
        }
        if (payload.getBudgetEndDate() != null) {
            update.set(this.qdo.budgetEndDate, (Object)payload.getBudgetEndDate());
        }
        if (payload.getApplyResId() != null) {
            update.set(this.qdo.applyResId, (Object)payload.getApplyResId());
        }
        if (payload.getApplyDate() != null) {
            update.set(this.qdo.applyDate, (Object)payload.getApplyDate());
        }
        if (payload.getExtVarchar1() != null) {
            update.set((Path)this.qdo.extVarchar1, (Object)payload.getExtVarchar1());
        }
        if (payload.getExtVarchar2() != null) {
            update.set((Path)this.qdo.extVarchar2, (Object)payload.getExtVarchar2());
        }
        if (payload.getExtVarchar3() != null) {
            update.set((Path)this.qdo.extVarchar3, (Object)payload.getExtVarchar3());
        }
        if (payload.getExtVarchar4() != null) {
            update.set((Path)this.qdo.extVarchar4, (Object)payload.getExtVarchar4());
        }
        if (payload.getExtVarchar5() != null) {
            update.set((Path)this.qdo.extVarchar5, (Object)payload.getExtVarchar5());
        }
        if (payload.getExtVarchar6() != null) {
            update.set((Path)this.qdo.extVarchar6, (Object)payload.getExtVarchar6());
        }
        if (payload.getExtVarchar7() != null) {
            update.set((Path)this.qdo.extVarchar7, (Object)payload.getExtVarchar7());
        }
        if (payload.getExtVarchar8() != null) {
            update.set((Path)this.qdo.extVarchar8, (Object)payload.getExtVarchar8());
        }
        if (payload.getExtVarchar9() != null) {
            update.set((Path)this.qdo.extVarchar9, (Object)payload.getExtVarchar9());
        }
        if (payload.getBudgetFiles() != null) {
            update.set((Path)this.qdo.budgetFiles, (Object)payload.getBudgetFiles());
        }
        if (payload.getProcDefKey() != null) {
            update.set((Path)this.qdo.procDefKey, (Object)payload.getProcDefKey());
        }
        if (payload.getFinYear() != null) {
            update.set((Path)this.qdo.finYear, (Object)payload.getFinYear());
        }
        if (payload.getTotalAmt() != null) {
            update.set(this.qdo.totalAmt, (Object)payload.getTotalAmt());
        }
        if (payload.getOriginalTotalAmt() != null) {
            update.set(this.qdo.originalTotalAmt, (Object)payload.getOriginalTotalAmt());
        }
        if (payload.getPlanAmt() != null) {
            update.set(this.qdo.planAmt, (Object)payload.getPlanAmt());
        }
        if (payload.getOriginalPlanAmt() != null) {
            update.set(this.qdo.originalPlanAmt, (Object)payload.getOriginalPlanAmt());
        }
        if (payload.getOriginalPlanEqva() != null) {
            update.set(this.qdo.originalPlanEqva, (Object)payload.getOriginalPlanEqva());
        }
        if (payload.getOriginalPlanEqvaAmt() != null) {
            update.set(this.qdo.originalPlanEqvaAmt, (Object)payload.getOriginalPlanEqvaAmt());
        }
        if (payload.getPlanEqva() != null) {
            update.set(this.qdo.planEqva, (Object)payload.getPlanEqva());
        }
        if (payload.getPlanEqvaAmt() != null) {
            update.set(this.qdo.planEqvaAmt, (Object)payload.getPlanEqvaAmt());
        }
        if (payload.getRemark() != null) {
            update.set((Path)this.qdo.remark, (Object)payload.getRemark());
        }
        if (payload.getUsedAmt() != null) {
            update.set(this.qdo.usedAmt, (Object)payload.getUsedAmt());
        }
        if (payload.getOccupyEqva() != null) {
            update.set(this.qdo.occupyEqva, (Object)payload.getOccupyEqva());
        }
        if (payload.getUsedEqva() != null) {
            update.set(this.qdo.usedEqva, (Object)payload.getUsedEqva());
        }
        if (payload.getOccupyAmt() != null) {
            update.set(this.qdo.occupyAmt, (Object)payload.getOccupyAmt());
        }
        if (payload.getUsedEqvaProportion() != null) {
            update.set(this.qdo.usedEqvaProportion, (Object)payload.getUsedEqvaProportion());
        }
        if (payload.getUsedAmtProportion() != null) {
            update.set(this.qdo.usedAmtProportion, (Object)payload.getUsedAmtProportion());
        }
        if (payload.getAllocatedAppropriation() != null) {
            update.set(this.qdo.allocatedAppropriation, (Object)payload.getAllocatedAppropriation());
        }
        if (payload.getDeleteFlag() != null) {
            update.set(this.qdo.deleteFlag, (Object)payload.getDeleteFlag());
        }
        if (payload.getTotalCost() != null) {
            update.set(this.qdo.totalCost, (Object)payload.getTotalCost());
        }
        if (payload.getGrossMargin() != null) {
            update.set(this.qdo.grossMargin, (Object)payload.getGrossMargin());
        }
        if ((nullFields = payload.getNullFields()) != null && nullFields.size() > 0) {
            if (nullFields.contains("id")) {
                update.setNull(this.qdo.id);
            }
            if (nullFields.contains("budgetName")) {
                update.setNull((Path)this.qdo.budgetName);
            }
            if (nullFields.contains("budgetStatus")) {
                update.setNull((Path)this.qdo.budgetStatus);
            }
            if (nullFields.contains("versionNo")) {
                update.setNull(this.qdo.versionNo);
            }
            if (nullFields.contains("procInstName")) {
                update.setNull((Path)this.qdo.procInstName);
            }
            if (nullFields.contains("procInstId")) {
                update.setNull((Path)this.qdo.procInstId);
            }
            if (nullFields.contains("procInstStatus")) {
                update.setNull(this.qdo.procInstStatus);
            }
            if (nullFields.contains("approvedTime")) {
                update.setNull(this.qdo.approvedTime);
            }
            if (nullFields.contains("selectFlag")) {
                update.setNull((Path)this.qdo.selectFlag);
            }
            if (nullFields.contains("budgetCode")) {
                update.setNull((Path)this.qdo.budgetCode);
            }
            if (nullFields.contains("sourceType")) {
                update.setNull((Path)this.qdo.sourceType);
            }
            if (nullFields.contains("sourceId")) {
                update.setNull(this.qdo.sourceId);
            }
            if (nullFields.contains("controlType")) {
                update.setNull((Path)this.qdo.controlType);
            }
            if (nullFields.contains("budgetStartDate")) {
                update.setNull(this.qdo.budgetStartDate);
            }
            if (nullFields.contains("budgetEndDate")) {
                update.setNull(this.qdo.budgetEndDate);
            }
            if (nullFields.contains("applyResId")) {
                update.setNull(this.qdo.applyResId);
            }
            if (nullFields.contains("applyDate")) {
                update.setNull(this.qdo.applyDate);
            }
            if (nullFields.contains("extVarchar1")) {
                update.setNull((Path)this.qdo.extVarchar1);
            }
            if (nullFields.contains("extVarchar2")) {
                update.setNull((Path)this.qdo.extVarchar2);
            }
            if (nullFields.contains("extVarchar3")) {
                update.setNull((Path)this.qdo.extVarchar3);
            }
            if (nullFields.contains("extVarchar4")) {
                update.setNull((Path)this.qdo.extVarchar4);
            }
            if (nullFields.contains("extVarchar5")) {
                update.setNull((Path)this.qdo.extVarchar5);
            }
            if (nullFields.contains("extVarchar6")) {
                update.setNull((Path)this.qdo.extVarchar6);
            }
            if (nullFields.contains("extVarchar7")) {
                update.setNull((Path)this.qdo.extVarchar7);
            }
            if (nullFields.contains("extVarchar8")) {
                update.setNull((Path)this.qdo.extVarchar8);
            }
            if (nullFields.contains("extVarchar9")) {
                update.setNull((Path)this.qdo.extVarchar9);
            }
            if (nullFields.contains("budgetFiles")) {
                update.setNull((Path)this.qdo.budgetFiles);
            }
            if (nullFields.contains("procDefKey")) {
                update.setNull((Path)this.qdo.procDefKey);
            }
            if (nullFields.contains("finYear")) {
                update.setNull((Path)this.qdo.finYear);
            }
            if (nullFields.contains("totalCost")) {
                update.setNull(this.qdo.totalCost);
            }
            if (nullFields.contains("grossMargin")) {
                update.setNull(this.qdo.grossMargin);
            }
        }
        SqlUtil.updateCommonJpaQuery(update, this.qdo._super);
        return update.execute();
    }

    public long deleteSoft(List<Long> keys) {
        JPAUpdateClause update = this.jpaQueryFactory.update((EntityPath)this.qdo).set(this.qdo.deleteFlag, (Object)1).where(new Predicate[]{this.qdo.id.in(keys)});
        SqlUtil.updateCommonJpaQuery(update, this.qdo._super);
        return update.execute();
    }

    public BudgetVO querySimpleBySource(Long sourceId, String sourceType) {
        JPAQuery<BudgetVO> jpaQuery = this.getJpaQuerySelect();
        jpaQuery.where((Predicate)this.qdo.sourceId.eq((Object)sourceId));
        jpaQuery.where((Predicate)this.qdo.sourceType.eq((Object)sourceType));
        jpaQuery.where((Predicate)this.qdo.deleteFlag.eq((Object)0));
        return (BudgetVO)jpaQuery.fetchFirst();
    }

    public void updateAllocatedAmt(Long budgetId, BigDecimal allocatedAmt, BigDecimal allocatedEqva, BigDecimal allocatedEqvaAmt, BigDecimal allocatedTotalAmt) {
        this.jpaQueryFactory.update((EntityPath)this.qdo).set(this.qdo.allocatedAmt, (Object)allocatedAmt).set(this.qdo.allocatedEqva, (Object)allocatedEqva).set(this.qdo.allocatedEqvaAmt, (Object)allocatedEqvaAmt).set(this.qdo.allocatedTotalAmt, (Object)allocatedTotalAmt).where(new Predicate[]{this.qdo.id.eq((Object)budgetId)}).execute();
    }

    public BudgetDAO(JPAQueryFactory jpaQueryFactory, BudgetRepo repo) {
        this.jpaQueryFactory = jpaQueryFactory;
        this.repo = repo;
    }
}

