/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5.server.prd.budget.service;

import com.elitescloud.boot.core.base.BaseServiceImpl;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.budget.payload.PmsBudgetDocRelatePayload;
import com.elitesland.tw.tw5.api.prd.budget.query.PmsBudgetDocRelateQuery;
import com.elitesland.tw.tw5.api.prd.budget.service.PmsBudgetDocRelateService;
import com.elitesland.tw.tw5.api.prd.budget.vo.PmsBudgetDocRelateVO;
import com.elitesland.tw.tw5.server.prd.budget.convert.PmsBudgetDocRelateConvert;
import com.elitesland.tw.tw5.server.prd.budget.dao.PmsBudgetDocRelateDAO;
import com.elitesland.tw.tw5.server.prd.budget.entity.PmsBudgetDocRelateDO;
import com.elitesland.tw.tw5.server.prd.budget.repo.PmsBudgetDocRelateRepo;
import java.util.Collections;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;

@Service
public class PmsBudgetDocRelateServiceImpl
extends BaseServiceImpl
implements PmsBudgetDocRelateService {
    private static final Logger log = LoggerFactory.getLogger(PmsBudgetDocRelateServiceImpl.class);
    private final PmsBudgetDocRelateRepo pmsBudgetDocRelateRepo;
    private final PmsBudgetDocRelateDAO pmsBudgetDocRelateDAO;

    public PagingVO<PmsBudgetDocRelateVO> queryPaging(PmsBudgetDocRelateQuery query) {
        return this.pmsBudgetDocRelateDAO.queryPaging(query);
    }

    public List<PmsBudgetDocRelateVO> queryListDynamic(PmsBudgetDocRelateQuery query) {
        return this.pmsBudgetDocRelateDAO.queryListDynamic(query);
    }

    public PmsBudgetDocRelateVO queryByKey(Long key) {
        PmsBudgetDocRelateDO entity = this.pmsBudgetDocRelateRepo.findById(key).orElseGet(PmsBudgetDocRelateDO::new);
        Assert.notNull((Object)entity.getId(), (String)"\u4e0d\u5b58\u5728");
        PmsBudgetDocRelateVO vo = PmsBudgetDocRelateConvert.INSTANCE.toVo(entity);
        return vo;
    }

    @Transactional(rollbackFor={Exception.class})
    public PmsBudgetDocRelateVO insert(PmsBudgetDocRelatePayload payload) {
        PmsBudgetDocRelateDO entityDo = PmsBudgetDocRelateConvert.INSTANCE.toDo(payload);
        return PmsBudgetDocRelateConvert.INSTANCE.toVo((PmsBudgetDocRelateDO)((Object)this.pmsBudgetDocRelateRepo.save((Object)entityDo)));
    }

    @Transactional
    public List<PmsBudgetDocRelateVO> batchInsert(List<PmsBudgetDocRelatePayload> payloadList) {
        if (ObjectUtils.isEmpty(payloadList)) {
            log.info("\u5f85\u63d2\u5165\u7684\u9884\u7b97\u5173\u8054\u6570\u636e\u4e3a\u7a7a\uff01");
            return Collections.emptyList();
        }
        List<PmsBudgetDocRelateDO> entityDOList = PmsBudgetDocRelateConvert.INSTANCE.toDoList(payloadList);
        return PmsBudgetDocRelateConvert.INSTANCE.toVoList(this.pmsBudgetDocRelateRepo.saveAll(entityDOList));
    }

    @Transactional(rollbackFor={Exception.class})
    public PmsBudgetDocRelateVO update(PmsBudgetDocRelatePayload payload) {
        PmsBudgetDocRelateDO entity = this.pmsBudgetDocRelateRepo.findById(payload.getId()).orElseGet(PmsBudgetDocRelateDO::new);
        Assert.notNull((Object)entity.getId(), (String)"\u4e0d\u5b58\u5728");
        PmsBudgetDocRelateDO entityDo = PmsBudgetDocRelateConvert.INSTANCE.toDo(payload);
        entity.copy(entityDo);
        return PmsBudgetDocRelateConvert.INSTANCE.toVo((PmsBudgetDocRelateDO)((Object)this.pmsBudgetDocRelateRepo.save((Object)entity)));
    }

    @Transactional(rollbackFor={Exception.class})
    public long updateByKeyDynamic(PmsBudgetDocRelatePayload payload) {
        PmsBudgetDocRelateVO pmsBudgetDocRelateVO = this.pmsBudgetDocRelateDAO.queryByKey(payload.getId());
        if (ObjectUtils.isEmpty((Object)pmsBudgetDocRelateVO)) {
            return -1L;
        }
        return this.pmsBudgetDocRelateDAO.updateByKeyDynamic(payload);
    }

    @Transactional
    public long updateByRelateDocId(PmsBudgetDocRelatePayload payload) {
        PmsBudgetDocRelateVO pmsBudgetDocRelateVO = this.pmsBudgetDocRelateDAO.queryByRelateDocId(payload.getId());
        if (ObjectUtils.isEmpty((Object)pmsBudgetDocRelateVO)) {
            return -1L;
        }
        return this.pmsBudgetDocRelateDAO.updateByRelateDocId(payload);
    }

    @Transactional(rollbackFor={Exception.class})
    public void deleteSoft(List<Long> keys) {
        if (!keys.isEmpty()) {
            this.pmsBudgetDocRelateDAO.deleteSoft(keys);
        }
    }

    @Transactional
    public void deleteByRelateDocId(List<Long> relateDocIds) {
        if (!relateDocIds.isEmpty()) {
            this.pmsBudgetDocRelateDAO.deleteByRelateDocId(relateDocIds);
        }
    }

    @Transactional
    public void deleteByRelateDocType(List<String> relateDocTypes) {
        this.pmsBudgetDocRelateDAO.deleteByRelateDocType(relateDocTypes);
    }

    public PmsBudgetDocRelateServiceImpl(PmsBudgetDocRelateRepo pmsBudgetDocRelateRepo, PmsBudgetDocRelateDAO pmsBudgetDocRelateDAO) {
        this.pmsBudgetDocRelateRepo = pmsBudgetDocRelateRepo;
        this.pmsBudgetDocRelateDAO = pmsBudgetDocRelateDAO;
    }
}

