/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5.server.prd.cal.dao;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.common.TwQueryParam;
import com.elitesland.tw.tw5.api.prd.cal.payload.CalAccountPayload;
import com.elitesland.tw.tw5.api.prd.cal.query.CalAccountQuery;
import com.elitesland.tw.tw5.api.prd.cal.vo.CalAccountVO;
import com.elitesland.tw.tw5.server.common.util.SqlUtil;
import com.elitesland.tw.tw5.server.prd.cal.entity.CalAccountDO;
import com.elitesland.tw.tw5.server.prd.cal.entity.QCalAccountDO;
import com.elitesland.tw.tw5.server.prd.cal.repo.CalAccountRepo;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.core.types.dsl.BooleanExpression;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import com.querydsl.jpa.impl.JPAUpdateClause;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

@Repository
public class CalAccountDAO {
    private final JPAQueryFactory jpaQueryFactory;
    private final CalAccountRepo repo;
    private final QCalAccountDO qdo = QCalAccountDO.calAccountDO;

    private JPAQuery<CalAccountVO> getJpaQuerySelect() {
        return (JPAQuery)this.jpaQueryFactory.select((Expression)Projections.bean(CalAccountVO.class, (Expression[])new Expression[]{this.qdo.id, this.qdo.remark, this.qdo.createUserId, this.qdo.creator, this.qdo.createTime, this.qdo.ledgerYear, this.qdo.ledgerName, this.qdo.ledgerStatus, this.qdo.auType, this.qdo.auId, this.qdo.ledgerNo, this.qdo.ledgerType, this.qdo.currCode, this.qdo.totalQty, this.qdo.frozenQty, this.qdo.avalQty, this.qdo.totalAmt, this.qdo.frozenAmt, this.qdo.avalAmt})).from((EntityPath)this.qdo);
    }

    private JPAQuery<CalAccountVO> getJpaQueryWhere(CalAccountQuery query) {
        JPAQuery<CalAccountVO> jpaQuery = this.getJpaQuerySelect();
        jpaQuery.where(this.where(query));
        SqlUtil.handleCommonJpaQuery(jpaQuery, this.qdo._super, (TwQueryParam)query);
        jpaQuery.orderBy(SqlUtil.getSortedColumn(this.qdo, query.getOrders()));
        return jpaQuery;
    }

    public long count(CalAccountQuery query) {
        JPAQuery jpaQuery = (JPAQuery)this.jpaQueryFactory.select((Expression)this.qdo.count()).from((EntityPath)this.qdo);
        jpaQuery.where(this.where(query));
        SqlUtil.handleCommonJpaQuery(jpaQuery, this.qdo._super, (TwQueryParam)query);
        long total = (Long)jpaQuery.fetchOne();
        return total;
    }

    private Predicate where(CalAccountQuery query) {
        ArrayList<BooleanExpression> list = new ArrayList<BooleanExpression>();
        if (!ObjectUtils.isEmpty((Object)query.getId())) {
            list.add(this.qdo.id.eq((Object)query.getId()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getLedgerYear())) {
            if (query.getLedgerYearFlag() != null && query.getLedgerYearFlag().equals(0)) {
                list.add(this.qdo.ledgerYear.ne((Object)query.getLedgerYear()));
            } else {
                list.add(this.qdo.ledgerYear.eq((Object)query.getLedgerYear()));
            }
        }
        if (!ObjectUtils.isEmpty((Object)query.getLedgerName())) {
            list.add(this.qdo.ledgerName.like(SqlUtil.toSqlLikeString(query.getLedgerName())));
        }
        if (!ObjectUtils.isEmpty((Object)query.getLedgerStatus())) {
            list.add(this.qdo.ledgerStatus.eq((Object)query.getLedgerStatus()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getAuType())) {
            list.add(this.qdo.auType.eq((Object)query.getAuType()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getAuTypes())) {
            list.add(this.qdo.auType.in((Collection)query.getAuTypes()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getAuId())) {
            list.add(this.qdo.auId.eq((Object)query.getAuId()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getLedgerNo())) {
            list.add(this.qdo.ledgerNo.eq((Object)query.getLedgerNo()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getLedgerType())) {
            list.add(this.qdo.ledgerType.eq((Object)query.getLedgerType()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getCurrCode())) {
            list.add(this.qdo.currCode.eq((Object)query.getCurrCode()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getTotalQty())) {
            list.add(this.qdo.totalQty.eq((Object)query.getTotalQty()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getFrozenQty())) {
            list.add(this.qdo.frozenQty.eq((Object)query.getFrozenQty()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getAvalQty())) {
            list.add(this.qdo.avalQty.eq((Object)query.getAvalQty()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getTotalAmt())) {
            list.add(this.qdo.totalAmt.eq((Object)query.getTotalAmt()));
        }
        if (StringUtils.hasText((String)query.getOperType())) {
            if ("1".equals(query.getOperType())) {
                list.add(this.qdo.totalAmt.gt((Number)0));
            }
            if ("-1".equals(query.getOperType())) {
                list.add(this.qdo.totalAmt.lt((Number)0));
            }
        }
        if (!ObjectUtils.isEmpty((Object)query.getFrozenAmt())) {
            list.add(this.qdo.frozenAmt.eq((Object)query.getFrozenAmt()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getAvalAmt())) {
            list.add(this.qdo.avalAmt.eq((Object)query.getAvalAmt()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getLedgerNos())) {
            list.add(this.qdo.ledgerNo.in((Collection)query.getLedgerNos()));
        }
        return ExpressionUtils.allOf(list);
    }

    public CalAccountVO queryByKey(Long id) {
        JPAQuery<CalAccountVO> jpaQuery = this.getJpaQuerySelect();
        jpaQuery.where((Predicate)this.qdo.id.eq((Object)id));
        jpaQuery.where((Predicate)this.qdo.deleteFlag.eq((Object)0));
        return (CalAccountVO)jpaQuery.fetchFirst();
    }

    public List<CalAccountVO> queryByKeys(List<Long> keys) {
        JPAQuery<CalAccountVO> jpaQuery = this.getJpaQuerySelect();
        jpaQuery.where((Predicate)this.qdo.id.in(keys));
        jpaQuery.where((Predicate)this.qdo.deleteFlag.eq((Object)0));
        return jpaQuery.fetch();
    }

    public List<CalAccountVO> queryListDynamic(CalAccountQuery query) {
        JPAQuery<CalAccountVO> jpaQuery = this.getJpaQueryWhere(query);
        return jpaQuery.fetch();
    }

    public PagingVO<CalAccountVO> queryPaging(CalAccountQuery query) {
        long total = this.count(query);
        if (total == 0L) {
            return PagingVO.empty();
        }
        JPAQuery<CalAccountVO> jpaQuery = this.getJpaQueryWhere(query);
        List result = ((JPAQuery)((JPAQuery)jpaQuery.offset(query.getPageRequest().getOffset())).limit((long)query.getPageRequest().getPageSize())).fetch();
        return PagingVO.builder().records(result).total(total).build();
    }

    public CalAccountDO save(CalAccountDO ado) {
        return (CalAccountDO)this.repo.save(ado);
    }

    public List<CalAccountDO> saveAll(List<CalAccountDO> dos) {
        return this.repo.saveAll(dos);
    }

    @Transactional
    public long updateByKeyDynamic(CalAccountPayload payload) {
        List nullFields;
        JPAUpdateClause update = this.jpaQueryFactory.update((EntityPath)this.qdo).where(new Predicate[]{this.qdo.id.eq((Object)payload.getId())});
        if (payload.getId() != null) {
            update.set(this.qdo.id, (Object)payload.getId());
        }
        if (payload.getLedgerYear() != null) {
            update.set(this.qdo.ledgerYear, (Object)payload.getLedgerYear());
        }
        if (payload.getLedgerName() != null) {
            update.set((Path)this.qdo.ledgerName, (Object)payload.getLedgerName());
        }
        if (payload.getLedgerStatus() != null) {
            update.set(this.qdo.ledgerStatus, (Object)payload.getLedgerStatus());
        }
        if (payload.getAuType() != null) {
            update.set((Path)this.qdo.auType, (Object)payload.getAuType());
        }
        if (payload.getAuId() != null) {
            update.set(this.qdo.auId, (Object)payload.getAuId());
        }
        if (payload.getLedgerNo() != null) {
            update.set((Path)this.qdo.ledgerNo, (Object)payload.getLedgerNo());
        }
        if (payload.getLedgerType() != null) {
            update.set((Path)this.qdo.ledgerType, (Object)payload.getLedgerType());
        }
        if (payload.getCurrCode() != null) {
            update.set((Path)this.qdo.currCode, (Object)payload.getCurrCode());
        }
        if (payload.getTotalQty() != null) {
            update.set(this.qdo.totalQty, (Object)payload.getTotalQty());
        }
        if (payload.getFrozenQty() != null) {
            update.set(this.qdo.frozenQty, (Object)payload.getFrozenQty());
        }
        if (payload.getAvalQty() != null) {
            update.set(this.qdo.avalQty, (Object)payload.getAvalQty());
        }
        if (payload.getTotalAmt() != null) {
            update.set(this.qdo.totalAmt, (Object)payload.getTotalAmt());
        }
        if (payload.getFrozenAmt() != null) {
            update.set(this.qdo.frozenAmt, (Object)payload.getFrozenAmt());
        }
        if (payload.getAvalAmt() != null) {
            update.set(this.qdo.avalAmt, (Object)payload.getAvalAmt());
        }
        if ((nullFields = payload.getNullFields()) != null && nullFields.size() > 0) {
            if (nullFields.contains("id")) {
                update.setNull(this.qdo.id);
            }
            if (nullFields.contains("ledgerYear")) {
                update.setNull(this.qdo.ledgerYear);
            }
            if (nullFields.contains("ledgerName")) {
                update.setNull((Path)this.qdo.ledgerName);
            }
            if (nullFields.contains("ledgerStatus")) {
                update.setNull(this.qdo.ledgerStatus);
            }
            if (nullFields.contains("auType")) {
                update.setNull((Path)this.qdo.auType);
            }
            if (nullFields.contains("auId")) {
                update.setNull(this.qdo.auId);
            }
            if (nullFields.contains("ledgerNo")) {
                update.setNull((Path)this.qdo.ledgerNo);
            }
            if (nullFields.contains("ledgerType")) {
                update.setNull((Path)this.qdo.ledgerType);
            }
            if (nullFields.contains("currCode")) {
                update.setNull((Path)this.qdo.currCode);
            }
            if (nullFields.contains("totalQty")) {
                update.setNull(this.qdo.totalQty);
            }
            if (nullFields.contains("frozenQty")) {
                update.setNull(this.qdo.frozenQty);
            }
            if (nullFields.contains("avalQty")) {
                update.setNull(this.qdo.avalQty);
            }
            if (nullFields.contains("totalAmt")) {
                update.setNull(this.qdo.totalAmt);
            }
            if (nullFields.contains("frozenAmt")) {
                update.setNull(this.qdo.frozenAmt);
            }
            if (nullFields.contains("avalAmt")) {
                update.setNull(this.qdo.avalAmt);
            }
        }
        return update.execute();
    }

    public long deleteSoft(List<Long> keys) {
        JPAUpdateClause update = this.jpaQueryFactory.update((EntityPath)this.qdo).set(this.qdo.deleteFlag, (Object)1).where(new Predicate[]{this.qdo.id.in(keys)});
        SqlUtil.updateCommonJpaQuery(update, this.qdo._super);
        return update.execute();
    }

    public List<Long> queryListIds(CalAccountQuery query) {
        JPAQuery jpaQuery = (JPAQuery)this.jpaQueryFactory.select(this.qdo.id).from((EntityPath)this.qdo);
        jpaQuery.where(this.where(query));
        SqlUtil.handleCommonJpaQuery(jpaQuery, this.qdo._super, (TwQueryParam)query);
        return jpaQuery.fetch();
    }

    public CalAccountVO queryByAuTypeAndAuId(String auType, Long auId) {
        JPAQuery<CalAccountVO> jpaQuery = this.getJpaQuerySelect();
        jpaQuery.where((Predicate)this.qdo.auType.eq((Object)auType));
        jpaQuery.where((Predicate)this.qdo.auId.eq((Object)auId));
        jpaQuery.where((Predicate)this.qdo.ledgerStatus.eq((Object)1));
        return (CalAccountVO)jpaQuery.fetchFirst();
    }

    public List<CalAccountVO> queryByAuTypeAndAuIds(String auType, List<Long> auIds) {
        JPAQuery<CalAccountVO> jpaQuery = this.getJpaQuerySelect();
        jpaQuery.where((Predicate)this.qdo.auType.eq((Object)auType));
        jpaQuery.where((Predicate)this.qdo.auId.in(auIds));
        jpaQuery.where((Predicate)this.qdo.ledgerStatus.eq((Object)1));
        return jpaQuery.fetch();
    }

    public List<CalAccountVO> queryByAuTypesAndAuIds(List<String> auTypes, List<Long> auIds) {
        JPAQuery<CalAccountVO> jpaQuery = this.getJpaQuerySelect();
        jpaQuery.where((Predicate)this.qdo.auType.in(auTypes));
        jpaQuery.where((Predicate)this.qdo.auId.in(auIds));
        jpaQuery.where((Predicate)this.qdo.ledgerStatus.eq((Object)1));
        return jpaQuery.fetch();
    }

    public long initAccount(List<Long> keys, int year) {
        BigDecimal zero = BigDecimal.ZERO;
        JPAUpdateClause update = this.jpaQueryFactory.update((EntityPath)this.qdo).where(new Predicate[]{this.qdo.id.in(keys)});
        update.set(this.qdo.ledgerYear, (Object)year);
        update.set(this.qdo.totalQty, (Object)zero);
        update.set(this.qdo.frozenQty, (Object)zero);
        update.set(this.qdo.avalQty, (Object)zero);
        update.set(this.qdo.totalAmt, (Object)zero);
        update.set(this.qdo.frozenAmt, (Object)zero);
        update.set(this.qdo.avalAmt, (Object)zero);
        return update.execute();
    }

    public CalAccountDAO(JPAQueryFactory jpaQueryFactory, CalAccountRepo repo) {
        this.jpaQueryFactory = jpaQueryFactory;
        this.repo = repo;
    }
}

