/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5.server.prd.crm.dao;

import com.elitescloud.cloudt.common.base.param.OrderItem;
import com.elitesland.tw.tw5.api.prd.crm.query.CrmPeopleWorkQuery;
import com.elitesland.tw.tw5.api.prd.crm.vo.CrmPeopleWorkVO;
import com.elitesland.tw.tw5.server.common.util.SqlUtil;
import com.elitesland.tw.tw5.server.prd.crm.entity.QCrmPeopleWorkDO;
import com.elitesland.tw.tw5.server.prd.crm.repo.CrmPeopleWorkRepo;
import com.elitesland.tw.tw5.server.prd.partner.common.entity.QBusinessPartnerDO;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import com.querydsl.jpa.impl.JPAUpdateClause;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.List;
import org.springframework.stereotype.Repository;
import org.springframework.util.ObjectUtils;

@Repository
public class CrmPeopleWorkDAO {
    private final JPAQueryFactory jpaQueryFactory;
    private final CrmPeopleWorkRepo repo;
    private final QCrmPeopleWorkDO qdo = QCrmPeopleWorkDO.crmPeopleWorkDO;
    private final QBusinessPartnerDO qBusinessPartnerDO = QBusinessPartnerDO.businessPartnerDO;

    private JPAQuery<CrmPeopleWorkVO> getJpaQuerySelect() {
        JPAQuery jpaQuery = (JPAQuery)((JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)Projections.bean(CrmPeopleWorkVO.class, (Expression[])new Expression[]{this.qdo.id, this.qdo.peopleId, this.qdo.customerId, this.qBusinessPartnerDO.partnerName.as("customerName"), this.qdo.companyName, this.qdo.custType, this.qdo.jobs, this.qdo.workStatus, this.qdo.startDate, this.qdo.endDate, this.qdo.createUserId, this.qdo.modifyTime, this.qdo.createTime, this.qdo.remark})).from((EntityPath)this.qdo)).leftJoin((EntityPath)this.qBusinessPartnerDO)).on((Predicate)this.qdo.customerId.eq(this.qBusinessPartnerDO.id));
        return jpaQuery;
    }

    public List<CrmPeopleWorkVO> queryList(CrmPeopleWorkQuery query) {
        JPAQuery<CrmPeopleWorkVO> jpaQuery = this.getJpaQuerySelect();
        if (!ObjectUtils.isEmpty((Object)query.getPeopleId())) {
            jpaQuery.where((Predicate)this.qdo.peopleId.eq((Object)query.getPeopleId()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getCustomerId())) {
            jpaQuery.where((Predicate)this.qdo.customerId.eq((Object)query.getCustomerId()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getCompanyName())) {
            jpaQuery.where((Predicate)this.qdo.companyName.eq((Object)query.getCompanyName()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getWorkStatus())) {
            jpaQuery.where((Predicate)this.qdo.workStatus.eq((Object)query.getWorkStatus()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getId())) {
            jpaQuery.where((Predicate)this.qdo.id.ne((Object)query.getId()));
        }
        jpaQuery.where((Predicate)this.qdo.deleteFlag.eq((Object)0));
        ArrayList<OrderItem> orders = new ArrayList<OrderItem>();
        orders.add(OrderItem.desc((String)"startDate"));
        jpaQuery.orderBy(SqlUtil.getSortedColumn(this.qdo, orders));
        return jpaQuery.fetch();
    }

    public CrmPeopleWorkVO queryByKey(Long key) {
        JPAQuery<CrmPeopleWorkVO> jpaQuery = this.getJpaQuerySelect();
        ((JPAQuery)jpaQuery.where((Predicate)this.qdo.id.eq((Object)key))).where((Predicate)this.qdo.deleteFlag.eq((Object)0));
        return (CrmPeopleWorkVO)jpaQuery.fetchFirst();
    }

    public long deleteSoft(List<Long> keys) {
        JPAUpdateClause update = this.jpaQueryFactory.update((EntityPath)this.qdo).set(this.qdo.deleteFlag, (Object)1).where(new Predicate[]{this.qdo.id.in(keys)});
        return update.execute();
    }

    public long updateWorkStatusByPeopleIds(List<Long> peopleIds) {
        JPAUpdateClause update = this.jpaQueryFactory.update((EntityPath)this.qdo).set((Path)this.qdo.workStatus, (Object)"0").set(this.qdo.endDate, (Object)LocalDate.now()).where(new Predicate[]{this.qdo.peopleId.in(peopleIds)}).where(new Predicate[]{this.qdo.workStatus.eq((Object)"1")});
        return update.execute();
    }

    public long updateCustomerIdByPeopleIds(List<Long> peopleIds, Long customerId) {
        JPAUpdateClause update = this.jpaQueryFactory.update((EntityPath)this.qdo).set(this.qdo.customerId, (Object)customerId).where(new Predicate[]{this.qdo.customerId.in(peopleIds)}).where(new Predicate[]{this.qdo.workStatus.eq((Object)"1")});
        return update.execute();
    }

    public CrmPeopleWorkDAO(JPAQueryFactory jpaQueryFactory, CrmPeopleWorkRepo repo) {
        this.jpaQueryFactory = jpaQueryFactory;
        this.repo = repo;
    }
}

