/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5.server.prd.humanresources.basebu.service;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.lang.Assert;
import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.system.dto.SysOrgBasicDTO;
import com.elitesland.tw.tw5.api.prd.humanresources.payload.PrdBaseRegionChangePayload;
import com.elitesland.tw.tw5.api.prd.humanresources.query.PrdBaseRegionChangeQuery;
import com.elitesland.tw.tw5.api.prd.humanresources.service.PrdBaseRegionChangeService;
import com.elitesland.tw.tw5.api.prd.humanresources.vo.PrdBaseRegionChangeVO;
import com.elitesland.tw.tw5.api.prd.org.service.PrdOrgOrganizationService;
import com.elitesland.tw.tw5.api.prd.org.vo.PrdOrgOrganizationVO;
import com.elitesland.tw.tw5.api.prd.system.payload.PrdMessageConfigPayload;
import com.elitesland.tw.tw5.api.prd.system.service.PrdMessageConfigService;
import com.elitesland.tw.tw5.api.prd.system.service.PrdSystemRoleService;
import com.elitesland.tw.tw5.server.prd.common.CacheUtil;
import com.elitesland.tw.tw5.server.prd.common.GlobalUtil;
import com.elitesland.tw.tw5.server.prd.common.WorkflowUtil;
import com.elitesland.tw.tw5.server.prd.common.functionEnum.FunctionSelectionEnum;
import com.elitesland.tw.tw5.server.prd.common.functionEnum.RoleEnum;
import com.elitesland.tw.tw5.server.prd.humanresources.base.HrBaseEnum;
import com.elitesland.tw.tw5.server.prd.humanresources.basebu.dao.PrdBaseRegionChangeDao;
import com.elitesland.tw.tw5.server.prd.humanresources.basebu.entity.PrdBaseRegionChangeDO;
import com.elitesland.tw.tw5.server.prd.humanresources.basebu.repo.PrdBaseRegionChangeRepo;
import com.elitesland.tw.tw5.server.prd.humanresources.convert.PrdBaseRegionChangeConvert;
import com.elitesland.tw.tw5.server.prd.system.constant.MessageNoticeTypeEnum;
import com.elitesland.tw.tw5.server.prd.system.dao.PrdSystemRoleDAO;
import com.elitesland.workflow.ProcessInfo;
import com.elitesland.workflow.enums.ProcInstStatus;
import com.elitesland.workflow.payload.StartProcessPayload;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service
public class PrdBaseRegionChangeServiceImpl
implements PrdBaseRegionChangeService {
    private static final Logger log = LoggerFactory.getLogger(PrdBaseRegionChangeServiceImpl.class);
    private final PrdBaseRegionChangeDao prdBaseRegionChangeDao;
    private final PrdBaseRegionChangeRepo prdBaseRegionChangeRepo;
    private final WorkflowUtil workflowUtil;
    private final PrdSystemRoleDAO prdSystemRoleDAO;
    private final PrdOrgOrganizationService prdOrgOrganizationService;
    private final CacheUtil cacheUtil;
    private final PrdMessageConfigService messageConfigService;
    private final PrdSystemRoleService roleService;

    @Transactional(rollbackFor={Exception.class})
    public PrdBaseRegionChangeVO save(PrdBaseRegionChangePayload prdBaseRegionChangePayload) {
        this.checkData(prdBaseRegionChangePayload);
        PrdBaseRegionChangeQuery prdBaseRegionChangeQuery = new PrdBaseRegionChangeQuery();
        prdBaseRegionChangeQuery.setApplyUserId(prdBaseRegionChangePayload.getApplyUserId());
        prdBaseRegionChangeQuery.setProcInstStatus(ProcInstStatus.APPROVING);
        Long count = this.prdBaseRegionChangeDao.count(prdBaseRegionChangeQuery);
        if (count > 0L) {
            throw new BusinessException(HrBaseEnum.FLOW_REPEAT_ERR.getDesc());
        }
        prdBaseRegionChangePayload.setSubmitTime(LocalDateTime.now());
        PrdBaseRegionChangeDO prdBaseRegionChangeDO = new PrdBaseRegionChangeDO();
        prdBaseRegionChangeDO = PrdBaseRegionChangeConvert.INSTANCE.p2d(prdBaseRegionChangePayload);
        PrdBaseRegionChangeDO res = (PrdBaseRegionChangeDO)((Object)this.prdBaseRegionChangeRepo.save((Object)prdBaseRegionChangeDO));
        this.startWorkFlow(res);
        return PrdBaseRegionChangeConvert.INSTANCE.d2v(res);
    }

    public void startWorkFlow(PrdBaseRegionChangeDO res) {
        ProcessInfo processInfo = new ProcessInfo();
        HashMap<String, Object> variables = new HashMap<String, Object>();
        Boolean isRagionChange = false;
        if (!res.getOldSocialRegion().equals(res.getNewSocialRegion())) {
            isRagionChange = true;
        }
        variables.put("ragionChange", isRagionChange);
        List<Long> xcUserIds = this.prdSystemRoleDAO.queryUserIdByRoleCodes(List.of(RoleEnum.PLAT_SALARY_MANAGER.getCode(), RoleEnum.PLAT_SALARY_SPECIALIST.getCode()));
        variables.put("Activity_1a4vis6", xcUserIds);
        SysOrgBasicDTO org = GlobalUtil.getLoginUser().getOrg();
        Assert.notNull((Object)res.getBaseBuId(), (String)"baseBuId\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        PrdOrgOrganizationVO prdOrgOrganizationVO = this.prdOrgOrganizationService.queryDetailSimpleByOrgId(res.getBaseBuId());
        variables.put("Activity_1vt5lvm", List.of(prdOrgOrganizationVO.getManageId()));
        List<Long> pthrUserIds = this.prdSystemRoleDAO.queryUserIdByRoleCode(RoleEnum.PLAT_HRD.getCode());
        variables.put("Activity_0l40et8", pthrUserIds);
        List<Long> zbhrUserIds = this.prdSystemRoleDAO.queryUserIdByRoleCodes(List.of(RoleEnum.PLAT_ERM.getCode(), RoleEnum.PLAT_ERS.getCode()));
        variables.put("Activity_10xxexy", zbhrUserIds);
        processInfo = this.workflowUtil.startProcess(StartProcessPayload.of((String)HrBaseEnum.BASE_REGION_CHANGE.getCode(), (String)("G02.Base\u5730\u4e0e\u793e\u4fdd\u516c\u79ef\u91d1\u7f34\u7eb3\u5730\u53d8\u66f4\u6d41\u7a0b-" + this.cacheUtil.getUserName(res.getApplyUserId())), (String)res.getId().toString(), variables), new Long[0]);
        String procInstId = processInfo.getProcInstId();
        ProcInstStatus procInstStatus = processInfo.getProcInstStatus();
        PrdBaseRegionChangePayload payload = new PrdBaseRegionChangePayload();
        payload.setProcInstId(procInstId);
        payload.setProcInstStatus(procInstStatus);
        payload.setId(res.getId());
        Long update = this.prdBaseRegionChangeDao.update(payload);
        String title = "Base\u5730\u53d8\u66f4-" + this.cacheUtil.getUserName(res.getApplyUserId());
        String oldBaseRegion = this.cacheUtil.transferSystemSelection(FunctionSelectionEnum.PCD.getCode(), res.getOldBaseRegion());
        String newBaseRegion = this.cacheUtil.transferSystemSelection(FunctionSelectionEnum.PCD.getCode(), res.getNewBaseRegion());
        String content = "\u5458\u5de5" + this.cacheUtil.getUserName(res.getApplyUserId()) + "\u53d1\u8d77\u4e86Base\u5730\u53d8\u66f4\uff0c\u539fBase\u5730:" + oldBaseRegion + "\uff0c\u65b0Base\u5730\u4e3a:" + newBaseRegion;
        this.sendMessage(res.getId(), title, content);
    }

    @Transactional(rollbackFor={Exception.class})
    public PrdBaseRegionChangeVO update(PrdBaseRegionChangePayload prdBaseRegionChangePayload) {
        Assert.notNull((Object)prdBaseRegionChangePayload.getId(), (String)"id is null", (Object[])new Object[0]);
        PrdBaseRegionChangeVO res = this.save(prdBaseRegionChangePayload);
        return res;
    }

    public PrdBaseRegionChangeVO get(Long id) {
        if (null == id) {
            return null;
        }
        PrdBaseRegionChangeVO res = this.prdBaseRegionChangeDao.get(id);
        return res;
    }

    public PagingVO<PrdBaseRegionChangeVO> page(PrdBaseRegionChangeQuery prdBaseRegionChangeQuery) {
        PagingVO<PrdBaseRegionChangeVO> res = this.prdBaseRegionChangeDao.page(prdBaseRegionChangeQuery);
        return res;
    }

    @Transactional(rollbackFor={Exception.class})
    public Long del(List<Long> ids) {
        if (CollectionUtil.isEmpty(ids)) {
            return 0L;
        }
        Long res = this.prdBaseRegionChangeDao.del(ids);
        return res;
    }

    public List<PrdBaseRegionChangeVO> getList(PrdBaseRegionChangeQuery prdBaseRegionChangeQuery) {
        List<PrdBaseRegionChangeVO> res = this.prdBaseRegionChangeDao.getList(prdBaseRegionChangeQuery);
        return res;
    }

    @Transactional(rollbackFor={Exception.class})
    public Long updateByCondition(PrdBaseRegionChangePayload prdBaseRegionChangePayload) {
        Assert.notNull((Object)prdBaseRegionChangePayload.getId());
        Long res = this.prdBaseRegionChangeDao.update(prdBaseRegionChangePayload);
        return res;
    }

    @Transactional(rollbackFor={Exception.class})
    public Boolean updateByBatch(List<PrdBaseRegionChangePayload> prdBaseRegionChangePayload) {
        for (PrdBaseRegionChangePayload payload : prdBaseRegionChangePayload) {
            this.updateByCondition(payload);
        }
        return true;
    }

    private void checkData(PrdBaseRegionChangePayload prdBaseRegionChangePayload) {
    }

    public void sendMessage(Long objectId, String messageTitle, String content) {
        PrdMessageConfigPayload ado = new PrdMessageConfigPayload();
        ado.setObjectId(objectId);
        ado.setMessageTitle(messageTitle);
        ado.setMessageType(Integer.valueOf(2));
        ado.setContentBigType("businessMessage");
        ado.setContentType(MessageNoticeTypeEnum.personnelMessage.getCode());
        ado.setMessageTag("important");
        ado.setIsEnable(Integer.valueOf(0));
        ado.setNoticeScope("appoint_people");
        ado.setNoticeWay("instation");
        ado.setReleaseSource("profileMessage");
        ado.setReleaseStatus(Integer.valueOf(3));
        ado.setMessageContent(content);
        ArrayList list = new ArrayList();
        list.addAll(this.roleService.queryUserIdByRoleCode(RoleEnum.PLAT_HRD.getCode()));
        list.addAll(this.roleService.queryUserIdByRoleCode(RoleEnum.PLAT_ERM.getCode()));
        list.addAll(this.roleService.queryUserIdByRoleCode(RoleEnum.PLAT_ERS.getCode()));
        list.addAll(this.roleService.queryUserIdByRoleCode(RoleEnum.PLAT_SALARY_MANAGER.getCode()));
        list.addAll(this.roleService.queryUserIdByRoleCode(RoleEnum.PLAT_SALARY_SPECIALIST.getCode()));
        if (!CollectionUtils.isEmpty(list)) {
            String noticeSource = list.stream().map(p -> p.toString()).collect(Collectors.joining(","));
            ado.setNoticeSource(noticeSource);
            this.messageConfigService.insert(ado);
        }
    }

    public PrdBaseRegionChangeServiceImpl(PrdBaseRegionChangeDao prdBaseRegionChangeDao, PrdBaseRegionChangeRepo prdBaseRegionChangeRepo, WorkflowUtil workflowUtil, PrdSystemRoleDAO prdSystemRoleDAO, PrdOrgOrganizationService prdOrgOrganizationService, CacheUtil cacheUtil, PrdMessageConfigService messageConfigService, PrdSystemRoleService roleService) {
        this.prdBaseRegionChangeDao = prdBaseRegionChangeDao;
        this.prdBaseRegionChangeRepo = prdBaseRegionChangeRepo;
        this.workflowUtil = workflowUtil;
        this.prdSystemRoleDAO = prdSystemRoleDAO;
        this.prdOrgOrganizationService = prdOrgOrganizationService;
        this.cacheUtil = cacheUtil;
        this.messageConfigService = messageConfigService;
        this.roleService = roleService;
    }
}

