/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5.server.prd.humanresources.eval.service;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.lang.Assert;
import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.humanresources.payload.PrdEvaluateDtlPayload;
import com.elitesland.tw.tw5.api.prd.humanresources.query.PrdEvaluateDtlQuery;
import com.elitesland.tw.tw5.api.prd.humanresources.service.PrdEvaluateConfigPointService;
import com.elitesland.tw.tw5.api.prd.humanresources.service.PrdEvaluateDtlService;
import com.elitesland.tw.tw5.api.prd.humanresources.vo.PrdEvaluateConfigPointVO;
import com.elitesland.tw.tw5.api.prd.humanresources.vo.PrdEvaluateDtlVO;
import com.elitesland.tw.tw5.server.prd.humanresources.convert.PrdEvaluateDtlConvert;
import com.elitesland.tw.tw5.server.prd.humanresources.eval.dao.PrdEvaluateDtlDao;
import com.elitesland.tw.tw5.server.prd.humanresources.eval.entity.PrdEvaluateDtlDO;
import com.elitesland.tw.tw5.server.prd.humanresources.eval.repo.PrdEvaluateDtlRepo;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class PrdEvaluateDtlServiceImpl
implements PrdEvaluateDtlService {
    private static final Logger log = LoggerFactory.getLogger(PrdEvaluateDtlServiceImpl.class);
    private final PrdEvaluateDtlDao prdEvaluateDtlDao;
    private final PrdEvaluateDtlRepo prdEvaluateDtlRepo;
    private final PrdEvaluateConfigPointService prdEvaluateConfigPointService;

    @Transactional(rollbackFor={Exception.class})
    public PrdEvaluateDtlVO save(PrdEvaluateDtlPayload prdEvaluateDtlPayload) {
        this.checkData(prdEvaluateDtlPayload);
        PrdEvaluateConfigPointVO prdEvaluateConfigPointVO = this.prdEvaluateConfigPointService.get(prdEvaluateDtlPayload.getPointId());
        if (null == prdEvaluateConfigPointVO) {
            throw new BusinessException("\u8bc4\u4ef7\u70b9pointId\u672a\u627e\u5230\uff0c\u8bf7\u6838\u5bf9");
        }
        PrdEvaluateDtlDO prdEvaluateDtlDO = new PrdEvaluateDtlDO();
        prdEvaluateDtlDO = PrdEvaluateDtlConvert.INSTANCE.p2d(prdEvaluateDtlPayload);
        PrdEvaluateDtlDO res = (PrdEvaluateDtlDO)((Object)this.prdEvaluateDtlRepo.save((Object)prdEvaluateDtlDO));
        return PrdEvaluateDtlConvert.INSTANCE.d2v(res);
    }

    @Transactional(rollbackFor={Exception.class})
    public PrdEvaluateDtlVO update(PrdEvaluateDtlPayload prdEvaluateDtlPayload) {
        Assert.notNull((Object)prdEvaluateDtlPayload.getId(), (String)"id is null", (Object[])new Object[0]);
        PrdEvaluateDtlVO res = this.save(prdEvaluateDtlPayload);
        return res;
    }

    public PrdEvaluateDtlVO get(Long id) {
        if (null == id) {
            return null;
        }
        PrdEvaluateDtlVO res = this.prdEvaluateDtlDao.get(id);
        return res;
    }

    public PagingVO<PrdEvaluateDtlVO> page(PrdEvaluateDtlQuery prdEvaluateDtlQuery) {
        PagingVO<PrdEvaluateDtlVO> res = this.prdEvaluateDtlDao.page(prdEvaluateDtlQuery);
        return res;
    }

    @Transactional(rollbackFor={Exception.class})
    public Long del(List<Long> ids) {
        if (CollectionUtil.isEmpty(ids)) {
            return 0L;
        }
        Long res = this.prdEvaluateDtlDao.del(ids);
        return res;
    }

    public List<PrdEvaluateDtlVO> getList(PrdEvaluateDtlQuery prdEvaluateDtlQuery) {
        List<PrdEvaluateDtlVO> res = this.prdEvaluateDtlDao.getList(prdEvaluateDtlQuery);
        return res;
    }

    private void checkData(PrdEvaluateDtlPayload prdEvaluateDtlPayload) {
        if (StringUtils.isBlank((CharSequence)prdEvaluateDtlPayload.getPointName())) {
            throw new BusinessException("\u8bc4\u4ef7\u70b9\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == prdEvaluateDtlPayload.getScore()) {
            throw new BusinessException("\u8bc4\u5206\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == prdEvaluateDtlPayload.getPointId()) {
            throw new BusinessException("pointId\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }

    @Transactional(rollbackFor={Exception.class})
    public Long updateByCondition(PrdEvaluateDtlPayload prdEvaluateDtlPayload) {
        Assert.notNull((Object)prdEvaluateDtlPayload.getId(), (String)"id\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Long res = this.prdEvaluateDtlDao.update(prdEvaluateDtlPayload);
        return res;
    }

    @Transactional
    public Long delByEvalIds(List<Long> ids) {
        Long res = this.prdEvaluateDtlDao.delByEvalIds(ids);
        return res;
    }

    public PrdEvaluateDtlServiceImpl(PrdEvaluateDtlDao prdEvaluateDtlDao, PrdEvaluateDtlRepo prdEvaluateDtlRepo, PrdEvaluateConfigPointService prdEvaluateConfigPointService) {
        this.prdEvaluateDtlDao = prdEvaluateDtlDao;
        this.prdEvaluateDtlRepo = prdEvaluateDtlRepo;
        this.prdEvaluateConfigPointService = prdEvaluateConfigPointService;
    }
}

