/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5.server.prd.humanresources.personnel.service;

import cn.hutool.core.collection.CollUtil;
import cn.zhxu.bs.BeanSearcher;
import cn.zhxu.bs.FieldOp;
import cn.zhxu.bs.FieldOps;
import cn.zhxu.bs.util.FieldFns;
import cn.zhxu.bs.util.MapBuilder;
import cn.zhxu.bs.util.MapUtils;
import com.alibaba.fastjson.JSON;
import com.elitescloud.boot.common.param.BaseViewModel;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.system.dto.req.UserCreateDTO;
import com.elitescloud.cloudt.system.param.SysUserBatchSwitchParam;
import com.elitescloud.cloudt.system.param.SysUserUpdateParam;
import com.elitescloud.cloudt.system.provider.SysUserRpcService;
import com.elitescloud.cloudt.system.provider.org.UserRpcService;
import com.elitesland.tw.tw5.api.common.TwQueryParam;
import com.elitesland.tw.tw5.api.common.change.payload.PrdSystemBusinessChangePayload;
import com.elitesland.tw.tw5.api.common.change.service.PrdSystemBusinessChangeService;
import com.elitesland.tw.tw5.api.common.change.vo.PrdSystemBusinessChangeVO;
import com.elitesland.tw.tw5.api.prd.cal.payload.CalEqvaIncomePayload;
import com.elitesland.tw.tw5.api.prd.cal.service.CalEqvaIncomeService;
import com.elitesland.tw.tw5.api.prd.humanresources.payload.PersonResPayload;
import com.elitesland.tw.tw5.api.prd.humanresources.payload.ResEntryExitLogPayload;
import com.elitesland.tw.tw5.api.prd.humanresources.query.PrdOrgResQuery;
import com.elitesland.tw.tw5.api.prd.humanresources.service.PersonAccountService;
import com.elitesland.tw.tw5.api.prd.humanresources.service.PersonCertService;
import com.elitesland.tw.tw5.api.prd.humanresources.service.PersonEduExperienceService;
import com.elitesland.tw.tw5.api.prd.humanresources.service.PersonProjectExperienceService;
import com.elitesland.tw.tw5.api.prd.humanresources.service.PersonResService;
import com.elitesland.tw.tw5.api.prd.humanresources.service.PersonRewardPunishService;
import com.elitesland.tw.tw5.api.prd.humanresources.service.PersonWorkExperienceService;
import com.elitesland.tw.tw5.api.prd.humanresources.service.ResEntryExitLogService;
import com.elitesland.tw.tw5.api.prd.humanresources.service.ResEvaluateService;
import com.elitesland.tw.tw5.api.prd.humanresources.vo.PersonResChangeVO;
import com.elitesland.tw.tw5.api.prd.humanresources.vo.PersonResVO;
import com.elitesland.tw.tw5.api.prd.humanresources.vo.ResEvaluateVO;
import com.elitesland.tw.tw5.api.prd.my.service.UserVacationService;
import com.elitesland.tw.tw5.api.prd.org.payload.PrdOrgEmployeePayload;
import com.elitesland.tw.tw5.api.prd.org.query.PrdOrgEmployeeQuery;
import com.elitesland.tw.tw5.api.prd.org.service.PrdOrgEmployeeEqvaRatioService;
import com.elitesland.tw.tw5.api.prd.org.service.PrdOrgEmployeeService;
import com.elitesland.tw.tw5.api.prd.org.vo.PrdOrgEmployeeBSVO;
import com.elitesland.tw.tw5.api.prd.org.vo.PrdOrgEmployeeVO;
import com.elitesland.tw.tw5.api.prd.task.query.TaskInfoQuery;
import com.elitesland.tw.tw5.api.prd.task.service.TaskInfoService;
import com.elitesland.tw.tw5.server.common.TwException;
import com.elitesland.tw.tw5.server.common.change.changeEnum.ChangeTypeEnum;
import com.elitesland.tw.tw5.server.common.change.dao.PrdSystemBusinessChangeDAO;
import com.elitesland.tw.tw5.server.common.permission.PermissionBeanSearcherFactory;
import com.elitesland.tw.tw5.server.common.permission.enums.PermissionDomainEnum;
import com.elitesland.tw.tw5.server.common.service.TransactionUtilService;
import com.elitesland.tw.tw5.server.common.util.SqlUtil;
import com.elitesland.tw.tw5.server.common.workFlow.ProcDefKey;
import com.elitesland.tw.tw5.server.prd.common.CacheUtil;
import com.elitesland.tw.tw5.server.prd.common.FileUtil;
import com.elitesland.tw.tw5.server.prd.common.WorkflowUtil;
import com.elitesland.tw.tw5.server.prd.common.functionEnum.FunctionSelectionEnum;
import com.elitesland.tw.tw5.server.prd.common.functionEnum.RoleEnum;
import com.elitesland.tw.tw5.server.prd.common.functionEnum.SystemDefaultEnum;
import com.elitesland.tw.tw5.server.prd.common.functionEnum.WorkFlowStatusEnum;
import com.elitesland.tw.tw5.server.prd.humanresources.personnel.convert.PersonResConvert;
import com.elitesland.tw.tw5.server.prd.org.convert.PrdOrgEmployeeConvert;
import com.elitesland.tw.tw5.server.prd.org.dao.PrdOrgEmployeeDAO;
import com.elitesland.tw.tw5.server.prd.org.dao.PrdOrgPersonDAO;
import com.elitesland.tw.tw5.server.prd.org.entity.PrdOrgEmployeeRefDO;
import com.elitesland.tw.tw5.server.prd.org.entity.PrdOrgPersonDO;
import com.elitesland.tw.tw5.server.prd.system.dao.PrdSystemRoleDAO;
import com.elitesland.tw.tw5.server.prd.system.entity.PrdSystemUserRoleDO;
import com.elitesland.tw.tw5.server.udc.UdcUtil;
import com.elitesland.workflow.ProcessInfo;
import com.elitesland.workflow.payload.StartProcessPayload;
import java.io.Serializable;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

@Service
public class PersonResServiceImpl
implements PersonResService {
    private static final Logger log = LoggerFactory.getLogger(PersonResServiceImpl.class);
    private final PrdOrgEmployeeDAO dao;
    private final CacheUtil cacheUtil;
    private final PersonEduExperienceService personEduExperienceService;
    private final PersonWorkExperienceService personWorkExperienceService;
    private final PersonProjectExperienceService personProjectExperienceService;
    private final PersonAccountService personAccountService;
    private final PersonCertService personCertService;
    private final ResEvaluateService resEvaluateService;
    private final TaskInfoService taskInfoService;
    private final WorkflowUtil workflowUtil;
    private final PrdSystemBusinessChangeService changeService;
    private final PrdSystemBusinessChangeDAO changeDAO;
    private final TransactionUtilService transactionUtilService;
    private final PrdSystemRoleDAO prdSystemRoleDAO;
    private final FileUtil fileUtil;
    private final UdcUtil udcUtil;
    private BeanSearcher beanSearcher;
    private final PrdOrgPersonDAO personDAO;
    private final PersonRewardPunishService personRewardPunishService;
    private final PrdOrgEmployeeDAO employeeDAO;
    private final UserVacationService userVacationService;
    private final PrdOrgEmployeeEqvaRatioService employeeEqvaRatioService;
    private final ResEntryExitLogService entryExitLogService;
    private final PrdOrgEmployeeService employeeService;
    private final CalEqvaIncomeService calEqvaIncomeService;
    private final UserRpcService userRpcService;
    @Value(value="${tw5.user_default.role_id}")
    private Long default_role_id;
    @Value(value="${tw5.user_default.external_role_id}")
    private Long external_role_id;
    @Autowired
    private SysUserRpcService sysUserRpcService;

    @Autowired
    public void setBeanSearcher(PermissionBeanSearcherFactory permissionBeanSearcherFactory) {
        this.beanSearcher = permissionBeanSearcherFactory.getBeanSearcherService(PermissionDomainEnum.PRD_ORG_RES);
    }

    public PagingVO<PrdOrgEmployeeVO> page(PrdOrgEmployeeQuery query) {
        PagingVO<PrdOrgEmployeeVO> evo = this.dao.queryPagingNew(query);
        List vos = evo.getRecords();
        for (PrdOrgEmployeeVO vo : vos) {
            vo.setResourceName(this.cacheUtil.transferSystemSelection(FunctionSelectionEnum.EmployeeResource.getCode(), vo.getResourceStatus()));
            vo.setHrName(this.cacheUtil.transferSystemSelection(FunctionSelectionEnum.EmployeeHr.getCode(), vo.getHrStatus()));
            vo.setSexName(this.cacheUtil.transferSystemSelection(FunctionSelectionEnum.EmployeeSex.getCode(), vo.getSex()));
            vo.setIdTypeName(this.cacheUtil.transferSystemSelection(FunctionSelectionEnum.EmployeeIdType.getCode(), vo.getIdType()));
            vo.setJobsName(this.cacheUtil.transferSystemSelection(FunctionSelectionEnum.EmployeeJobs.getCode(), vo.getJobs()));
            vo.setCompanyName(this.cacheUtil.getCompanyNameByBookId(vo.getBookId()));
        }
        return evo;
    }

    public PersonResVO queryById(Long id) {
        PrdOrgEmployeeVO vo = this.dao.queryByKey(id);
        vo.setRoleDatas(this.dao.queryUserRoles(vo.getUserId()));
        vo.setDataRefVOS(this.dao.queryOrgListByKey(vo.getUserId()));
        vo.setIdValidDatas(this.fileUtil.getFileDatas(vo.getIdValidCodes()));
        vo.setHeadDatas(this.fileUtil.getFileDatas(vo.getHeadCodes()));
        vo.setResumeDatas(this.fileUtil.getFileDatas(vo.getResumeCodes()));
        vo.setSelfIntroVideoDatas(this.fileUtil.getFileDatas(vo.getSelfIntroVideoCodes()));
        vo.setResourceName(this.cacheUtil.transferSystemSelection(FunctionSelectionEnum.EmployeeResource.getCode(), vo.getResourceStatus()));
        vo.setHrName(this.cacheUtil.transferSystemSelection(FunctionSelectionEnum.EmployeeHr.getCode(), vo.getHrStatus()));
        vo.setCompanyName(this.cacheUtil.getCompanyNameByBookId(vo.getBookId()));
        PersonResVO personResVO = new PersonResVO();
        vo = (PrdOrgEmployeeVO)this.udcUtil.translate(vo);
        if (Objects.equals(vo.getExtString6(), "INTERNAL_RES")) {
            vo.setExString9Name(this.cacheUtil.transferSystemSelection(FunctionSelectionEnum.EmployeeInternalType.getCode(), vo.getExtString9()));
        } else if (Objects.equals(vo.getExtString6(), "EXTERNAL_RES")) {
            vo.setExString9Name(this.cacheUtil.transferSystemSelection(FunctionSelectionEnum.EmployeeExternalType.getCode(), vo.getExtString9()));
        }
        vo.setEqvaRatio(this.employeeEqvaRatioService.getEqvaRatio(vo.getUserId(), LocalDate.now()));
        personResVO.setPrdOrgEmployeeVO(vo);
        Long personId = vo.getPersonId();
        List eduExperienceVOList = this.personEduExperienceService.findAllByPersonId(personId);
        personResVO.setEduExperienceVOList(eduExperienceVOList);
        List workExperienceVOList = this.personWorkExperienceService.findAllByPersonId(personId);
        personResVO.setWorkExperienceVOList(workExperienceVOList);
        List projectExperienceVOList = this.personProjectExperienceService.findAllByPersonId(personId);
        personResVO.setProjectExperienceVOList(projectExperienceVOList);
        List certVOList = this.personCertService.findAllByPersonId(personId);
        personResVO.setCertVOList(certVOList);
        List accountVOList = this.personAccountService.findAllByPersonId(personId);
        personResVO.setPersonAccountVOList(accountVOList);
        ResEvaluateVO resEvaluateVO = this.resEvaluateService.getResEvaluateScore(vo.getUserId());
        personResVO.setResEvaluateVO(resEvaluateVO);
        List rewardPunishVOList = this.personRewardPunishService.findAllByPersonId(personId);
        personResVO.setRewardPunishVOList(rewardPunishVOList);
        TaskInfoQuery taskInfoQuery = new TaskInfoQuery();
        taskInfoQuery.setTaskResId(vo.getUserId());
        List taskInfoVOList = this.taskInfoService.queryList(taskInfoQuery);
        personResVO.setTaskInfoVOList(taskInfoVOList);
        return personResVO;
    }

    public void update(PersonResVO personResVO) {
        PrdOrgEmployeeVO prdOrgEmployeeVO = personResVO.getPrdOrgEmployeeVO();
        PrdOrgEmployeeVO eDo = this.dao.queryByKey(prdOrgEmployeeVO.getId());
        PrdOrgEmployeePayload payload = PrdOrgEmployeeConvert.INSTANCE.toPayload(prdOrgEmployeeVO);
        SysUserUpdateParam param = new SysUserUpdateParam();
        Long personId = eDo.getPersonId();
        param.setEmail(payload.getEmail());
        param.setEnabled(payload.getEnabled());
        param.setId(eDo.getUserId());
        param.setLastName(payload.getLastName());
        param.setFirstName(payload.getEmployeeName());
        param.setMobile(payload.getMobile());
        this.sysUserRpcService.update(param);
        if (!eDo.getEmployeeName().equals(eDo.getEmployeeName())) {
            this.dao.update(payload);
        }
        if (payload.getRoleIds() != null) {
            if (payload.getRoleIds().size() == 0) {
                this.dao.deleteRolesByUserId(eDo.getUserId());
            } else {
                ArrayList<PrdSystemUserRoleDO> userRoleDOS = new ArrayList<PrdSystemUserRoleDO>();
                for (Long roleId : payload.getRoleIds()) {
                    PrdSystemUserRoleDO roleDO = new PrdSystemUserRoleDO();
                    roleDO.setRoleId(roleId);
                    roleDO.setUserId(eDo.getUserId());
                    userRoleDOS.add(roleDO);
                }
                this.dao.deleteRolesByUserId(eDo.getUserId());
                this.dao.saveUserRoleAll(userRoleDOS);
            }
        }
        payload.setPersonId(personId);
        this.dao.updatePerson(payload);
        this.personEduExperienceService.saveAll(personResVO.getEduExperienceVOList(), personId);
        this.personProjectExperienceService.saveAll(personResVO.getProjectExperienceVOList(), personId);
        this.personCertService.saveAll(personResVO.getCertVOList(), personId);
        this.personWorkExperienceService.saveAll(personResVO.getWorkExperienceVOList(), personId);
    }

    public PersonResVO queryByUserId(Long userId) {
        PrdOrgEmployeeVO prdOrgEmployeeVO = this.cacheUtil.getEmployee(userId);
        return this.queryById(prdOrgEmployeeVO.getId());
    }

    @Transactional
    public Long personInfoChangeSubmit(PersonResPayload payload) {
        this.submitChangeProc(payload);
        return 0L;
    }

    @Transactional
    public void updateChange(PersonResPayload payload) {
        Long employeeId = payload.getPrdOrgEmployeePayload().getId();
        PersonResVO oldVo = this.queryById(employeeId);
        oldVo.setId(employeeId);
        payload.setId(employeeId);
        PersonResVO resVO = PersonResConvert.INSTANCE.payloadToVo(payload);
        resVO.setPrdOrgEmployeeVO(PrdOrgEmployeeConvert.INSTANCE.toVo(payload.getPrdOrgEmployeePayload()));
        this.changeService.updateVersionLog((Object)resVO, (Object)oldVo, ChangeTypeEnum.PERSONAL_INFO.getCode(), employeeId.toString());
    }

    private void submitChangeProc(PersonResPayload payload) {
        ProcessInfo processInfo = new ProcessInfo();
        String status = WorkFlowStatusEnum.APPROVED_WORK.getCode();
        HashMap<String, Serializable> variables = new HashMap<String, Serializable>();
        List<Long> empManageIds = this.prdSystemRoleDAO.queryUserIdByRoleCodes(List.of(RoleEnum.PLAT_ERM.getCode(), RoleEnum.PLAT_ERS.getCode()));
        variables.put("Activity_0mpxlyy", CollUtil.newArrayList(empManageIds));
        variables.put("Activity_12f105m", Integer.valueOf(0));
        Long employeeId = payload.getPrdOrgEmployeePayload().getId();
        String extString6 = payload.getPrdOrgEmployeePayload().getExtString6();
        if (Objects.equals(extString6, "EXTERNAL_RES")) {
            variables.put("externalRes", Boolean.valueOf(true));
            List<Long> platSalaryManager = this.prdSystemRoleDAO.queryUserIdByRoleCodes(List.of(RoleEnum.PLAT_SALARY_MANAGER.getCode()));
            variables.put("Activity_12f105m", CollUtil.newArrayList(platSalaryManager));
        } else {
            variables.put("externalRes", Boolean.valueOf(false));
        }
        processInfo = this.workflowUtil.startProcess(StartProcessPayload.of((String)ProcDefKey.PERSONAL_INFO_CHANGE.name(), (String)(payload.getPrdOrgEmployeePayload().getEmployeeName() + "-\u4e2a\u4eba\u4fe1\u606f\u53d8\u66f4\u6d41\u7a0b"), (String)("" + employeeId), variables), new Long[0]);
        PrdOrgEmployeePayload employeePayload = new PrdOrgEmployeePayload();
        employeePayload.setProcInstId(processInfo.getProcInstId());
        employeePayload.setId(employeeId);
        employeePayload.setProcInstStatus(processInfo.getProcInstStatus());
        employeePayload.setSubmitTime(LocalDateTime.now());
        PersonResVO oldVo = this.queryById(employeeId);
        oldVo.setId(employeeId);
        payload.setId(employeeId);
        PersonResVO resVO = PersonResConvert.INSTANCE.payloadToVo(payload);
        PrdOrgEmployeePayload prdOrgEmployeePayload = payload.getPrdOrgEmployeePayload();
        prdOrgEmployeePayload.setProcInstId(processInfo.getProcInstId());
        resVO.setPrdOrgEmployeeVO(PrdOrgEmployeeConvert.INSTANCE.toVo(prdOrgEmployeePayload));
        PrdSystemBusinessChangePayload changePayload = new PrdSystemBusinessChangePayload();
        changePayload.setChangeType(ChangeTypeEnum.PERSONAL_INFO.getCode());
        changePayload.setChangeDocId(employeeId.toString());
        changePayload.setVersionContent(JSON.toJSONString((Object)resVO));
        changePayload.setChangeContent(JSON.toJSONString((Object)oldVo));
        changePayload.setVersionStatus(Integer.valueOf(1));
        changePayload.setProcInstId(processInfo.getProcInstId());
        this.changeService.save(changePayload);
        this.transactionUtilService.executeWithRunnable(() -> this.dao.updateProcessDate(employeePayload));
    }

    public PersonResChangeVO personalChangeInfo(Long employeeId, String procId) {
        PrdSystemBusinessChangeVO prdSystemBusinessChangeVO = this.changeService.getChangeLog(ChangeTypeEnum.PERSONAL_INFO.getCode(), employeeId.toString(), procId);
        if (!ObjectUtils.isEmpty((Object)prdSystemBusinessChangeVO)) {
            PersonResChangeVO resChangeVO = new PersonResChangeVO();
            PersonResVO newResVo = (PersonResVO)JSON.parseObject((String)prdSystemBusinessChangeVO.getVersionContent(), PersonResVO.class);
            if (!ObjectUtils.isEmpty((Object)prdSystemBusinessChangeVO.getChangeContent())) {
                PersonResVO oldResVO = (PersonResVO)JSON.parseObject((String)prdSystemBusinessChangeVO.getChangeContent(), PersonResVO.class);
                resChangeVO.setOldResVO(oldResVO);
            }
            resChangeVO.setNewResVO(newResVo);
            return resChangeVO;
        }
        return null;
    }

    public Long getJobInternalRecommUserId(Long userId) {
        return this.dao.getJobInternalRecommUserId(userId);
    }

    public PagingVO<PrdOrgEmployeeBSVO> permissionPaging(PrdOrgResQuery query) {
        MapBuilder mapBuilder = this.pageWhereBuilder(query);
        Number totalNum = this.beanSearcher.searchCount(PrdOrgEmployeeBSVO.class, mapBuilder.build());
        if (totalNum.equals(0)) {
            return null;
        }
        List employeeVOList = this.beanSearcher.searchList(PrdOrgEmployeeBSVO.class, mapBuilder.build());
        for (PrdOrgEmployeeBSVO vo : employeeVOList) {
            vo.setResourceName(this.cacheUtil.transferSystemSelection(FunctionSelectionEnum.EmployeeResource.getCode(), vo.getResourceStatus()));
            if (Objects.equals(vo.getExtString6(), "INTERNAL_RES")) {
                vo.setExtString9Name(this.cacheUtil.transferSystemSelection(FunctionSelectionEnum.EmployeeInternalType.getCode(), vo.getExtString9()));
                continue;
            }
            if (!Objects.equals(vo.getExtString6(), "EXTERNAL_RES")) continue;
            vo.setExtString9Name(this.cacheUtil.transferSystemSelection(FunctionSelectionEnum.EmployeeExternalType.getCode(), vo.getExtString9()));
        }
        return PagingVO.builder().records(employeeVOList).total(((Long)totalNum).longValue()).build();
    }

    public List<Long> getJobingUserList(PrdOrgEmployeeQuery prdOrgEmployeeQuery) {
        prdOrgEmployeeQuery.setResourceStatusIn(Arrays.asList("3", "4", "5"));
        List<Long> res = this.dao.getJobingUserList(prdOrgEmployeeQuery);
        return res;
    }

    private MapBuilder pageWhereBuilder(PrdOrgResQuery query) {
        MapBuilder builder = MapUtils.builder();
        if (!ObjectUtils.isEmpty((Object)query.getResNo())) {
            ((MapBuilder)builder.field(PrdOrgEmployeeBSVO::getResNo, new Object[]{query.getResNo()})).op((FieldOp)FieldOps.Equal);
        }
        if (!ObjectUtils.isEmpty((Object)query.getPersonName())) {
            ((MapBuilder)builder.field(PrdOrgEmployeeBSVO::getPersonName, new Object[]{query.getPersonName()})).op((FieldOp)FieldOps.Contain);
        }
        if (!ObjectUtils.isEmpty((Object)query.getExtString6())) {
            ((MapBuilder)builder.field(PrdOrgEmployeeBSVO::getExtString6, new Object[]{query.getExtString6()})).op((FieldOp)FieldOps.Equal);
        }
        if (!ObjectUtils.isEmpty((Object)query.getExtString9())) {
            ((MapBuilder)builder.field(PrdOrgEmployeeBSVO::getExtString9, new Object[]{query.getExtString9()})).op((FieldOp)FieldOps.Equal);
        }
        if (!ObjectUtils.isEmpty((Object)query.getProcInstStatus())) {
            ((MapBuilder)builder.field(PrdOrgEmployeeBSVO::getProcInstStatus, new Object[]{query.getProcInstStatus()})).op((FieldOp)FieldOps.Equal);
        }
        if (!ObjectUtils.isEmpty((Object)query.getOrgId())) {
            ((MapBuilder)builder.field(PrdOrgEmployeeBSVO::getOrgId, new Object[]{query.getOrgId()})).op((FieldOp)FieldOps.Equal);
        }
        if (!ObjectUtils.isEmpty((Object)query.getExtString5())) {
            ((MapBuilder)builder.field(PrdOrgEmployeeBSVO::getExtString5, new Object[]{query.getExtString5()})).op((FieldOp)FieldOps.Equal);
        }
        if (!ObjectUtils.isEmpty((Object)query.getParentId())) {
            ((MapBuilder)builder.field(PrdOrgEmployeeBSVO::getParentId, new Object[]{query.getParentId()})).op((FieldOp)FieldOps.Equal);
        }
        if (!ObjectUtils.isEmpty((Object)query.getResManagerId())) {
            ((MapBuilder)builder.field(PrdOrgEmployeeBSVO::getResManagerId, new Object[]{query.getResManagerId()})).op((FieldOp)FieldOps.Equal);
        }
        if (!ObjectUtils.isEmpty((Object)query.getEnrollDateStart()) && !ObjectUtils.isEmpty((Object)query.getEnrollDateEnd())) {
            ((MapBuilder)builder.field(PrdOrgEmployeeBSVO::getEnrollDate, new FieldFns.FieldFn[0])).sql(" $1 > ? and $1 < ?", new Object[]{query.getEnrollDateStart(), query.getEnrollDateEnd()});
        }
        if (!ObjectUtils.isEmpty((Object)query.getExtDate4Start()) && !ObjectUtils.isEmpty((Object)query.getExtDate4End())) {
            ((MapBuilder)builder.field(PrdOrgEmployeeBSVO::getExtDate4, new FieldFns.FieldFn[0])).sql(" $1 > ? and $1 < ?", new Object[]{query.getExtDate4Start(), query.getExtDate4End()});
        }
        if (!ObjectUtils.isEmpty((Object)query.getExtString1())) {
            ((MapBuilder)builder.field(PrdOrgEmployeeBSVO::getExtString1, new Object[]{query.getExtString1()})).op((FieldOp)FieldOps.Equal);
        }
        if (!ObjectUtils.isEmpty((Object)query.getExtString2())) {
            ((MapBuilder)builder.field(PrdOrgEmployeeBSVO::getExtString2, new Object[]{query.getExtString2()})).op((FieldOp)FieldOps.Equal);
        }
        if (!ObjectUtils.isEmpty((Object)query.getExtString3())) {
            ((MapBuilder)builder.field(PrdOrgEmployeeBSVO::getExtString3, new Object[]{query.getExtString3()})).op((FieldOp)FieldOps.Equal);
        }
        if (!ObjectUtils.isEmpty((Object)query.getExtString4())) {
            ((MapBuilder)builder.field(PrdOrgEmployeeBSVO::getExtString4, new Object[]{query.getExtString4()})).op((FieldOp)FieldOps.Equal);
        }
        if (!ObjectUtils.isEmpty((Object)query.getRemark())) {
            ((MapBuilder)builder.field(PrdOrgEmployeeBSVO::getRemark, new Object[]{query.getRemark()})).op((FieldOp)FieldOps.Contain);
        }
        if (!ObjectUtils.isEmpty((Object)query.getResourceStatus())) {
            ((MapBuilder)builder.field(PrdOrgEmployeeBSVO::getResourceStatus, new Object[]{query.getResourceStatus()})).op((FieldOp)FieldOps.Equal);
        }
        ((MapBuilder)builder.field(BaseViewModel::getDeleteFlag, new Object[]{0})).op((FieldOp)FieldOps.Equal);
        SqlUtil.handleBS(builder, (TwQueryParam)query);
        return builder;
    }

    @Transactional
    public void updateEmployee(PrdOrgEmployeePayload payload) {
        UserCreateDTO param = new UserCreateDTO();
        param.setEmail(payload.getEmail());
        param.setEnabled(payload.getEnabled());
        param.setId(payload.getUserId());
        param.setFullName(payload.getEmployeeName());
        param.setMobile(payload.getMobile());
        param.setUsername(payload.getUserName());
        this.userRpcService.upsert(param);
        PrdOrgPersonDO personSaveDO = this.personDAO.findByKey(payload.getPersonId());
        if (payload.getEmail() != null) {
            personSaveDO.setEmail(payload.getEmail());
        }
        if (payload.getMobile() != null) {
            personSaveDO.setMobile(payload.getMobile());
        }
        if (payload.getUserName() != null) {
            personSaveDO.setUserName(payload.getUserName());
        }
        if (payload.getEnabled() != null) {
            personSaveDO.setEnabled(payload.getEnabled());
        }
        this.dao.savePerson(personSaveDO);
        this.dao.update(payload);
        this.dao.deleteRolesByUserId(payload.getUserId());
        PrdOrgEmployeeRefDO refDo = new PrdOrgEmployeeRefDO();
        this.dao.deleteRefSoft(Collections.singletonList(payload.getUserId()));
        refDo.setJoinDate(LocalDate.now());
        refDo.setOrgId(payload.getOrgId());
        refDo.setUserId(payload.getUserId());
        refDo.setParentId(payload.getParentId());
        refDo.setIsDefault(0);
        PrdSystemUserRoleDO roleDO = new PrdSystemUserRoleDO();
        if (Objects.equals(payload.getExtString6(), "EXTERNAL_RES")) {
            roleDO.setRoleId(this.external_role_id);
        }
        roleDO.setUserId(payload.getUserId());
        this.dao.saveUserRole(roleDO);
        this.dao.saveRef(refDo);
    }

    @Transactional
    public void depart(Long id, LocalDate date) {
        PrdOrgEmployeeVO prdOrgEmployeeVO = this.employeeDAO.queryByKey(id);
        if (StringUtils.hasText((String)prdOrgEmployeeVO.getResourceStatus()) && SystemDefaultEnum.LeaveIngResourceStatus.getCode().equals(prdOrgEmployeeVO.getResourceStatus())) {
            throw TwException.error("", "\u5f53\u524d\u5458\u5de5\u5df2\u5904\u4e8e\u79bb\u804c\u4e2d\uff0c\u8bf7\u524d\u5f80\u5904\u7406\u79bb\u804c\u7533\u8bf7\u5217\u8868\u5904\u7406\u79bb\u804c\u6d41\u7a0b");
        }
        this.employeeDAO.updateResStatus(id, SystemDefaultEnum.LeavedResourceStatus.getCode());
        SysUserBatchSwitchParam sysUserBatchSwitchParam = new SysUserBatchSwitchParam();
        ArrayList<Long> userIds = new ArrayList<Long>();
        userIds.add(prdOrgEmployeeVO.getUserId());
        sysUserBatchSwitchParam.setEnable(false);
        sysUserBatchSwitchParam.setUserIds(userIds);
        this.sysUserRpcService.batchSwitchUserStatus(sysUserBatchSwitchParam);
        this.userVacationService.deleteAllByUserId(prdOrgEmployeeVO.getUserId());
        this.employeeDAO.updateExitDate(id, date);
        ResEntryExitLogPayload resEntryExitLogPayload = new ResEntryExitLogPayload();
        resEntryExitLogPayload.setEntryExitDate(date.toString());
        resEntryExitLogPayload.setEmployeeId(id);
        resEntryExitLogPayload.setReasonType1("LEAVE_BY_HR");
        resEntryExitLogPayload.setReasonType2("LEAVE");
        resEntryExitLogPayload.setResType(prdOrgEmployeeVO.getExtString6());
        resEntryExitLogPayload.setBookId(prdOrgEmployeeVO.getBookId());
        resEntryExitLogPayload.setOrgId(prdOrgEmployeeVO.getOrgId());
        resEntryExitLogPayload.setBaseCity(prdOrgEmployeeVO.getExtString5());
        resEntryExitLogPayload.setCoopType(prdOrgEmployeeVO.getCooperationMode());
        resEntryExitLogPayload.setJob(prdOrgEmployeeVO.getJobs());
        this.entryExitLogService.save(resEntryExitLogPayload);
        this.employeeService.deleteOrgRefSoftAll(prdOrgEmployeeVO.getUserId(), date);
        if ("EXTERNAL_RES".equals(prdOrgEmployeeVO.getExtString6())) {
            CalEqvaIncomePayload payload = new CalEqvaIncomePayload();
            payload.setLineStatus("0");
            payload.setEndDate(date);
            payload.setResId(prdOrgEmployeeVO.getUserId());
            this.calEqvaIncomeService.saveExterEqvaIncome(payload);
        }
    }

    public PersonResServiceImpl(PrdOrgEmployeeDAO dao, CacheUtil cacheUtil, PersonEduExperienceService personEduExperienceService, PersonWorkExperienceService personWorkExperienceService, PersonProjectExperienceService personProjectExperienceService, PersonAccountService personAccountService, PersonCertService personCertService, ResEvaluateService resEvaluateService, TaskInfoService taskInfoService, WorkflowUtil workflowUtil, PrdSystemBusinessChangeService changeService, PrdSystemBusinessChangeDAO changeDAO, TransactionUtilService transactionUtilService, PrdSystemRoleDAO prdSystemRoleDAO, FileUtil fileUtil, UdcUtil udcUtil, PrdOrgPersonDAO personDAO, PersonRewardPunishService personRewardPunishService, PrdOrgEmployeeDAO employeeDAO, UserVacationService userVacationService, PrdOrgEmployeeEqvaRatioService employeeEqvaRatioService, ResEntryExitLogService entryExitLogService, PrdOrgEmployeeService employeeService, CalEqvaIncomeService calEqvaIncomeService, UserRpcService userRpcService) {
        this.dao = dao;
        this.cacheUtil = cacheUtil;
        this.personEduExperienceService = personEduExperienceService;
        this.personWorkExperienceService = personWorkExperienceService;
        this.personProjectExperienceService = personProjectExperienceService;
        this.personAccountService = personAccountService;
        this.personCertService = personCertService;
        this.resEvaluateService = resEvaluateService;
        this.taskInfoService = taskInfoService;
        this.workflowUtil = workflowUtil;
        this.changeService = changeService;
        this.changeDAO = changeDAO;
        this.transactionUtilService = transactionUtilService;
        this.prdSystemRoleDAO = prdSystemRoleDAO;
        this.fileUtil = fileUtil;
        this.udcUtil = udcUtil;
        this.personDAO = personDAO;
        this.personRewardPunishService = personRewardPunishService;
        this.employeeDAO = employeeDAO;
        this.userVacationService = userVacationService;
        this.employeeEqvaRatioService = employeeEqvaRatioService;
        this.entryExitLogService = entryExitLogService;
        this.employeeService = employeeService;
        this.calEqvaIncomeService = calEqvaIncomeService;
        this.userRpcService = userRpcService;
    }
}

