/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5.server.prd.my.controller;

import com.alibaba.excel.EasyExcel;
import com.alibaba.excel.write.builder.ExcelWriterBuilder;
import com.alibaba.excel.write.builder.ExcelWriterSheetBuilder;
import com.alibaba.excel.write.handler.WriteHandler;
import com.alibaba.excel.write.style.column.LongestMatchColumnWidthStyleStrategy;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.common.base.param.OrderItem;
import com.elitesland.tw.tw5.api.prd.crm.payload.CrmCustomerOperationExcelExport;
import com.elitesland.tw.tw5.api.prd.crm.vo.CrmCustomerOperationVO;
import com.elitesland.tw.tw5.api.prd.my.payload.TimesheetListPayload;
import com.elitesland.tw.tw5.api.prd.my.payload.TimesheetPayload;
import com.elitesland.tw.tw5.api.prd.my.query.MonthlyTimesheetQuery;
import com.elitesland.tw.tw5.api.prd.my.query.TimesheetQuery;
import com.elitesland.tw.tw5.api.prd.my.service.PmsTimesheetService;
import com.elitesland.tw.tw5.api.prd.my.vo.PmsTimesheetExcel;
import com.elitesland.tw.tw5.api.prd.my.vo.TimesheetSubsidySelectTypeVO;
import com.elitesland.tw.tw5.api.prd.my.vo.TimesheetVO;
import com.elitesland.tw.tw5.api.prd.pms.service.PmsProjectService;
import com.elitesland.tw.tw5.api.prd.pms.vo.PmsProjectVO;
import com.elitesland.tw.tw5.api.prd.pms.vo.PmsTimesheetProjectVO;
import com.elitesland.tw.tw5.server.common.TwException;
import com.elitesland.tw.tw5.server.common.TwOutputUtil;
import com.elitesland.tw.tw5.server.common.excel.ExcelUtil;
import com.elitesland.tw.tw5.server.common.permission.annotation.FunctionDetail;
import com.elitesland.tw.tw5.server.common.permission.annotation.PermissionDomain;
import com.elitesland.tw.tw5.server.common.permission.annotation.PermissionFunction;
import com.elitesland.tw.tw5.server.common.permission.enums.FunctionCodeEnum;
import com.elitesland.tw.tw5.server.common.permission.enums.FunctionTypeEnum;
import com.elitesland.tw.tw5.server.common.permission.enums.PermissionDomainEnum;
import com.elitesland.tw.tw5.server.common.permission.enums.PermissionTypeEnum;
import com.elitesland.tw.tw5.server.prd.common.GlobalUtil;
import com.elitesland.tw.tw5.server.prd.common.functionEnum.RoleEnum;
import com.elitesland.tw.tw5.server.prd.my.convert.TimesheetConvert;
import com.elitesland.tw.tw5.server.prd.system.dao.PrdSystemRoleDAO;
import com.elitesland.tw.tw5.server.udc.UdcNameClass;
import com.elitesland.tw.tw5.server.udc.UdcUtil;
import io.swagger.annotations.ApiOperation;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URLEncoder;
import java.time.LocalDate;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/pms/my/timesheet"})
@PermissionDomain(domain=PermissionDomainEnum.PMS_TIME_SHEET)
public class PmsTimesheetController {
    private static final Logger log = LoggerFactory.getLogger(PmsTimesheetController.class);
    private final PmsTimesheetService pmsTimesheetService;
    private final PrdSystemRoleDAO systemRoleDAO;
    private final UdcUtil udcUtil;
    private final PmsProjectService pmsProjectService;

    @GetMapping(value={"/listProject"})
    @UdcNameClass
    @ApiOperation(value="\u6839\u636e\u9879\u76ee\u6210\u5458\u67e5\u8be2\u6240\u6709\u9879\u76ee")
    public TwOutputUtil<List<PmsTimesheetProjectVO>> listProject(Long userId, Boolean selectAll) {
        return TwOutputUtil.ok(this.pmsTimesheetService.listProject(userId, selectAll));
    }

    @GetMapping(value={"/listAllProject"})
    @UdcNameClass
    @ApiOperation(value="\u6240\u6709\u9879\u76ee\u5217\u8868\uff08\u9879\u76ee\u3001\u5546\u673a\u3001BU\u9879\u76ee\uff09")
    public TwOutputUtil<List<PmsTimesheetProjectVO>> listAllProject() {
        return TwOutputUtil.ok(this.pmsTimesheetService.listAllProject());
    }

    @PostMapping(value={"/batchInsert"})
    public TwOutputUtil batchInsert(@RequestBody TimesheetListPayload payload) {
        return TwOutputUtil.ok(this.pmsTimesheetService.batchInsert(payload));
    }

    @PutMapping
    public TwOutputUtil update(@RequestBody TimesheetPayload payload) {
        return TwOutputUtil.ok(this.pmsTimesheetService.update(payload));
    }

    @GetMapping(value={"/{key}"})
    @UdcNameClass
    public TwOutputUtil queryOneByKey(@PathVariable Long key) {
        return TwOutputUtil.ok(this.pmsTimesheetService.queryByKey(key));
    }

    @PostMapping(value={"/paging"})
    @UdcNameClass
    @PermissionFunction(functions={@FunctionDetail(functionCode=FunctionCodeEnum.TIME_SHEET_PAGE, type=FunctionTypeEnum.TAB)}, fieldPermission=true, permissionType=PermissionTypeEnum.DATA_PERMISSION)
    public TwOutputUtil<PagingVO<TimesheetVO>> paging(@RequestBody TimesheetQuery query) {
        PagingVO paging1 = this.pmsTimesheetService.pagingPermission(query);
        return TwOutputUtil.ok(paging1);
    }

    @GetMapping(value={"/list"})
    @UdcNameClass
    public TwOutputUtil<List<TimesheetVO>> queryList(TimesheetQuery query) {
        Long loginUserId = GlobalUtil.getLoginUserId();
        query.setTsUserId(loginUserId);
        return TwOutputUtil.ok(this.pmsTimesheetService.queryList(query));
    }

    @GetMapping(value={"/accReimTimesheetOverview"})
    @UdcNameClass
    public TwOutputUtil accReimTimesheetOverview(TimesheetQuery query) {
        return TwOutputUtil.ok(this.pmsTimesheetService.getAccReimTimesheetOverview(query));
    }

    @PatchMapping(value={"/updateApproving/{apprUserId}"})
    public TwOutputUtil updateApprovingUser(@RequestBody List<Long> keys, @PathVariable Long apprUserId) {
        this.pmsTimesheetService.updateApprovingUser(keys, apprUserId);
        return TwOutputUtil.ok();
    }

    @GetMapping(value={"/getTimesheetOverview"})
    @UdcNameClass
    public TwOutputUtil getTimesheetOverview(TimesheetQuery query) {
        return TwOutputUtil.ok(this.pmsTimesheetService.getTimesheetOverview(query));
    }

    @GetMapping(value={"/getTimesheetRemind"})
    @UdcNameClass
    public TwOutputUtil getTimesheetRemind(TimesheetQuery query) {
        return TwOutputUtil.ok(this.pmsTimesheetService.getTimesheetRemind(query));
    }

    @GetMapping(value={"/approving/count"})
    public TwOutputUtil approvingCount(TimesheetQuery query) {
        query.setApprUserId(GlobalUtil.getLoginUserId());
        long total = this.pmsTimesheetService.count(query);
        return TwOutputUtil.ok(total);
    }

    @GetMapping(value={"/approving/paging"})
    @UdcNameClass
    public TwOutputUtil approvingPaging(TimesheetQuery query) {
        query.setTimesheetIdV4IsNull(Boolean.valueOf(true));
        this.permissionOpertion(query);
        OrderItem orderItem = OrderItem.desc((String)"workDate");
        query.setOrders(Arrays.asList(orderItem));
        return TwOutputUtil.ok(this.pmsTimesheetService.paging(query));
    }

    void permissionOpertion(TimesheetQuery query) {
        List<Long> userIdsByRole;
        Long loginUserId = GlobalUtil.getLoginUserId();
        boolean isSystemAdmin = GlobalUtil.getLoginGeneralUser().isSystemAdmin();
        if (!(isSystemAdmin || !CollectionUtils.isEmpty(userIdsByRole = this.systemRoleDAO.queryUserIdByRoleCodes(Arrays.asList(RoleEnum.SYS.getCode()))) && userIdsByRole.contains(loginUserId))) {
            PmsProjectVO pmsProjectVO;
            query.setApprUserId(loginUserId);
            if (query.getProjId() != null && (pmsProjectVO = this.pmsProjectService.queryByKeySimple(query.getProjId())) != null && pmsProjectVO.getPmResId().equals(loginUserId)) {
                query.setApprUserId(null);
            }
        }
    }

    @GetMapping(value={"/approving/pagingGroup"})
    @UdcNameClass
    public TwOutputUtil approvingPagingGroup(TimesheetQuery query) {
        query.setTimesheetIdV4IsNull(Boolean.valueOf(true));
        this.permissionOpertion(query);
        return TwOutputUtil.ok(this.pmsTimesheetService.pagingGroup(query));
    }

    @GetMapping(value={"/approving/exportList"})
    public void exportList(TimesheetQuery query, HttpServletResponse response) throws IOException {
        String sheetName = "\u5de5\u4f5c\u65e5\u5fd7\u5ba1\u6279";
        OrderItem orderItem = OrderItem.asc((String)"createTime");
        query.defaultOrder(orderItem);
        this.approvingDataFilterQuery(query);
        List list = this.pmsTimesheetService.queryList(query);
        if (list.size() > 50000) {
            throw TwException.error("500", "\u5bfc\u51fa\u6570\u636e\u8fc7\u5927\uff0c\u8bf7\u5206\u6279\u64cd\u4f5c\uff0c\u76ee\u524d\u5bfc\u51fa\u6570\u91cf\uff1a" + list.size());
        }
        List excelList = TimesheetConvert.INSTANCE.voPmsListVoExcelExport(list);
        excelList = this.udcUtil.translateList(excelList);
        String fileName = URLEncoder.encode(sheetName + System.currentTimeMillis() + ".xlsx", "UTF-8");
        response.setContentType("application/vnd.openxmlformats-officedocument.spreadsheetml.sheet");
        response.setCharacterEncoding("utf-8");
        response.addHeader("Content-Disposition", "attachment;filename=" + fileName);
        ExcelWriterSheetBuilder sheet = ((ExcelWriterBuilder)EasyExcel.write((OutputStream)response.getOutputStream(), PmsTimesheetExcel.class).registerWriteHandler((WriteHandler)new LongestMatchColumnWidthStyleStrategy())).sheet(sheetName);
        ExcelUtil.excelHelper(sheet, PmsTimesheetExcel.class, null);
        sheet.doWrite(excelList);
    }

    @GetMapping(value={"/approving/exportListGroup"})
    public void exportListGroup(TimesheetQuery query, HttpServletResponse response) throws IOException {
        String sheetName = "\u5de5\u4f5c\u65e5\u5fd7\u5ba1\u6279";
        OrderItem orderItem = OrderItem.asc((String)"createTime");
        query.defaultOrder(orderItem);
        this.approvingDataFilterQuery(query);
        List list = this.pmsTimesheetService.listGroup(query);
        List excelList = TimesheetConvert.INSTANCE.voPmsListVoExcelExport(list);
        excelList = this.udcUtil.translateList(excelList);
        String fileName = URLEncoder.encode(sheetName + System.currentTimeMillis() + ".xlsx", "UTF-8");
        response.setContentType("application/vnd.openxmlformats-officedocument.spreadsheetml.sheet");
        response.setCharacterEncoding("utf-8");
        response.addHeader("Content-Disposition", "attachment;filename=" + fileName);
        ExcelWriterSheetBuilder sheet = ((ExcelWriterBuilder)EasyExcel.write((OutputStream)response.getOutputStream(), CrmCustomerOperationVO.class).registerWriteHandler((WriteHandler)new LongestMatchColumnWidthStyleStrategy())).sheet(sheetName);
        ExcelUtil.excelHelper(sheet, CrmCustomerOperationExcelExport.class, null);
        sheet.doWrite(excelList);
    }

    @GetMapping(value={"/exportList"})
    @PermissionFunction(functions={@FunctionDetail(functionCode=FunctionCodeEnum.TIME_SHEET_PAGE, type=FunctionTypeEnum.TAB)}, fieldPermission=true, permissionType=PermissionTypeEnum.DATA_PERMISSION)
    public void exportMyList(TimesheetQuery query, HttpServletResponse response) throws IOException {
        String sheetName = "\u5de5\u4f5c\u65e5\u5fd7\u5217\u8868";
        query.set_functionCode("TIME_SHEET_PAGE");
        List list = this.pmsTimesheetService.listPermission(query);
        List excelList = list.stream().map(p -> {
            PmsTimesheetExcel v = new PmsTimesheetExcel();
            BeanUtils.copyProperties((Object)p, (Object)v);
            return v;
        }).collect(Collectors.toList());
        excelList = this.udcUtil.translateList(excelList);
        String fileName = URLEncoder.encode(sheetName + System.currentTimeMillis() + ".xlsx", "UTF-8");
        response.setContentType("application/vnd.openxmlformats-officedocument.spreadsheetml.sheet");
        response.setCharacterEncoding("utf-8");
        response.addHeader("Content-Disposition", "attachment;filename=" + fileName);
        ExcelWriterSheetBuilder sheet = ((ExcelWriterBuilder)EasyExcel.write((OutputStream)response.getOutputStream(), PmsTimesheetExcel.class).registerWriteHandler((WriteHandler)new LongestMatchColumnWidthStyleStrategy())).sheet(sheetName);
        ExcelUtil.excelHelper(sheet, PmsTimesheetExcel.class, null);
        sheet.doWrite(excelList);
    }

    private void approvingDataFilterQuery(TimesheetQuery query) {
        List<Long> userIdsByRole;
        Long loginUserId = GlobalUtil.getLoginUserId();
        boolean isSystemAdmin = GlobalUtil.getLoginGeneralUser().isSystemAdmin();
        if (!(isSystemAdmin || !CollectionUtils.isEmpty(userIdsByRole = this.systemRoleDAO.queryUserIdByRoleCodes(Arrays.asList(RoleEnum.SYS.getCode(), RoleEnum.TIME_SHEET_MANAGER.getCode()))) && userIdsByRole.contains(loginUserId))) {
            query.setApprUserId(loginUserId);
        }
    }

    @PostMapping(value={"/approving/revoked"})
    public TwOutputUtil revoked(Long[] keys) {
        this.pmsTimesheetService.revoked(Arrays.asList(keys));
        return TwOutputUtil.ok();
    }

    @PostMapping(value={"/approved/revoked"})
    public TwOutputUtil approvedRevoked(Long[] keys) {
        this.pmsTimesheetService.approvedRevoked(Arrays.asList(keys));
        return TwOutputUtil.ok();
    }

    @PostMapping(value={"/approving/approved"})
    public TwOutputUtil toApproved(Long[] keys) {
        this.pmsTimesheetService.toApproved(Arrays.asList(keys));
        return TwOutputUtil.ok();
    }

    @PostMapping(value={"/approving/rejected"})
    public TwOutputUtil rejected(Long[] keys, String apprResult) {
        this.pmsTimesheetService.rejected(Arrays.asList(keys), apprResult);
        return TwOutputUtil.ok();
    }

    @PostMapping(value={"/approving/approvedPro"})
    public TwOutputUtil approvedPro(Long[] keys) {
        this.pmsTimesheetService.toAdvanced(Arrays.asList(keys));
        return TwOutputUtil.ok();
    }

    @DeleteMapping(value={"/deleteSoft"})
    public TwOutputUtil deleteSoft(Long[] keys) {
        this.pmsTimesheetService.deleteSoft(Arrays.asList(keys));
        return TwOutputUtil.ok();
    }

    @GetMapping(value={"/timesheet/repair"})
    public TwOutputUtil repairTimesheet() {
        return TwOutputUtil.ok();
    }

    @GetMapping(value={"/monthly/paging"})
    @UdcNameClass
    public TwOutputUtil monthlyPaging(MonthlyTimesheetQuery query) {
        return TwOutputUtil.ok(this.pmsTimesheetService.monthlyPaging(query));
    }

    @GetMapping(value={"/monthly/export"})
    @UdcNameClass
    public void monthlyExport(MonthlyTimesheetQuery query, HttpServletResponse response) {
        this.pmsTimesheetService.monthlyExport(query, response);
    }

    @GetMapping(value={"/monthly/syncJDE"})
    @UdcNameClass
    public TwOutputUtil monthlySyncJDE(MonthlyTimesheetQuery query) {
        this.pmsTimesheetService.monthlySyncToJDE(query);
        return TwOutputUtil.ok();
    }

    @GetMapping(value={"/listWorkTypeExt4"})
    public TwOutputUtil<List<TimesheetSubsidySelectTypeVO>> listWorkTypeExt4(String workDate, String reasonType, Long reasonId, Long tsUserId) {
        LocalDate workDatePro = LocalDate.parse(workDate);
        return TwOutputUtil.ok(this.pmsTimesheetService.listWorkTypeExt4(workDatePro, reasonType, reasonId, tsUserId));
    }

    @GetMapping(value={"/listWorkHourSelect"})
    public TwOutputUtil<List<TimesheetSubsidySelectTypeVO>> listWorkHourSelect(String workDate, String reasonType, Long reasonId, Long tsUserId) {
        LocalDate workDatePro = LocalDate.parse(workDate);
        return TwOutputUtil.ok(this.pmsTimesheetService.listWorkHourSelect(workDatePro, reasonType, reasonId, tsUserId));
    }

    public PmsTimesheetController(PmsTimesheetService pmsTimesheetService, PrdSystemRoleDAO systemRoleDAO, UdcUtil udcUtil, PmsProjectService pmsProjectService) {
        this.pmsTimesheetService = pmsTimesheetService;
        this.systemRoleDAO = systemRoleDAO;
        this.udcUtil = udcUtil;
        this.pmsProjectService = pmsProjectService;
    }
}

