/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5.server.prd.partner.common.service;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.IdUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.extra.pinyin.PinyinUtil;
import cn.hutool.extra.spring.SpringUtil;
import com.alibaba.fastjson.JSONObject;
import com.elitescloud.boot.common.param.BaseViewModel;
import com.elitescloud.boot.core.base.BaseServiceImpl;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.common.TwCommonPayload;
import com.elitesland.tw.tw5.api.common.change.payload.ComChangePayload;
import com.elitesland.tw.tw5.api.common.change.service.ComChangeService;
import com.elitesland.tw.tw5.api.common.change.vo.ComChangeVO;
import com.elitesland.tw.tw5.api.prd.crm.query.CrmCustomerOperationQuery;
import com.elitesland.tw.tw5.api.prd.crm.service.CrmCustomerOperationService;
import com.elitesland.tw.tw5.api.prd.crm.vo.CrmActDynamicVO;
import com.elitesland.tw.tw5.api.prd.crm.vo.CrmCustomerOperationVO;
import com.elitesland.tw.tw5.api.prd.crm.vo.CrmFollowVO;
import com.elitesland.tw.tw5.api.prd.org.vo.PrdOrgEmployeeVO;
import com.elitesland.tw.tw5.api.prd.org.vo.PrdOrgRoleVO;
import com.elitesland.tw.tw5.api.prd.partner.business.service.CrmBusinessPartnerService;
import com.elitesland.tw.tw5.api.prd.partner.common.payload.AddressBookPayload;
import com.elitesland.tw.tw5.api.prd.partner.common.payload.BookAccountPayload;
import com.elitesland.tw.tw5.api.prd.partner.common.payload.BookAddressPayload;
import com.elitesland.tw.tw5.api.prd.partner.common.payload.BookInvoicePayload;
import com.elitesland.tw.tw5.api.prd.partner.common.payload.BusinessCutomerManagePayload;
import com.elitesland.tw.tw5.api.prd.partner.common.payload.BusinessParnerTaskInfoPayload;
import com.elitesland.tw.tw5.api.prd.partner.common.payload.BusinessPartnerChangePayload;
import com.elitesland.tw.tw5.api.prd.partner.common.payload.BusinessPartnerPayload;
import com.elitesland.tw.tw5.api.prd.partner.common.payload.CommonKeysPayload;
import com.elitesland.tw.tw5.api.prd.partner.common.payload.PrdAbPayload;
import com.elitesland.tw.tw5.api.prd.partner.common.query.BookAccountQuery;
import com.elitesland.tw.tw5.api.prd.partner.common.query.BookAddressQuery;
import com.elitesland.tw.tw5.api.prd.partner.common.query.BookContactsQuery;
import com.elitesland.tw.tw5.api.prd.partner.common.query.BookInvoiceQuery;
import com.elitesland.tw.tw5.api.prd.partner.common.query.BusinessPartnerQuery;
import com.elitesland.tw.tw5.api.prd.partner.common.service.AddressBookService;
import com.elitesland.tw.tw5.api.prd.partner.common.service.BookAccountService;
import com.elitesland.tw.tw5.api.prd.partner.common.service.BookAddressService;
import com.elitesland.tw.tw5.api.prd.partner.common.service.BookContactsService;
import com.elitesland.tw.tw5.api.prd.partner.common.service.BookInvoiceService;
import com.elitesland.tw.tw5.api.prd.partner.common.service.BusinessPartnerService;
import com.elitesland.tw.tw5.api.prd.partner.common.vo.AddressBookVO;
import com.elitesland.tw.tw5.api.prd.partner.common.vo.BookAccountVO;
import com.elitesland.tw.tw5.api.prd.partner.common.vo.BookAddressVO;
import com.elitesland.tw.tw5.api.prd.partner.common.vo.BookInvoiceVO;
import com.elitesland.tw.tw5.api.prd.partner.common.vo.BusinessConfirmedCustomerVO;
import com.elitesland.tw.tw5.api.prd.partner.common.vo.BusinessPartnerChangeVO;
import com.elitesland.tw.tw5.api.prd.partner.common.vo.BusinessPartnerIdentityVO;
import com.elitesland.tw.tw5.api.prd.partner.common.vo.BusinessPartnerInfoVO;
import com.elitesland.tw.tw5.api.prd.partner.common.vo.BusinessPartnerListInfoVO;
import com.elitesland.tw.tw5.api.prd.partner.common.vo.BusinessPartnerMainSyncVO;
import com.elitesland.tw.tw5.api.prd.partner.common.vo.BusinessPartnerSimpleVO;
import com.elitesland.tw.tw5.api.prd.partner.common.vo.BusinessPartnerTaskVO;
import com.elitesland.tw.tw5.api.prd.partner.common.vo.BusinessPartnerTreeVO;
import com.elitesland.tw.tw5.api.prd.partner.common.vo.BusinessPartnerVO;
import com.elitesland.tw.tw5.api.prd.partner.identity.payload.BusinessCollaboratePartnerInfoPayload;
import com.elitesland.tw.tw5.api.prd.partner.identity.payload.BusinessCustomerInfoPayload;
import com.elitesland.tw.tw5.api.prd.partner.identity.payload.BusinessSupplierInfoPayload;
import com.elitesland.tw.tw5.api.prd.partner.identity.service.BusinessCollaboratePartnerInfoService;
import com.elitesland.tw.tw5.api.prd.partner.identity.service.BusinessCustomerInfoService;
import com.elitesland.tw.tw5.api.prd.partner.identity.service.BusinessSupplierInfoService;
import com.elitesland.tw.tw5.api.prd.partner.identity.vo.BusinessCollaboratePartnerInfoVO;
import com.elitesland.tw.tw5.api.prd.partner.identity.vo.BusinessCustomerInfoVO;
import com.elitesland.tw.tw5.api.prd.partner.identity.vo.BusinessSupplierInfoVO;
import com.elitesland.tw.tw5.api.prd.partner.team.payload.BusinessTeamMemberPayload;
import com.elitesland.tw.tw5.api.prd.partner.team.query.BusinessTeamMemberQuery;
import com.elitesland.tw.tw5.api.prd.partner.team.service.BusinessTeamMemberService;
import com.elitesland.tw.tw5.api.prd.partner.team.vo.BusinessTeamMemberVO;
import com.elitesland.tw.tw5.api.prd.system.service.PrdSystemLogService;
import com.elitesland.tw.tw5.server.common.HttpUtil;
import com.elitesland.tw.tw5.server.common.TwException;
import com.elitesland.tw.tw5.server.common.change.changeEnum.ChangeTypeEnum;
import com.elitesland.tw.tw5.server.common.dao.TransferUtilDAO;
import com.elitesland.tw.tw5.server.common.service.TransactionUtilService;
import com.elitesland.tw.tw5.server.common.service.TransferUtilServiceImpl;
import com.elitesland.tw.tw5.server.common.util.ChangeFieldLogUtil;
import com.elitesland.tw.tw5.server.common.workFlow.ProcDefKey;
import com.elitesland.tw.tw5.server.prd.common.CacheUtil;
import com.elitesland.tw.tw5.server.prd.common.GlobalUtil;
import com.elitesland.tw.tw5.server.prd.common.WorkflowUtil;
import com.elitesland.tw.tw5.server.prd.common.functionEnum.BusinessOperStatusEnum;
import com.elitesland.tw.tw5.server.prd.common.functionEnum.CountryEnum;
import com.elitesland.tw.tw5.server.prd.common.functionEnum.CrmFollowObjectEnum;
import com.elitesland.tw.tw5.server.prd.common.functionEnum.CustomerScaleEnum;
import com.elitesland.tw.tw5.server.prd.common.functionEnum.PrdSystemObjectEnum;
import com.elitesland.tw.tw5.server.prd.common.functionEnum.RoleEnum;
import com.elitesland.tw.tw5.server.prd.common.functionEnum.WorkFlowRoleCodeEnum;
import com.elitesland.tw.tw5.server.prd.common.functionEnum.WorkFlowStatusEnum;
import com.elitesland.tw.tw5.server.prd.crm.dao.CrmActActivityDAO;
import com.elitesland.tw.tw5.server.prd.crm.dao.CrmFollowDAO;
import com.elitesland.tw.tw5.server.prd.crm.dao.CrmLeadsDAO;
import com.elitesland.tw.tw5.server.prd.crm.dao.CrmOpportunityDAO;
import com.elitesland.tw.tw5.server.prd.crm.entity.CrmFollowDO;
import com.elitesland.tw.tw5.server.prd.crm.service.CrmFollowServiceImpl;
import com.elitesland.tw.tw5.server.prd.org.dao.PrdOrgEmployeeDAO;
import com.elitesland.tw.tw5.server.prd.org.dao.PrdOrgOrganizationDAO;
import com.elitesland.tw.tw5.server.prd.partner.common.convert.BusinessPartnerConvert;
import com.elitesland.tw.tw5.server.prd.partner.common.dao.BusinessPartnerDAO;
import com.elitesland.tw.tw5.server.prd.partner.common.entity.BusinessPartnerDO;
import com.elitesland.tw.tw5.server.prd.partner.common.repo.BusinessPartnerRepo;
import com.elitesland.tw.tw5.server.prd.partner.constants.BookAddressTypeEnum;
import com.elitesland.tw.tw5.server.prd.partner.constants.BusinessInsideOrOutSideEnum;
import com.elitesland.tw.tw5.server.prd.partner.constants.BusinessPartnerIdentityEnum;
import com.elitesland.tw.tw5.server.prd.partner.constants.BusinessPartnerStageEnum;
import com.elitesland.tw.tw5.server.prd.partner.constants.BusinessPartnerStatusEnum;
import com.elitesland.tw.tw5.server.prd.partner.constants.BusinessPartnerTypeEnum;
import com.elitesland.tw.tw5.server.prd.partner.constants.BusinessTeamRoleEnum;
import com.elitesland.tw.tw5.server.prd.partner.constants.BusinessTeamTypeEnum;
import com.elitesland.tw.tw5.server.prd.partner.identity.entity.BusinessCollaboratePartnerInfoDO;
import com.elitesland.tw.tw5.server.prd.partner.identity.entity.BusinessCustomerInfoDO;
import com.elitesland.tw.tw5.server.prd.partner.identity.entity.BusinessSupplierInfoDO;
import com.elitesland.tw.tw5.server.prd.partner.identity.repo.BusinessCollaboratePartnerInfoRepo;
import com.elitesland.tw.tw5.server.prd.partner.identity.repo.BusinessCustomerInfoRepo;
import com.elitesland.tw.tw5.server.prd.partner.identity.repo.BusinessDistributorInfoRepo;
import com.elitesland.tw.tw5.server.prd.partner.identity.repo.BusinessSupplierInfoRepo;
import com.elitesland.tw.tw5.server.udc.UdcUtil;
import com.elitesland.workflow.ProcessInfo;
import com.elitesland.workflow.payload.StartProcessPayload;
import com.querydsl.core.Tuple;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

@Service
public class BusinessPartnerServiceImpl
extends BaseServiceImpl
implements BusinessPartnerService {
    private static final Logger log = LoggerFactory.getLogger(BusinessPartnerServiceImpl.class);
    private final BusinessPartnerRepo businessPartnerRepo;
    private final BusinessPartnerDAO businessPartnerDAO;
    private final AddressBookService addressBookService;
    private final BookAddressService bookAddressService;
    private final BookContactsService bookContactsService;
    private final BookAccountService bookAccountService;
    private final BookInvoiceService bookInvoiceService;
    private final ChangeFieldLogUtil changeFieldLogUtil;
    private final PrdSystemLogService logService;
    private final BusinessTeamMemberService businessTeamMemberService;
    private final BusinessCustomerInfoService businessCustomerInfoService;
    private final BusinessSupplierInfoService businessSupplierInfoService;
    private final BusinessCollaboratePartnerInfoService businessCollaboratePartnerInfoService;
    private final CacheUtil cacheUtil;
    private final BusinessCustomerInfoRepo businessCustomerInfoRepo;
    private final BusinessSupplierInfoRepo businessSupplierInfoRepo;
    private final BusinessCollaboratePartnerInfoRepo businessCollaboratePartnerInfoRepo;
    private final BusinessDistributorInfoRepo businessDistributorInfoRepo;
    private final UdcUtil udcUtil;
    @Value(value="${tw5.workflow.enabled}")
    private Boolean workflow_enabled;
    private final WorkflowUtil workflowUtil;
    private final PrdOrgOrganizationDAO daoOrg;
    private final PrdOrgEmployeeDAO employeeDAO;
    @Value(value="${tw5.workflow.orgId}")
    private Long workflow_orgId;
    private final TransactionUtilService transactionUtilService;
    private final ComChangeService changeService;
    @Value(value="${tw4.prd_ab.operation:api/openReport/v1/sync/asyncAbTask}")
    private String prd_ab_operation;
    private final HttpUtil httpUtil;
    private final TransferUtilServiceImpl transferUtilService;
    private final TransferUtilDAO transferUtilDAO;
    private final CrmLeadsDAO crmLeadsDAO;
    private final CrmOpportunityDAO crmOpportunityDAO;
    private final CrmFollowDAO crmFollowDAO;
    private final CrmFollowServiceImpl followService;
    private final CrmActActivityDAO actActivityDAO;

    public PagingVO<BusinessPartnerVO> queryPaging(BusinessPartnerQuery query) {
        this.dataPermission(query);
        PagingVO<BusinessPartnerVO> businessPartnerVOPagingVO = this.businessPartnerDAO.queryPaging(query);
        this.translateList(businessPartnerVOPagingVO.getRecords());
        return businessPartnerVOPagingVO;
    }

    public long count(BusinessPartnerQuery query) {
        this.dataPermission(query);
        return this.businessPartnerDAO.count(query);
    }

    public List<BusinessPartnerVO> queryListDynamic(BusinessPartnerQuery query) {
        this.dataPermission(query);
        List<BusinessPartnerVO> businessPartnerVOList = this.businessPartnerDAO.queryListDynamic(query);
        this.translateList(businessPartnerVOList);
        return businessPartnerVOList;
    }

    public void judgePartnerName(String partnerName) {
        Long total = this.businessPartnerDAO.judgePartnerName(partnerName);
        if (total > 0L) {
            throw TwException.error("", "\u4e1a\u52a1\u4f19\u4f34\u540d\u79f0\u5df2\u5b58\u5728\uff0c\u8bf7\u91cd\u65b0\u8f93\u5165");
        }
    }

    public List<BusinessPartnerVO> queryListByIds(List<Long> ids) {
        List<BusinessPartnerVO> vos = this.businessPartnerDAO.findByIds(ids);
        this.translateList(vos);
        return vos;
    }

    public BusinessPartnerIdentityVO judgeIdentityDisplay(Long partnerId) {
        BusinessPartnerIdentityVO.IdentityVO identityVO;
        BusinessPartnerDO entityDo = this.businessPartnerRepo.findById(partnerId).orElseGet(BusinessPartnerDO::new);
        Assert.notNull((Object)entityDo.getId(), (String)"\u4e0d\u5b58\u5728");
        BusinessPartnerIdentityVO businessPartnerIdentityVO = new BusinessPartnerIdentityVO();
        ArrayList<BusinessPartnerIdentityVO.IdentityVO> IdentityVOList = new ArrayList<BusinessPartnerIdentityVO.IdentityVO>();
        Long bookId = entityDo.getBookId();
        BookAccountQuery bookAccountQuery = new BookAccountQuery();
        bookAccountQuery.setBookId(bookId);
        businessPartnerIdentityVO.setAccountCount(this.bookAccountService.count(bookAccountQuery));
        BookAddressQuery bookAddressQuery = new BookAddressQuery();
        bookAddressQuery.setBookId(bookId);
        businessPartnerIdentityVO.setAddressCount(this.bookAddressService.count(bookAddressQuery));
        BookInvoiceQuery bookInvoiceQuery = new BookInvoiceQuery();
        bookInvoiceQuery.setBookId(bookId);
        businessPartnerIdentityVO.setInvoiceCount(this.bookInvoiceService.count(bookInvoiceQuery));
        BookContactsQuery bookContactsQuery = new BookContactsQuery();
        bookContactsQuery.setBookId(bookId);
        businessPartnerIdentityVO.setContactCount(this.bookContactsService.count(bookContactsQuery));
        BusinessTeamMemberQuery businessTeamMemberQuery = new BusinessTeamMemberQuery();
        businessTeamMemberQuery.setObjectId(entityDo.getId());
        businessPartnerIdentityVO.setTeamCount(this.businessTeamMemberService.count(businessTeamMemberQuery));
        BusinessCustomerInfoDO businessCustomerInfoDO = this.businessCustomerInfoRepo.findByPartnerId(partnerId);
        if (entityDo.getCustomerFlag().booleanValue() || businessCustomerInfoDO != null) {
            identityVO = new BusinessPartnerIdentityVO.IdentityVO(businessPartnerIdentityVO);
            identityVO.setName("\u5ba2\u6237");
            identityVO.setValue("customer");
            if (entityDo.getCustomerFlag().booleanValue() && !BusinessPartnerStatusEnum.APPROVING.getCode().equals(businessCustomerInfoDO.getCustomerStatus())) {
                identityVO.setCanEdit(Boolean.valueOf(true));
            }
            IdentityVOList.add(identityVO);
            CrmBusinessPartnerService crmBusinessPartnerService = (CrmBusinessPartnerService)SpringUtil.getBean(CrmBusinessPartnerService.class);
            long countBusiness = crmBusinessPartnerService.countBusiness(partnerId, bookId);
            businessPartnerIdentityVO.setBusinessCount(Long.valueOf(countBusiness));
            long countFollowList = crmBusinessPartnerService.countFollowList(partnerId);
            businessPartnerIdentityVO.setOperationCount(Long.valueOf(countFollowList));
        }
        if (entityDo.getSupplierFlag().booleanValue() || this.businessSupplierInfoRepo.findByPartnerId(partnerId) != null) {
            identityVO = new BusinessPartnerIdentityVO.IdentityVO(businessPartnerIdentityVO);
            identityVO.setName("\u4f9b\u5e94\u5546");
            identityVO.setValue("supply");
            if (entityDo.getSupplierFlag().booleanValue()) {
                identityVO.setCanEdit(Boolean.valueOf(true));
            }
            IdentityVOList.add(identityVO);
        }
        if (entityDo.getDistributorFlag().booleanValue() || this.businessDistributorInfoRepo.findByPartnerId(partnerId) != null) {
            identityVO = new BusinessPartnerIdentityVO.IdentityVO(businessPartnerIdentityVO);
            identityVO.setName("\u7ecf\u9500\u5546");
            identityVO.setValue("dealer");
            if (entityDo.getDistributorFlag().booleanValue()) {
                identityVO.setCanEdit(Boolean.valueOf(true));
            }
            IdentityVOList.add(identityVO);
        }
        if (entityDo.getCollaborateFlag().booleanValue() || this.businessCollaboratePartnerInfoRepo.findByPartnerId(partnerId) != null) {
            identityVO = new BusinessPartnerIdentityVO.IdentityVO(businessPartnerIdentityVO);
            identityVO.setName("\u5408\u4f5c\u4f19\u4f34");
            identityVO.setValue("partner");
            if (entityDo.getCollaborateFlag().booleanValue()) {
                identityVO.setCanEdit(Boolean.valueOf(true));
            }
            IdentityVOList.add(identityVO);
        }
        businessPartnerIdentityVO.setOperation(IdentityVOList);
        return businessPartnerIdentityVO;
    }

    public List<BusinessPartnerTreeVO> listTree(BusinessPartnerQuery query) {
        List<BusinessPartnerVO> businessPartnerVOS = this.queryListDynamic(query);
        if (!CollectionUtils.isEmpty(businessPartnerVOS)) {
            List businessPartnerTreeVOS = BusinessPartnerConvert.INSTANCE.voListVoTreeList(businessPartnerVOS);
            List<BusinessPartnerTreeVO> collection = this.treeDataSearch(businessPartnerTreeVOS);
            if (!CollectionUtils.isEmpty(collection)) {
                businessPartnerTreeVOS.addAll(collection);
            }
            businessPartnerTreeVOS = businessPartnerTreeVOS.stream().collect(Collectors.collectingAndThen(Collectors.toCollection(() -> new TreeSet<BusinessPartnerTreeVO>(Comparator.comparing(BusinessPartnerTreeVO::getId))), ArrayList::new));
            return businessPartnerTreeVOS;
        }
        return Collections.EMPTY_LIST;
    }

    private List<BusinessPartnerTreeVO> treeDataSearch(List<BusinessPartnerTreeVO> vos) {
        ArrayList<BusinessPartnerTreeVO> result = new ArrayList<BusinessPartnerTreeVO>();
        if (!CollectionUtils.isEmpty(vos)) {
            vos.forEach(crmCustomerOperationVO -> {
                Long parentId = crmCustomerOperationVO.getParentId();
                if (parentId != null) {
                    BusinessPartnerVO vo = this.queryByKey(parentId);
                    BusinessPartnerTreeVO treeVO = new BusinessPartnerTreeVO();
                    result.add(BusinessPartnerConvert.INSTANCE.voToTree(vo));
                }
            });
            if (!CollectionUtils.isEmpty(this.treeDataSearch(result))) {
                result.addAll(this.treeDataSearch(result));
            }
        }
        return result;
    }

    public List<BusinessPartnerSimpleVO> queryListSimple() {
        return this.businessPartnerDAO.queryListSimple();
    }

    public List<BusinessPartnerSimpleVO> queryNearCustomerList() {
        return this.businessPartnerDAO.queryNearCustomerList();
    }

    public BusinessPartnerVO queryByKey(Long key) {
        BusinessPartnerVO businessPartnerVO = this.businessPartnerDAO.queryByKey(key);
        if (businessPartnerVO == null) {
            throw TwException.error("", "\u6570\u636e\u4e0d\u5b58\u5728");
        }
        if (businessPartnerVO.getParentId() != null) {
            BusinessPartnerDO partnerDO = this.businessPartnerRepo.findById(businessPartnerVO.getParentId()).orElseGet(BusinessPartnerDO::new);
            businessPartnerVO.setParentIdDesc(partnerDO.getPartnerName());
        }
        Map<Object, Object> teamMemberMap = new HashMap();
        HashMap customerOperationMap = new HashMap();
        BusinessTeamMemberQuery teamMemberQuery = new BusinessTeamMemberQuery();
        teamMemberQuery.setObjectId(key);
        List businessTeamMemberVOS = this.businessTeamMemberService.queryListDynamic(teamMemberQuery);
        if (!CollectionUtils.isEmpty((Collection)businessTeamMemberVOS)) {
            teamMemberMap = businessTeamMemberVOS.stream().collect(Collectors.groupingBy(BusinessTeamMemberVO::getMemberRole));
        }
        if (teamMemberMap.containsKey(BusinessTeamRoleEnum.SALE_MANAGER.getCode())) {
            businessPartnerVO.setBusinessUserId(((BusinessTeamMemberVO)((List)teamMemberMap.get(BusinessTeamRoleEnum.SALE_MANAGER.getCode())).get(0)).getUserId());
            businessPartnerVO.setBusinessUserName(((BusinessTeamMemberVO)((List)teamMemberMap.get(BusinessTeamRoleEnum.SALE_MANAGER.getCode())).get(0)).getMemberName());
        }
        if (teamMemberMap.containsKey(BusinessTeamRoleEnum.SERVICE_MANAGER.getCode())) {
            businessPartnerVO.setServiceUserId(((BusinessTeamMemberVO)((List)teamMemberMap.get(BusinessTeamRoleEnum.SERVICE_MANAGER.getCode())).get(0)).getUserId());
            businessPartnerVO.setServiceUserName(((BusinessTeamMemberVO)((List)teamMemberMap.get(BusinessTeamRoleEnum.SERVICE_MANAGER.getCode())).get(0)).getMemberName());
        }
        if (teamMemberMap.containsKey(BusinessTeamRoleEnum.CARE.getCode())) {
            businessPartnerVO.setCareUserId(((BusinessTeamMemberVO)((List)teamMemberMap.get(BusinessTeamRoleEnum.CARE.getCode())).get(0)).getUserId());
            businessPartnerVO.setCareUserName(((BusinessTeamMemberVO)((List)teamMemberMap.get(BusinessTeamRoleEnum.CARE.getCode())).get(0)).getMemberName());
        }
        if (teamMemberMap.containsKey(BusinessTeamRoleEnum.OPERATION.getCode())) {
            businessPartnerVO.setOperationUserId(((BusinessTeamMemberVO)((List)teamMemberMap.get(BusinessTeamRoleEnum.OPERATION.getCode())).get(0)).getUserId());
            businessPartnerVO.setOperationUserName(((BusinessTeamMemberVO)((List)teamMemberMap.get(BusinessTeamRoleEnum.OPERATION.getCode())).get(0)).getMemberName());
        }
        this.translateList(Collections.singletonList(businessPartnerVO));
        return businessPartnerVO;
    }

    public List<BusinessPartnerVO> queryByBookId(Long bookId) {
        return this.businessPartnerDAO.queryByBookId(bookId);
    }

    public BusinessPartnerVO queryCustomerByBookId(Long bookId) {
        if (bookId == null) {
            throw TwException.error("", "\u5730\u5740\u8584id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        return this.businessPartnerDAO.queryCustomerByBookId(bookId);
    }

    public BusinessPartnerVO querySupplierByBookId(Long bookId) {
        if (bookId == null) {
            throw TwException.error("", "\u5730\u5740\u8584id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        return this.businessPartnerDAO.querySupplierByBookId(bookId);
    }

    public BusinessPartnerSimpleVO queryByPartnerName(String partnerName) {
        if (StringUtils.isEmpty((Object)partnerName)) {
            return null;
        }
        return this.businessPartnerDAO.queryByPartnerName(partnerName);
    }

    public BusinessPartnerVO queryByKeySimple(Long key) {
        BusinessPartnerDO entity = this.businessPartnerRepo.findById(key).orElseGet(BusinessPartnerDO::new);
        Assert.notNull((Object)entity.getId(), (String)"\u4e0d\u5b58\u5728");
        BusinessPartnerVO vo = BusinessPartnerConvert.INSTANCE.toVo(entity);
        return vo;
    }

    @Transactional(rollbackFor={Exception.class})
    public BusinessPartnerVO insert(BusinessPartnerPayload payload) {
        return this.insertPro(payload, true, true, true);
    }

    @Transactional(rollbackFor={Exception.class})
    public BusinessPartnerVO insertPro(BusinessPartnerPayload payload, boolean checkPartnerNameFlag, boolean qixinFlag, boolean operationLogRecordFlag) {
        CrmBusinessPartnerService crmBusinessPartnerService;
        boolean qxbDataInitFlag;
        if (checkPartnerNameFlag) {
            this.judgePartnerName(payload.getPartnerName());
        }
        AddressBookVO addressBookVO = this.addressBookService.insert(new AddressBookPayload());
        payload.setBookId(addressBookVO.getId());
        if (StringUtils.isEmpty((Object)payload.getBusinessPartnerNo())) {
            payload.setBusinessPartnerNo(this.generateSeqNum("BUSINESS_PARTNER", new String[0]));
        }
        BusinessPartnerDO entityDo = BusinessPartnerConvert.INSTANCE.toDo(payload);
        String partnerName = entityDo.getPartnerName();
        String pinyin = PinyinUtil.getPinyin((String)partnerName, (String)"");
        entityDo.setPartnerNamePinyin(pinyin);
        entityDo.setDataTransferFlag(false);
        entityDo.setCustomerFlag(false);
        entityDo.setSupplierFlag(false);
        entityDo.setCollaborateFlag(false);
        entityDo.setDistributorFlag(false);
        payload.setCustomerFlag(Boolean.valueOf(false));
        payload.setSupplierFlag(Boolean.valueOf(false));
        Object identityDescLog = "";
        if (BusinessInsideOrOutSideEnum.OUTSIDE.getCode().equals(payload.getInsideOrOutSide())) {
            String[] identityArray = payload.getPartnerIdentity().split(",");
            List<String> identityList = Arrays.asList(identityArray);
            if (operationLogRecordFlag) {
                String identityDesc = this.translateIdentity(payload.getPartnerIdentity());
                identityDescLog = "\u8eab\u4efd \u521b\u5efa\u4e3a " + identityDesc + "\n";
            }
            if (identityList.contains(BusinessPartnerIdentityEnum.CUSTOMER.getCode())) {
                entityDo.setCustomerFlag(true);
                payload.setCustomerFlag(Boolean.valueOf(true));
            }
            if (identityList.contains(BusinessPartnerIdentityEnum.SUPPLIER.getCode())) {
                entityDo.setSupplierFlag(true);
                payload.setSupplierFlag(Boolean.valueOf(true));
            }
            if (identityList.contains(BusinessPartnerIdentityEnum.COLLABORATE.getCode())) {
                entityDo.setCollaborateFlag(true);
            }
            if (identityList.contains(BusinessPartnerIdentityEnum.DISTRIBUTOR.getCode())) {
                entityDo.setDistributorFlag(true);
            }
        }
        BusinessPartnerDO save = (BusinessPartnerDO)this.businessPartnerRepo.save(entityDo);
        Long id = save.getId();
        String longitudeLatitude = "";
        if (!StringUtils.isEmpty((Object)payload.getProvince()) || !StringUtils.isEmpty((Object)payload.getDetailAddress())) {
            BookAddressPayload bookAddressPayload = new BookAddressPayload();
            bookAddressPayload.setBookId(addressBookVO.getId());
            bookAddressPayload.setDetailAddress(payload.getDetailAddress());
            bookAddressPayload.setCountry(payload.getCountry());
            bookAddressPayload.setProvince(payload.getProvince());
            bookAddressPayload.setProvinceName(payload.getProvinceName());
            bookAddressPayload.setCity(payload.getCity());
            bookAddressPayload.setCityName(payload.getCityName());
            bookAddressPayload.setDistrict(payload.getDistrict());
            bookAddressPayload.setDistrictName(payload.getDistrictName());
            bookAddressPayload.setIsDefault(Boolean.valueOf(true));
            bookAddressPayload.setAddressType(BookAddressTypeEnum.company_addr.getCode());
            bookAddressPayload.setCountry(CountryEnum.CHINA.getCode());
            bookAddressPayload.setPartnerId(id);
            bookAddressPayload.setLongitudeLatitude(payload.getLongitudeLatitude());
            BookAddressVO insert = this.bookAddressService.insert(bookAddressPayload, Boolean.valueOf(true));
            longitudeLatitude = insert.getLongitudeLatitude();
        }
        this.dealSaveBusinessPartner(payload, entityDo);
        if (operationLogRecordFlag) {
            String fieldsCreateLog = this.changeFieldLogUtil.getFieldsCreateLog(entityDo);
            this.logService.saveNewLog(id, PrdSystemObjectEnum.BUSINESS_PARTNER.getCode(), (String)identityDescLog + fieldsCreateLog);
        }
        if (qixinFlag && (qxbDataInitFlag = (crmBusinessPartnerService = (CrmBusinessPartnerService)SpringUtil.getBean(CrmBusinessPartnerService.class)).fillQxbInfo(save.getPartnerName(), save.getId().longValue(), save.getBookId()))) {
            save.setQxbDataInitFlag(true);
        }
        BusinessPartnerVO businessPartnerVO = BusinessPartnerConvert.INSTANCE.toVo(save);
        businessPartnerVO.setLongitudeLatitude(longitudeLatitude);
        return businessPartnerVO;
    }

    @Transactional(rollbackFor={Exception.class})
    public BusinessPartnerVO insertOtherIdentity(BusinessPartnerPayload payload, Boolean operationLogRecordFlag) {
        CrmBusinessPartnerService crmBusinessPartnerService;
        boolean qxbDataInitFlag;
        boolean qxbDataInitFlagDb;
        BusinessPartnerDO entity = this.businessPartnerRepo.findById(payload.getId()).orElseGet(BusinessPartnerDO::new);
        Assert.notNull((Object)entity.getId(), (String)"\u4e0d\u5b58\u5728");
        BusinessPartnerDO entityLog = new BusinessPartnerDO();
        BeanUtils.copyProperties((Object)entity, (Object)entityLog);
        BusinessPartnerDO entityDo = BusinessPartnerConvert.INSTANCE.toDo(payload);
        entityDo.setCustomerFlag(false);
        entityDo.setSupplierFlag(false);
        entityDo.setCollaborateFlag(false);
        if (BusinessInsideOrOutSideEnum.OUTSIDE.getCode().equals(payload.getInsideOrOutSide())) {
            String newIdentity;
            String oldIdentity = entity.getPartnerIdentity();
            if (oldIdentity.equals(newIdentity = payload.getPartnerIdentity())) {
                throw TwException.error("", "\u8eab\u4efd\u672a\u53d8\u66f4\uff0c\u8bf7\u4fee\u6539\u540e\u91cd\u65b0\u63d0\u4ea4");
            }
            String partnerIdentity = entity.getPartnerIdentity();
            String[] oldIdentityArray = partnerIdentity.split(",");
            ArrayList<String> oldIdentityList = new ArrayList<String>(Arrays.asList(oldIdentityArray));
            String[] identityArray = payload.getPartnerIdentity().split(",");
            ArrayList<String> identityList = new ArrayList<String>(Arrays.asList(identityArray));
            identityList.removeAll(oldIdentityList);
            if (identityList.contains(BusinessPartnerIdentityEnum.CUSTOMER.getCode())) {
                entityDo.setCustomerFlag(true);
            }
            if (identityList.contains(BusinessPartnerIdentityEnum.SUPPLIER.getCode())) {
                entityDo.setSupplierFlag(true);
            }
            if (identityList.contains(BusinessPartnerIdentityEnum.COLLABORATE.getCode())) {
                entityDo.setCollaborateFlag(true);
            }
            if (operationLogRecordFlag.booleanValue()) {
                this.logService.saveNewLog(entityDo.getId(), PrdSystemObjectEnum.BUSINESS_PARTNER.getCode(), "\u8eab\u4efd\u7531" + oldIdentity + " \u4fee\u6539\u4e3a " + newIdentity);
            }
        }
        this.dealSaveBusinessPartner(payload, entityDo);
        entity.copy(entityDo);
        String partnerIdentity = entity.getPartnerIdentity();
        if (partnerIdentity.contains(BusinessPartnerIdentityEnum.CUSTOMER.getCode())) {
            entity.setCustomerFlag(true);
        }
        if (partnerIdentity.contains(BusinessPartnerIdentityEnum.SUPPLIER.getCode())) {
            entity.setSupplierFlag(true);
        }
        if (partnerIdentity.contains(BusinessPartnerIdentityEnum.COLLABORATE.getCode())) {
            entity.setSupplierFlag(true);
        }
        BusinessPartnerDO save = this.businessPartnerDAO.save(entity);
        boolean bl = qxbDataInitFlagDb = null == entity.getQxbDataInitFlag() || null != entity.getQxbDataInitFlag() && entity.getQxbDataInitFlag() == false;
        if (StringUtils.hasText((String)payload.getPartnerName()) && qxbDataInitFlagDb && (qxbDataInitFlag = (crmBusinessPartnerService = (CrmBusinessPartnerService)SpringUtil.getBean(CrmBusinessPartnerService.class)).fillQxbInfo(save.getPartnerName(), save.getId().longValue(), save.getBookId()))) {
            save.setQxbDataInitFlag(true);
        }
        return null;
    }

    @Transactional(rollbackFor={Exception.class})
    public BusinessPartnerVO update(BusinessPartnerPayload payload) {
        CrmBusinessPartnerService crmBusinessPartnerService;
        boolean qxbDataInitFlag;
        boolean qxbDataInitFlagDb;
        BusinessPartnerDO entity = this.businessPartnerRepo.findById(payload.getId()).orElseGet(BusinessPartnerDO::new);
        Assert.notNull((Object)entity.getId(), (String)"\u4e0d\u5b58\u5728");
        BusinessPartnerDO entityLog = new BusinessPartnerDO();
        BeanUtils.copyProperties((Object)entity, (Object)entityLog);
        BusinessPartnerDO entityDo = BusinessPartnerConvert.INSTANCE.toDo(payload);
        if (StringUtils.hasText((String)entityDo.getPartnerName())) {
            String partnerName = entityDo.getPartnerName();
            String pinyin = PinyinUtil.getPinyin((String)partnerName, (String)"");
            entityDo.setPartnerNamePinyin(pinyin);
        }
        if (!StringUtils.isEmpty((Object)payload.getPartnerIdentity())) {
            String[] identityArray = payload.getPartnerIdentity().split(",");
            List<String> identityList = Arrays.asList(identityArray);
            entityDo.setCustomerFlag(false);
            entityDo.setSupplierFlag(false);
            entityDo.setCollaborateFlag(false);
            if (identityList.contains(BusinessPartnerIdentityEnum.CUSTOMER.getCode())) {
                entityDo.setCustomerFlag(true);
            }
            if (identityList.contains(BusinessPartnerIdentityEnum.SUPPLIER.getCode())) {
                entityDo.setSupplierFlag(true);
            }
            if (identityList.contains(BusinessPartnerIdentityEnum.COLLABORATE.getCode())) {
                entityDo.setCollaborateFlag(true);
            }
            Long id = entityDo.getId();
            BusinessCustomerInfoDO BusinessCustomerInfoDO2 = this.businessCustomerInfoRepo.findByPartnerId(id);
            if (entityDo.getCustomerFlag().booleanValue()) {
                if (BusinessCustomerInfoDO2 != null) {
                    BusinessCustomerInfoDO2.setCustomerStatus(BusinessPartnerStatusEnum.CREATE.getCode());
                    this.businessCustomerInfoRepo.save(BusinessCustomerInfoDO2);
                } else {
                    BusinessCustomerInfoPayload businessCustomerInfoPayload = new BusinessCustomerInfoPayload();
                    businessCustomerInfoPayload.setPartnerId(id);
                    businessCustomerInfoPayload.setCustomerStatus(BusinessPartnerStatusEnum.CREATE.getCode());
                    businessCustomerInfoPayload.setIsOperate(Boolean.valueOf(false));
                    businessCustomerInfoPayload.setCustomerGradle(payload.getCustomerGradle());
                    businessCustomerInfoPayload.setCustomerRegion(payload.getCustomerRegion());
                    businessCustomerInfoPayload.setCustomerStage(BusinessPartnerStageEnum.POTENTIAL.getCode());
                    businessCustomerInfoPayload.setNewCustFlag(payload.getNewCustFlag());
                    this.businessCustomerInfoService.insert(businessCustomerInfoPayload);
                }
            } else {
                if (BusinessCustomerInfoDO2 != null) {
                    BusinessCustomerInfoDO2.setCustomerStatus(BusinessPartnerStatusEnum.CLOSE.getCode());
                    this.businessCustomerInfoRepo.save(BusinessCustomerInfoDO2);
                }
                if (entity.getCustomerFlag().booleanValue()) {
                    this.businessTeamMemberService.updateTeamByIdentityChange(id, BusinessPartnerIdentityEnum.CUSTOMER.getCode());
                }
            }
            BusinessSupplierInfoDO supplierInfoDO = this.businessSupplierInfoRepo.findByPartnerId(id);
            if (entityDo.getSupplierFlag().booleanValue()) {
                if (supplierInfoDO != null) {
                    supplierInfoDO.setSupplierStatus(BusinessPartnerStatusEnum.CREATE.getCode());
                    this.businessSupplierInfoRepo.save(supplierInfoDO);
                } else {
                    BusinessSupplierInfoPayload businessSupplierInfoPayload = new BusinessSupplierInfoPayload();
                    businessSupplierInfoPayload.setPartnerId(id);
                    businessSupplierInfoPayload.setSupplierStatus(BusinessPartnerStatusEnum.CREATE.getCode());
                    this.businessSupplierInfoService.insert(businessSupplierInfoPayload);
                }
            } else {
                if (supplierInfoDO != null) {
                    supplierInfoDO.setSupplierStatus(BusinessPartnerStatusEnum.CLOSE.getCode());
                    this.businessSupplierInfoRepo.save(supplierInfoDO);
                }
                if (entity.getSupplierFlag().booleanValue()) {
                    this.businessTeamMemberService.updateTeamByIdentityChange(id, BusinessPartnerIdentityEnum.SUPPLIER.getCode());
                }
            }
            BusinessCollaboratePartnerInfoDO collaboratePartnerInfoDO = this.businessCollaboratePartnerInfoRepo.findByPartnerId(id);
            if (entityDo.getCollaborateFlag().booleanValue()) {
                if (collaboratePartnerInfoDO != null) {
                    collaboratePartnerInfoDO.setCollaborateStatus(BusinessPartnerStatusEnum.CREATE.getCode());
                    this.businessCollaboratePartnerInfoRepo.save(collaboratePartnerInfoDO);
                } else {
                    BusinessCollaboratePartnerInfoPayload businessCollaboratePartnerInfoPayload = new BusinessCollaboratePartnerInfoPayload();
                    businessCollaboratePartnerInfoPayload.setCollaborateStatus(BusinessPartnerStatusEnum.CREATE.getCode());
                    businessCollaboratePartnerInfoPayload.setPartnerId(id);
                    this.businessCollaboratePartnerInfoService.insert(businessCollaboratePartnerInfoPayload);
                }
            } else {
                if (collaboratePartnerInfoDO != null) {
                    collaboratePartnerInfoDO.setCollaborateStatus(BusinessPartnerStatusEnum.CLOSE.getCode());
                    this.businessCollaboratePartnerInfoRepo.save(collaboratePartnerInfoDO);
                }
                if (entity.getCollaborateFlag().booleanValue() && entityDo.getDistributorFlag().booleanValue()) {
                    this.businessTeamMemberService.updateTeamByIdentityChange(id, BusinessPartnerIdentityEnum.COLLABORATE.getCode());
                }
            }
        }
        if (!CollectionUtils.isEmpty((Collection)payload.getNullFields())) {
            this.deleteTeamMember(payload.getNullFields(), payload.getId());
        }
        BusinessCutomerManagePayload businessCutomerManagePayload = new BusinessCutomerManagePayload();
        businessCutomerManagePayload.setBusinessUserId(payload.getBusinessUserId());
        businessCutomerManagePayload.setServiceUserId(payload.getServiceUserId());
        businessCutomerManagePayload.setOperationUserId(payload.getOperationUserId());
        businessCutomerManagePayload.setCareUserId(payload.getCareUserId());
        businessCutomerManagePayload.setId(payload.getId());
        this.businessCustomerInfoService.updateCustomerManageTeamMember(businessCutomerManagePayload);
        entity.copy(entityDo);
        StringBuilder fieldsUpdateLog = this.changeFieldLogUtil.nullFieldsProcess((TwCommonPayload)payload, entityLog, entity);
        BusinessPartnerDO save = (BusinessPartnerDO)this.businessPartnerRepo.save(entity);
        fieldsUpdateLog.append(this.changeFieldLogUtil.getFieldsUpdateLog(entityDo, entityLog));
        if (StringUtils.hasText((CharSequence)fieldsUpdateLog)) {
            this.logService.saveNewLog(entityDo.getId(), PrdSystemObjectEnum.BUSINESS_PARTNER.getCode(), fieldsUpdateLog.toString());
        }
        boolean bl = qxbDataInitFlagDb = null == entity.getQxbDataInitFlag() || null != entity.getQxbDataInitFlag() && entity.getQxbDataInitFlag() == false;
        if (StringUtils.hasText((String)payload.getPartnerName()) && qxbDataInitFlagDb && (qxbDataInitFlag = (crmBusinessPartnerService = (CrmBusinessPartnerService)SpringUtil.getBean(CrmBusinessPartnerService.class)).fillQxbInfo(save.getPartnerName(), save.getId().longValue(), save.getBookId()))) {
            save.setQxbDataInitFlag(true);
        }
        return BusinessPartnerConvert.INSTANCE.toVo(save);
    }

    private void deleteTeamMember(List<String> nullFields, Long id) {
        ArrayList<String> memberRoles = new ArrayList<String>();
        if (nullFields.contains("businessUserId")) {
            memberRoles.add(BusinessTeamRoleEnum.SALE_MANAGER.getCode());
        }
        if (nullFields.contains("serviceUserId")) {
            memberRoles.add(BusinessTeamRoleEnum.SERVICE_MANAGER.getCode());
        }
        if (nullFields.contains("operationUserId")) {
            memberRoles.add(BusinessTeamRoleEnum.OPERATION.getCode());
        }
        if (nullFields.contains("CARE")) {
            memberRoles.add(BusinessTeamRoleEnum.SALE_MANAGER.getCode());
        }
        if (!CollectionUtils.isEmpty(memberRoles)) {
            this.businessTeamMemberService.deleteTeamMember(id, BusinessTeamTypeEnum.PARTNER.getCode(), memberRoles);
        }
    }

    @Transactional(rollbackFor={Exception.class})
    public void deleteSoft(List<Long> keys) {
        if (!keys.isEmpty()) {
            this.businessPartnerDAO.deleteSoft(keys);
        }
    }

    private void translateList(List<BusinessPartnerVO> businessPartnerVOS) {
        List ids = businessPartnerVOS.stream().map(e -> e.getId()).collect(Collectors.toList());
        List businessTeamMemberVOS = this.businessTeamMemberService.queryByObjectIdsAndRole(ids, BusinessTeamRoleEnum.SALE_MANAGER.getCode());
        CrmCustomerOperationService crmCustomerOperationService = (CrmCustomerOperationService)SpringUtil.getBean(CrmCustomerOperationService.class);
        CrmCustomerOperationQuery crmCustomerOperationQuery = new CrmCustomerOperationQuery();
        crmCustomerOperationQuery.setCustomerIdList(ids);
        List crmCustomerOperationVOS = crmCustomerOperationService.queryListCommon(crmCustomerOperationQuery);
        List crmCustomerOperationNoPermissionVOS = crmCustomerOperationService.queryList(crmCustomerOperationQuery);
        Map<Long, List<BusinessTeamMemberVO>> businessTeamMemberVOSMap = businessTeamMemberVOS.stream().collect(Collectors.groupingBy(BaseViewModel::getId));
        Map<Long, List<CrmCustomerOperationVO>> crmCustomerOperationVOSMap = crmCustomerOperationVOS.stream().collect(Collectors.groupingBy(BaseViewModel::getId));
        Map<Long, List<CrmCustomerOperationVO>> crmCustomerOperationNoPermissionVOSMap = crmCustomerOperationNoPermissionVOS.stream().collect(Collectors.groupingBy(CrmCustomerOperationVO::getCustomerId));
        businessPartnerVOS.stream().forEach(businessPartnerVO -> this.translate((BusinessPartnerVO)businessPartnerVO, businessTeamMemberVOSMap, crmCustomerOperationVOSMap, crmCustomerOperationNoPermissionVOSMap));
    }

    private void translate(BusinessPartnerVO businessPartnerVO, Map<Long, List<BusinessTeamMemberVO>> businessTeamMemberVOSMap, Map<Long, List<CrmCustomerOperationVO>> crmCustomerOperationVOSMap, Map<Long, List<CrmCustomerOperationVO>> crmCustomerOperationNoPermissionVOSMap) {
        Long businessPartnerVOId = businessPartnerVO.getId();
        String identity = businessPartnerVO.getPartnerIdentity();
        if (StringUtils.hasText((String)identity)) {
            List<BusinessTeamMemberVO> businessTeamMemberVOS;
            businessPartnerVO.setPartnerIdentityDesc(this.translateIdentity(identity));
            if (identity.contains(BusinessPartnerIdentityEnum.CUSTOMER.getCode()) && (businessTeamMemberVOS = businessTeamMemberVOSMap.get(businessPartnerVOId)) != null && businessTeamMemberVOS.size() > 0) {
                StringBuilder saleDutyIdStr = new StringBuilder();
                StringBuilder saleDutyIdDescStr = new StringBuilder();
                for (int i = 0; i < businessTeamMemberVOS.size(); ++i) {
                    if (i == businessTeamMemberVOS.size() - 1) {
                        saleDutyIdStr.append(businessTeamMemberVOS.get(i).getUserId());
                        saleDutyIdDescStr.append(this.cacheUtil.getUserName(businessTeamMemberVOS.get(i).getUserId()));
                        continue;
                    }
                    saleDutyIdStr.append(businessTeamMemberVOS.get(i).getUserId() + ",");
                    saleDutyIdDescStr.append(this.cacheUtil.getUserName(businessTeamMemberVOS.get(i).getUserId()) + ",");
                }
                businessPartnerVO.setSaleDutyId(saleDutyIdStr.toString());
                businessPartnerVO.setSaleDutyIdDesc(saleDutyIdDescStr.toString());
            }
        }
        StringBuilder str = new StringBuilder();
        if (businessPartnerVO.getProvinceName() != null) {
            str.append(businessPartnerVO.getProvinceName() + "/");
        }
        if (businessPartnerVO.getCityName() != null) {
            str.append(businessPartnerVO.getCityName() + "/");
        }
        if (businessPartnerVO.getDistrictName() != null) {
            str.append(businessPartnerVO.getDistrictName());
        }
        businessPartnerVO.setAddress(str.toString());
        List<CrmCustomerOperationVO> crmCustomerOperationVOS = crmCustomerOperationVOSMap.get(businessPartnerVOId);
        businessPartnerVO.setCustOperStatus(BusinessOperStatusEnum.CLOSE.getCode());
        businessPartnerVO.setBusinessOperaPermissonFlag(Boolean.valueOf(false));
        if (!CollectionUtils.isEmpty(crmCustomerOperationVOS)) {
            businessPartnerVO.setBusinessOperaPermissonFlag(Boolean.valueOf(true));
            String custOperStatus = crmCustomerOperationVOS.get(0).getCustOperStatus();
            if (StringUtils.hasText((String)custOperStatus)) {
                businessPartnerVO.setCustOperStatus(custOperStatus);
                businessPartnerVO.setOperId(crmCustomerOperationVOS.get(0).getId());
            }
        } else {
            String custOperStatus;
            List<CrmCustomerOperationVO> crmCustomerOperationNoPermissionVOS = crmCustomerOperationNoPermissionVOSMap.get(businessPartnerVOId);
            if (!CollectionUtils.isEmpty(crmCustomerOperationNoPermissionVOS) && StringUtils.hasText((String)(custOperStatus = crmCustomerOperationNoPermissionVOS.get(0).getCustOperStatus()))) {
                businessPartnerVO.setCustOperStatus(custOperStatus);
                businessPartnerVO.setOperId(crmCustomerOperationNoPermissionVOS.get(0).getId());
            }
        }
        businessPartnerVO.setBusinessFinancePicFlag(this.cacheUtil.hasSystemRolePermission(Arrays.asList(RoleEnum.FINANCE_MEMBER.getCode())));
        businessPartnerVO.setConfirmCustFlag(this.cacheUtil.hasSystemRolePermission(Arrays.asList(RoleEnum.POTENTIAL_CUST_CONFIRM.getCode())));
    }

    private String translateIdentity(String identity) {
        String[] identityArray = identity.split(",");
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < identityArray.length; ++i) {
            if (i == identityArray.length - 1) {
                stringBuilder.append(BusinessPartnerIdentityEnum.valueOf(identityArray[i]).getDesc());
                continue;
            }
            stringBuilder.append(BusinessPartnerIdentityEnum.valueOf(identityArray[i]).getDesc() + ",");
        }
        return stringBuilder.toString();
    }

    private String translateTw4Identity(String identity) {
        String[] identityArray = identity.split(",");
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < identityArray.length; ++i) {
            if (i == identityArray.length - 1) {
                stringBuilder.append(BusinessPartnerIdentityEnum.valueOf(identityArray[i]).getTw4Code());
                continue;
            }
            stringBuilder.append(BusinessPartnerIdentityEnum.valueOf(identityArray[i]).getTw4Code() + ",");
        }
        return stringBuilder.toString();
    }

    public long saleCount(BusinessPartnerQuery query) {
        return this.businessPartnerDAO.saleCount(query);
    }

    public List<BusinessPartnerVO> listForDm(List<String> partnerNameList) {
        List<BusinessPartnerVO> list = this.businessPartnerDAO.listForDm(partnerNameList);
        return list;
    }

    public List<BusinessPartnerVO> queryCustPartnerListSimple() {
        return this.businessPartnerDAO.queryCustPartnerListSimple();
    }

    public BusinessPartnerInfoVO queryBusinessPartnerInfoByPartnerName(String partnerName) {
        BusinessPartnerQuery query = new BusinessPartnerQuery();
        query.setPartnerName(partnerName);
        List<BusinessPartnerInfoVO> businessPartnerInfoVOS = this.businessPartnerDAO.queryBusinessPartnerInfo(query);
        if (!CollectionUtils.isEmpty(businessPartnerInfoVOS)) {
            BusinessPartnerInfoVO businessPartnerInfoVO = businessPartnerInfoVOS.get(0);
            if (businessPartnerInfoVO != null) {
                BusinessCustomerInfoVO businessCustomerInfoVO;
                String partnerIdentity;
                Long id = businessPartnerInfoVO.getId();
                Map<Object, Object> teamMemberMap = new HashMap();
                BusinessTeamMemberQuery teamMemberQuery = new BusinessTeamMemberQuery();
                teamMemberQuery.setObjectId(id);
                List businessTeamMemberVOS = this.businessTeamMemberService.queryListDynamic(teamMemberQuery);
                if (!CollectionUtils.isEmpty((Collection)businessTeamMemberVOS)) {
                    teamMemberMap = businessTeamMemberVOS.stream().collect(Collectors.groupingBy(BusinessTeamMemberVO::getMemberRole));
                }
                if (!StringUtils.hasText((String)(partnerIdentity = businessPartnerInfoVO.getPartnerIdentity()))) {
                    return businessPartnerInfoVO;
                }
                if (partnerIdentity.contains(BusinessPartnerIdentityEnum.CUSTOMER.getCode()) && (businessCustomerInfoVO = this.businessCustomerInfoService.queryByPartnerId(id)) != null) {
                    if (teamMemberMap.containsKey(BusinessTeamRoleEnum.SALE_MANAGER.getCode())) {
                        businessCustomerInfoVO.setBusinessUserId(((BusinessTeamMemberVO)((List)teamMemberMap.get(BusinessTeamRoleEnum.SALE_MANAGER.getCode())).get(0)).getUserId());
                    }
                    if (teamMemberMap.containsKey(BusinessTeamRoleEnum.SERVICE_MANAGER.getCode())) {
                        businessCustomerInfoVO.setServiceUserId(((BusinessTeamMemberVO)((List)teamMemberMap.get(BusinessTeamRoleEnum.SERVICE_MANAGER.getCode())).get(0)).getUserId());
                    }
                    if (teamMemberMap.containsKey(BusinessTeamRoleEnum.CARE.getCode())) {
                        businessCustomerInfoVO.setCareUserId(((BusinessTeamMemberVO)((List)teamMemberMap.get(BusinessTeamRoleEnum.CARE.getCode())).get(0)).getUserId());
                    }
                    if (teamMemberMap.containsKey(BusinessTeamRoleEnum.OPERATION.getCode())) {
                        businessCustomerInfoVO.setOperationUserId(((BusinessTeamMemberVO)((List)teamMemberMap.get(BusinessTeamRoleEnum.OPERATION.getCode())).get(0)).getUserId());
                    }
                    businessPartnerInfoVO.setBusinessCustomerInfoVO(businessCustomerInfoVO);
                }
                if (partnerIdentity.contains(BusinessPartnerIdentityEnum.SUPPLIER.getCode())) {
                    BusinessSupplierInfoVO businessSupplierInfoVO = this.businessSupplierInfoService.queryByPartnerId(id);
                    if (teamMemberMap.containsKey(BusinessTeamRoleEnum.PURCHASE_MANAGER.getCode())) {
                        businessSupplierInfoVO.setPurchaseInchargeResId(((BusinessTeamMemberVO)((List)teamMemberMap.get(BusinessTeamRoleEnum.PURCHASE_MANAGER.getCode())).get(0)).getUserId());
                    }
                    businessPartnerInfoVO.setBusinessSupplierInfoVO(businessSupplierInfoVO);
                }
                if (partnerIdentity.contains(BusinessPartnerIdentityEnum.COLLABORATE.getCode())) {
                    BusinessCollaboratePartnerInfoVO businessCollaboratePartnerInfoVO = this.businessCollaboratePartnerInfoService.queryByPartnerId(id);
                    if (teamMemberMap.containsKey(BusinessTeamRoleEnum.CHANNEL_MANAGER.getCode())) {
                        businessCollaboratePartnerInfoVO.setChannelUserId(((BusinessTeamMemberVO)((List)teamMemberMap.get(BusinessTeamRoleEnum.CHANNEL_MANAGER.getCode())).get(0)).getUserId());
                    }
                    businessPartnerInfoVO.setBusinessCollaboratePartnerInfoVO(businessCollaboratePartnerInfoVO);
                }
            }
            return businessPartnerInfoVO;
        }
        return null;
    }

    @Transactional(rollbackFor={Exception.class})
    public void changeAccountAndInvoice(BusinessPartnerChangePayload payload) {
        List bookAccountPayloadList;
        BusinessPartnerVO businessPartnerVO = this.businessPartnerDAO.queryByKey(payload.getId());
        if (businessPartnerVO == null) {
            throw TwException.error("", "\u53d8\u66f4\u6570\u636e\u4e0d\u5b58\u5728");
        }
        if (WorkFlowStatusEnum.APPROVING_WORK.getCode().equals(businessPartnerVO.getApplyStatus())) {
            throw TwException.error("", "\u53d8\u66f4\u6d41\u7a0b\u4e2d\u7684\u6570\u636e\u4e0d\u80fd\u518d\u6b21\u53d1\u8d77\u53d8\u66f4");
        }
        businessPartnerVO = (BusinessPartnerVO)this.udcUtil.translate(businessPartnerVO);
        this.translateList(Collections.singletonList(businessPartnerVO));
        BookAccountQuery bookAccountQuery = new BookAccountQuery();
        bookAccountQuery.setBookId(businessPartnerVO.getBookId());
        List bookAccountVOS = this.bookAccountService.queryListDynamic(bookAccountQuery);
        BookInvoiceQuery bookInvoiceQuery = new BookInvoiceQuery();
        bookInvoiceQuery.setBookId(businessPartnerVO.getBookId());
        List bookInvoiceVOS = this.bookInvoiceService.queryListDynamic(bookInvoiceQuery);
        BusinessPartnerChangeVO businessPartnerChangeVO = new BusinessPartnerChangeVO();
        businessPartnerChangeVO.setId(payload.getId());
        businessPartnerChangeVO.setBusinessPartnerVO(businessPartnerVO);
        businessPartnerChangeVO.setBookAccountVOList(bookAccountVOS);
        businessPartnerChangeVO.setBookInvoiceVOList(bookInvoiceVOS);
        BusinessPartnerChangeVO oldChangeVO = (BusinessPartnerChangeVO)this.udcUtil.translate(businessPartnerChangeVO);
        BusinessPartnerChangeVO newVO = new BusinessPartnerChangeVO();
        newVO.setId(payload.getId());
        newVO.setBusinessPartnerVO(oldChangeVO.getBusinessPartnerVO());
        List bookInvoicePayloadList = payload.getBookInvoicePayloadList();
        if (!CollectionUtils.isEmpty((Collection)bookInvoicePayloadList)) {
            List bookInvoicePayloads = bookInvoicePayloadList.stream().filter(p -> p.getIsDefault() != null && p.getIsDefault() != false).collect(Collectors.toList());
            if (CollectionUtils.isEmpty(bookInvoicePayloads)) {
                bookInvoicePayloadList.stream().forEach(p -> p.setIsDefault(Boolean.valueOf(false)));
                ((BookInvoicePayload)bookInvoicePayloadList.get(0)).setIsDefault(Boolean.valueOf(true));
            } else {
                if (bookInvoicePayloads.size() > 1) {
                    throw TwException.error("", "\u53d1\u7968\u4fe1\u606f\u4e0d\u80fd\u63d0\u4ea4\u591a\u6761\u9ed8\u8ba4\u7684\u6570\u636e");
                }
                List bookInvoicePayloadFalse = bookInvoicePayloadList.stream().filter(p -> p.getIsDefault() == null || p.getIsDefault() == false).collect(Collectors.toList());
                if (!CollectionUtils.isEmpty(bookInvoicePayloadFalse)) {
                    bookInvoicePayloadFalse.stream().forEach(p -> p.setIsDefault(Boolean.valueOf(false)));
                }
            }
            List<BookInvoiceVO> newBookInvoiceVOS = this.bookInvoiceToVoList(bookInvoicePayloadList);
            newVO.setBookInvoiceVOList(newBookInvoiceVOS);
        }
        if (!CollectionUtils.isEmpty((Collection)(bookAccountPayloadList = payload.getBookAccountPayloadList()))) {
            List bookAccountPayloads = bookAccountPayloadList.stream().filter(p -> p.getIsDefault() != null && p.getIsDefault() != false).collect(Collectors.toList());
            if (CollectionUtils.isEmpty(bookAccountPayloads)) {
                bookAccountPayloadList.stream().forEach(p -> p.setIsDefault(Boolean.valueOf(false)));
                ((BookAccountPayload)bookAccountPayloadList.get(0)).setIsDefault(Boolean.valueOf(true));
            } else {
                if (bookAccountPayloads.size() > 1) {
                    throw TwException.error("", "\u94f6\u884c\u4fe1\u606f\u4e0d\u80fd\u63d0\u4ea4\u591a\u6761\u9ed8\u8ba4\u7684\u6570\u636e");
                }
                List bookAccountPayloadFalse = bookAccountPayloadList.stream().filter(p -> p.getIsDefault() == null || p.getIsDefault() == false).collect(Collectors.toList());
                if (!CollectionUtils.isEmpty(bookAccountPayloadFalse)) {
                    bookAccountPayloadFalse.stream().forEach(p -> p.setIsDefault(Boolean.valueOf(false)));
                }
            }
            List<BookAccountVO> newBookAccountVOS = this.bookAccountToVOList(bookAccountPayloadList);
            newVO.setBookAccountVOList(newBookAccountVOS);
        }
        newVO = (BusinessPartnerChangeVO)this.udcUtil.translate(newVO);
        String changeStatus = WorkFlowStatusEnum.APPROVING_WORK.getCode();
        Long saveId = this.changeService.save(ChangeTypeEnum.ACC_INVOICE_CHANGE.getCode(), (Object)oldChangeVO, (Object)newVO, "" + payload.getId());
        HashMap<String, List<String>> batchMap = new HashMap<String, List<String>>();
        PrdOrgRoleVO arAccount = this.daoOrg.queryRoleByOrgIdAndRoleCode(this.workflow_orgId, WorkFlowRoleCodeEnum.AR_ACCOUNTANT.getCode());
        if (ObjectUtils.isEmpty((Object)arAccount)) {
            throw TwException.error("", WorkFlowRoleCodeEnum.AR_ACCOUNTANT.getDesc() + "\u4e0d\u5b58\u5728\uff01");
        }
        String[] splitByArAccount = arAccount.getRoleEmployees().split(",");
        batchMap.put("Activity_0nqziqi", Arrays.asList(splitByArAccount));
        ProcessInfo processInfo = this.workflowUtil.startProcess(StartProcessPayload.of((String)ProcDefKey.ACC_INVOICE_CHANGE.name(), (String)(businessPartnerVO.getPartnerName() + "-\u94f6\u884c\u8d26\u6237/\u5f00\u7968\u4fe1\u606f\u53d8\u66f4"), (String)("" + saveId), batchMap), new Long[0]);
        String procInstId = processInfo.getProcInstId();
        BusinessPartnerPayload payload0 = new BusinessPartnerPayload();
        payload0.setId(payload.getId());
        payload0.setApplyStatus(changeStatus);
        ComChangePayload changePayload = new ComChangePayload();
        changePayload.setId(saveId);
        changePayload.setProcInstId(procInstId);
        changePayload.setApprStatus(changeStatus);
        changePayload.setChangeStatus(changeStatus);
        this.transactionUtilService.executeWithRunnable(() -> {
            this.businessPartnerDAO.updateWorkFlow(payload0);
            this.changeService.updateWorkFlow(changePayload);
        });
    }

    @Transactional(rollbackFor={Exception.class})
    public void changeAccountAndInvoiceUpdate(BusinessPartnerChangePayload payload) {
        List bookAccountPayloadList;
        BusinessPartnerVO businessPartnerVO = this.businessPartnerDAO.queryByKey(payload.getId());
        this.translateList(Collections.singletonList(businessPartnerVO));
        businessPartnerVO = (BusinessPartnerVO)this.udcUtil.translate(businessPartnerVO);
        BusinessPartnerChangeVO newVO = new BusinessPartnerChangeVO();
        newVO.setId(payload.getId());
        newVO.setBusinessPartnerVO(businessPartnerVO);
        List bookInvoicePayloadList = payload.getBookInvoicePayloadList();
        if (!CollectionUtils.isEmpty((Collection)bookInvoicePayloadList)) {
            List bookInvoicePayloads = bookInvoicePayloadList.stream().filter(p -> p.getIsDefault() != null && p.getIsDefault() != false).collect(Collectors.toList());
            if (CollectionUtils.isEmpty(bookInvoicePayloads)) {
                bookInvoicePayloadList.stream().forEach(p -> p.setIsDefault(Boolean.valueOf(false)));
                ((BookInvoicePayload)bookInvoicePayloadList.get(0)).setIsDefault(Boolean.valueOf(true));
            } else {
                if (bookInvoicePayloads.size() > 1) {
                    throw TwException.error("", "\u53d1\u7968\u4fe1\u606f\u4e0d\u80fd\u63d0\u4ea4\u591a\u6761\u9ed8\u8ba4\u7684\u6570\u636e");
                }
                List bookInvoicePayloadFalse = bookInvoicePayloadList.stream().filter(p -> p.getIsDefault() == null || p.getIsDefault() == false).collect(Collectors.toList());
                if (!CollectionUtils.isEmpty(bookInvoicePayloadFalse)) {
                    bookInvoicePayloadFalse.stream().forEach(p -> p.setIsDefault(Boolean.valueOf(false)));
                }
            }
            List<BookInvoiceVO> newBookInvoiceVOS = this.bookInvoiceToVoList(bookInvoicePayloadList);
            newVO.setBookInvoiceVOList(newBookInvoiceVOS);
        }
        if (!CollectionUtils.isEmpty((Collection)(bookAccountPayloadList = payload.getBookAccountPayloadList()))) {
            List bookAccountPayloads = bookAccountPayloadList.stream().filter(p -> p.getIsDefault() != null && p.getIsDefault() != false).collect(Collectors.toList());
            if (CollectionUtils.isEmpty(bookAccountPayloads)) {
                bookAccountPayloadList.stream().forEach(p -> p.setIsDefault(Boolean.valueOf(false)));
                ((BookAccountPayload)bookAccountPayloadList.get(0)).setIsDefault(Boolean.valueOf(true));
            } else {
                if (bookAccountPayloads.size() > 1) {
                    throw TwException.error("", "\u94f6\u884c\u4fe1\u606f\u4e0d\u80fd\u63d0\u4ea4\u591a\u6761\u9ed8\u8ba4\u7684\u6570\u636e");
                }
                List bookAccountPayloadFalse = bookAccountPayloadList.stream().filter(p -> p.getIsDefault() == null || p.getIsDefault() == false).collect(Collectors.toList());
                if (!CollectionUtils.isEmpty(bookAccountPayloadFalse)) {
                    bookAccountPayloadFalse.stream().forEach(p -> p.setIsDefault(Boolean.valueOf(false)));
                }
            }
            List<BookAccountVO> newBookAccountVOS = this.bookAccountToVOList(bookAccountPayloadList);
            newVO.setBookAccountVOList(newBookAccountVOS);
        }
        newVO = (BusinessPartnerChangeVO)this.udcUtil.translate(newVO);
        ComChangeVO comChangeVO = this.changeService.queryByKey(payload.getBusinessKey());
        if (!ObjectUtils.isEmpty((Object)comChangeVO)) {
            Long saveId = comChangeVO.getId();
            String procInstId = comChangeVO.getProcInstId();
            ComChangePayload changePayload = new ComChangePayload();
            changePayload.setId(saveId);
            changePayload.setChangeContent(JSONObject.toJSONString((Object)newVO));
            this.changeService.updateByKeyDynamic(changePayload);
        }
    }

    public BusinessPartnerChangeVO queryChangeAccountAndInvoiceInfo(Long businessKey, Long partnerId) {
        if (businessKey != null) {
            ComChangeVO comChangeVO = this.changeService.queryByKey(businessKey);
            String changeContent = comChangeVO.getChangeContent();
            if (StringUtils.isEmpty((Object)changeContent)) {
                throw TwException.error("", "\u6570\u636e\u4e0d\u5b58\u5728,\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458");
            }
            BusinessPartnerChangeVO businessPartnerChangeVO = (BusinessPartnerChangeVO)JSONObject.parseObject((String)changeContent, BusinessPartnerChangeVO.class);
            if (CollUtil.isNotEmpty((Collection)businessPartnerChangeVO.getBookInvoiceVOList())) {
                for (BookInvoiceVO bookInvoiceVO : businessPartnerChangeVO.getBookInvoiceVOList()) {
                    bookInvoiceVO.setLineId(IdUtil.fastSimpleUUID());
                }
            }
            if (CollUtil.isNotEmpty((Collection)businessPartnerChangeVO.getBookAccountVOList())) {
                for (BookAccountVO bookAccountVO : businessPartnerChangeVO.getBookAccountVOList()) {
                    bookAccountVO.setLineId(IdUtil.fastSimpleUUID());
                }
            }
            return businessPartnerChangeVO;
        }
        if (partnerId != null) {
            BusinessPartnerChangeVO businessPartnerChangeVO = new BusinessPartnerChangeVO();
            businessPartnerChangeVO.setId(partnerId);
            BusinessPartnerVO businessPartnerVO = this.queryByKey(partnerId);
            businessPartnerChangeVO.setBusinessPartnerVO(businessPartnerVO);
            BookAccountQuery bookAccountQuery = new BookAccountQuery();
            bookAccountQuery.setBookId(businessPartnerVO.getBookId());
            List bookAccountVOS = this.bookAccountService.queryListDynamic(bookAccountQuery);
            businessPartnerChangeVO.setBookAccountVOList(bookAccountVOS);
            BookInvoiceQuery bookInvoiceQuery = new BookInvoiceQuery();
            bookInvoiceQuery.setBookId(businessPartnerVO.getBookId());
            List bookInvoiceVOS = this.bookInvoiceService.queryListDynamic(bookInvoiceQuery);
            businessPartnerChangeVO.setBookInvoiceVOList(bookInvoiceVOS);
            return businessPartnerChangeVO;
        }
        return null;
    }

    public BusinessPartnerTaskVO businessPartnerTaskInfo(BusinessParnerTaskInfoPayload payload) {
        if (StringUtils.isEmpty((Object)payload.getProcDefKey())) {
            throw TwException.error("", "\u6d41\u7a0b\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
        }
        Long partnerId = null;
        if (ProcDefKey.CUSTOMER_ACTIVE.getName().equals(payload.getProcDefKey())) {
            partnerId = this.businessCustomerInfoService.queryByKey(payload.getObjectId()).getPartnerId();
        }
        if (ProcDefKey.COLLABORATE_ACTIVE.getName().equals(payload.getProcDefKey())) {
            partnerId = this.businessCollaboratePartnerInfoService.queryByKey(payload.getObjectId()).getPartnerId();
        }
        if (ProcDefKey.ACC_INVOICE_CHANGE.getName().equals(payload.getProcDefKey())) {
            partnerId = payload.getObjectId();
        }
        if (partnerId == null) {
            throw TwException.error("", "\u5f53\u524d\u5355\u636e\u4e0d\u5b58\u5728");
        }
        BusinessPartnerTaskVO businessPartnerTaskVO = new BusinessPartnerTaskVO();
        BusinessPartnerVO businessPartnerVO = this.queryByKey(partnerId);
        if (businessPartnerVO != null) {
            BusinessCustomerInfoVO businessCustomerInfoVO;
            String partnerIdentity;
            businessPartnerVO = (BusinessPartnerVO)this.udcUtil.translate(businessPartnerVO);
            businessPartnerTaskVO.setBusinessPartnerVO(businessPartnerVO);
            Long id = businessPartnerVO.getId();
            Map<Object, Object> teamMemberMap = new HashMap();
            BusinessTeamMemberQuery teamMemberQuery = new BusinessTeamMemberQuery();
            teamMemberQuery.setObjectId(id);
            List businessTeamMemberVOS = this.businessTeamMemberService.queryListDynamic(teamMemberQuery);
            if (!CollectionUtils.isEmpty((Collection)businessTeamMemberVOS)) {
                teamMemberMap = businessTeamMemberVOS.stream().collect(Collectors.groupingBy(BusinessTeamMemberVO::getMemberRole));
            }
            if ((partnerIdentity = businessPartnerVO.getPartnerIdentity()).contains(BusinessPartnerIdentityEnum.CUSTOMER.getCode()) && (businessCustomerInfoVO = this.businessCustomerInfoService.queryByPartnerId(id)) != null) {
                if (teamMemberMap.containsKey(BusinessTeamRoleEnum.SALE_MANAGER.getCode())) {
                    businessCustomerInfoVO.setBusinessUserId(((BusinessTeamMemberVO)((List)teamMemberMap.get(BusinessTeamRoleEnum.SALE_MANAGER.getCode())).get(0)).getUserId());
                    businessCustomerInfoVO.setBusinessUserName(((BusinessTeamMemberVO)((List)teamMemberMap.get(BusinessTeamRoleEnum.SALE_MANAGER.getCode())).get(0)).getMemberName());
                }
                if (teamMemberMap.containsKey(BusinessTeamRoleEnum.SERVICE_MANAGER.getCode())) {
                    businessCustomerInfoVO.setServiceUserId(((BusinessTeamMemberVO)((List)teamMemberMap.get(BusinessTeamRoleEnum.SERVICE_MANAGER.getCode())).get(0)).getUserId());
                    businessCustomerInfoVO.setServiceUserName(((BusinessTeamMemberVO)((List)teamMemberMap.get(BusinessTeamRoleEnum.SERVICE_MANAGER.getCode())).get(0)).getMemberName());
                }
                if (teamMemberMap.containsKey(BusinessTeamRoleEnum.CARE.getCode())) {
                    businessCustomerInfoVO.setCareUserId(((BusinessTeamMemberVO)((List)teamMemberMap.get(BusinessTeamRoleEnum.CARE.getCode())).get(0)).getUserId());
                    businessCustomerInfoVO.setCareUserName(((BusinessTeamMemberVO)((List)teamMemberMap.get(BusinessTeamRoleEnum.CARE.getCode())).get(0)).getMemberName());
                }
                if (teamMemberMap.containsKey(BusinessTeamRoleEnum.OPERATION.getCode())) {
                    businessCustomerInfoVO.setOperationUserId(((BusinessTeamMemberVO)((List)teamMemberMap.get(BusinessTeamRoleEnum.OPERATION.getCode())).get(0)).getUserId());
                    businessCustomerInfoVO.setOperationUserName(((BusinessTeamMemberVO)((List)teamMemberMap.get(BusinessTeamRoleEnum.OPERATION.getCode())).get(0)).getMemberName());
                }
                businessCustomerInfoVO = (BusinessCustomerInfoVO)this.udcUtil.translate(businessCustomerInfoVO);
                businessPartnerTaskVO.setBusinessCustomerInfoVO(businessCustomerInfoVO);
            }
            if (partnerIdentity.contains(BusinessPartnerIdentityEnum.SUPPLIER.getCode())) {
                BusinessSupplierInfoVO businessSupplierInfoVO = this.businessSupplierInfoService.queryByPartnerId(id);
                if (teamMemberMap.containsKey(BusinessTeamRoleEnum.PURCHASE_MANAGER.getCode())) {
                    businessSupplierInfoVO.setPurchaseInchargeResId(((BusinessTeamMemberVO)((List)teamMemberMap.get(BusinessTeamRoleEnum.PURCHASE_MANAGER.getCode())).get(0)).getUserId());
                    businessSupplierInfoVO.setPurchaseInchargeResName(((BusinessTeamMemberVO)((List)teamMemberMap.get(BusinessTeamRoleEnum.PURCHASE_MANAGER.getCode())).get(0)).getMemberName());
                }
                businessSupplierInfoVO = (BusinessSupplierInfoVO)this.udcUtil.translate(businessSupplierInfoVO);
                businessPartnerTaskVO.setBusinessSupplierInfoVO(businessSupplierInfoVO);
            }
            if (partnerIdentity.contains(BusinessPartnerIdentityEnum.COLLABORATE.getCode())) {
                BusinessCollaboratePartnerInfoVO businessCollaboratePartnerInfoVO = this.businessCollaboratePartnerInfoService.queryByPartnerId(id);
                if (teamMemberMap.containsKey(BusinessTeamRoleEnum.CHANNEL_MANAGER.getCode())) {
                    businessCollaboratePartnerInfoVO.setChannelUserId(((BusinessTeamMemberVO)((List)teamMemberMap.get(BusinessTeamRoleEnum.CHANNEL_MANAGER.getCode())).get(0)).getUserId());
                    businessCollaboratePartnerInfoVO.setChannelUserName(((BusinessTeamMemberVO)((List)teamMemberMap.get(BusinessTeamRoleEnum.CHANNEL_MANAGER.getCode())).get(0)).getMemberName());
                }
                businessCollaboratePartnerInfoVO = (BusinessCollaboratePartnerInfoVO)this.udcUtil.translate(businessCollaboratePartnerInfoVO);
                businessPartnerTaskVO.setBusinessCollaboratePartnerInfoVO(businessCollaboratePartnerInfoVO);
            }
        }
        BookAccountQuery bookAccountQuery = new BookAccountQuery();
        bookAccountQuery.setBookId(businessPartnerVO.getBookId());
        List bookAccountVOS = this.bookAccountService.queryListDynamic(bookAccountQuery);
        bookAccountVOS = this.udcUtil.translateList(bookAccountVOS);
        businessPartnerTaskVO.setBookAccountVOList(bookAccountVOS);
        BookInvoiceQuery bookInvoiceQuery = new BookInvoiceQuery();
        bookInvoiceQuery.setBookId(businessPartnerVO.getBookId());
        List bookInvoiceVOS = this.bookInvoiceService.queryListDynamic(bookInvoiceQuery);
        bookInvoiceVOS = this.udcUtil.translateList(bookInvoiceVOS);
        businessPartnerTaskVO.setBookInvoiceVOList(bookInvoiceVOS);
        return businessPartnerTaskVO;
    }

    @Transactional(rollbackFor={Exception.class})
    public void updateAccAndInvoice(BusinessPartnerChangeVO vo) {
        BusinessPartnerVO businessPartnerVO = vo.getBusinessPartnerVO();
        if (businessPartnerVO == null) {
            businessPartnerVO = this.queryByKey(vo.getId());
        }
        Long bookId = businessPartnerVO.getBookId();
        List bookInvoiceVOList = vo.getBookInvoiceVOList();
        if (!CollectionUtils.isEmpty((Collection)bookInvoiceVOList)) {
            List collect = bookInvoiceVOList.stream().filter(p -> p.getIsDefault() != null && p.getIsDefault().equals(true)).collect(Collectors.toList());
            if (CollectionUtils.isEmpty(collect)) {
                collect.stream().forEach(p -> p.setIsDefault(Boolean.valueOf(false)));
                ((BookInvoiceVO)bookInvoiceVOList.get(0)).setIsDefault(Boolean.valueOf(true));
            } else {
                if (collect.size() > 1) {
                    throw TwException.error("", "\u53d1\u7968\u4fe1\u606f\u4e0d\u80fd\u63d0\u4ea4\u591a\u6761\u9ed8\u8ba4\u7684\u6570\u636e");
                }
                List collectFalse = bookInvoiceVOList.stream().filter(p -> p.getIsDefault() == null || p.getIsDefault() == false).collect(Collectors.toList());
                if (!CollectionUtils.isEmpty(collectFalse)) {
                    collectFalse.stream().forEach(p -> p.setIsDefault(Boolean.valueOf(false)));
                }
            }
            BookInvoiceQuery query = new BookInvoiceQuery();
            query.setBookId(bookId);
            List olBookInvoiceVOS = this.bookInvoiceService.queryListDynamic(query);
            if (!CollectionUtils.isEmpty((Collection)olBookInvoiceVOS)) {
                Map<Long, List<BookInvoiceVO>> newBookInvoiceMap = bookInvoiceVOList.stream().filter(p -> p.getId() != null).collect(Collectors.groupingBy(BaseViewModel::getId));
                ArrayList deleteIdList = new ArrayList();
                olBookInvoiceVOS.stream().forEach(p -> {
                    if (!newBookInvoiceMap.containsKey(p.getId())) {
                        deleteIdList.add(p.getId());
                    }
                });
                if (!CollectionUtils.isEmpty(deleteIdList)) {
                    this.bookInvoiceService.deleteSoftBykeys(deleteIdList, bookId, businessPartnerVO.getId());
                }
            }
            bookInvoiceVOList.stream().forEach(p -> {
                if (p.getId() == null) {
                    p.setBookId(bookId);
                }
            });
            this.bookInvoiceService.saveAll(bookInvoiceVOList);
        } else {
            this.bookInvoiceService.deleteByBookId(bookId);
        }
        List bookAccountVOList = vo.getBookAccountVOList();
        if (!CollectionUtils.isEmpty((Collection)bookAccountVOList)) {
            List collect = bookAccountVOList.stream().filter(p -> p.getIsDefault() != null && p.getIsDefault().equals(true)).collect(Collectors.toList());
            if (CollectionUtils.isEmpty(collect)) {
                collect.stream().forEach(p -> p.setIsDefault(Boolean.valueOf(false)));
                ((BookAccountVO)bookAccountVOList.get(0)).setIsDefault(Boolean.valueOf(true));
            } else {
                if (collect.size() > 1) {
                    throw TwException.error("", "\u94f6\u884c\u4fe1\u606f\u4e0d\u80fd\u63d0\u4ea4\u591a\u6761\u9ed8\u8ba4\u7684\u6570\u636e");
                }
                List collectFalse = bookAccountVOList.stream().filter(p -> p.getIsDefault() == null || p.getIsDefault() == false).collect(Collectors.toList());
                if (!CollectionUtils.isEmpty(collectFalse)) {
                    collectFalse.stream().forEach(p -> p.setIsDefault(Boolean.valueOf(false)));
                }
            }
            BookAccountQuery query = new BookAccountQuery();
            query.setBookId(bookId);
            List oldBookAccountVOVOS = this.bookAccountService.queryListDynamic(query);
            if (!CollectionUtils.isEmpty((Collection)oldBookAccountVOVOS)) {
                Map<Long, List<BookAccountVO>> newBookAccountMap = bookAccountVOList.stream().filter(p -> p.getId() != null).collect(Collectors.groupingBy(BaseViewModel::getId));
                ArrayList deleteIdList = new ArrayList();
                oldBookAccountVOVOS.stream().forEach(p -> {
                    if (!newBookAccountMap.containsKey(p.getId())) {
                        deleteIdList.add(p.getId());
                    }
                });
                if (!CollectionUtils.isEmpty(deleteIdList)) {
                    this.bookAccountService.deleteSoftBykeys(deleteIdList, bookId, businessPartnerVO.getId());
                }
            }
            bookAccountVOList.stream().forEach(p -> {
                if (p.getId() == null) {
                    p.setBookId(bookId);
                }
            });
            this.bookAccountService.saveAll(bookAccountVOList);
        } else {
            this.bookAccountService.deleteByBookId(bookId);
        }
    }

    public PagingVO<BusinessConfirmedCustomerVO> queryConfirmedCustomer(BusinessPartnerQuery query) {
        this.dataPermission(query);
        PagingVO<BusinessConfirmedCustomerVO> businessConfirmedCustomerVOPagingVO = this.businessPartnerDAO.queryConfirmedCustomer(query);
        if (!CollectionUtils.isEmpty((Collection)businessConfirmedCustomerVOPagingVO.getRecords())) {
            List partnerIdList = businessConfirmedCustomerVOPagingVO.stream().map(p -> p.getPartnerId()).collect(Collectors.toList());
            BusinessTeamMemberQuery businessTeamMemberQuery = new BusinessTeamMemberQuery();
            businessTeamMemberQuery.setObjectIdList(partnerIdList);
            businessTeamMemberQuery.setMemberRole(BusinessTeamRoleEnum.SERVICE_MANAGER.getCode());
            List businessTeamMemberVOS = this.businessTeamMemberService.queryListDynamic(businessTeamMemberQuery);
            Map<Long, List<BusinessTeamMemberVO>> teamMemberVOMap = businessTeamMemberVOS.stream().collect(Collectors.groupingBy(BusinessTeamMemberVO::getObjectId));
            businessConfirmedCustomerVOPagingVO.stream().forEach(p -> {
                StringBuilder str = new StringBuilder();
                if (p.getProvinceName() != null) {
                    str.append(p.getProvinceName() + "/");
                }
                if (p.getCityName() != null) {
                    str.append(p.getCityName() + "/");
                }
                if (p.getDistrictName() != null) {
                    str.append(p.getDistrictName());
                }
                p.setAddress(str.toString());
                if (!CollectionUtils.isEmpty((Map)teamMemberVOMap) && teamMemberVOMap.containsKey(p.getPartnerId())) {
                    p.setServiceUserId(((BusinessTeamMemberVO)((List)teamMemberVOMap.get(p.getPartnerId())).get(0)).getUserId());
                    p.setServiceUserName(((BusinessTeamMemberVO)((List)teamMemberVOMap.get(p.getPartnerId())).get(0)).getMemberName());
                }
            });
        }
        return businessConfirmedCustomerVOPagingVO;
    }

    public Long countConfirmedCustomer() {
        return this.businessPartnerDAO.countConfirmedCustomer();
    }

    @Transactional(rollbackFor={Exception.class})
    public void updateConfirmedCustomer(CommonKeysPayload payload) {
        if (payload == null || CollectionUtils.isEmpty((Collection)payload.getKeys())) {
            throw TwException.error("", "\u8bf7\u9009\u62e9\u6570\u636e");
        }
        this.businessPartnerDAO.updateConfirmedCustomer(payload.getKeys());
    }

    public void updateBusinessParnerModifyTime(List<Long> bookIdList) {
        this.businessPartnerDAO.updateBusinessParnerModifyTime(bookIdList);
    }

    public Map<Long, String> findNameByBookIds(List<Long> bookIdList) {
        List<Tuple> list;
        List collect;
        HashMap<Long, String> resultMap = new HashMap<Long, String>();
        if (!(CollectionUtils.isEmpty(bookIdList) || CollectionUtils.isEmpty(collect = bookIdList.stream().filter(p -> p != null).collect(Collectors.toList())) || CollectionUtils.isEmpty(list = this.businessPartnerDAO.findNameByBookIds(bookIdList)))) {
            for (Tuple tuple : list) {
                resultMap.put((Long)tuple.get(0, Long.class), (String)tuple.get(1, String.class));
            }
        }
        return resultMap;
    }

    public List<BusinessPartnerListInfoVO> findListInfoByBookIds(List<Long> bookIdList) {
        List<Tuple> nameByBookIds = this.businessPartnerDAO.findNameByBookIds(bookIdList);
        if (CollectionUtils.isEmpty(nameByBookIds)) {
            return null;
        }
        Map bookAddressVOMap = this.bookAccountService.queryByBookIdList(bookIdList);
        return nameByBookIds.stream().map(tuple -> {
            BusinessPartnerListInfoVO businessPartnerListInfoVO = new BusinessPartnerListInfoVO();
            businessPartnerListInfoVO.setBookId((Long)tuple.get(0, Long.class));
            businessPartnerListInfoVO.setPartnerName((String)tuple.get(1, String.class));
            businessPartnerListInfoVO.setBookAccountVOList((List)bookAddressVOMap.get(tuple.get(0, Long.class)));
            return businessPartnerListInfoVO;
        }).collect(Collectors.toList());
    }

    public List<BusinessPartnerVO> queryByBookIdsAndType(List<Long> bookIds, String insideOrOutside) {
        return this.businessPartnerDAO.queryByBookIdsAndType(bookIds, insideOrOutside);
    }

    public void dealSaveBusinessPartner(BusinessPartnerPayload payload, BusinessPartnerDO entityDo) {
        BusinessTeamMemberPayload businessTeamMemberPayload;
        Long orgId;
        Long id = entityDo.getId();
        ArrayList<BusinessTeamMemberPayload> payloadList = new ArrayList<BusinessTeamMemberPayload>();
        Long loginUserId = GlobalUtil.getLoginUserId();
        String userName = this.cacheUtil.getUserName(GlobalUtil.getLoginUserId());
        if (payload.getId() != null) {
            List userIdcollect;
            List businessTeamMemberVOS = this.businessTeamMemberService.queryByObjectIdAndRole(id, BusinessTeamRoleEnum.CREATOR.getCode());
            if (!CollectionUtils.isEmpty((Collection)businessTeamMemberVOS) && !(userIdcollect = businessTeamMemberVOS.stream().map(p -> p.getUserId()).collect(Collectors.toList())).contains(GlobalUtil.getLoginUserId())) {
                BusinessTeamMemberPayload businessTeamMemberPayloadCreator = new BusinessTeamMemberPayload();
                businessTeamMemberPayloadCreator.setUserId(loginUserId);
                businessTeamMemberPayloadCreator.setMemberName(userName);
                businessTeamMemberPayloadCreator.setMemberRole(BusinessTeamRoleEnum.CREATOR.getCode());
                businessTeamMemberPayloadCreator.setMemberRoleName(BusinessTeamRoleEnum.CREATOR.getDesc());
                businessTeamMemberPayloadCreator.setObjectId(id);
                businessTeamMemberPayloadCreator.setType(BusinessTeamTypeEnum.PARTNER.getCode());
                businessTeamMemberPayloadCreator.setIsCreator(Boolean.valueOf(true));
                businessTeamMemberPayloadCreator.setSortNo(BusinessTeamRoleEnum.CREATOR.getSortNo());
                businessTeamMemberPayloadCreator.setOrgId(this.cacheUtil.getDefaultOrgIdByUserId(loginUserId));
                payloadList.add(businessTeamMemberPayloadCreator);
            }
        } else {
            BusinessTeamMemberPayload businessTeamMemberPayloadCreator = new BusinessTeamMemberPayload();
            businessTeamMemberPayloadCreator.setUserId(loginUserId);
            businessTeamMemberPayloadCreator.setMemberName(userName);
            businessTeamMemberPayloadCreator.setMemberRole(BusinessTeamRoleEnum.CREATOR.getCode());
            businessTeamMemberPayloadCreator.setMemberRoleName(BusinessTeamRoleEnum.CREATOR.getDesc());
            businessTeamMemberPayloadCreator.setObjectId(id);
            businessTeamMemberPayloadCreator.setType(BusinessTeamTypeEnum.PARTNER.getCode());
            businessTeamMemberPayloadCreator.setIsCreator(Boolean.valueOf(true));
            businessTeamMemberPayloadCreator.setSortNo(BusinessTeamRoleEnum.CREATOR.getSortNo());
            businessTeamMemberPayloadCreator.setOrgId(this.cacheUtil.getDefaultOrgIdByUserId(loginUserId));
            payloadList.add(businessTeamMemberPayloadCreator);
        }
        if (entityDo.getCustomerFlag().booleanValue()) {
            BusinessTeamMemberPayload businessTeamMemberPayload2;
            Long orgId2;
            BusinessCustomerInfoPayload businessCustomerInfoPayload = new BusinessCustomerInfoPayload();
            businessCustomerInfoPayload.setPartnerId(id);
            String customerStatus = BusinessPartnerStatusEnum.CREATE.getCode();
            if (!StringUtils.isEmpty((Object)payload.getCustomerStatus())) {
                customerStatus = payload.getCustomerStatus();
            }
            businessCustomerInfoPayload.setCustomerStatus(customerStatus);
            businessCustomerInfoPayload.setCustomerGradle(payload.getCustomerGradle());
            businessCustomerInfoPayload.setCustomerRegion(payload.getCustomerRegion());
            businessCustomerInfoPayload.setCustomerSource(payload.getCustomerSource());
            businessCustomerInfoPayload.setConfirmFlag(Boolean.valueOf(false));
            businessCustomerInfoPayload.setCustomerStage(BusinessPartnerStageEnum.POTENTIAL.getCode());
            businessCustomerInfoPayload.setNewCustFlag(payload.getNewCustFlag());
            this.businessCustomerInfoService.insert(businessCustomerInfoPayload);
            if (payload.getServiceUserId() != null) {
                orgId2 = this.cacheUtil.getDefaultOrgIdByUserId(payload.getServiceUserId());
                businessTeamMemberPayload2 = new BusinessTeamMemberPayload();
                businessTeamMemberPayload2.setUserId(payload.getServiceUserId());
                businessTeamMemberPayload2.setMemberName(this.cacheUtil.getUserName(payload.getServiceUserId()));
                businessTeamMemberPayload2.setMemberRole(BusinessTeamRoleEnum.SERVICE_MANAGER.getCode());
                businessTeamMemberPayload2.setMemberRoleName(BusinessTeamRoleEnum.SERVICE_MANAGER.getDesc());
                businessTeamMemberPayload2.setObjectId(id);
                businessTeamMemberPayload2.setType(BusinessTeamTypeEnum.PARTNER.getCode());
                businessTeamMemberPayload2.setSortNo(BusinessTeamRoleEnum.SERVICE_MANAGER.getSortNo());
                businessTeamMemberPayload2.setOrgId(orgId2);
                payloadList.add(businessTeamMemberPayload2);
            }
            if (payload.getBusinessUserId() != null) {
                orgId2 = this.cacheUtil.getDefaultOrgIdByUserId(payload.getBusinessUserId());
                businessTeamMemberPayload2 = new BusinessTeamMemberPayload();
                businessTeamMemberPayload2.setUserId(payload.getBusinessUserId());
                businessTeamMemberPayload2.setMemberName(this.cacheUtil.getUserName(payload.getBusinessUserId()));
                businessTeamMemberPayload2.setMemberRole(BusinessTeamRoleEnum.SALE_MANAGER.getCode());
                businessTeamMemberPayload2.setMemberRoleName(BusinessTeamRoleEnum.SALE_MANAGER.getDesc());
                businessTeamMemberPayload2.setObjectId(id);
                businessTeamMemberPayload2.setType(BusinessTeamTypeEnum.PARTNER.getCode());
                businessTeamMemberPayload2.setSortNo(BusinessTeamRoleEnum.SALE_MANAGER.getSortNo());
                businessTeamMemberPayload2.setOrgId(orgId2);
                payloadList.add(businessTeamMemberPayload2);
            }
            if (payload.getCareUserId() != null) {
                orgId2 = this.cacheUtil.getDefaultOrgIdByUserId(payload.getCareUserId());
                businessTeamMemberPayload2 = new BusinessTeamMemberPayload();
                businessTeamMemberPayload2.setUserId(payload.getCareUserId());
                businessTeamMemberPayload2.setMemberName(this.cacheUtil.getUserName(payload.getCareUserId()));
                businessTeamMemberPayload2.setMemberRole(BusinessTeamRoleEnum.CARE.getCode());
                businessTeamMemberPayload2.setMemberRoleName(BusinessTeamRoleEnum.CARE.getDesc());
                businessTeamMemberPayload2.setObjectId(id);
                businessTeamMemberPayload2.setType(BusinessTeamTypeEnum.PARTNER.getCode());
                businessTeamMemberPayload2.setSortNo(BusinessTeamRoleEnum.CARE.getSortNo());
                businessTeamMemberPayload2.setOrgId(orgId2);
                payloadList.add(businessTeamMemberPayload2);
            }
            if (payload.getOperationUserId() != null) {
                orgId2 = this.cacheUtil.getDefaultOrgIdByUserId(payload.getOperationUserId());
                businessTeamMemberPayload2 = new BusinessTeamMemberPayload();
                businessTeamMemberPayload2.setUserId(payload.getOperationUserId());
                businessTeamMemberPayload2.setMemberName(this.cacheUtil.getUserName(payload.getOperationUserId()));
                businessTeamMemberPayload2.setMemberRole(BusinessTeamRoleEnum.OPERATION.getCode());
                businessTeamMemberPayload2.setMemberRoleName(BusinessTeamRoleEnum.OPERATION.getDesc());
                businessTeamMemberPayload2.setObjectId(id);
                businessTeamMemberPayload2.setType(BusinessTeamTypeEnum.PARTNER.getCode());
                businessTeamMemberPayload2.setSortNo(BusinessTeamRoleEnum.OPERATION.getSortNo());
                businessTeamMemberPayload2.setOrgId(orgId2);
                payloadList.add(businessTeamMemberPayload2);
            }
        }
        if (entityDo.getSupplierFlag().booleanValue()) {
            BusinessSupplierInfoPayload businessSupplierInfoPayload = new BusinessSupplierInfoPayload();
            businessSupplierInfoPayload.setPartnerId(id);
            businessSupplierInfoPayload.setSupplierStatus(BusinessPartnerStatusEnum.CREATE.getCode());
            businessSupplierInfoPayload.setSupplierGradle(payload.getSupplierGradle());
            businessSupplierInfoPayload.setSettlementPeriod(payload.getSettlementPeriod());
            businessSupplierInfoPayload.setStartTime(payload.getStartTime());
            businessSupplierInfoPayload.setEndTime(payload.getEndTime());
            businessSupplierInfoPayload.setFileCode1(payload.getFileCode1());
            businessSupplierInfoPayload.setFileCode2(payload.getFileCode2());
            this.businessSupplierInfoService.insert(businessSupplierInfoPayload);
            if (payload.getPurchaseInchargeResId() != null) {
                orgId = this.cacheUtil.getDefaultOrgIdByUserId(payload.getPurchaseInchargeResId());
                businessTeamMemberPayload = new BusinessTeamMemberPayload();
                businessTeamMemberPayload.setUserId(payload.getPurchaseInchargeResId());
                businessTeamMemberPayload.setMemberName(this.cacheUtil.getUserName(payload.getPurchaseInchargeResId()));
                businessTeamMemberPayload.setMemberRole(BusinessTeamRoleEnum.PURCHASE_MANAGER.getCode());
                businessTeamMemberPayload.setMemberRoleName(BusinessTeamRoleEnum.PURCHASE_MANAGER.getDesc());
                businessTeamMemberPayload.setObjectId(id);
                businessTeamMemberPayload.setType(BusinessTeamTypeEnum.PARTNER.getCode());
                businessTeamMemberPayload.setSortNo(BusinessTeamRoleEnum.PURCHASE_MANAGER.getSortNo());
                businessTeamMemberPayload.setOrgId(orgId);
                payloadList.add(businessTeamMemberPayload);
            }
        }
        if (entityDo.getCollaborateFlag().booleanValue()) {
            BusinessCollaboratePartnerInfoPayload businessCollaboratePartnerInfoPayload = new BusinessCollaboratePartnerInfoPayload();
            businessCollaboratePartnerInfoPayload.setCollaborateStatus(BusinessPartnerStatusEnum.CREATE.getCode());
            businessCollaboratePartnerInfoPayload.setPartnerId(id);
            businessCollaboratePartnerInfoPayload.setCollaborateGradle(payload.getCollaborateGradle());
            businessCollaboratePartnerInfoPayload.setCollaborateForm(payload.getCollaborateForm());
            businessCollaboratePartnerInfoPayload.setCollaborateType(payload.getCollaborateType());
            businessCollaboratePartnerInfoPayload.setCollaborateProduct(payload.getCollaborateProduct());
            businessCollaboratePartnerInfoPayload.setCollaborateServiceIndustry(payload.getCollaborateServiceIndustry());
            businessCollaboratePartnerInfoPayload.setCollaborateCustomer(payload.getCollaborateCustomer());
            businessCollaboratePartnerInfoPayload.setServiceCustomerScale(payload.getServiceCustomerScale());
            businessCollaboratePartnerInfoPayload.setCollaborateRegion(payload.getCollaborateRegion());
            businessCollaboratePartnerInfoPayload.setContactPeopleType(payload.getContactPeopleType());
            businessCollaboratePartnerInfoPayload.setChannelUserId(payload.getChannelUserId());
            businessCollaboratePartnerInfoPayload.setBuManageUserId(payload.getBuManageUserId());
            businessCollaboratePartnerInfoPayload.setBuManagePhone(payload.getBuManagePhone());
            businessCollaboratePartnerInfoPayload.setBuManageEmail(payload.getBuManageEmail());
            businessCollaboratePartnerInfoPayload.setCollaborateDescription(payload.getCollaborateDescription());
            businessCollaboratePartnerInfoPayload.setCollaborateTag(payload.getCollaborateTag());
            businessCollaboratePartnerInfoPayload.setCollaborateKeyword(payload.getCollaborateKeyword());
            businessCollaboratePartnerInfoPayload.setFileCodes1(payload.getFileCode3());
            businessCollaboratePartnerInfoPayload.setFileCodes2(payload.getFileCode4());
            businessCollaboratePartnerInfoPayload.setFileCodes3(payload.getFileCode5());
            businessCollaboratePartnerInfoPayload.setStartTime(payload.getCollaborateStartTime());
            businessCollaboratePartnerInfoPayload.setEndTime(payload.getCollaborateEndTime());
            this.businessCollaboratePartnerInfoService.insert(businessCollaboratePartnerInfoPayload);
            if (payload.getChannelUserId() != null) {
                orgId = this.cacheUtil.getDefaultOrgIdByUserId(payload.getChannelUserId());
                businessTeamMemberPayload = new BusinessTeamMemberPayload();
                businessTeamMemberPayload.setUserId(payload.getChannelUserId());
                businessTeamMemberPayload.setMemberName(this.cacheUtil.getUserName(payload.getChannelUserId()));
                businessTeamMemberPayload.setMemberRole(BusinessTeamRoleEnum.CHANNEL_MANAGER.getCode());
                businessTeamMemberPayload.setMemberRoleName(BusinessTeamRoleEnum.CHANNEL_MANAGER.getDesc());
                businessTeamMemberPayload.setObjectId(id);
                businessTeamMemberPayload.setType(BusinessTeamTypeEnum.PARTNER.getCode());
                businessTeamMemberPayload.setSortNo(BusinessTeamRoleEnum.CHANNEL_MANAGER.getSortNo());
                businessTeamMemberPayload.setOrgId(orgId);
                payloadList.add(businessTeamMemberPayload);
            }
        }
        if (!CollectionUtils.isEmpty(payloadList)) {
            this.businessTeamMemberService.saveAll(payloadList);
        }
    }

    public List<BookInvoiceVO> bookInvoiceToVoList(List<BookInvoicePayload> bookInvoicePayloadList) {
        if (bookInvoicePayloadList == null) {
            return null;
        }
        ArrayList<BookInvoiceVO> list = new ArrayList<BookInvoiceVO>(bookInvoicePayloadList.size());
        for (BookInvoicePayload bookInvoicePayload : bookInvoicePayloadList) {
            list.add(this.bookInvoiceToVo(bookInvoicePayload));
        }
        return list;
    }

    public BookInvoiceVO bookInvoiceToVo(BookInvoicePayload ado) {
        if (ado == null) {
            return null;
        }
        BookInvoiceVO bookInvoiceVO = new BookInvoiceVO();
        bookInvoiceVO.setId(ado.getId());
        bookInvoiceVO.setRemark(ado.getRemark());
        bookInvoiceVO.setCreateUserId(ado.getCreateUserId());
        bookInvoiceVO.setCreator(ado.getCreator());
        bookInvoiceVO.setCreateTime(ado.getCreateTime());
        bookInvoiceVO.setModifyUserId(ado.getModifyUserId());
        bookInvoiceVO.setModifyTime(ado.getModifyTime());
        bookInvoiceVO.setDeleteFlag(ado.getDeleteFlag());
        bookInvoiceVO.setBookId(ado.getBookId());
        bookInvoiceVO.setInvoiceMessage(ado.getInvoiceMessage());
        bookInvoiceVO.setInvoiceTitle(ado.getInvoiceTitle());
        bookInvoiceVO.setTaxRete(ado.getTaxRete());
        bookInvoiceVO.setTaxNo(ado.getTaxNo());
        bookInvoiceVO.setInvoiceType(ado.getInvoiceType());
        bookInvoiceVO.setInvoiceAddress(ado.getInvoiceAddress());
        bookInvoiceVO.setInvoicePhone(ado.getInvoicePhone());
        bookInvoiceVO.setDepositBank(ado.getDepositBank());
        bookInvoiceVO.setInvoiceAccount(ado.getInvoiceAccount());
        bookInvoiceVO.setCurrency(ado.getCurrency());
        bookInvoiceVO.setIsDefault(ado.getIsDefault());
        return bookInvoiceVO;
    }

    public List<BookAccountVO> bookAccountToVOList(List<BookAccountPayload> bookAccountPayloadList) {
        if (bookAccountPayloadList == null) {
            return null;
        }
        ArrayList<BookAccountVO> list = new ArrayList<BookAccountVO>(bookAccountPayloadList.size());
        for (BookAccountPayload bookAccountPayload : bookAccountPayloadList) {
            list.add(this.bookAcountToVo(bookAccountPayload));
        }
        return list;
    }

    public BookAccountVO bookAcountToVo(BookAccountPayload ado) {
        if (ado == null) {
            return null;
        }
        BookAccountVO bookAccountVO = new BookAccountVO();
        bookAccountVO.setId(ado.getId());
        bookAccountVO.setRemark(ado.getRemark());
        bookAccountVO.setCreateUserId(ado.getCreateUserId());
        bookAccountVO.setCreator(ado.getCreator());
        bookAccountVO.setCreateTime(ado.getCreateTime());
        bookAccountVO.setModifyUserId(ado.getModifyUserId());
        bookAccountVO.setModifyTime(ado.getModifyTime());
        bookAccountVO.setDeleteFlag(ado.getDeleteFlag());
        bookAccountVO.setBookId(ado.getBookId());
        bookAccountVO.setAccountType(ado.getAccountType());
        bookAccountVO.setAccountUsage(ado.getAccountUsage());
        bookAccountVO.setDepositBank(ado.getDepositBank());
        bookAccountVO.setDepositCity(ado.getDepositCity());
        bookAccountVO.setDepositBankOutlet(ado.getDepositBankOutlet());
        bookAccountVO.setAccountName(ado.getAccountName());
        bookAccountVO.setAccountNo(ado.getAccountNo());
        bookAccountVO.setCurrency(ado.getCurrency());
        bookAccountVO.setIsDefault(ado.getIsDefault());
        return bookAccountVO;
    }

    public void dataPermission(BusinessPartnerQuery query) {
        long userId = GlobalUtil.getLoginUserId();
        Boolean rolePermission = this.cacheUtil.hasSystemRolePermission(Arrays.asList(RoleEnum.SYS.getCode(), RoleEnum.OPS.getCode(), RoleEnum.FINANCE_MEMBER.getCode(), RoleEnum.BUSINESS_PARTNER_MANAGER.getCode(), RoleEnum.PLAT_ALL_PIC.getCode(), RoleEnum.PLAT_BUSINESS_PIC.getCode()));
        query.setPermissionFlag(Boolean.valueOf(rolePermission == false));
        if (!rolePermission.booleanValue()) {
            query.setLoginUserId(Long.valueOf(userId));
        }
    }

    public void assembleCrmCustomerPayload(BusinessPartnerPayload payload, PrdAbPayload prdAbPayload) {
        prdAbPayload.setCustomerStatus(BusinessPartnerStatusEnum.ACTIVE.getCode());
        prdAbPayload.setCustomerName(payload.getPartnerName());
        prdAbPayload.setCustomerGrade(payload.getCustomerGradle());
        prdAbPayload.setCustomerSource(payload.getCustomerSource());
        prdAbPayload.setCompanyIndustry(payload.getPartnerIndustry());
        prdAbPayload.setCompanyPhone(payload.getPartnerPhone());
        prdAbPayload.setCompanyEmail(payload.getPartnerEmail());
        prdAbPayload.setCompanyFax(payload.getPartnerFax());
        prdAbPayload.setProvince(payload.getProvince());
        prdAbPayload.setProvinceName(payload.getProvinceName());
        prdAbPayload.setCity(payload.getCity());
        prdAbPayload.setCityName(payload.getCityName());
        prdAbPayload.setDistrict(payload.getDistrict());
        prdAbPayload.setDistrictName(payload.getDistrictName());
        prdAbPayload.setCompanyAddress(payload.getDetailAddress());
        prdAbPayload.setCompanyWebsite(payload.getPartnerWebsite());
        prdAbPayload.setCompanyScale(CustomerScaleEnum.valueOf(payload.getOrganizationScale()).getTw4Code());
        prdAbPayload.setCurrency(payload.getCurrency());
        prdAbPayload.setLanguage(payload.getLanguage());
        prdAbPayload.setCompanyNature(payload.getPartnerNature());
        prdAbPayload.setServiceUserId(payload.getServiceUserId());
        prdAbPayload.setBusinessUserId(payload.getBusinessUserId());
        prdAbPayload.setCareUserId(payload.getCareUserId());
        prdAbPayload.setOperationUserId(payload.getOperationUserId());
    }

    public void syncTw4Translate(BusinessPartnerMainSyncVO vo, Map<String, List<BusinessTeamMemberVO>> teamMap, Map<Long, List<PrdOrgEmployeeVO>> tw4UserIdMap) {
        List<BusinessTeamMemberVO> businessTeamMemberVOS;
        Long id = vo.getId();
        if (teamMap.containsKey(id) && !CollectionUtils.isEmpty(businessTeamMemberVOS = teamMap.get(id))) {
            Long userId;
            Map<String, List<BusinessTeamMemberVO>> listMap = businessTeamMemberVOS.stream().collect(Collectors.groupingBy(BusinessTeamMemberVO::getMemberRole));
            if (listMap.containsKey(BusinessTeamRoleEnum.SALE_MANAGER.getCode())) {
                userId = listMap.get(BusinessTeamRoleEnum.SALE_MANAGER.getCode()).get(0).getUserId();
                vo.setBusinessUserId(tw4UserIdMap.get(userId).get(0).getUserIdV4());
            }
            if (listMap.containsKey(BusinessTeamRoleEnum.SERVICE_MANAGER.getCode())) {
                userId = listMap.get(BusinessTeamRoleEnum.SERVICE_MANAGER.getCode()).get(0).getUserId();
                vo.setServiceUserId(tw4UserIdMap.get(userId).get(0).getUserIdV4());
            }
            if (listMap.containsKey(BusinessTeamRoleEnum.CARE.getCode())) {
                userId = listMap.get(BusinessTeamRoleEnum.CARE.getCode()).get(0).getUserId();
                vo.setCareUserId(tw4UserIdMap.get(userId).get(0).getUserIdV4());
            }
            if (listMap.containsKey(BusinessTeamRoleEnum.OPERATION.getCode())) {
                userId = listMap.get(BusinessTeamRoleEnum.OPERATION.getCode()).get(0).getUserId();
                vo.setOperationUserId(tw4UserIdMap.get(userId).get(0).getUserIdV4());
            }
        }
        vo.setRelateType(this.translateTw4Identity(vo.getRelateType()));
        if (BusinessPartnerTypeEnum.ORGANIZATION.getCode().equals(vo.getAbType())) {
            vo.setAbType("02");
        } else {
            vo.setAbType("01");
        }
        if (StringUtils.hasText((String)vo.getCompanyScale())) {
            vo.setCompanyScale(CustomerScaleEnum.valueOf(vo.getCompanyScale()).getTw4Code());
        }
        if (StringUtils.hasText((String)vo.getCustomerStatus())) {
            vo.setCustomerStatus(BusinessPartnerStatusEnum.valueOf(vo.getCustomerStatus()).getTw4Code());
        }
        if (StringUtils.hasText((String)vo.getInnerType())) {
            vo.setInnerType(BusinessInsideOrOutSideEnum.valueOf(vo.getInnerType()).getTw4Code());
        }
    }

    public int queryContractNum(Long custId) {
        return this.businessPartnerRepo.queryContractNum(custId);
    }

    public List<CrmFollowVO> queryFollowList(Long customerId, Boolean withAcitityFollows) {
        List<Long> activiyProjIds;
        List<Long> actIds;
        ArrayList<Object> followVOS = new ArrayList<Object>();
        List<Long> leadIds = this.crmLeadsDAO.queryByFormalCustomerId(customerId);
        List<Long> oppoIds = this.crmOpportunityDAO.queryByFormalCustomerId(customerId);
        List<CrmFollowDO> leadsFollowDos = this.crmFollowDAO.queryByObjectIdsAndObjectType(leadIds, CrmFollowObjectEnum.Leads.getCode());
        followVOS.addAll(this.followService.toListVo(CrmFollowObjectEnum.Leads, leadsFollowDos));
        List<CrmFollowDO> oppoFollowDos = this.crmFollowDAO.queryByObjectIdsAndObjectType(oppoIds, CrmFollowObjectEnum.Opportunity.getCode());
        followVOS.addAll(this.followService.toListVo(CrmFollowObjectEnum.Opportunity, oppoFollowDos));
        if (withAcitityFollows != null && withAcitityFollows.booleanValue() && (actIds = this.actActivityDAO.queryByIds(activiyProjIds = this.actActivityDAO.queryByLeadsIds(leadIds))) != null && !actIds.isEmpty()) {
            ArrayList<CrmFollowVO> activityFollowVOS = new ArrayList<CrmFollowVO>();
            List<CrmActDynamicVO> dynamicVOS = this.actActivityDAO.queryActDynamicByPrjIds(actIds);
            for (CrmActDynamicVO dynamicVO : dynamicVOS) {
                CrmFollowVO followVO = new CrmFollowVO();
                followVO.setCreateTime(dynamicVO.getCreateTime());
                followVO.setCreateUserId(dynamicVO.getCreateUserId());
                followVO.setCreateUserName(dynamicVO.getEmployeeName());
                followVO.setFollowContent(dynamicVO.getDynamicContent());
                followVO.setFollowObject("activity");
                followVO.setFollowObjectDesc("\u5e02\u573a\u6d3b\u52a8");
                followVO.setFollowType(dynamicVO.getDynamicType());
                followVO.setFollowTypeDesc(dynamicVO.getDynamicTypeName());
                followVO.setId(dynamicVO.getId());
                followVO.setModifyTime(dynamicVO.getModifyTime());
                followVO.setModifyUserId(dynamicVO.getModifyUserId());
                activityFollowVOS.add(followVO);
            }
            followVOS.addAll(activityFollowVOS);
        }
        List<CrmFollowVO> collect = followVOS.stream().sorted((u1, u2) -> u1.getCreateTime().compareTo(u2.getCreateTime())).collect(Collectors.toList());
        return collect;
    }

    @Transactional
    public void updateAccAndInvoice2(BusinessPartnerChangeVO vo) {
        List bookAccountVOList;
        BusinessPartnerVO businessPartnerVO = vo.getBusinessPartnerVO();
        if (businessPartnerVO == null) {
            businessPartnerVO = this.queryByKey(vo.getId());
        }
        Long bookId = businessPartnerVO.getBookId();
        List bookInvoiceVOList = vo.getBookInvoiceVOList();
        if (!CollectionUtils.isEmpty((Collection)bookInvoiceVOList)) {
            List collect = bookInvoiceVOList.stream().filter(p -> p.getIsDefault() != null && p.getIsDefault().equals(true)).collect(Collectors.toList());
            if (CollectionUtils.isEmpty(collect)) {
                collect.stream().forEach(p -> p.setIsDefault(Boolean.valueOf(false)));
                ((BookInvoiceVO)bookInvoiceVOList.get(0)).setIsDefault(Boolean.valueOf(true));
            } else {
                if (collect.size() > 1) {
                    throw TwException.error("", "\u53d1\u7968\u4fe1\u606f\u4e0d\u80fd\u63d0\u4ea4\u591a\u6761\u9ed8\u8ba4\u7684\u6570\u636e");
                }
                List collectFalse = bookInvoiceVOList.stream().filter(p -> p.getIsDefault() == null || p.getIsDefault() == false).collect(Collectors.toList());
                if (!CollectionUtils.isEmpty(collectFalse)) {
                    collectFalse.stream().forEach(p -> p.setIsDefault(Boolean.valueOf(false)));
                }
            }
            BookInvoiceQuery query = new BookInvoiceQuery();
            query.setBookId(bookId);
            List olBookInvoiceVOS = this.bookInvoiceService.queryListDynamic(query);
            if (!CollectionUtils.isEmpty((Collection)olBookInvoiceVOS)) {
                Map<Long, List<BookInvoiceVO>> newBookInvoiceMap = bookInvoiceVOList.stream().filter(p -> p.getId() != null).collect(Collectors.groupingBy(BaseViewModel::getId));
                ArrayList deleteIdList = new ArrayList();
                olBookInvoiceVOS.stream().forEach(p -> {
                    if (!newBookInvoiceMap.containsKey(p.getId())) {
                        deleteIdList.add(p.getId());
                    }
                });
                if (!CollectionUtils.isEmpty(deleteIdList)) {
                    this.bookInvoiceService.deleteSoftBykeys(deleteIdList, bookId, businessPartnerVO.getId());
                }
            }
            bookInvoiceVOList.stream().forEach(p -> {
                if (p.getId() == null) {
                    p.setBookId(bookId);
                }
            });
            this.bookInvoiceService.saveAll(bookInvoiceVOList);
        }
        if (!CollectionUtils.isEmpty((Collection)(bookAccountVOList = vo.getBookAccountVOList()))) {
            List collect = bookAccountVOList.stream().filter(p -> p.getIsDefault() != null && p.getIsDefault().equals(true)).collect(Collectors.toList());
            if (CollectionUtils.isEmpty(collect)) {
                collect.stream().forEach(p -> p.setIsDefault(Boolean.valueOf(false)));
                ((BookAccountVO)bookAccountVOList.get(0)).setIsDefault(Boolean.valueOf(true));
            } else {
                if (collect.size() > 1) {
                    throw TwException.error("", "\u94f6\u884c\u4fe1\u606f\u4e0d\u80fd\u63d0\u4ea4\u591a\u6761\u9ed8\u8ba4\u7684\u6570\u636e");
                }
                List collectFalse = bookAccountVOList.stream().filter(p -> p.getIsDefault() == null || p.getIsDefault() == false).collect(Collectors.toList());
                if (!CollectionUtils.isEmpty(collectFalse)) {
                    collectFalse.stream().forEach(p -> p.setIsDefault(Boolean.valueOf(false)));
                }
            }
            BookAccountQuery query = new BookAccountQuery();
            query.setBookId(bookId);
            List oldBookAccountVOVOS = this.bookAccountService.queryListDynamic(query);
            if (!CollectionUtils.isEmpty((Collection)oldBookAccountVOVOS)) {
                Map<Long, List<BookAccountVO>> newBookAccountMap = bookAccountVOList.stream().filter(p -> p.getId() != null).collect(Collectors.groupingBy(BaseViewModel::getId));
                ArrayList deleteIdList = new ArrayList();
                oldBookAccountVOVOS.stream().forEach(p -> {
                    if (!newBookAccountMap.containsKey(p.getId())) {
                        deleteIdList.add(p.getId());
                    }
                });
                if (!CollectionUtils.isEmpty(deleteIdList)) {
                    this.bookAccountService.deleteSoftBykeys(deleteIdList, bookId, businessPartnerVO.getId());
                }
            }
            bookAccountVOList.stream().forEach(p -> {
                if (p.getId() == null) {
                    p.setBookId(bookId);
                }
            });
            this.bookAccountService.saveAll(bookAccountVOList);
        }
    }

    public Boolean checkExitInvices(Long bookId) {
        Assert.notNull((Object)bookId, (String)"bookId\u4e0d\u80fd\u4e3a\u7a7a");
        Integer count = 0;
        BookInvoiceQuery bookInvoiceQuery = new BookInvoiceQuery();
        bookInvoiceQuery.setBookId(bookId);
        Long count1 = this.bookInvoiceService.count(bookInvoiceQuery);
        if (count1 > 0L) {
            return true;
        }
        List<BusinessPartnerVO> businessPartnerVOS = this.queryByBookId(bookId);
        if (CollectionUtils.isEmpty(businessPartnerVOS)) {
            return false;
        }
        BusinessPartnerVO businessPartnerVO = businessPartnerVOS.get(0);
        if (StrUtil.isNotBlank((CharSequence)businessPartnerVO.getApplyStatus()) && businessPartnerVO.getApplyStatus().equals(BusinessPartnerStatusEnum.APPROVING.getCode())) {
            return true;
        }
        BusinessCustomerInfoVO businessCustomerInfoVO = this.businessCustomerInfoService.queryByPartnerId(businessPartnerVO.getId());
        if (businessCustomerInfoVO != null && businessCustomerInfoVO.getCustomerStatus().equals(BusinessPartnerStatusEnum.APPROVING.getCode())) {
            return true;
        }
        return false;
    }

    public BusinessPartnerServiceImpl(BusinessPartnerRepo businessPartnerRepo, BusinessPartnerDAO businessPartnerDAO, AddressBookService addressBookService, BookAddressService bookAddressService, BookContactsService bookContactsService, BookAccountService bookAccountService, BookInvoiceService bookInvoiceService, ChangeFieldLogUtil changeFieldLogUtil, PrdSystemLogService logService, BusinessTeamMemberService businessTeamMemberService, BusinessCustomerInfoService businessCustomerInfoService, BusinessSupplierInfoService businessSupplierInfoService, BusinessCollaboratePartnerInfoService businessCollaboratePartnerInfoService, CacheUtil cacheUtil, BusinessCustomerInfoRepo businessCustomerInfoRepo, BusinessSupplierInfoRepo businessSupplierInfoRepo, BusinessCollaboratePartnerInfoRepo businessCollaboratePartnerInfoRepo, BusinessDistributorInfoRepo businessDistributorInfoRepo, UdcUtil udcUtil, WorkflowUtil workflowUtil, PrdOrgOrganizationDAO daoOrg, PrdOrgEmployeeDAO employeeDAO, TransactionUtilService transactionUtilService, ComChangeService changeService, HttpUtil httpUtil, TransferUtilServiceImpl transferUtilService, TransferUtilDAO transferUtilDAO, CrmLeadsDAO crmLeadsDAO, CrmOpportunityDAO crmOpportunityDAO, CrmFollowDAO crmFollowDAO, CrmFollowServiceImpl followService, CrmActActivityDAO actActivityDAO) {
        this.businessPartnerRepo = businessPartnerRepo;
        this.businessPartnerDAO = businessPartnerDAO;
        this.addressBookService = addressBookService;
        this.bookAddressService = bookAddressService;
        this.bookContactsService = bookContactsService;
        this.bookAccountService = bookAccountService;
        this.bookInvoiceService = bookInvoiceService;
        this.changeFieldLogUtil = changeFieldLogUtil;
        this.logService = logService;
        this.businessTeamMemberService = businessTeamMemberService;
        this.businessCustomerInfoService = businessCustomerInfoService;
        this.businessSupplierInfoService = businessSupplierInfoService;
        this.businessCollaboratePartnerInfoService = businessCollaboratePartnerInfoService;
        this.cacheUtil = cacheUtil;
        this.businessCustomerInfoRepo = businessCustomerInfoRepo;
        this.businessSupplierInfoRepo = businessSupplierInfoRepo;
        this.businessCollaboratePartnerInfoRepo = businessCollaboratePartnerInfoRepo;
        this.businessDistributorInfoRepo = businessDistributorInfoRepo;
        this.udcUtil = udcUtil;
        this.workflowUtil = workflowUtil;
        this.daoOrg = daoOrg;
        this.employeeDAO = employeeDAO;
        this.transactionUtilService = transactionUtilService;
        this.changeService = changeService;
        this.httpUtil = httpUtil;
        this.transferUtilService = transferUtilService;
        this.transferUtilDAO = transferUtilDAO;
        this.crmLeadsDAO = crmLeadsDAO;
        this.crmOpportunityDAO = crmOpportunityDAO;
        this.crmFollowDAO = crmFollowDAO;
        this.followService = followService;
        this.actActivityDAO = actActivityDAO;
    }
}

