/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5.server.prd.partner.strategy.service;

import com.elitescloud.boot.core.base.BaseServiceImpl;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.partner.strategy.payload.BusinessModelIndexPayload;
import com.elitesland.tw.tw5.api.prd.partner.strategy.query.BusinessModelIndexQuery;
import com.elitesland.tw.tw5.api.prd.partner.strategy.service.BusinessModelIndexService;
import com.elitesland.tw.tw5.api.prd.partner.strategy.vo.BusinessModelIndexVO;
import com.elitesland.tw.tw5.server.prd.partner.strategy.convert.BusinessModelIndexConvert;
import com.elitesland.tw.tw5.server.prd.partner.strategy.dao.BusinessModelIndexDAO;
import com.elitesland.tw.tw5.server.prd.partner.strategy.entity.BusinessModelIndexDO;
import com.elitesland.tw.tw5.server.prd.partner.strategy.repo.BusinessModelIndexRepo;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

@Service
public class BusinessModelIndexServiceImpl
extends BaseServiceImpl
implements BusinessModelIndexService {
    private static final Logger log = LoggerFactory.getLogger(BusinessModelIndexServiceImpl.class);
    private final BusinessModelIndexRepo businessModelIndexRepo;
    private final BusinessModelIndexDAO businessModelIndexDAO;

    public PagingVO<BusinessModelIndexVO> queryPaging(BusinessModelIndexQuery query) {
        return this.businessModelIndexDAO.queryPaging(query);
    }

    public List<BusinessModelIndexVO> queryListDynamic(BusinessModelIndexQuery query) {
        return this.businessModelIndexDAO.queryListDynamic(query);
    }

    public BusinessModelIndexVO queryByKey(Long key) {
        BusinessModelIndexDO entity = this.businessModelIndexRepo.findById(key).orElseGet(BusinessModelIndexDO::new);
        Assert.notNull((Object)entity.getId(), (String)"\u4e0d\u5b58\u5728");
        BusinessModelIndexVO vo = BusinessModelIndexConvert.INSTANCE.toVo(entity);
        return vo;
    }

    @Transactional(rollbackFor={Exception.class})
    public BusinessModelIndexVO insert(BusinessModelIndexPayload payload) {
        BusinessModelIndexDO entityDo = BusinessModelIndexConvert.INSTANCE.toDo(payload);
        return BusinessModelIndexConvert.INSTANCE.toVo((BusinessModelIndexDO)this.businessModelIndexRepo.save(entityDo));
    }

    @Transactional(rollbackFor={Exception.class})
    public BusinessModelIndexVO update(BusinessModelIndexPayload payload) {
        BusinessModelIndexDO entity = this.businessModelIndexRepo.findById(payload.getId()).orElseGet(BusinessModelIndexDO::new);
        Assert.notNull((Object)entity.getId(), (String)"\u4e0d\u5b58\u5728");
        BusinessModelIndexDO entityDo = BusinessModelIndexConvert.INSTANCE.toDo(payload);
        entity.copy(entityDo);
        return BusinessModelIndexConvert.INSTANCE.toVo((BusinessModelIndexDO)this.businessModelIndexRepo.save(entity));
    }

    @Transactional(rollbackFor={Exception.class})
    public long updateByKeyDynamic(BusinessModelIndexPayload payload) {
        BusinessModelIndexDO entity = this.businessModelIndexRepo.findById(payload.getId()).orElseGet(BusinessModelIndexDO::new);
        Assert.notNull((Object)entity.getId(), (String)"\u4e0d\u5b58\u5728");
        long result = this.businessModelIndexDAO.updateByKeyDynamic(payload);
        return result;
    }

    @Transactional(rollbackFor={Exception.class})
    public void deleteSoft(List<Long> keys) {
        if (!keys.isEmpty()) {
            this.businessModelIndexDAO.deleteSoft(keys);
        }
    }

    @Transactional(rollbackFor={Exception.class})
    public void deleteSoftByModelId(Long modelId) {
        this.businessModelIndexDAO.deleteSoftByModelId(modelId);
    }

    public BusinessModelIndexServiceImpl(BusinessModelIndexRepo businessModelIndexRepo, BusinessModelIndexDAO businessModelIndexDAO) {
        this.businessModelIndexRepo = businessModelIndexRepo;
        this.businessModelIndexDAO = businessModelIndexDAO;
    }
}

