/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5.server.prd.pms.service;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.pms.service.PmsConContractService;
import com.elitesland.tw.tw5.api.prd.salecon.query.SaleConContractQuery;
import com.elitesland.tw.tw5.api.prd.salecon.vo.SaleConContractVO;
import com.elitesland.tw.tw5.api.prd.system.vo.PrdSystemSelectionVO;
import com.elitesland.tw.tw5.server.prd.common.CacheUtil;
import com.elitesland.tw.tw5.server.prd.common.functionEnum.RoleEnum;
import com.elitesland.tw.tw5.server.prd.pms.dao.PmsConContractDAO;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class PmsConContractServiceImpl
implements PmsConContractService {
    private static final Logger log = LoggerFactory.getLogger(PmsConContractServiceImpl.class);
    private final PmsConContractDAO pmsConContractDAO;
    private final CacheUtil cacheUtil;

    public PagingVO<SaleConContractVO> findCountByCustProp(SaleConContractQuery query) {
        ArrayList custPropList = new ArrayList();
        PrdSystemSelectionVO systemSelection = this.cacheUtil.getSystemSelection("crm:company_nature");
        List children = systemSelection.getChildren();
        if (this.cacheUtil.hasSystemRolePermission(Arrays.asList(RoleEnum.A_CUST_NATURE.getCode())).booleanValue()) {
            children.forEach(item -> {
                if (item.getExtString1().equals(RoleEnum.A_CUST_NATURE.getCode())) {
                    custPropList.add(item.getSelectionValue());
                }
            });
        }
        if (this.cacheUtil.hasSystemRolePermission(Arrays.asList(RoleEnum.B_CUST_NATURE.getCode())).booleanValue()) {
            children.forEach(item -> {
                if (item.getExtString1().equals(RoleEnum.B_CUST_NATURE.getCode())) {
                    custPropList.add(item.getSelectionValue());
                }
            });
        }
        query.setCustPropList(custPropList);
        return this.pmsConContractDAO.queryPaging(query);
    }

    public long findCountByCustProp(List<String> custPropList) {
        SaleConContractQuery query = new SaleConContractQuery();
        query.setCustPropList(custPropList);
        return this.pmsConContractDAO.count(query);
    }

    public PmsConContractServiceImpl(PmsConContractDAO pmsConContractDAO, CacheUtil cacheUtil) {
        this.pmsConContractDAO = pmsConContractDAO;
        this.cacheUtil = cacheUtil;
    }
}

