/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5.server.prd.salecon.dao;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.common.TwQueryParam;
import com.elitesland.tw.tw5.api.prd.salecon.payload.ConReceivablePayload;
import com.elitesland.tw.tw5.api.prd.salecon.query.ConReceivableQuery;
import com.elitesland.tw.tw5.api.prd.salecon.vo.ConReceivableVO;
import com.elitesland.tw.tw5.server.common.util.SqlUtil;
import com.elitesland.tw.tw5.server.prd.salecon.entity.ConReceivableDO;
import com.elitesland.tw.tw5.server.prd.salecon.entity.QConReceivableDO;
import com.elitesland.tw.tw5.server.prd.salecon.repo.ConReceivableRepo;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.core.types.dsl.BooleanExpression;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import com.querydsl.jpa.impl.JPAUpdateClause;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.List;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.ObjectUtils;

@Repository
public class ConReceivableDAO {
    private final JPAQueryFactory jpaQueryFactory;
    private final ConReceivableRepo repo;
    private final QConReceivableDO qdo = QConReceivableDO.conReceivableDO;

    private JPAQuery<ConReceivableVO> getJpaQuerySelect() {
        return (JPAQuery)this.jpaQueryFactory.select((Expression)Projections.bean(ConReceivableVO.class, (Expression[])new Expression[]{this.qdo.id, this.qdo.recvNo, this.qdo.recvClass, this.qdo.sourceId, this.qdo.recvAmt, this.qdo.recvDate, this.qdo.accountNo, this.qdo.ledgerDate, this.qdo.bookAccountId})).from((EntityPath)this.qdo);
    }

    private JPAQuery<ConReceivableVO> getJpaQueryWhere(ConReceivableQuery query) {
        JPAQuery<ConReceivableVO> jpaQuery = this.getJpaQuerySelect();
        jpaQuery.where(this.where(query));
        SqlUtil.handleCommonJpaQuery(jpaQuery, this.qdo._super, (TwQueryParam)query);
        jpaQuery.orderBy(SqlUtil.getSortedColumn(this.qdo, query.getOrders()));
        return jpaQuery;
    }

    public long count(ConReceivableQuery query) {
        JPAQuery jpaQuery = (JPAQuery)this.jpaQueryFactory.select((Expression)this.qdo.count()).from((EntityPath)this.qdo);
        jpaQuery.where(this.where(query));
        SqlUtil.handleCommonJpaQuery(jpaQuery, this.qdo._super, (TwQueryParam)query);
        long total = (Long)jpaQuery.fetchOne();
        return total;
    }

    private Predicate where(ConReceivableQuery query) {
        ArrayList<BooleanExpression> list = new ArrayList<BooleanExpression>();
        if (!ObjectUtils.isEmpty((Object)query.getId())) {
            list.add(this.qdo.id.eq((Object)query.getId()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getRecvNo())) {
            list.add(this.qdo.recvNo.eq((Object)query.getRecvNo()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getRecvClass())) {
            list.add(this.qdo.recvClass.eq((Object)query.getRecvClass()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getSourceId())) {
            list.add(this.qdo.sourceId.eq((Object)query.getSourceId()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getRecvAmt())) {
            list.add(this.qdo.recvAmt.eq((Object)query.getRecvAmt()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getRecvDate())) {
            list.add(this.qdo.recvDate.eq((Object)query.getRecvDate()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getAccountNo())) {
            list.add(this.qdo.accountNo.eq((Object)query.getAccountNo()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getLedgerDate())) {
            list.add(this.qdo.ledgerDate.eq((Object)query.getLedgerDate()));
        }
        return ExpressionUtils.allOf(list);
    }

    public ConReceivableVO queryByKey(Long id) {
        JPAQuery<ConReceivableVO> jpaQuery = this.getJpaQuerySelect();
        jpaQuery.where((Predicate)this.qdo.id.eq((Object)id));
        jpaQuery.where((Predicate)this.qdo.deleteFlag.eq((Object)0));
        return (ConReceivableVO)jpaQuery.fetchFirst();
    }

    public List<ConReceivableVO> queryListDynamic(ConReceivableQuery query) {
        JPAQuery<ConReceivableVO> jpaQuery = this.getJpaQueryWhere(query);
        return jpaQuery.fetch();
    }

    public PagingVO<ConReceivableVO> queryPaging(ConReceivableQuery query) {
        long total = this.count(query);
        if (total == 0L) {
            return PagingVO.empty();
        }
        JPAQuery<ConReceivableVO> jpaQuery = this.getJpaQueryWhere(query);
        List result = ((JPAQuery)((JPAQuery)jpaQuery.offset(query.getPageRequest().getOffset())).limit((long)query.getPageRequest().getPageSize())).fetch();
        return PagingVO.builder().records(result).total(total).build();
    }

    public ConReceivableDO save(ConReceivableDO ado) {
        return (ConReceivableDO)this.repo.save(ado);
    }

    public List<ConReceivableDO> saveAll(List<ConReceivableDO> dos) {
        return this.repo.saveAll(dos);
    }

    @Transactional
    public long updateByKeyDynamic(ConReceivablePayload payload) {
        List nullFields;
        JPAUpdateClause update = this.jpaQueryFactory.update((EntityPath)this.qdo).where(new Predicate[]{this.qdo.id.eq((Object)payload.getId())});
        if (payload.getId() != null) {
            update.set(this.qdo.id, (Object)payload.getId());
        }
        if (payload.getRecvNo() != null) {
            update.set((Path)this.qdo.recvNo, (Object)payload.getRecvNo());
        }
        if (payload.getRecvClass() != null) {
            update.set((Path)this.qdo.recvClass, (Object)payload.getRecvClass());
        }
        if (payload.getSourceId() != null) {
            update.set(this.qdo.sourceId, (Object)payload.getSourceId());
        }
        if (payload.getRecvAmt() != null) {
            update.set(this.qdo.recvAmt, (Object)payload.getRecvAmt());
        }
        if (payload.getRecvDate() != null) {
            update.set(this.qdo.recvDate, (Object)payload.getRecvDate());
        }
        if (payload.getAccountNo() != null) {
            update.set((Path)this.qdo.accountNo, (Object)payload.getAccountNo());
        }
        if (payload.getLedgerDate() != null) {
            update.set(this.qdo.ledgerDate, (Object)payload.getLedgerDate());
        }
        if (payload.getBookAccountId() != null) {
            update.set(this.qdo.bookAccountId, (Object)payload.getBookAccountId());
        }
        if ((nullFields = payload.getNullFields()) != null && nullFields.size() > 0) {
            if (nullFields.contains("id")) {
                update.setNull(this.qdo.id);
            }
            if (nullFields.contains("recvNo")) {
                update.setNull((Path)this.qdo.recvNo);
            }
            if (nullFields.contains("recvClass")) {
                update.setNull((Path)this.qdo.recvClass);
            }
            if (nullFields.contains("sourceId")) {
                update.setNull(this.qdo.sourceId);
            }
            if (nullFields.contains("recvAmt")) {
                update.setNull(this.qdo.recvAmt);
            }
            if (nullFields.contains("recvDate")) {
                update.setNull(this.qdo.recvDate);
            }
            if (nullFields.contains("accountNo")) {
                update.setNull((Path)this.qdo.accountNo);
            }
            if (nullFields.contains("ledgerDate")) {
                update.setNull(this.qdo.ledgerDate);
            }
            if (nullFields.contains("bookAccountId")) {
                update.setNull(this.qdo.bookAccountId);
            }
        }
        SqlUtil.updateCommonJpaQuery(update, this.qdo._super);
        return update.execute();
    }

    public long deleteSoft(List<Long> keys) {
        JPAUpdateClause update = this.jpaQueryFactory.update((EntityPath)this.qdo).set(this.qdo.deleteFlag, (Object)1).where(new Predicate[]{this.qdo.id.in(keys)});
        SqlUtil.updateCommonJpaQuery(update, this.qdo._super);
        return update.execute();
    }

    public long updateRecvAccount(Long invId, String accountNo, String ledgerDate) {
        JPAUpdateClause update = this.jpaQueryFactory.update((EntityPath)this.qdo).set((Path)this.qdo.accountNo, (Object)accountNo).set(this.qdo.ledgerDate, (Object)LocalDate.parse(ledgerDate, DateTimeFormatter.ofPattern("yyyy-MM-dd"))).where(new Predicate[]{this.qdo.sourceId.in((Object[])new Long[]{invId}).and((Predicate)this.qdo.recvClass.eq((Object)"1"))});
        SqlUtil.updateCommonJpaQuery(update, this.qdo._super);
        return update.execute();
    }

    public ConReceivableDAO(JPAQueryFactory jpaQueryFactory, ConReceivableRepo repo) {
        this.jpaQueryFactory = jpaQueryFactory;
        this.repo = repo;
    }
}

